package org.apache.iotdb.db.mpp.execution.operator.process.fill.constant;

import org.apache.iotdb.db.mpp.execution.operator.process.fill.IFill;
import org.apache.iotdb.tsfile.read.common.block.column.LongColumn;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.RunLengthEncodedColumn;

import java.util.Optional;

/*
* This class is generated using freemarker and the constantFill.ftl template.
*/
@SuppressWarnings("unused")
public class LongConstantFill implements IFill {

  // fill value
  private final long value;
  // used for constructing RunLengthEncodedColumn, size of it must be 1
  private final long[] valueArray;

  public LongConstantFill(long value) {
    this.value = value;
    this.valueArray = new long[] {value};
  }

  @Override
  public Column fill(Column valueColumn) {
    int size = valueColumn.getPositionCount();
    // if this valueColumn doesn't have any null value, or it's empty, just return itself;
    if (!valueColumn.mayHaveNull() || size == 0) {
      return valueColumn;
    }
    // if its values are all null
    if (valueColumn instanceof RunLengthEncodedColumn) {
      return new RunLengthEncodedColumn(new LongColumn(1, Optional.empty(), valueArray), size);
    } else {
      long[] array = new long[size];
      for (int i = 0; i < size; i++) {
        if (valueColumn.isNull(i)) {
          array[i] = value;
        } else {
          array[i] = valueColumn.getLong(i);
        }
      }
      return new LongColumn(size, Optional.empty(), array);
    }
  }
}


