/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.wal.recover.file;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.memtable.IMemTable;
import org.apache.iotdb.db.engine.querycontext.ReadOnlyMemChunk;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.DeleteDataNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.db.wal.recover.file.TsFilePlanRedoer;
import org.apache.iotdb.db.wal.utils.TsFileUtilsForRecoverTest;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.reader.IPointReader;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.BitMap;
import org.apache.iotdb.tsfile.write.TsFileWriter;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.record.datapoint.BooleanDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.DoubleDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.FloatDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.IntDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.LongDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.StringDataPoint;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TsFilePlanRedoerTest {
    private static final String SG_NAME = "root.recover_sg";
    private static final String DEVICE1_NAME = "root.recover_sg".concat(".d1");
    private static final String DEVICE2_NAME = "root.recover_sg".concat(".d2");
    private static final String DEVICE3_NAME = "root.recover_sg".concat(".d3");
    private static final String FILE_NAME = TsFileUtilsForRecoverTest.getTestTsFilePath("root.recover_sg", 0L, 0L, 1L);
    private TsFileResource tsFileResource;
    private CompressionType compressionType;
    boolean prevIsAutoCreateSchemaEnabled;
    boolean prevIsEnablePartialInsert;
    boolean prevIsCluster;

    @Before
    public void setUp() throws Exception {
        this.prevIsCluster = IoTDBDescriptor.getInstance().getConfig().isClusterMode();
        EnvironmentUtils.envSetUp();
        IoTDBDescriptor.getInstance().getConfig().setClusterMode(true);
        this.prevIsAutoCreateSchemaEnabled = IoTDBDescriptor.getInstance().getConfig().isAutoCreateSchemaEnabled();
        this.prevIsEnablePartialInsert = IoTDBDescriptor.getInstance().getConfig().isEnablePartialInsert();
        IoTDBDescriptor.getInstance().getConfig().setEnablePartialInsert(true);
        this.compressionType = TSFileDescriptor.getInstance().getConfig().getCompressor();
        IoTDB.schemaProcessor.setStorageGroup(new PartialPath(SG_NAME));
        IoTDB.schemaProcessor.createTimeseries(new PartialPath(DEVICE1_NAME.concat(".s1")), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
        IoTDB.schemaProcessor.createTimeseries(new PartialPath(DEVICE1_NAME.concat(".s2")), TSDataType.INT64, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
        IoTDB.schemaProcessor.createTimeseries(new PartialPath(DEVICE2_NAME.concat(".s1")), TSDataType.FLOAT, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
        IoTDB.schemaProcessor.createTimeseries(new PartialPath(DEVICE2_NAME.concat(".s2")), TSDataType.DOUBLE, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
        IoTDB.schemaProcessor.createAlignedTimeSeries(new PartialPath(DEVICE3_NAME), Arrays.asList("s1", "s2", "s3", "s4", "s5"), Arrays.asList(TSDataType.INT32, TSDataType.INT64, TSDataType.BOOLEAN, TSDataType.FLOAT, TSDataType.TEXT), Arrays.asList(TSEncoding.RLE, TSEncoding.RLE, TSEncoding.RLE, TSEncoding.RLE, TSEncoding.PLAIN), Arrays.asList(this.compressionType, this.compressionType, this.compressionType, this.compressionType, this.compressionType));
    }

    @After
    public void tearDown() throws Exception {
        File modsFile;
        if (this.tsFileResource != null) {
            this.tsFileResource.close();
        }
        if ((modsFile = new File(FILE_NAME.concat(".mods"))).exists()) {
            modsFile.delete();
        }
        IoTDBDescriptor.getInstance().getConfig().setClusterMode(this.prevIsCluster);
        EnvironmentUtils.cleanEnv();
        IoTDBDescriptor.getInstance().getConfig().setEnablePartialInsert(this.prevIsEnablePartialInsert);
    }

    @Test
    public void testRedoInsertRowPlan() throws Exception {
        TimeValuePair timeValuePair;
        File file = new File(FILE_NAME);
        this.generateCompleteFile(file);
        this.tsFileResource = new TsFileResource(file);
        this.tsFileResource.updateStartTime(DEVICE1_NAME, 1L);
        this.tsFileResource.updateEndTime(DEVICE1_NAME, 2L);
        this.tsFileResource.updateStartTime(DEVICE2_NAME, 3L);
        this.tsFileResource.updateEndTime(DEVICE2_NAME, 4L);
        long time = 5L;
        TSDataType[] dataTypes = new TSDataType[]{TSDataType.FLOAT, TSDataType.DOUBLE};
        Object[] columns = new Object[]{Float.valueOf(1.0f), 1.0};
        InsertRowNode insertRowNode = new InsertRowNode(new PlanNodeId("0"), new PartialPath(DEVICE2_NAME), false, new String[]{"s1", "s2"}, dataTypes, time, columns, false);
        insertRowNode.setMeasurementSchemas(new MeasurementSchema[]{new MeasurementSchema("s1", TSDataType.FLOAT), new MeasurementSchema("s2", TSDataType.DOUBLE)});
        TsFilePlanRedoer planRedoer = new TsFilePlanRedoer(this.tsFileResource, true, null);
        planRedoer.redoInsert((InsertNode)insertRowNode);
        IMemTable recoveryMemTable = planRedoer.getRecoveryMemTable();
        MeasurementPath fullPath = new MeasurementPath(DEVICE2_NAME, "s1", (IMeasurementSchema)new MeasurementSchema("s1", TSDataType.FLOAT, TSEncoding.RLE));
        ReadOnlyMemChunk memChunk = recoveryMemTable.query((PartialPath)fullPath, Long.MIN_VALUE, null);
        IPointReader iterator = memChunk.getPointReader();
        time = 5L;
        while (iterator.hasNextTimeValuePair()) {
            timeValuePair = iterator.nextTimeValuePair();
            Assert.assertEquals((long)time, (long)timeValuePair.getTimestamp());
            Assert.assertEquals((double)1.0, (double)timeValuePair.getValue().getFloat(), (double)1.0E-4);
            ++time;
        }
        Assert.assertEquals((long)6L, (long)time);
        fullPath = new MeasurementPath(DEVICE2_NAME, "s2", (IMeasurementSchema)new MeasurementSchema("s2", TSDataType.DOUBLE, TSEncoding.RLE));
        memChunk = recoveryMemTable.query((PartialPath)fullPath, Long.MIN_VALUE, null);
        iterator = memChunk.getPointReader();
        time = 5L;
        while (iterator.hasNextTimeValuePair()) {
            timeValuePair = iterator.nextTimeValuePair();
            Assert.assertEquals((long)time, (long)timeValuePair.getTimestamp());
            Assert.assertEquals((double)1.0, (double)timeValuePair.getValue().getDouble(), (double)1.0E-4);
            ++time;
        }
        Assert.assertEquals((long)6L, (long)time);
    }

    @Test
    public void testRedoInsertAlignedRowPlan() throws Exception {
        File file = new File(FILE_NAME);
        this.generateCompleteFile(file);
        this.tsFileResource = new TsFileResource(file);
        this.tsFileResource.updateStartTime(DEVICE3_NAME, 5L);
        this.tsFileResource.updateStartTime(DEVICE3_NAME, 5L);
        long time = 6L;
        TSDataType[] dataTypes = new TSDataType[]{TSDataType.INT32, TSDataType.INT64, TSDataType.BOOLEAN, TSDataType.FLOAT, TSDataType.TEXT};
        Object[] columns = new Object[]{1, 1L, true, Float.valueOf(1.0f), new Binary("1")};
        InsertRowNode insertRowNode = new InsertRowNode(new PlanNodeId("0"), new PartialPath(DEVICE3_NAME), true, new String[]{"s1", "s2", "s3", "s4", "s5"}, dataTypes, time, columns, false);
        insertRowNode.setMeasurementSchemas(new MeasurementSchema[]{new MeasurementSchema("s1", TSDataType.INT32), new MeasurementSchema("s2", TSDataType.INT64), new MeasurementSchema("s3", TSDataType.BOOLEAN), new MeasurementSchema("s4", TSDataType.FLOAT), new MeasurementSchema("s5", TSDataType.TEXT)});
        TsFilePlanRedoer planRedoer = new TsFilePlanRedoer(this.tsFileResource, true, null);
        planRedoer.redoInsert((InsertNode)insertRowNode);
        IMemTable recoveryMemTable = planRedoer.getRecoveryMemTable();
        AlignedPath fullPath = new AlignedPath(DEVICE3_NAME, Arrays.asList("s1", "s2", "s3", "s4", "s5"), Arrays.asList(new MeasurementSchema("s1", TSDataType.INT32, TSEncoding.RLE), new MeasurementSchema("s2", TSDataType.INT64, TSEncoding.RLE), new MeasurementSchema("s3", TSDataType.BOOLEAN, TSEncoding.RLE), new MeasurementSchema("s4", TSDataType.FLOAT, TSEncoding.RLE), new MeasurementSchema("s5", TSDataType.TEXT, TSEncoding.PLAIN)));
        ReadOnlyMemChunk memChunk = recoveryMemTable.query((PartialPath)fullPath, Long.MIN_VALUE, null);
        IPointReader iterator = memChunk.getPointReader();
        time = 6L;
        while (iterator.hasNextTimeValuePair()) {
            TimeValuePair timeValuePair = iterator.nextTimeValuePair();
            Assert.assertEquals((long)time, (long)timeValuePair.getTimestamp());
            Assert.assertEquals((long)1L, (long)timeValuePair.getValue().getVector()[0].getInt());
            Assert.assertEquals((long)1L, (long)timeValuePair.getValue().getVector()[1].getLong());
            Assert.assertEquals((Object)true, (Object)timeValuePair.getValue().getVector()[2].getBoolean());
            Assert.assertEquals((double)1.0, (double)timeValuePair.getValue().getVector()[3].getFloat(), (double)1.0E-5);
            Assert.assertEquals((Object)Binary.valueOf((String)"1"), (Object)timeValuePair.getValue().getVector()[4].getBinary());
            ++time;
        }
        Assert.assertEquals((long)7L, (long)time);
    }

    @Test
    public void testRedoInsertTabletPlan() throws Exception {
        TimeValuePair timeValuePair;
        File file = new File(FILE_NAME);
        this.generateCompleteFile(file);
        this.tsFileResource = new TsFileResource(file);
        this.tsFileResource.updateStartTime(DEVICE1_NAME, 1L);
        this.tsFileResource.updateEndTime(DEVICE1_NAME, 2L);
        this.tsFileResource.updateStartTime(DEVICE2_NAME, 3L);
        this.tsFileResource.updateEndTime(DEVICE2_NAME, 4L);
        long[] times = new long[]{5L, 6L, 7L, 8L};
        ArrayList<Integer> dataTypes = new ArrayList<Integer>();
        dataTypes.add(TSDataType.INT32.ordinal());
        dataTypes.add(TSDataType.INT64.ordinal());
        Object[] columns = new Object[]{new int[times.length], new long[times.length]};
        for (int r = 0; r < times.length; ++r) {
            ((int[])columns[0])[r] = 100;
            ((long[])columns[1])[r] = 10000L;
        }
        BitMap[] bitMaps = new BitMap[dataTypes.size()];
        for (int i = 0; i < dataTypes.size(); ++i) {
            if (bitMaps[i] == null) {
                bitMaps[i] = new BitMap(times.length);
            }
            bitMaps[i].mark(3);
        }
        InsertTabletNode insertTabletNode = new InsertTabletNode(new PlanNodeId("0"), new PartialPath(DEVICE1_NAME), false, new String[]{"s1", "s2"}, new TSDataType[]{TSDataType.INT32, TSDataType.INT64}, times, bitMaps, columns, times.length);
        insertTabletNode.setMeasurementSchemas(new MeasurementSchema[]{new MeasurementSchema("s1", TSDataType.INT32), new MeasurementSchema("s2", TSDataType.INT64)});
        TsFilePlanRedoer planRedoer = new TsFilePlanRedoer(this.tsFileResource, true, null);
        planRedoer.redoInsert((InsertNode)insertTabletNode);
        IMemTable recoveryMemTable = planRedoer.getRecoveryMemTable();
        MeasurementPath fullPath = new MeasurementPath(DEVICE1_NAME, "s1", (IMeasurementSchema)new MeasurementSchema("s1", TSDataType.INT32, TSEncoding.RLE));
        ReadOnlyMemChunk memChunk = recoveryMemTable.query((PartialPath)fullPath, Long.MIN_VALUE, null);
        IPointReader iterator = memChunk.getPointReader();
        int time = 5;
        while (iterator.hasNextTimeValuePair()) {
            timeValuePair = iterator.nextTimeValuePair();
            Assert.assertEquals((long)time, (long)timeValuePair.getTimestamp());
            Assert.assertEquals((long)100L, (long)timeValuePair.getValue().getInt());
            ++time;
        }
        Assert.assertEquals((long)8L, (long)time);
        fullPath = new MeasurementPath(DEVICE1_NAME, "s2", (IMeasurementSchema)new MeasurementSchema("s2", TSDataType.INT64, TSEncoding.RLE));
        memChunk = recoveryMemTable.query((PartialPath)fullPath, Long.MIN_VALUE, null);
        iterator = memChunk.getPointReader();
        time = 5;
        while (iterator.hasNextTimeValuePair()) {
            timeValuePair = iterator.nextTimeValuePair();
            Assert.assertEquals((long)time, (long)timeValuePair.getTimestamp());
            Assert.assertEquals((long)10000L, (long)timeValuePair.getValue().getLong());
            ++time;
        }
        Assert.assertEquals((long)8L, (long)time);
    }

    @Test
    public void testRedoInsertAlignedTabletPlan() throws Exception {
        File file = new File(FILE_NAME);
        this.generateCompleteFile(file);
        this.tsFileResource = new TsFileResource(file);
        this.tsFileResource.updateStartTime(DEVICE3_NAME, 5L);
        this.tsFileResource.updateStartTime(DEVICE3_NAME, 5L);
        long[] times = new long[]{6L, 7L, 8L, 9L};
        ArrayList<Integer> dataTypes = new ArrayList<Integer>();
        dataTypes.add(TSDataType.INT32.ordinal());
        dataTypes.add(TSDataType.INT64.ordinal());
        dataTypes.add(TSDataType.BOOLEAN.ordinal());
        dataTypes.add(TSDataType.FLOAT.ordinal());
        dataTypes.add(TSDataType.TEXT.ordinal());
        Object[] columns = new Object[]{new int[times.length], new long[times.length], new boolean[times.length], new float[times.length], new Binary[times.length]};
        for (int r = 0; r < times.length; ++r) {
            ((int[])columns[0])[r] = (r + 1) * 100;
            ((long[])columns[1])[r] = (r + 1) * 100;
            ((boolean[])columns[2])[r] = true;
            ((float[])columns[3])[r] = (r + 1) * 100;
            ((Binary[])columns[4])[r] = Binary.valueOf((String)((r + 1) * 100 + ""));
        }
        BitMap[] bitMaps = new BitMap[dataTypes.size()];
        for (int i = 0; i < dataTypes.size(); ++i) {
            if (bitMaps[i] == null) {
                bitMaps[i] = new BitMap(times.length);
            }
            bitMaps[i].mark(3);
        }
        InsertTabletNode insertTabletNode = new InsertTabletNode(new PlanNodeId("0"), new PartialPath(DEVICE3_NAME), true, new String[]{"s1", "s2", "s3", "s4", "s5"}, new TSDataType[]{TSDataType.INT32, TSDataType.INT64, TSDataType.BOOLEAN, TSDataType.FLOAT, TSDataType.TEXT}, times, bitMaps, columns, times.length);
        insertTabletNode.setMeasurementSchemas(new MeasurementSchema[]{new MeasurementSchema("s1", TSDataType.INT32), new MeasurementSchema("s2", TSDataType.INT64), new MeasurementSchema("s3", TSDataType.BOOLEAN), new MeasurementSchema("s4", TSDataType.FLOAT), new MeasurementSchema("s5", TSDataType.TEXT)});
        TsFilePlanRedoer planRedoer = new TsFilePlanRedoer(this.tsFileResource, true, null);
        planRedoer.redoInsert((InsertNode)insertTabletNode);
        IMemTable recoveryMemTable = planRedoer.getRecoveryMemTable();
        AlignedPath fullPath = new AlignedPath(DEVICE3_NAME, Arrays.asList("s1", "s2", "s3", "s4", "s5"), Arrays.asList(new MeasurementSchema("s1", TSDataType.INT32, TSEncoding.RLE), new MeasurementSchema("s2", TSDataType.INT64, TSEncoding.RLE), new MeasurementSchema("s3", TSDataType.BOOLEAN, TSEncoding.RLE), new MeasurementSchema("s4", TSDataType.FLOAT, TSEncoding.RLE), new MeasurementSchema("s5", TSDataType.TEXT, TSEncoding.PLAIN)));
        ReadOnlyMemChunk memChunk = recoveryMemTable.query((PartialPath)fullPath, Long.MIN_VALUE, null);
        IPointReader iterator = memChunk.getPointReader();
        int time = 6;
        while (iterator.hasNextTimeValuePair()) {
            TimeValuePair timeValuePair = iterator.nextTimeValuePair();
            Assert.assertEquals((long)time, (long)timeValuePair.getTimestamp());
            Assert.assertEquals((long)((time - 5) * 100), (long)timeValuePair.getValue().getVector()[0].getInt());
            Assert.assertEquals((long)((long)(time - 5) * 100L), (long)timeValuePair.getValue().getVector()[1].getLong());
            Assert.assertEquals((Object)true, (Object)timeValuePair.getValue().getVector()[2].getBoolean());
            Assert.assertEquals((double)((time - 5) * 100), (double)timeValuePair.getValue().getVector()[3].getFloat(), (double)1.0E-5);
            Assert.assertEquals((Object)Binary.valueOf((String)((time - 5) * 100 + "")), (Object)timeValuePair.getValue().getVector()[4].getBinary());
            ++time;
        }
        Assert.assertEquals((long)9L, (long)time);
    }

    @Test
    public void testRedoOverLapPlanIntoSeqFile() throws Exception {
        File file = new File(FILE_NAME);
        this.generateCompleteFile(file);
        this.tsFileResource = new TsFileResource(file);
        this.tsFileResource.updateStartTime(DEVICE1_NAME, 1L);
        this.tsFileResource.updateEndTime(DEVICE1_NAME, 2L);
        this.tsFileResource.updateStartTime(DEVICE2_NAME, 3L);
        this.tsFileResource.updateEndTime(DEVICE2_NAME, 4L);
        long[] times = new long[]{1L, 2L};
        ArrayList<Integer> dataTypes = new ArrayList<Integer>();
        dataTypes.add(TSDataType.INT32.ordinal());
        dataTypes.add(TSDataType.INT64.ordinal());
        Object[] columns = new Object[]{new int[times.length], new long[times.length]};
        for (int r = 0; r < times.length; ++r) {
            ((int[])columns[0])[r] = 100;
            ((long[])columns[1])[r] = 10000L;
        }
        InsertTabletNode insertTabletNode = new InsertTabletNode(new PlanNodeId("0"), new PartialPath(DEVICE1_NAME), false, new String[]{"s1", "s2"}, new TSDataType[]{TSDataType.INT32, TSDataType.INT64}, times, null, columns, times.length);
        TsFilePlanRedoer planRedoer = new TsFilePlanRedoer(this.tsFileResource, true, null);
        planRedoer.redoInsert((InsertNode)insertTabletNode);
        IMemTable recoveryMemTable = planRedoer.getRecoveryMemTable();
        Assert.assertTrue((boolean)recoveryMemTable.isEmpty());
    }

    @Test
    public void testRedoOverLapPlanIntoUnseqFile() throws Exception {
        TimeValuePair timeValuePair;
        File file = new File(FILE_NAME);
        this.generateCompleteFile(file);
        this.tsFileResource = new TsFileResource(file);
        this.tsFileResource.updateStartTime(DEVICE1_NAME, 1L);
        this.tsFileResource.updateEndTime(DEVICE1_NAME, 2L);
        this.tsFileResource.updateStartTime(DEVICE2_NAME, 3L);
        this.tsFileResource.updateEndTime(DEVICE2_NAME, 4L);
        long[] times = new long[]{1L, 2L};
        ArrayList<Integer> dataTypes = new ArrayList<Integer>();
        dataTypes.add(TSDataType.INT32.ordinal());
        dataTypes.add(TSDataType.INT64.ordinal());
        Object[] columns = new Object[]{new int[times.length], new long[times.length]};
        for (int r = 0; r < times.length; ++r) {
            ((int[])columns[0])[r] = 100;
            ((long[])columns[1])[r] = 10000L;
        }
        InsertTabletNode insertTabletNode = new InsertTabletNode(new PlanNodeId("0"), new PartialPath(DEVICE1_NAME), false, new String[]{"s1", "s2"}, new TSDataType[]{TSDataType.INT32, TSDataType.INT64}, times, null, columns, times.length);
        insertTabletNode.setMeasurementSchemas(new MeasurementSchema[]{new MeasurementSchema("s1", TSDataType.INT32), new MeasurementSchema("s2", TSDataType.INT64)});
        TsFilePlanRedoer planRedoer = new TsFilePlanRedoer(this.tsFileResource, false, null);
        planRedoer.redoInsert((InsertNode)insertTabletNode);
        IMemTable recoveryMemTable = planRedoer.getRecoveryMemTable();
        MeasurementPath fullPath = new MeasurementPath(DEVICE1_NAME, "s1", (IMeasurementSchema)new MeasurementSchema("s1", TSDataType.INT32, TSEncoding.RLE));
        ReadOnlyMemChunk memChunk = recoveryMemTable.query((PartialPath)fullPath, Long.MIN_VALUE, null);
        IPointReader iterator = memChunk.getPointReader();
        int time = 1;
        while (iterator.hasNextTimeValuePair()) {
            timeValuePair = iterator.nextTimeValuePair();
            Assert.assertEquals((long)time, (long)timeValuePair.getTimestamp());
            Assert.assertEquals((long)100L, (long)timeValuePair.getValue().getInt());
            ++time;
        }
        Assert.assertEquals((long)3L, (long)time);
        fullPath = new MeasurementPath(DEVICE1_NAME, "s2", (IMeasurementSchema)new MeasurementSchema("s2", TSDataType.INT64, TSEncoding.RLE));
        memChunk = recoveryMemTable.query((PartialPath)fullPath, Long.MIN_VALUE, null);
        iterator = memChunk.getPointReader();
        time = 1;
        while (iterator.hasNextTimeValuePair()) {
            timeValuePair = iterator.nextTimeValuePair();
            Assert.assertEquals((long)time, (long)timeValuePair.getTimestamp());
            Assert.assertEquals((long)10000L, (long)timeValuePair.getValue().getLong());
            ++time;
        }
        Assert.assertEquals((long)3L, (long)time);
    }

    @Test
    public void testRedoDeleteDataNode() throws Exception {
        File file = new File(FILE_NAME);
        this.generateCompleteFile(file);
        this.tsFileResource = new TsFileResource(file);
        this.tsFileResource.updateStartTime(DEVICE1_NAME, 1L);
        this.tsFileResource.updateEndTime(DEVICE1_NAME, 2L);
        this.tsFileResource.updateStartTime(DEVICE2_NAME, 3L);
        this.tsFileResource.updateEndTime(DEVICE2_NAME, 4L);
        DeleteDataNode deleteDataNode = new DeleteDataNode(new PlanNodeId(""), Collections.singletonList(new PartialPath(DEVICE1_NAME)), Long.MIN_VALUE, Long.MAX_VALUE);
        File modsFile = new File(FILE_NAME.concat(".mods"));
        Assert.assertFalse((boolean)modsFile.exists());
        TsFilePlanRedoer planRedoer = new TsFilePlanRedoer(this.tsFileResource, false, null);
        planRedoer.redoDelete(deleteDataNode);
        Assert.assertTrue((boolean)modsFile.exists());
    }

    @Test
    public void testRedoAlignedInsertAfterDeleteTimeseries() throws Exception {
        IoTDB.schemaProcessor.deleteTimeseries(new PartialPath(DEVICE3_NAME.concat(".s1")));
        IoTDB.schemaProcessor.deleteTimeseries(new PartialPath(DEVICE3_NAME.concat(".s5")));
        File file = new File(FILE_NAME);
        this.generateCompleteFile(file);
        this.tsFileResource = new TsFileResource(file);
        this.tsFileResource.updateStartTime(DEVICE3_NAME, 5L);
        this.tsFileResource.updateStartTime(DEVICE3_NAME, 5L);
        long[] times = new long[]{6L, 7L, 8L, 9L};
        List<Integer> dataTypes = Arrays.asList(TSDataType.INT32.ordinal(), TSDataType.INT64.ordinal(), TSDataType.BOOLEAN.ordinal(), TSDataType.FLOAT.ordinal(), TSDataType.TEXT.ordinal());
        Object[] columns = new Object[]{new int[times.length], new long[times.length], new boolean[times.length], new float[times.length], new Binary[times.length]};
        for (int r = 0; r < times.length; ++r) {
            ((int[])columns[0])[r] = (r + 1) * 100;
            ((long[])columns[1])[r] = (r + 1) * 100;
            ((boolean[])columns[2])[r] = true;
            ((float[])columns[3])[r] = (r + 1) * 100;
            ((Binary[])columns[4])[r] = Binary.valueOf((String)((r + 1) * 100 + ""));
        }
        BitMap[] bitMaps = new BitMap[dataTypes.size()];
        for (int i = 0; i < dataTypes.size(); ++i) {
            if (bitMaps[i] == null) {
                bitMaps[i] = new BitMap(times.length);
            }
            bitMaps[i].mark(3);
        }
        InsertTabletNode insertTabletNode = new InsertTabletNode(new PlanNodeId(""), new PartialPath(DEVICE3_NAME), true, new String[]{null, "s2", "s3", "s4", null}, new TSDataType[]{TSDataType.INT32, TSDataType.INT64, TSDataType.BOOLEAN, TSDataType.FLOAT, TSDataType.TEXT}, times, bitMaps, columns, times.length);
        TsFilePlanRedoer planRedoer = new TsFilePlanRedoer(this.tsFileResource, true, null);
        MeasurementSchema[] schemas = new MeasurementSchema[]{null, new MeasurementSchema("s2", TSDataType.INT64), new MeasurementSchema("s3", TSDataType.BOOLEAN), new MeasurementSchema("s4", TSDataType.FLOAT), null};
        insertTabletNode.setMeasurementSchemas(schemas);
        planRedoer.redoInsert((InsertNode)insertTabletNode);
        int time = 9;
        TSDataType[] dataTypes2 = new TSDataType[]{TSDataType.INT32, TSDataType.INT64, TSDataType.BOOLEAN, TSDataType.FLOAT, TSDataType.TEXT};
        Object[] columns2 = new Object[]{400, 400L, true, Float.valueOf(400.0f), new Binary("400")};
        InsertRowNode insertRowNode = new InsertRowNode(new PlanNodeId(""), new PartialPath(DEVICE3_NAME), true, new String[]{null, "s2", "s3", "s4", null}, dataTypes2, (long)time, columns2, false);
        insertRowNode.setMeasurementSchemas(schemas);
        planRedoer.redoInsert((InsertNode)insertRowNode);
        IMemTable recoveryMemTable = planRedoer.getRecoveryMemTable();
        AlignedPath fullPath = new AlignedPath(DEVICE3_NAME, Arrays.asList("s1", "s2", "s3", "s4", "s5"), Arrays.asList(new MeasurementSchema("s1", TSDataType.INT32, TSEncoding.RLE), new MeasurementSchema("s2", TSDataType.INT64, TSEncoding.RLE), new MeasurementSchema("s3", TSDataType.BOOLEAN, TSEncoding.RLE), new MeasurementSchema("s4", TSDataType.FLOAT, TSEncoding.RLE), new MeasurementSchema("s5", TSDataType.TEXT, TSEncoding.PLAIN)));
        ReadOnlyMemChunk memChunk = recoveryMemTable.query((PartialPath)fullPath, Long.MIN_VALUE, null);
        IPointReader iterator = memChunk.getPointReader();
        time = 6;
        while (iterator.hasNextTimeValuePair()) {
            TimeValuePair timeValuePair = iterator.nextTimeValuePair();
            Assert.assertEquals((long)time, (long)timeValuePair.getTimestamp());
            Assert.assertEquals(null, (Object)timeValuePair.getValue().getVector()[0]);
            Assert.assertEquals((long)((long)(time - 5) * 100L), (long)timeValuePair.getValue().getVector()[1].getLong());
            Assert.assertEquals((Object)true, (Object)timeValuePair.getValue().getVector()[2].getBoolean());
            Assert.assertEquals((double)((time - 5) * 100), (double)timeValuePair.getValue().getVector()[3].getFloat(), (double)1.0E-5);
            Assert.assertEquals(null, (Object)timeValuePair.getValue().getVector()[4]);
            ++time;
        }
        Assert.assertEquals((long)10L, (long)time);
    }

    private void generateCompleteFile(File tsFile) throws IOException, WriteProcessException {
        try (TsFileWriter writer = new TsFileWriter(tsFile);){
            writer.registerTimeseries(new Path(DEVICE1_NAME), new MeasurementSchema("s1", TSDataType.INT32, TSEncoding.RLE));
            writer.registerTimeseries(new Path(DEVICE1_NAME), new MeasurementSchema("s2", TSDataType.INT64, TSEncoding.RLE));
            writer.registerTimeseries(new Path(DEVICE2_NAME), new MeasurementSchema("s1", TSDataType.FLOAT, TSEncoding.RLE));
            writer.registerTimeseries(new Path(DEVICE2_NAME), new MeasurementSchema("s2", TSDataType.DOUBLE, TSEncoding.RLE));
            writer.registerAlignedTimeseries(new Path(DEVICE3_NAME), Arrays.asList(new MeasurementSchema("s1", TSDataType.INT32, TSEncoding.RLE), new MeasurementSchema("s2", TSDataType.INT64, TSEncoding.RLE), new MeasurementSchema("s3", TSDataType.BOOLEAN, TSEncoding.RLE), new MeasurementSchema("s4", TSDataType.FLOAT, TSEncoding.RLE), new MeasurementSchema("s5", TSDataType.TEXT, TSEncoding.PLAIN)));
            writer.write(new TSRecord(1L, DEVICE1_NAME).addTuple((DataPoint)new IntDataPoint("s1", 1)).addTuple((DataPoint)new LongDataPoint("s2", 1L)));
            writer.write(new TSRecord(2L, DEVICE1_NAME).addTuple((DataPoint)new IntDataPoint("s1", 2)).addTuple((DataPoint)new LongDataPoint("s2", 2L)));
            writer.write(new TSRecord(3L, DEVICE2_NAME).addTuple((DataPoint)new FloatDataPoint("s1", 3.0f)).addTuple((DataPoint)new DoubleDataPoint("s2", 3.0)));
            writer.write(new TSRecord(4L, DEVICE2_NAME).addTuple((DataPoint)new FloatDataPoint("s1", 4.0f)).addTuple((DataPoint)new DoubleDataPoint("s2", 4.0)));
            writer.writeAligned(new TSRecord(5L, DEVICE3_NAME).addTuple((DataPoint)new IntDataPoint("s1", 5)).addTuple((DataPoint)new LongDataPoint("s2", 5L)).addTuple((DataPoint)new BooleanDataPoint("s3", true)).addTuple((DataPoint)new FloatDataPoint("s4", 5.0f)).addTuple((DataPoint)new StringDataPoint("s5", Binary.valueOf((String)"5"))));
        }
    }
}

