/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.wal.recover.file;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.util.List;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.db.wal.recover.file.SealedTsFileRecoverPerformer;
import org.apache.iotdb.db.wal.utils.TsFileUtilsForRecoverTest;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.write.TsFileWriter;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.DoubleDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.FloatDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.IntDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.LongDataPoint;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SealedTsFileRecoverPerformerTest {
    private static final String SG_NAME = "root.recover_sg";
    private static final String DEVICE1_NAME = "root.recover_sg".concat(".d1");
    private static final String DEVICE2_NAME = "root.recover_sg".concat(".d2");
    private static final String FILE_NAME = TsFileUtilsForRecoverTest.getTestTsFilePath("root.recover_sg", 0L, 0L, 1L);
    private TsFileResource tsFileResource;

    @Before
    public void setUp() throws Exception {
        EnvironmentUtils.cleanDir(new File(FILE_NAME).getParent());
    }

    @After
    public void tearDown() throws Exception {
        if (this.tsFileResource != null) {
            this.tsFileResource.close();
        }
        EnvironmentUtils.cleanDir(new File(FILE_NAME).getParent());
    }

    @Test
    public void testCompleteFileWithResource() throws Exception {
        File file = new File(FILE_NAME);
        this.generateCompleteFile(file);
        TsFileResource resourcePreparer = new TsFileResource(file);
        resourcePreparer.updateStartTime(DEVICE1_NAME, 1L);
        resourcePreparer.updateEndTime(DEVICE1_NAME, 2L);
        resourcePreparer.updateStartTime(DEVICE2_NAME, 3L);
        resourcePreparer.updateEndTime(DEVICE2_NAME, 4L);
        resourcePreparer.close();
        resourcePreparer.serialize();
        Assert.assertTrue((boolean)file.exists());
        Assert.assertTrue((boolean)new File(FILE_NAME.concat(".resource")).exists());
        this.tsFileResource = new TsFileResource(file);
        try (SealedTsFileRecoverPerformer recoverPerformer = new SealedTsFileRecoverPerformer(this.tsFileResource);){
            recoverPerformer.recover();
            Assert.assertFalse((boolean)recoverPerformer.hasCrashed());
            Assert.assertFalse((boolean)recoverPerformer.canWrite());
        }
        TsFileSequenceReader reader = new TsFileSequenceReader(FILE_NAME);
        List chunkMetadataList = reader.getChunkMetadataList(new Path(DEVICE1_NAME, "s1", true));
        Assert.assertNotNull((Object)chunkMetadataList);
        chunkMetadataList = reader.getChunkMetadataList(new Path(DEVICE1_NAME, "s2", true));
        Assert.assertNotNull((Object)chunkMetadataList);
        chunkMetadataList = reader.getChunkMetadataList(new Path(DEVICE2_NAME, "s1", true));
        Assert.assertNotNull((Object)chunkMetadataList);
        chunkMetadataList = reader.getChunkMetadataList(new Path(DEVICE2_NAME, "s2", true));
        Assert.assertNotNull((Object)chunkMetadataList);
        reader.close();
        Assert.assertEquals((long)1L, (long)this.tsFileResource.getStartTime(DEVICE1_NAME));
        Assert.assertEquals((long)2L, (long)this.tsFileResource.getEndTime(DEVICE1_NAME));
        Assert.assertEquals((long)3L, (long)this.tsFileResource.getStartTime(DEVICE2_NAME));
        Assert.assertEquals((long)4L, (long)this.tsFileResource.getEndTime(DEVICE2_NAME));
        Assert.assertTrue((boolean)file.exists());
        Assert.assertTrue((boolean)new File(FILE_NAME.concat(".resource")).exists());
    }

    @Test
    public void testCompleteFileWithBrokenResource() throws Exception {
        File file = new File(FILE_NAME);
        this.generateCompleteFile(file);
        try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(FILE_NAME.concat(".resource")));){
            ((OutputStream)outputStream).write(1);
        }
        Assert.assertTrue((boolean)file.exists());
        Assert.assertTrue((boolean)new File(FILE_NAME.concat(".resource")).exists());
        this.tsFileResource = new TsFileResource(file);
        try (SealedTsFileRecoverPerformer recoverPerformer = new SealedTsFileRecoverPerformer(this.tsFileResource);){
            recoverPerformer.recover();
            Assert.assertFalse((boolean)recoverPerformer.hasCrashed());
            Assert.assertFalse((boolean)recoverPerformer.canWrite());
        }
        TsFileSequenceReader reader = new TsFileSequenceReader(FILE_NAME);
        List chunkMetadataList = reader.getChunkMetadataList(new Path(DEVICE1_NAME, "s1", true));
        Assert.assertNotNull((Object)chunkMetadataList);
        chunkMetadataList = reader.getChunkMetadataList(new Path(DEVICE1_NAME, "s2", true));
        Assert.assertNotNull((Object)chunkMetadataList);
        chunkMetadataList = reader.getChunkMetadataList(new Path(DEVICE2_NAME, "s1", true));
        Assert.assertNotNull((Object)chunkMetadataList);
        chunkMetadataList = reader.getChunkMetadataList(new Path(DEVICE2_NAME, "s2", true));
        Assert.assertNotNull((Object)chunkMetadataList);
        reader.close();
        Assert.assertEquals((long)1L, (long)this.tsFileResource.getStartTime(DEVICE1_NAME));
        Assert.assertEquals((long)2L, (long)this.tsFileResource.getEndTime(DEVICE1_NAME));
        Assert.assertEquals((long)3L, (long)this.tsFileResource.getStartTime(DEVICE2_NAME));
        Assert.assertEquals((long)4L, (long)this.tsFileResource.getEndTime(DEVICE2_NAME));
        Assert.assertTrue((boolean)file.exists());
        Assert.assertTrue((boolean)new File(FILE_NAME.concat(".resource")).exists());
    }

    @Test
    public void testCompleteFileWithoutResource() throws Exception {
        File file = new File(FILE_NAME);
        this.generateCompleteFile(file);
        Assert.assertTrue((boolean)file.exists());
        Assert.assertFalse((boolean)new File(FILE_NAME.concat(".resource")).exists());
        this.tsFileResource = new TsFileResource(file);
        try (SealedTsFileRecoverPerformer recoverPerformer = new SealedTsFileRecoverPerformer(this.tsFileResource);){
            recoverPerformer.recover();
            Assert.assertFalse((boolean)recoverPerformer.hasCrashed());
            Assert.assertFalse((boolean)recoverPerformer.canWrite());
        }
        TsFileSequenceReader reader = new TsFileSequenceReader(FILE_NAME);
        List chunkMetadataList = reader.getChunkMetadataList(new Path(DEVICE1_NAME, "s1", true));
        Assert.assertNotNull((Object)chunkMetadataList);
        chunkMetadataList = reader.getChunkMetadataList(new Path(DEVICE1_NAME, "s2", true));
        Assert.assertNotNull((Object)chunkMetadataList);
        chunkMetadataList = reader.getChunkMetadataList(new Path(DEVICE2_NAME, "s1", true));
        Assert.assertNotNull((Object)chunkMetadataList);
        chunkMetadataList = reader.getChunkMetadataList(new Path(DEVICE2_NAME, "s2", true));
        Assert.assertNotNull((Object)chunkMetadataList);
        reader.close();
        Assert.assertEquals((long)1L, (long)this.tsFileResource.getStartTime(DEVICE1_NAME));
        Assert.assertEquals((long)2L, (long)this.tsFileResource.getEndTime(DEVICE1_NAME));
        Assert.assertEquals((long)3L, (long)this.tsFileResource.getStartTime(DEVICE2_NAME));
        Assert.assertEquals((long)4L, (long)this.tsFileResource.getEndTime(DEVICE2_NAME));
        Assert.assertTrue((boolean)file.exists());
        Assert.assertTrue((boolean)new File(FILE_NAME.concat(".resource")).exists());
    }

    private void generateCompleteFile(File tsFile) throws IOException, WriteProcessException {
        try (TsFileWriter writer = new TsFileWriter(tsFile);){
            writer.registerTimeseries(new Path(DEVICE1_NAME), new MeasurementSchema("s1", TSDataType.INT32, TSEncoding.RLE));
            writer.registerTimeseries(new Path(DEVICE1_NAME), new MeasurementSchema("s2", TSDataType.INT64, TSEncoding.RLE));
            writer.registerTimeseries(new Path(DEVICE2_NAME), new MeasurementSchema("s1", TSDataType.FLOAT, TSEncoding.RLE));
            writer.registerTimeseries(new Path(DEVICE2_NAME), new MeasurementSchema("s2", TSDataType.DOUBLE, TSEncoding.RLE));
            writer.write(new TSRecord(1L, DEVICE1_NAME).addTuple((DataPoint)new IntDataPoint("s1", 1)).addTuple((DataPoint)new LongDataPoint("s2", 1L)));
            writer.write(new TSRecord(2L, DEVICE1_NAME).addTuple((DataPoint)new IntDataPoint("s1", 2)).addTuple((DataPoint)new LongDataPoint("s2", 2L)));
            writer.write(new TSRecord(3L, DEVICE2_NAME).addTuple((DataPoint)new FloatDataPoint("s1", 3.0f)).addTuple((DataPoint)new DoubleDataPoint("s2", 3.0)));
            writer.write(new TSRecord(4L, DEVICE2_NAME).addTuple((DataPoint)new FloatDataPoint("s1", 4.0f)).addTuple((DataPoint)new DoubleDataPoint("s2", 4.0)));
        }
    }

    @Test
    public void testCrashedFile() throws Exception {
        File file = new File(FILE_NAME);
        this.generateCrashedFile(file);
        Assert.assertTrue((boolean)file.exists());
        Assert.assertFalse((boolean)new File(FILE_NAME.concat(".resource")).exists());
        this.tsFileResource = new TsFileResource(file);
        try (SealedTsFileRecoverPerformer recoverPerformer = new SealedTsFileRecoverPerformer(this.tsFileResource);){
            recoverPerformer.recover();
            Assert.assertTrue((boolean)recoverPerformer.hasCrashed());
            Assert.assertFalse((boolean)recoverPerformer.canWrite());
        }
        TsFileSequenceReader reader = new TsFileSequenceReader(FILE_NAME);
        List chunkMetadataList = reader.getChunkMetadataList(new Path(DEVICE1_NAME, "s1", true));
        Assert.assertNotNull((Object)chunkMetadataList);
        chunkMetadataList = reader.getChunkMetadataList(new Path(DEVICE1_NAME, "s2", true));
        Assert.assertNotNull((Object)chunkMetadataList);
        chunkMetadataList = reader.getChunkMetadataList(new Path(DEVICE2_NAME, "s1", true));
        Assert.assertNotNull((Object)chunkMetadataList);
        chunkMetadataList = reader.getChunkMetadataList(new Path(DEVICE2_NAME, "s2", true));
        Assert.assertNotNull((Object)chunkMetadataList);
        Assert.assertEquals((long)1L, (long)chunkMetadataList.size());
        Chunk chunk = reader.readMemChunk((ChunkMetadata)chunkMetadataList.get(0));
        Assert.assertEquals((long)3L, (long)chunk.getChunkStatistic().getEndTime());
        reader.close();
        Assert.assertEquals((long)1L, (long)this.tsFileResource.getStartTime(DEVICE1_NAME));
        Assert.assertEquals((long)2L, (long)this.tsFileResource.getEndTime(DEVICE1_NAME));
        Assert.assertEquals((long)3L, (long)this.tsFileResource.getStartTime(DEVICE2_NAME));
        Assert.assertEquals((long)3L, (long)this.tsFileResource.getEndTime(DEVICE2_NAME));
        Assert.assertTrue((boolean)file.exists());
        Assert.assertTrue((boolean)new File(FILE_NAME.concat(".resource")).exists());
    }

    private void generateCrashedFile(File tsFile) throws IOException, WriteProcessException {
        long truncateSize;
        try (TsFileWriter writer = new TsFileWriter(tsFile);){
            writer.registerTimeseries(new Path(DEVICE1_NAME), new MeasurementSchema("s1", TSDataType.INT32, TSEncoding.RLE));
            writer.registerTimeseries(new Path(DEVICE1_NAME), new MeasurementSchema("s2", TSDataType.INT64, TSEncoding.RLE));
            writer.registerTimeseries(new Path(DEVICE2_NAME), new MeasurementSchema("s1", TSDataType.FLOAT, TSEncoding.RLE));
            writer.registerTimeseries(new Path(DEVICE2_NAME), new MeasurementSchema("s2", TSDataType.DOUBLE, TSEncoding.RLE));
            writer.write(new TSRecord(1L, DEVICE1_NAME).addTuple((DataPoint)new IntDataPoint("s1", 1)).addTuple((DataPoint)new LongDataPoint("s2", 1L)));
            writer.write(new TSRecord(2L, DEVICE1_NAME).addTuple((DataPoint)new IntDataPoint("s1", 2)).addTuple((DataPoint)new LongDataPoint("s2", 2L)));
            writer.write(new TSRecord(3L, DEVICE2_NAME).addTuple((DataPoint)new FloatDataPoint("s1", 3.0f)).addTuple((DataPoint)new DoubleDataPoint("s2", 3.0)));
            writer.flushAllChunkGroups();
            try (FileChannel channel = new FileInputStream(tsFile).getChannel();){
                truncateSize = channel.size();
            }
            writer.write(new TSRecord(4L, DEVICE2_NAME).addTuple((DataPoint)new FloatDataPoint("s1", 4.0f)).addTuple((DataPoint)new DoubleDataPoint("s2", 4.0)));
            writer.flushAllChunkGroups();
            channel = new FileInputStream(tsFile).getChannel();
            try {
                truncateSize = (truncateSize + channel.size()) / 2L;
            }
            finally {
                if (channel != null) {
                    channel.close();
                }
            }
        }
        try (FileChannel channel = new FileOutputStream(tsFile, true).getChannel();){
            channel.truncate(truncateSize);
        }
    }
}

