/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.wal.recover;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.wal.buffer.IWALByteBufferView;
import org.apache.iotdb.db.wal.buffer.WALEntryValue;
import org.apache.iotdb.db.wal.buffer.WALInfoEntry;
import org.apache.iotdb.db.wal.io.WALByteBufReader;
import org.apache.iotdb.db.wal.io.WALMetaData;
import org.apache.iotdb.db.wal.io.WALWriter;
import org.apache.iotdb.db.wal.recover.WALRecoverWriter;
import org.apache.iotdb.db.wal.utils.WALByteBufferForTest;
import org.apache.iotdb.db.wal.utils.WALFileStatus;
import org.apache.iotdb.db.wal.utils.WALFileUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class WALRecoverWriterTest {
    private final File logFile = new File(TestConstant.BASE_OUTPUT_PATH.concat(WALFileUtils.getLogFileName((long)1L, (long)1L, (WALFileStatus)WALFileStatus.CONTAINS_SEARCH_INDEX)));

    @After
    public void tearDown() throws Exception {
        this.logFile.delete();
    }

    @Test
    public void testEmptyFile() throws IOException {
        this.logFile.createNewFile();
        long firstSearchIndex = WALFileUtils.parseStartSearchIndex((String)this.logFile.getName());
        WALMetaData walMetaData = new WALMetaData(firstSearchIndex, new ArrayList());
        WALRecoverWriter walRecoverWriter = new WALRecoverWriter(this.logFile);
        walRecoverWriter.recover(walMetaData);
        Assert.assertEquals((long)(17 + WALWriter.MAGIC_STRING_BYTES), (long)this.logFile.length());
        try (WALByteBufReader reader = new WALByteBufReader(this.logFile);){
            Assert.assertFalse((boolean)reader.hasNext());
            Assert.assertEquals((long)firstSearchIndex, (long)reader.getFirstSearchIndex());
        }
    }

    @Test
    public void testFileWithoutMagicString() throws IOException {
        this.logFile.createNewFile();
        try (OutputStream stream = Files.newOutputStream(this.logFile.toPath(), new OpenOption[0]);){
            stream.write(1);
        }
        long firstSearchIndex = WALFileUtils.parseStartSearchIndex((String)this.logFile.getName());
        WALMetaData walMetaData = new WALMetaData(firstSearchIndex, new ArrayList());
        WALRecoverWriter walRecoverWriter = new WALRecoverWriter(this.logFile);
        walRecoverWriter.recover(walMetaData);
        Assert.assertEquals((long)(17 + WALWriter.MAGIC_STRING_BYTES), (long)this.logFile.length());
        try (WALByteBufReader reader = new WALByteBufReader(this.logFile);){
            Assert.assertFalse((boolean)reader.hasNext());
            Assert.assertEquals((long)firstSearchIndex, (long)reader.getFirstSearchIndex());
        }
    }

    @Test
    public void testCompleteFile() throws IOException, IllegalPathException {
        WALMetaData walMetaData = new WALMetaData();
        WALInfoEntry walEntry = new WALInfoEntry(1L, (WALEntryValue)WALRecoverWriterTest.getInsertRowNode());
        int size = walEntry.serializedSize();
        WALByteBufferForTest buffer = new WALByteBufferForTest(ByteBuffer.allocate(size));
        walEntry.serialize((IWALByteBufferView)buffer);
        walMetaData.add(size, 1L);
        try (WALWriter walWriter = new WALWriter(this.logFile);){
            walWriter.write(buffer.getBuffer(), walMetaData);
        }
        WALRecoverWriter walRecoverWriter = new WALRecoverWriter(this.logFile);
        walRecoverWriter.recover(walMetaData);
        try (WALByteBufReader reader = new WALByteBufReader(this.logFile);){
            Assert.assertTrue((boolean)reader.hasNext());
            Assert.assertEquals((long)size, (long)reader.next().capacity());
            Assert.assertFalse((boolean)reader.hasNext());
            Assert.assertEquals((long)1L, (long)reader.getFirstSearchIndex());
        }
    }

    @Test
    public void testFileWithBrokenMagicString() throws IOException, IllegalPathException {
        WALMetaData walMetaData = new WALMetaData();
        WALInfoEntry walEntry = new WALInfoEntry(1L, (WALEntryValue)WALRecoverWriterTest.getInsertRowNode());
        int size = walEntry.serializedSize();
        WALByteBufferForTest buffer = new WALByteBufferForTest(ByteBuffer.allocate(size));
        walEntry.serialize((IWALByteBufferView)buffer);
        walMetaData.add(size, 1L);
        try (WALWriter walWriter = new WALWriter(this.logFile);){
            walWriter.write(buffer.getBuffer(), walMetaData);
        }
        long len = this.logFile.length();
        try (FileChannel channel = FileChannel.open(this.logFile.toPath(), StandardOpenOption.APPEND);){
            channel.truncate(len - 1L);
        }
        WALRecoverWriter walRecoverWriter = new WALRecoverWriter(this.logFile);
        walRecoverWriter.recover(walMetaData);
        try (WALByteBufReader reader = new WALByteBufReader(this.logFile);){
            Assert.assertTrue((boolean)reader.hasNext());
            Assert.assertEquals((long)size, (long)reader.next().capacity());
            Assert.assertFalse((boolean)reader.hasNext());
            Assert.assertEquals((long)1L, (long)reader.getFirstSearchIndex());
        }
    }

    public static InsertRowNode getInsertRowNode() throws IllegalPathException {
        String devicePath = "root.test_sg.test_d";
        long time = 110L;
        TSDataType[] dataTypes = new TSDataType[]{TSDataType.DOUBLE, TSDataType.FLOAT, TSDataType.INT64, TSDataType.INT32, TSDataType.BOOLEAN, TSDataType.TEXT};
        Object[] columns = new Object[]{1.0, Float.valueOf(2.0f), 10000L, 100, false, new Binary("hh0")};
        InsertRowNode insertRowNode = new InsertRowNode(new PlanNodeId(""), new PartialPath(devicePath), false, new String[]{"s1", "s2", "s3", "s4", "s5", "s6"}, dataTypes, time, columns, false);
        insertRowNode.setSearchIndex(1L);
        insertRowNode.setMeasurementSchemas(new MeasurementSchema[]{new MeasurementSchema("s1", TSDataType.DOUBLE), new MeasurementSchema("s2", TSDataType.FLOAT), new MeasurementSchema("s3", TSDataType.INT64), new MeasurementSchema("s4", TSDataType.INT32), new MeasurementSchema("s5", TSDataType.BOOLEAN), new MeasurementSchema("s6", TSDataType.TEXT)});
        return insertRowNode;
    }
}

