/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.wal.node;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.engine.memtable.IMemTable;
import org.apache.iotdb.db.engine.memtable.PrimitiveMemTable;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.db.wal.checkpoint.MemTableInfo;
import org.apache.iotdb.db.wal.io.WALReader;
import org.apache.iotdb.db.wal.node.WALNode;
import org.apache.iotdb.db.wal.recover.CheckpointRecoverUtils;
import org.apache.iotdb.db.wal.utils.WALFileStatus;
import org.apache.iotdb.db.wal.utils.WALFileUtils;
import org.apache.iotdb.db.wal.utils.WALMode;
import org.apache.iotdb.db.wal.utils.listener.AbstractResultListener;
import org.apache.iotdb.db.wal.utils.listener.WALFlushListener;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.BitMap;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WALNodeTest {
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final String identifier = String.valueOf(Integer.MAX_VALUE);
    private static final String logDirectory = TestConstant.BASE_OUTPUT_PATH.concat("wal-test");
    private static final String devicePath = "root.test_sg.test_d";
    private WALMode prevMode;
    private WALNode walNode;
    private boolean isClusterMode;

    @Before
    public void setUp() throws Exception {
        EnvironmentUtils.cleanDir(logDirectory);
        this.prevMode = config.getWalMode();
        this.isClusterMode = config.isClusterMode();
        config.setWalMode(WALMode.SYNC);
        config.setClusterMode(true);
        this.walNode = new WALNode(identifier, logDirectory);
    }

    @After
    public void tearDown() throws Exception {
        this.walNode.close();
        config.setWalMode(this.prevMode);
        config.setClusterMode(this.isClusterMode);
        EnvironmentUtils.cleanDir(logDirectory);
    }

    @Test
    public void testConcurrentWrite() throws Exception {
        int threadsNum = 3;
        ExecutorService executorService = Executors.newFixedThreadPool(threadsNum);
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        List<WALFlushListener> walFlushListeners = Collections.synchronizedList(new ArrayList());
        ConcurrentHashMap.KeySetView expectedInsertTabletNodes = ConcurrentHashMap.newKeySet();
        int i = 0;
        while (i < threadsNum) {
            int n = i++;
            Callable<Void> writeTask = () -> {
                try {
                    this.writeInsertTabletNode(memTableId, expectedInsertTabletNodes, walFlushListeners);
                }
                catch (IllegalPathException e) {
                    Assert.fail();
                }
                return null;
            };
            Future<Void> future = executorService.submit(writeTask);
            futures.add(future);
        }
        for (Future future : futures) {
            future.get();
        }
        while (!this.walNode.isAllWALEntriesConsumed()) {
            Thread.sleep(1000L);
        }
        Thread.sleep(1000L);
        File[] walFiles = WALFileUtils.listAllWALFiles((File)new File(logDirectory));
        HashSet<InsertTabletNode> hashSet = new HashSet<InsertTabletNode>();
        if (walFiles != null) {
            for (File walFile : walFiles) {
                try (WALReader walReader = new WALReader(walFile);){
                    while (walReader.hasNext()) {
                        hashSet.add((InsertTabletNode)walReader.next().getValue());
                    }
                }
            }
        }
        Assert.assertEquals(expectedInsertTabletNodes, hashSet);
        try {
            for (WALFlushListener walFlushListener : walFlushListeners) {
                Assert.assertNotEquals((Object)AbstractResultListener.Status.FAILURE, (Object)walFlushListener.waitForResult());
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void writeInsertTabletNode(int memTableId, Set<InsertTabletNode> expectedInsertTabletNodes, List<WALFlushListener> walFlushListeners) throws IllegalPathException {
        for (int i = 0; i < 100; ++i) {
            InsertTabletNode insertTabletNode = this.getInsertTabletNode(devicePath + memTableId, new long[]{i});
            expectedInsertTabletNodes.add(insertTabletNode);
            WALFlushListener walFlushListener = this.walNode.log((long)memTableId, insertTabletNode, 0, insertTabletNode.getRowCount());
            walFlushListeners.add(walFlushListener);
        }
    }

    private InsertTabletNode getInsertTabletNode(String devicePath, long[] times) throws IllegalPathException {
        String[] measurements = new String[]{"s1", "s2", "s3", "s4", "s5", "s6"};
        TSDataType[] dataTypes = new TSDataType[]{TSDataType.DOUBLE, TSDataType.FLOAT, TSDataType.INT64, TSDataType.INT32, TSDataType.BOOLEAN, TSDataType.TEXT};
        Object[] columns = new Object[]{new double[times.length], new float[times.length], new long[times.length], new int[times.length], new boolean[times.length], new Binary[times.length]};
        for (int r = 0; r < times.length; ++r) {
            ((double[])columns[0])[r] = 1.0 + (double)r;
            ((float[])columns[1])[r] = 2.0f + (float)r;
            ((long[])columns[2])[r] = 10000L + (long)r;
            ((int[])columns[3])[r] = 100 + r;
            ((boolean[])columns[4])[r] = r % 2 == 0;
            ((Binary[])columns[5])[r] = new Binary("hh" + r);
        }
        BitMap[] bitMaps = new BitMap[dataTypes.length];
        for (int i = 0; i < dataTypes.length; ++i) {
            if (bitMaps[i] == null) {
                bitMaps[i] = new BitMap(times.length);
            }
            bitMaps[i].mark(i % times.length);
        }
        InsertTabletNode insertTabletNode = new InsertTabletNode(new PlanNodeId(""), new PartialPath(devicePath), false, measurements, dataTypes, times, bitMaps, columns, times.length);
        MeasurementSchema[] schemas = new MeasurementSchema[6];
        for (int i = 0; i < 6; ++i) {
            schemas[i] = new MeasurementSchema(measurements[i], dataTypes[i], TSEncoding.PLAIN);
        }
        insertTabletNode.setMeasurementSchemas(schemas);
        return insertTabletNode;
    }

    @Test
    public void testConcurrentCheckpoint() throws Exception {
        int threadsNum = 5;
        ExecutorService executorService = Executors.newFixedThreadPool(threadsNum);
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        ConcurrentHashMap expectedMemTableId2Info = new ConcurrentHashMap();
        int memTablesNum = 10;
        for (int i = 0; i < memTablesNum; ++i) {
            Callable<Void> callable = () -> {
                PrimitiveMemTable memTable = new PrimitiveMemTable();
                long memTableId = memTable.getMemTableId();
                String tsFilePath = logDirectory + File.separator + memTableId + ".tsfile";
                long firstFileVersionId = this.walNode.getCurrentLogVersion();
                this.walNode.onMemTableCreated((IMemTable)memTable, tsFilePath);
                if (memTableId % 2L == 0L) {
                    this.walNode.onMemTableFlushed((IMemTable)memTable);
                } else {
                    MemTableInfo memTableInfo = new MemTableInfo((IMemTable)memTable, tsFilePath, firstFileVersionId);
                    expectedMemTableId2Info.put(memTableId, memTableInfo);
                }
                return null;
            };
            Future<Void> future = executorService.submit(callable);
            futures.add(future);
        }
        for (Future future : futures) {
            future.get();
        }
        Map actualMemTableId2Info = CheckpointRecoverUtils.recoverMemTableInfo((File)new File(logDirectory)).getMemTableId2Info();
        Assert.assertEquals(expectedMemTableId2Info, (Object)actualMemTableId2Info);
    }

    @Test
    public void testDeleteOutdatedFiles() throws Exception {
        ArrayList<WALFlushListener> walFlushListeners = new ArrayList<WALFlushListener>();
        long time = 0L;
        PrimitiveMemTable memTable = new PrimitiveMemTable();
        long memTableId = memTable.getMemTableId();
        String tsFilePath = logDirectory + File.separator + memTableId + ".tsfile";
        this.walNode.onMemTableCreated((IMemTable)memTable, tsFilePath);
        while (this.walNode.getCurrentLogVersion() == 0L) {
            InsertTabletNode insertTabletNode = this.getInsertTabletNode(devicePath + memTableId, new long[]{++time});
            WALFlushListener walFlushListener = this.walNode.log(memTableId, insertTabletNode, 0, insertTabletNode.getRowCount());
            walFlushListeners.add(walFlushListener);
        }
        this.walNode.onMemTableFlushed((IMemTable)memTable);
        this.walNode.onMemTableCreated((IMemTable)new PrimitiveMemTable(), tsFilePath);
        Assert.assertTrue((boolean)new File(logDirectory + File.separator + WALFileUtils.getLogFileName((long)0L, (long)0L, (WALFileStatus)WALFileStatus.CONTAINS_NONE_SEARCH_INDEX)).exists());
        Assert.assertTrue((boolean)new File(logDirectory + File.separator + WALFileUtils.getLogFileName((long)1L, (long)0L, (WALFileStatus)WALFileStatus.CONTAINS_SEARCH_INDEX)).exists());
        this.walNode.deleteOutdatedFiles();
        Assert.assertFalse((boolean)new File(logDirectory + File.separator + WALFileUtils.getLogFileName((long)0L, (long)0L, (WALFileStatus)WALFileStatus.CONTAINS_NONE_SEARCH_INDEX)).exists());
        Assert.assertTrue((boolean)new File(logDirectory + File.separator + WALFileUtils.getLogFileName((long)1L, (long)0L, (WALFileStatus)WALFileStatus.CONTAINS_SEARCH_INDEX)).exists());
        try {
            for (WALFlushListener walFlushListener : walFlushListeners) {
                Assert.assertNotEquals((Object)AbstractResultListener.Status.FAILURE, (Object)walFlushListener.waitForResult());
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

