/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.wal;

import java.io.File;
import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.db.wal.WALManager;
import org.apache.iotdb.db.wal.node.WALNode;
import org.apache.iotdb.db.wal.utils.WALFileUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WALManagerTest {
    private static final CommonConfig commonConfig = CommonDescriptor.getInstance().getConfig();
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private final String[] walDirs = new String[]{TestConstant.BASE_OUTPUT_PATH.concat("wal_test1"), TestConstant.BASE_OUTPUT_PATH.concat("wal_test2"), TestConstant.BASE_OUTPUT_PATH.concat("wal_test3")};
    private String[] prevWalDirs;

    @Before
    public void setUp() throws Exception {
        this.prevWalDirs = commonConfig.getWalDirs();
        commonConfig.setWalDirs(this.walDirs);
        EnvironmentUtils.envSetUp();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
        for (String walDir : this.walDirs) {
            EnvironmentUtils.cleanDir(walDir);
        }
        commonConfig.setWalDirs(this.prevWalDirs);
    }

    @Test
    public void testDeleteOutdatedWALFiles() throws IllegalPathException {
        File[] nodeDirs;
        File walDirFile;
        WALManager walManager = WALManager.getInstance();
        WALNode[] walNodes = new WALNode[3];
        for (int i = 0; i < 12; ++i) {
            WALNode walNode = (WALNode)walManager.applyForWALNode(String.valueOf(i));
            if (i % 4 == 0) {
                walNodes[i / 4] = walNode;
            } else {
                Assert.assertEquals((Object)walNodes[i / 4], (Object)walNode);
            }
            walNode.log((long)i, this.getInsertRowNode());
            walNode.rollWALFile();
        }
        for (String walDir : this.walDirs) {
            walDirFile = new File(walDir);
            Assert.assertTrue((boolean)walDirFile.exists());
            nodeDirs = walDirFile.listFiles(File::isDirectory);
            Assert.assertNotNull((Object)nodeDirs);
            for (File nodeDir : nodeDirs) {
                Assert.assertTrue((boolean)nodeDir.exists());
                Assert.assertEquals((long)5L, (long)WALFileUtils.listAllWALFiles((File)nodeDir).length);
            }
        }
        walManager.deleteOutdatedWALFiles();
        for (String walDir : this.walDirs) {
            walDirFile = new File(walDir);
            Assert.assertTrue((boolean)walDirFile.exists());
            nodeDirs = walDirFile.listFiles(File::isDirectory);
            Assert.assertNotNull((Object)nodeDirs);
            for (File nodeDir : nodeDirs) {
                Assert.assertTrue((boolean)nodeDir.exists());
                Assert.assertEquals((long)1L, (long)WALFileUtils.listAllWALFiles((File)nodeDir).length);
            }
        }
    }

    private InsertRowNode getInsertRowNode() throws IllegalPathException {
        long time = 110L;
        TSDataType[] dataTypes = new TSDataType[]{TSDataType.DOUBLE, TSDataType.FLOAT, TSDataType.INT64, TSDataType.INT32, TSDataType.BOOLEAN, TSDataType.TEXT};
        Object[] columns = new Object[]{1.0, Float.valueOf(2.0f), 10000L, 100, false, new Binary("hh0")};
        InsertRowNode node = new InsertRowNode(new PlanNodeId(""), new PartialPath("root.test_sg.test_d"), false, new String[]{"s1", "s2", "s3", "s4", "s5", "s6"}, dataTypes, time, columns, false);
        node.setMeasurementSchemas(new MeasurementSchema[]{new MeasurementSchema("s1", TSDataType.DOUBLE), new MeasurementSchema("s2", TSDataType.FLOAT), new MeasurementSchema("s3", TSDataType.INT64), new MeasurementSchema("s4", TSDataType.INT32), new MeasurementSchema("s5", TSDataType.BOOLEAN), new MeasurementSchema("s6", TSDataType.TEXT)});
        return node;
    }
}

