/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.writelog;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.CRC32;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTimeSeriesPlan;
import org.apache.iotdb.db.utils.writelog.LogWriter;
import org.apache.iotdb.db.utils.writelog.SingleFileLogReader;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LogWriterReaderTest {
    private static String filePath = "logtest.test";
    ByteBuffer logsBuffer = ByteBuffer.allocate(65536);
    List<PhysicalPlan> plans = new ArrayList<PhysicalPlan>();

    @Before
    public void prepare() throws IllegalPathException {
        if (new File(filePath).exists()) {
            new File(filePath).delete();
        }
        CreateTimeSeriesPlan plan1 = new CreateTimeSeriesPlan(new PartialPath("d1.s1"), TSDataType.INT64, TSEncoding.PLAIN, CompressionType.SNAPPY, null, null, null, null);
        CreateTimeSeriesPlan plan2 = new CreateTimeSeriesPlan(new PartialPath("d1.s2"), TSDataType.INT64, TSEncoding.PLAIN, CompressionType.SNAPPY, null, null, null, null);
        ArrayList<PartialPath> paths = new ArrayList<PartialPath>();
        paths.add(new PartialPath("d1.s1"));
        paths.add(new PartialPath("d1.s2"));
        this.plans.add((PhysicalPlan)plan1);
        this.plans.add((PhysicalPlan)plan2);
        for (PhysicalPlan plan : this.plans) {
            plan.serialize(this.logsBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteAndRead() throws IOException {
        LogWriter writer = new LogWriter(filePath, false);
        writer.write(this.logsBuffer);
        try {
            writer.force();
            writer.close();
            SingleFileLogReader reader = new SingleFileLogReader(new File(filePath));
            ArrayList<PhysicalPlan> res = new ArrayList<PhysicalPlan>();
            while (reader.hasNext()) {
                res.add(reader.next());
            }
            for (int i = 0; i < this.plans.size(); ++i) {
                Assert.assertEquals((Object)this.plans.get(i), res.get(i));
            }
            reader.close();
        }
        finally {
            new File(filePath).delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReachEOF() throws IOException {
        try {
            try (LogWriter writer = new LogWriter(filePath, false);){
                writer.write(this.logsBuffer);
                writer.force();
            }
            long expectedLength = new File(filePath).length();
            try (FileOutputStream outputStream = new FileOutputStream(filePath, true);
                 FileChannel channel = outputStream.getChannel();){
                ByteBuffer logBuffer = ByteBuffer.allocate(120);
                for (int i = 0; i < 20; ++i) {
                    logBuffer.putInt(Integer.MIN_VALUE);
                }
                logBuffer.flip();
                ByteBuffer lengthBuffer = ByteBuffer.allocate(4);
                lengthBuffer.putInt(logBuffer.capacity());
                lengthBuffer.flip();
                channel.write(lengthBuffer);
                channel.write(logBuffer);
                channel.force(true);
            }
            try (SingleFileLogReader reader = new SingleFileLogReader(new File(filePath));){
                ArrayList<PhysicalPlan> res = new ArrayList<PhysicalPlan>();
                while (reader.hasNext()) {
                    res.add(reader.next());
                }
                for (int i = 0; i < this.plans.size(); ++i) {
                    Assert.assertEquals((Object)this.plans.get(i), res.get(i));
                }
            }
            Assert.assertEquals((long)expectedLength, (long)new File(filePath).length());
        }
        finally {
            new File(filePath).delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTruncateBrokenLogs() throws IOException {
        try {
            try (LogWriter writer = new LogWriter(filePath, false);){
                writer.write(this.logsBuffer);
                writer.force();
            }
            long expectedLength = new File(filePath).length();
            try (FileOutputStream outputStream = new FileOutputStream(filePath, true);
                 FileChannel channel = outputStream.getChannel();){
                ByteBuffer logBuffer = ByteBuffer.allocate(120);
                for (int i = 0; i < 30; ++i) {
                    logBuffer.putInt(Integer.MIN_VALUE);
                }
                logBuffer.flip();
                ByteBuffer lengthBuffer = ByteBuffer.allocate(4);
                lengthBuffer.putInt(logBuffer.limit());
                lengthBuffer.flip();
                CRC32 checkSummer = new CRC32();
                checkSummer.reset();
                checkSummer.update(logBuffer);
                ByteBuffer checkSumBuffer = ByteBuffer.allocate(8);
                checkSumBuffer.putLong(checkSummer.getValue());
                logBuffer.flip();
                checkSumBuffer.flip();
                channel.write(lengthBuffer);
                channel.write(logBuffer);
                channel.write(checkSumBuffer);
                channel.force(true);
            }
            try (SingleFileLogReader reader = new SingleFileLogReader(new File(filePath));){
                ArrayList<PhysicalPlan> res = new ArrayList<PhysicalPlan>();
                while (reader.hasNext()) {
                    res.add(reader.next());
                }
                for (int i = 0; i < this.plans.size(); ++i) {
                    Assert.assertEquals((Object)this.plans.get(i), res.get(i));
                }
            }
            Assert.assertEquals((long)expectedLength, (long)new File(filePath).length());
        }
        finally {
            new File(filePath).delete();
        }
    }
}

