/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import java.util.Collections;
import java.util.Random;
import java.util.TreeSet;
import org.apache.iotdb.db.utils.datastructure.TimeSelector;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TimeSelectorTest {
    private static final long DEFAULT_ITERATION_TIMES = 10000L;
    private TreeSet<Long> selector1;
    private TimeSelector selector2;

    @Before
    public void setUp() {
        this.selector1 = new TreeSet();
        this.selector2 = new TimeSelector(8, true);
    }

    @Test
    public void testEmpty() {
        Assert.assertTrue((boolean)this.selector2.isEmpty());
    }

    @Test
    public void testAdd1() {
        this.selector1.add(0L);
        this.selector2.add(0L);
        this.assertEquals();
    }

    @Test
    public void testAdd2() {
        for (long i = 0L; i < 10000L; ++i) {
            this.selector1.add(0L);
            this.selector2.add(0L);
        }
        this.assertEquals();
    }

    @Test
    public void testAdd3() {
        for (long i = 0L; i < 10000L; ++i) {
            this.selector1.add(i);
            this.selector2.add(i);
        }
        this.assertEquals();
    }

    @Test
    public void testAdd4() {
        for (long i = 0L; i < 10000L; ++i) {
            this.selector1.add(10000L - i);
            this.selector2.add(10000L - i);
        }
        this.assertEquals();
    }

    @Test
    public void testAdd5() {
        for (long i = 0L; i < 10000L; ++i) {
            this.selector1.add(i);
            this.selector1.add(10000L - i);
            this.selector1.add(i);
            this.selector1.add(10000L - i);
            this.selector2.add(i);
            this.selector2.add(10000L - i);
            this.selector2.add(i);
            this.selector2.add(10000L - i);
        }
        this.assertEquals();
    }

    @Test
    public void testAdd6() {
        for (long i = 0L; i < 10000L; ++i) {
            this.selector1.add(i);
            this.selector1.add(i + 2L);
            this.selector1.add(i + 1L);
            this.selector1.add(i - 1L);
            this.selector1.add(i);
            this.selector2.add(i);
            this.selector2.add(i + 2L);
            this.selector2.add(i + 1L);
            this.selector2.add(i - 1L);
            this.selector2.add(i);
        }
        this.assertEquals();
    }

    @Test
    public void testAdd7() {
        Random random = new Random();
        for (long i = 0L; i < 10000L; ++i) {
            long nextRandomLong = random.nextLong();
            this.selector1.add(nextRandomLong);
            this.selector2.add(nextRandomLong);
        }
        this.assertEquals();
    }

    @Test
    public void testAddAndPoll1() {
        for (long i = 0L; i < 10000L; ++i) {
            this.selector1.add(i);
            this.selector2.add(i);
            if (i % 3L != 0L) continue;
            this.selector1.pollFirst();
            this.selector2.pollFirst();
        }
        this.assertEquals();
    }

    @Test
    public void testAddAndPoll2() {
        for (long i = 0L; i < 10000L; ++i) {
            this.selector1.add(10000L - i);
            this.selector1.add(i);
            this.selector2.add(10000L - i);
            this.selector2.add(i);
            if (i % 3L == 0L) {
                this.selector1.pollFirst();
                this.selector2.pollFirst();
            }
            Assert.assertEquals((long)this.selector1.first(), (long)this.selector2.first());
        }
        this.assertEquals();
    }

    @Test
    public void testAddAndPoll3() {
        for (long i = 0L; i < 10000L; ++i) {
            this.selector1.add(i);
            this.selector1.add(i + 2L);
            this.selector1.pollFirst();
            this.selector1.add(i + 1L);
            this.selector1.add(i - 1L);
            this.selector1.pollFirst();
            this.selector1.add(i);
            this.selector1.pollFirst();
            this.selector2.add(i);
            this.selector2.add(i + 2L);
            this.selector2.pollFirst();
            this.selector2.add(i + 1L);
            this.selector2.add(i - 1L);
            this.selector2.pollFirst();
            this.selector2.add(i);
            this.selector2.pollFirst();
        }
        this.assertEquals();
    }

    @Test
    public void testDescending() {
        this.selector1 = new TreeSet(Collections.reverseOrder());
        this.selector2 = new TimeSelector(8, false);
        for (long i = 0L; i < 10000L; ++i) {
            this.selector1.add(i);
            this.selector1.add(i + 2L);
            this.selector1.pollFirst();
            this.selector1.add(i + 1L);
            this.selector1.add(i - 1L);
            this.selector1.pollFirst();
            this.selector1.add(i);
            this.selector1.pollFirst();
            this.selector2.add(i);
            this.selector2.add(i + 2L);
            this.selector2.pollFirst();
            this.selector2.add(i + 1L);
            this.selector2.add(i - 1L);
            this.selector2.pollFirst();
            this.selector2.add(i);
            this.selector2.pollFirst();
        }
        this.assertEquals();
    }

    @Test
    public void testAddAndPeek() {
        long[] elements = new long[]{0L, 2L, 1L, -1L, 0L, 1L, -1L, 0L};
        long[] results = new long[]{-1L, 0L, 1L, 2L};
        for (long element : elements) {
            this.selector1.add(element);
            this.selector2.add(element);
        }
        for (long result : results) {
            Assert.assertEquals((long)result, (long)this.selector1.first());
            Assert.assertEquals((long)result, (long)this.selector2.first());
            this.selector1.pollFirst();
            this.selector2.pollFirst();
        }
        Assert.assertTrue((boolean)this.selector1.isEmpty());
        Assert.assertTrue((boolean)this.selector2.isEmpty());
    }

    private void assertEquals() {
        Assert.assertFalse((boolean)this.selector2.isEmpty());
        Assert.assertFalse((boolean)this.selector2.isEmpty());
        while (!this.selector1.isEmpty()) {
            Assert.assertFalse((boolean)this.selector2.isEmpty());
            Assert.assertEquals((long)this.selector1.pollFirst(), (long)this.selector2.pollFirst());
        }
        Assert.assertTrue((boolean)this.selector2.isEmpty());
        Assert.assertTrue((boolean)this.selector2.isEmpty());
    }
}

