/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import java.util.ArrayList;
import java.util.Random;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.iotdb.db.utils.datastructure.LongTVList;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.utils.BitMap;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;
import org.junit.Assert;
import org.junit.Test;

public class LongTVListTest {
    @Test
    public void testLongTVList1() {
        long i;
        LongTVList tvList = LongTVList.newList();
        for (i = 0L; i < 1000L; ++i) {
            tvList.putLong(i, i);
        }
        tvList.sort();
        for (i = 0L; i < (long)tvList.rowCount; ++i) {
            Assert.assertEquals((long)i, (long)tvList.getLong((int)i));
            Assert.assertEquals((long)i, (long)tvList.getTime((int)i));
        }
    }

    @Test
    public void testLongTVList2() {
        long i;
        LongTVList tvList = LongTVList.newList();
        for (i = 1000L; i >= 0L; --i) {
            tvList.putLong(i, i);
        }
        tvList.sort();
        for (i = 0L; i < (long)tvList.rowCount; ++i) {
            Assert.assertEquals((long)i, (long)tvList.getLong((int)i));
            Assert.assertEquals((long)i, (long)tvList.getTime((int)i));
        }
    }

    @Test
    public void testLongTVList3() {
        long i;
        Random random = new Random();
        LongTVList tvList = LongTVList.newList();
        ArrayList<TimeValuePair> inputs = new ArrayList<TimeValuePair>();
        for (i = 0L; i < 10000L; ++i) {
            long time = random.nextInt(10000);
            long value = random.nextInt(10000);
            tvList.putLong(time, value);
            inputs.add(new TimeValuePair(time, (TsPrimitiveType)new TsPrimitiveType.TsLong(value)));
        }
        tvList.sort();
        inputs.sort(TimeValuePair::compareTo);
        for (i = 0L; i < (long)tvList.rowCount; ++i) {
            Assert.assertEquals((long)((TimeValuePair)inputs.get((int)i)).getTimestamp(), (long)tvList.getTime((int)i));
            Assert.assertEquals((long)((TimeValuePair)inputs.get((int)i)).getValue().getLong(), (long)tvList.getLong((int)i));
        }
    }

    @Test
    public void testPutLongsWithoutBitMap() {
        long i;
        LongTVList tvList = LongTVList.newList();
        ArrayList<Long> longList = new ArrayList<Long>();
        ArrayList<Long> timeList = new ArrayList<Long>();
        for (i = 1000L; i >= 0L; --i) {
            timeList.add(i);
            longList.add(i);
        }
        tvList.putLongs(ArrayUtils.toPrimitive((Long[])timeList.toArray(new Long[0])), ArrayUtils.toPrimitive((Long[])longList.toArray(new Long[0])), null, 0, 1000);
        for (i = 0L; i < (long)tvList.rowCount; ++i) {
            Assert.assertEquals((long)((long)tvList.rowCount - i), (long)tvList.getLong((int)i));
            Assert.assertEquals((long)((long)tvList.rowCount - i), (long)tvList.getTime((int)i));
        }
    }

    @Test
    public void testPutIntsWithBitMap() {
        LongTVList tvList = LongTVList.newList();
        ArrayList<Long> longList = new ArrayList<Long>();
        ArrayList<Long> timeList = new ArrayList<Long>();
        BitMap bitMap = new BitMap(1001);
        for (long i = 1000L; i >= 0L; --i) {
            timeList.add(i);
            longList.add(i);
            if (i % 100L != 0L) continue;
            bitMap.mark((int)i);
        }
        tvList.putLongs(ArrayUtils.toPrimitive((Long[])timeList.toArray(new Long[0])), ArrayUtils.toPrimitive((Long[])longList.toArray(new Long[0])), bitMap, 0, 1000);
        tvList.sort();
        int nullCnt = 0;
        for (long i = 1L; i < (long)longList.size(); ++i) {
            if (i % 100L == 0L) {
                ++nullCnt;
                continue;
            }
            Assert.assertEquals((long)i, (long)tvList.getLong((int)i - nullCnt - 1));
            Assert.assertEquals((long)i, (long)tvList.getTime((int)i - nullCnt - 1));
        }
    }

    @Test
    public void testClone() {
        LongTVList tvList = LongTVList.newList();
        ArrayList<Long> longList = new ArrayList<Long>();
        ArrayList<Long> timeList = new ArrayList<Long>();
        BitMap bitMap = new BitMap(1001);
        for (long i = 1000L; i >= 0L; --i) {
            timeList.add(i);
            longList.add(i);
            if (i % 100L != 0L) continue;
            bitMap.mark((int)i);
        }
        tvList.putLongs(ArrayUtils.toPrimitive((Long[])timeList.toArray(new Long[0])), ArrayUtils.toPrimitive((Long[])longList.toArray(new Long[0])), bitMap, 0, 1000);
        tvList.sort();
        LongTVList clonedTvList = tvList.clone();
        for (long i = 0L; i < (long)tvList.rowCount; ++i) {
            Assert.assertEquals((long)tvList.getLong((int)i), (long)clonedTvList.getLong((int)i));
            Assert.assertEquals((long)tvList.getTime((int)i), (long)clonedTvList.getTime((int)i));
        }
    }
}

