/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.iotdb.db.utils.datastructure.IntTVList;
import org.apache.iotdb.tsfile.utils.BitMap;
import org.junit.Assert;
import org.junit.Test;

public class IntTVListTest {
    @Test
    public void testIntTVList1() {
        int i;
        IntTVList tvList = IntTVList.newList();
        for (i = 0; i < 1000; ++i) {
            tvList.putInt((long)i, i);
        }
        tvList.sort();
        for (i = 0; i < tvList.rowCount; ++i) {
            Assert.assertEquals((long)i, (long)tvList.getInt(i));
            Assert.assertEquals((long)i, (long)tvList.getTime(i));
        }
    }

    @Test
    public void testIntTVList2() {
        int i;
        IntTVList tvList = IntTVList.newList();
        for (i = 1000; i >= 0; --i) {
            tvList.putInt((long)i, i);
        }
        tvList.sort();
        for (i = 0; i < tvList.rowCount; ++i) {
            Assert.assertEquals((long)i, (long)tvList.getInt(i));
            Assert.assertEquals((long)i, (long)tvList.getTime(i));
        }
    }

    @Test
    public void testPutIntsWithoutBitMap() {
        IntTVList tvList = IntTVList.newList();
        ArrayList<Integer> intList = new ArrayList<Integer>();
        ArrayList<Long> timeList = new ArrayList<Long>();
        for (int i = 1000; i >= 0; --i) {
            timeList.add(Long.valueOf(i));
            intList.add(i);
        }
        tvList.putInts(ArrayUtils.toPrimitive((Long[])timeList.toArray(new Long[0])), ArrayUtils.toPrimitive((Integer[])intList.toArray(new Integer[0])), null, 0, 1000);
        for (long i = 0L; i < (long)tvList.rowCount; ++i) {
            Assert.assertEquals((long)((long)tvList.rowCount - i), (long)tvList.getInt((int)i));
            Assert.assertEquals((long)((long)tvList.rowCount - i), (long)tvList.getTime((int)i));
        }
    }

    @Test
    public void testPutIntsWithBitMap() {
        IntTVList tvList = IntTVList.newList();
        ArrayList<Integer> intList = new ArrayList<Integer>();
        ArrayList<Long> timeList = new ArrayList<Long>();
        BitMap bitMap = new BitMap(1001);
        for (int i = 1000; i >= 0; --i) {
            timeList.add(Long.valueOf(i));
            intList.add(i);
            if (i % 100 != 0) continue;
            bitMap.mark(i);
        }
        tvList.putInts(ArrayUtils.toPrimitive((Long[])timeList.toArray(new Long[0])), ArrayUtils.toPrimitive((Integer[])intList.toArray(new Integer[0])), bitMap, 0, 1000);
        tvList.sort();
        int nullCnt = 0;
        for (long i = 1L; i < (long)intList.size(); ++i) {
            if (i % 100L == 0L) {
                ++nullCnt;
                continue;
            }
            Assert.assertEquals((long)i, (long)tvList.getInt((int)i - nullCnt - 1));
            Assert.assertEquals((long)i, (long)tvList.getTime((int)i - nullCnt - 1));
        }
    }

    @Test
    public void testClone() {
        IntTVList tvList = IntTVList.newList();
        ArrayList<Integer> intList = new ArrayList<Integer>();
        ArrayList<Long> timeList = new ArrayList<Long>();
        BitMap bitMap = new BitMap(1001);
        for (int i = 1000; i >= 0; --i) {
            timeList.add(Long.valueOf(i));
            intList.add(i);
            if (i % 100 != 0) continue;
            bitMap.mark(i);
        }
        tvList.putInts(ArrayUtils.toPrimitive((Long[])timeList.toArray(new Long[0])), ArrayUtils.toPrimitive((Integer[])intList.toArray(new Integer[0])), bitMap, 0, 1000);
        tvList.sort();
        IntTVList clonedTvList = tvList.clone();
        for (long i = 0L; i < (long)tvList.rowCount; ++i) {
            Assert.assertEquals((long)tvList.getInt((int)i), (long)clonedTvList.getInt((int)i));
            Assert.assertEquals((long)tvList.getTime((int)i), (long)clonedTvList.getTime((int)i));
        }
    }
}

