/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.iotdb.db.utils.datastructure.FloatTVList;
import org.apache.iotdb.tsfile.utils.BitMap;
import org.junit.Assert;
import org.junit.Test;

public class FloatTVListTest {
    public static float delta = 0.001f;

    @Test
    public void testFloatTVList1() {
        int i;
        FloatTVList tvList = FloatTVList.newList();
        for (i = 0; i < 1000; ++i) {
            tvList.putFloat((long)i, (float)i);
        }
        tvList.sort();
        for (i = 0; i < tvList.rowCount; ++i) {
            Assert.assertEquals((float)i, (float)tvList.getFloat(i), (float)delta);
            Assert.assertEquals((long)i, (long)tvList.getTime(i));
        }
    }

    @Test
    public void testFloatTVList2() {
        int i;
        FloatTVList tvList = FloatTVList.newList();
        for (i = 1000; i >= 0; --i) {
            tvList.putFloat((long)i, (float)i);
        }
        tvList.sort();
        for (i = 0; i < tvList.rowCount; ++i) {
            Assert.assertEquals((float)i, (float)tvList.getFloat(i), (float)delta);
            Assert.assertEquals((long)i, (long)tvList.getTime(i));
        }
    }

    @Test
    public void testPutFloatsWithoutBitMap() {
        long i;
        FloatTVList tvList = FloatTVList.newList();
        ArrayList<Float> floatList = new ArrayList<Float>();
        ArrayList<Long> timeList = new ArrayList<Long>();
        for (i = 1000L; i >= 0L; --i) {
            timeList.add(i);
            floatList.add(Float.valueOf(i));
        }
        tvList.putFloats(ArrayUtils.toPrimitive((Long[])timeList.toArray(new Long[0])), ArrayUtils.toPrimitive((Float[])floatList.toArray(new Float[0]), (float)0.0f), null, 0, 1000);
        for (i = 0L; i < (long)tvList.rowCount; ++i) {
            Assert.assertEquals((float)((float)tvList.rowCount - (float)i), (float)tvList.getFloat((int)i), (float)delta);
            Assert.assertEquals((long)((long)tvList.rowCount - i), (long)tvList.getTime((int)i));
        }
    }

    @Test
    public void testPutFloatsWithBitMap() {
        FloatTVList tvList = FloatTVList.newList();
        ArrayList<Float> floatList = new ArrayList<Float>();
        ArrayList<Long> timeList = new ArrayList<Long>();
        BitMap bitMap = new BitMap(1001);
        for (long i = 1000L; i >= 0L; --i) {
            timeList.add(i);
            floatList.add(Float.valueOf(i));
            if (i % 100L != 0L) continue;
            bitMap.mark((int)i);
        }
        tvList.putFloats(ArrayUtils.toPrimitive((Long[])timeList.toArray(new Long[0])), ArrayUtils.toPrimitive((Float[])floatList.toArray(new Float[0]), (float)0.0f), bitMap, 0, 1000);
        tvList.sort();
        int nullCnt = 0;
        for (long i = 1L; i < (long)floatList.size(); ++i) {
            if (i % 100L == 0L) {
                ++nullCnt;
                continue;
            }
            Assert.assertEquals((float)i, (float)tvList.getFloat((int)i - nullCnt - 1), (float)delta);
            Assert.assertEquals((long)i, (long)tvList.getTime((int)i - nullCnt - 1));
        }
    }

    @Test
    public void testClone() {
        FloatTVList tvList = FloatTVList.newList();
        ArrayList<Float> floatList = new ArrayList<Float>();
        ArrayList<Long> timeList = new ArrayList<Long>();
        BitMap bitMap = new BitMap(1001);
        for (long i = 1000L; i >= 0L; --i) {
            timeList.add(i);
            floatList.add(Float.valueOf(i));
            if (i % 100L != 0L) continue;
            bitMap.mark((int)i);
        }
        tvList.putFloats(ArrayUtils.toPrimitive((Long[])timeList.toArray(new Long[0])), ArrayUtils.toPrimitive((Float[])floatList.toArray(new Float[0]), (float)0.0f), bitMap, 0, 1000);
        tvList.sort();
        FloatTVList clonedTvList = tvList.clone();
        for (long i = 0L; i < (long)tvList.rowCount; ++i) {
            Assert.assertEquals((float)tvList.getFloat((int)i), (float)clonedTvList.getFloat((int)i), (float)delta);
            Assert.assertEquals((long)tvList.getTime((int)i), (long)clonedTvList.getTime((int)i));
        }
    }
}

