/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.iotdb.db.utils.datastructure.FixedPriorityBlockingQueue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class FixedPriorityBlockingQueueTest {
    private FixedPriorityBlockingQueue<Integer> queue = new FixedPriorityBlockingQueue(10, Integer::compare);

    @After
    public void tearDown() {
        this.queue.clear();
    }

    @Test
    public void testBlockingTake() throws InterruptedException {
        AtomicBoolean hasTaken = new AtomicBoolean(false);
        Thread t1 = new Thread(() -> {
            try {
                this.queue.take();
                hasTaken.set(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        Thread t2 = new Thread(() -> {
            try {
                Assert.assertFalse((boolean)hasTaken.get());
                this.queue.put((Object)1);
                Thread.sleep(500L);
                Assert.assertTrue((boolean)hasTaken.get());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        t1.start();
        Thread.sleep(100L);
        t2.start();
        t1.join();
        t2.join();
    }

    @Test
    public void testPutAndOrder() throws InterruptedException {
        Object[] integers;
        Object[] objectArray = integers = new Integer[]{0, -5, 11, 233, 45, 69, -249, 33, 787, -556, 762, 380, 747, 777, 22, 77, 666, 321, 456, 575};
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            int integer = objectArray[i];
            this.queue.put((Object)integer);
        }
        Assert.assertEquals((long)10L, (long)this.queue.size());
        int prev = (Integer)this.queue.take();
        ArrayList<Integer> integerList = new ArrayList<Integer>();
        integerList.add(prev);
        for (int i = 0; i < 9; ++i) {
            int curr = (Integer)this.queue.take();
            Assert.assertTrue((prev <= curr ? 1 : 0) != 0);
            integerList.add(curr);
            prev = curr;
        }
        Arrays.sort(integers);
        List<Object> expectedList = Arrays.asList(integers).subList(0, 10);
        Assert.assertArrayEquals((Object[])expectedList.toArray(new Integer[0]), (Object[])integerList.toArray(new Integer[0]));
    }

    @Test
    public void testTakeMax() throws InterruptedException {
        Object[] integers;
        Object[] objectArray = integers = new Integer[]{0, -5, 11, 233, 45, 69, -249, 33, 787, -556, 762, 380, 747, 777, 22, 77, 666, 321, 456, 575};
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            int integer = objectArray[i];
            this.queue.put((Object)integer);
        }
        Assert.assertEquals((long)10L, (long)this.queue.size());
        int prev = (Integer)this.queue.takeMax();
        ArrayList<Integer> integerList = new ArrayList<Integer>();
        integerList.add(prev);
        for (int i = 0; i < 9; ++i) {
            int curr = (Integer)this.queue.takeMax();
            Assert.assertTrue((prev >= curr ? 1 : 0) != 0);
            integerList.add(curr);
            prev = curr;
        }
        Arrays.sort(integers);
        List<Object> expectedList = Arrays.asList(integers).subList(0, 10);
        Collections.reverse(expectedList);
        Assert.assertArrayEquals((Object[])expectedList.toArray(new Integer[0]), (Object[])integerList.toArray(new Integer[0]));
    }

    @Test
    public void testConcurrentPut() throws InterruptedException {
        FixedPriorityBlockingQueue testQueue = new FixedPriorityBlockingQueue(100, Integer::compare);
        CopyOnWriteArrayList expectedList = new CopyOnWriteArrayList();
        Thread t1 = new Thread(() -> {
            try {
                Random random = new Random(1L);
                for (int i = 0; i < 30; ++i) {
                    int curr = random.nextInt();
                    expectedList.add(curr);
                    testQueue.put((Object)curr);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        });
        Thread t2 = new Thread(() -> {
            try {
                Random random = new Random(2L);
                for (int i = 0; i < 30; ++i) {
                    int curr = random.nextInt();
                    expectedList.add(curr);
                    testQueue.put((Object)curr);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        });
        Thread t3 = new Thread(() -> {
            try {
                Random random = new Random(3L);
                for (int i = 0; i < 30; ++i) {
                    int curr = random.nextInt();
                    expectedList.add(curr);
                    testQueue.put((Object)curr);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        });
        t1.start();
        t2.start();
        t3.start();
        t1.join();
        t2.join();
        t3.join();
        Assert.assertEquals((long)90L, (long)testQueue.size());
        ArrayList<Integer> resultList = new ArrayList<Integer>();
        int prev = (Integer)testQueue.take();
        resultList.add(prev);
        while (testQueue.size() > 0) {
            int curr = (Integer)testQueue.take();
            resultList.add(curr);
            Assert.assertTrue((prev <= curr ? 1 : 0) != 0);
            prev = curr;
        }
        Collections.sort(expectedList);
        Assert.assertArrayEquals((Object[])expectedList.toArray(new Integer[0]), (Object[])resultList.toArray(new Integer[0]));
    }

    @Test
    public void testConcurrentTake() throws InterruptedException {
        FixedPriorityBlockingQueue testQueue = new FixedPriorityBlockingQueue(100, Integer::compare);
        Random random = new Random(10L);
        ArrayList resultList = new ArrayList();
        ReentrantLock lock = new ReentrantLock();
        ArrayList<Integer> expectedList = new ArrayList<Integer>();
        for (int i = 0; i < 90; ++i) {
            int curr = random.nextInt();
            testQueue.put((Object)curr);
            expectedList.add(curr);
        }
        Collections.sort(expectedList);
        Thread t1 = new Thread(() -> {
            try {
                while (resultList.size() < 90) {
                    lock.lock();
                    try {
                        if (resultList.size() >= 90) {
                            return;
                        }
                        int curr = (Integer)testQueue.take();
                        resultList.add(curr);
                    }
                    finally {
                        lock.unlock();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        Thread t2 = new Thread(() -> {
            try {
                while (resultList.size() < 90) {
                    lock.lock();
                    try {
                        if (resultList.size() >= 90) {
                            return;
                        }
                        int curr = (Integer)testQueue.take();
                        resultList.add(curr);
                    }
                    finally {
                        lock.unlock();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        Thread t3 = new Thread(() -> {
            try {
                while (resultList.size() < 90) {
                    lock.lock();
                    try {
                        if (resultList.size() >= 90) {
                            return;
                        }
                        int curr = (Integer)testQueue.take();
                        resultList.add(curr);
                    }
                    finally {
                        lock.unlock();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        t1.start();
        t2.start();
        t3.start();
        t1.join();
        t2.join();
        t3.join();
        Assert.assertArrayEquals((Object[])expectedList.toArray(new Integer[0]), (Object[])resultList.toArray(new Integer[0]));
    }

    @Test
    public void testHooks() throws InterruptedException {
        ArrayList<AtomicInteger> integers = new ArrayList<AtomicInteger>();
        Random random = new Random(100L);
        FixedPriorityBlockingQueue testQueue = new FixedPriorityBlockingQueue(10, Comparator.comparingInt(AtomicInteger::get));
        for (int i = 0; i < 20; ++i) {
            integers.add(new AtomicInteger(random.nextInt(1000)));
        }
        testQueue.regsitPollLastHook(x -> x.set(x.get() + 1));
        testQueue.regsitPollLastHook(x -> x.set(x.get() * 5));
        testQueue.regsitPollLastHook(x -> x.set(x.get() * x.get()));
        integers.sort(Comparator.comparingInt(AtomicInteger::get));
        ArrayList<AtomicInteger> expectedList = new ArrayList<AtomicInteger>();
        List tempList = integers.subList(10, 20);
        for (AtomicInteger i : tempList) {
            expectedList.add(new AtomicInteger(i.get()));
        }
        for (AtomicInteger atomicInteger : integers) {
            testQueue.put((Object)atomicInteger);
        }
        expectedList.forEach(x -> x.set(x.get() + 1));
        expectedList.forEach(x -> x.set(x.get() * 5));
        expectedList.forEach(x -> x.set(x.get() * x.get()));
        for (int i = 0; i < expectedList.size(); ++i) {
            Assert.assertEquals((long)((AtomicInteger)expectedList.get(i)).get(), (long)((AtomicInteger)tempList.get(i)).get());
        }
    }
}

