/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.metadata.LocalSchemaProcessor;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.SchemaUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.write.schema.TimeseriesSchema;
import org.junit.Assert;
import org.junit.Test;

public class SchemaUtilsTest {
    @Test
    public void registerTimeseriesTest() throws MetadataException {
        IoTDB.configManager.init();
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        String tsPath = "root.sg.d1.s1";
        TimeseriesSchema timeseriesSchema = new TimeseriesSchema(tsPath, TSDataType.INT32);
        SchemaUtils.registerTimeseries((TimeseriesSchema)timeseriesSchema);
        Assert.assertTrue((boolean)IoTDB.schemaProcessor.isPathExist(new PartialPath(tsPath)));
    }

    @Test
    public void getAggregatedDataTypesTest() {
        ArrayList<TSDataType> measurementTypes = new ArrayList<TSDataType>();
        measurementTypes.add(TSDataType.INT64);
        measurementTypes.add(TSDataType.TEXT);
        measurementTypes.add(TSDataType.BOOLEAN);
        measurementTypes.add(TSDataType.DOUBLE);
        Assert.assertEquals(Collections.nCopies(measurementTypes.size(), TSDataType.INT64), (Object)SchemaUtils.getAggregatedDataTypes(measurementTypes, (String)"min_time"));
        Assert.assertEquals(Collections.nCopies(measurementTypes.size(), TSDataType.INT64), (Object)SchemaUtils.getAggregatedDataTypes(measurementTypes, (String)"count"));
        Assert.assertEquals(Collections.nCopies(measurementTypes.size(), TSDataType.DOUBLE), (Object)SchemaUtils.getAggregatedDataTypes(measurementTypes, (String)"sum"));
        Assert.assertEquals(measurementTypes, (Object)SchemaUtils.getAggregatedDataTypes(measurementTypes, (String)"last_value"));
        Assert.assertEquals(measurementTypes, (Object)SchemaUtils.getAggregatedDataTypes(measurementTypes, (String)"max_value"));
    }
}

