/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.TimeUnit;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.udf.service.UDFManagementService;
import org.apache.iotdb.db.auth.AuthorizerManager;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.directories.DirectoryManager;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.engine.StorageEngineV2;
import org.apache.iotdb.db.engine.cache.BloomFilterCache;
import org.apache.iotdb.db.engine.cache.ChunkCache;
import org.apache.iotdb.db.engine.cache.TimeSeriesMetadataCache;
import org.apache.iotdb.db.engine.compaction.CompactionTaskManager;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.metadata.idtable.IDTableManager;
import org.apache.iotdb.db.metadata.idtable.entry.DeviceIDFactory;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.FileReaderManager;
import org.apache.iotdb.db.query.control.QueryResourceManager;
import org.apache.iotdb.db.query.control.QueryTimeManager;
import org.apache.iotdb.db.query.executor.LastQueryExecutor;
import org.apache.iotdb.db.rescon.MemTableManager;
import org.apache.iotdb.db.rescon.PrimitiveArrayManager;
import org.apache.iotdb.db.rescon.SystemInfo;
import org.apache.iotdb.db.rescon.TsFileResourceManager;
import org.apache.iotdb.db.service.NewIoTDB;
import org.apache.iotdb.db.sync.common.LocalSyncInfoFetcher;
import org.apache.iotdb.db.wal.WALManager;
import org.apache.iotdb.db.wal.recover.WALRecoverManager;
import org.apache.iotdb.rpc.TConfigurationConst;
import org.apache.iotdb.rpc.TSocketWrapper;
import org.apache.iotdb.tsfile.utils.FilePathUtils;
import org.apache.iotdb.udf.api.exception.UDFManagementException;
import org.apache.thrift.TConfiguration;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransportException;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvironmentUtils {
    private static final Logger logger = LoggerFactory.getLogger(EnvironmentUtils.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final CommonConfig commonConfig = CommonDescriptor.getInstance().getConfig();
    private static final DirectoryManager directoryManager = DirectoryManager.getInstance();
    public static long TEST_QUERY_JOB_ID = 1L;
    public static QueryContext TEST_QUERY_CONTEXT = new QueryContext(TEST_QUERY_JOB_ID);
    private static final long oldSeqTsFileSize = config.getSeqTsFileSize();
    private static final long oldUnSeqTsFileSize = config.getUnSeqTsFileSize();
    private static final long oldGroupSizeInByte = config.getMemtableSizeThreshold();
    private static NewIoTDB daemon;
    private static TConfiguration tConfiguration;
    public static boolean examinePorts;

    public static void cleanEnv() throws IOException, StorageEngineException {
        boolean closed;
        CompactionTaskManager.getInstance().waitAllCompactionFinish();
        try {
            if (UDFManagementService.getInstance() != null) {
                UDFManagementService.getInstance().deregisterAll();
            }
        }
        catch (UDFManagementException e) {
            Assert.fail((String)e.getMessage());
        }
        logger.debug("EnvironmentUtil cleanEnv...");
        if (daemon != null) {
            daemon.stop();
            daemon = null;
        }
        QueryResourceManager.getInstance().endQuery(TEST_QUERY_JOB_ID);
        FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
        if (examinePorts && !(closed = EnvironmentUtils.examinePorts())) {
            try {
                TimeUnit.SECONDS.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!EnvironmentUtils.examinePorts()) {
                Assert.fail((String)"failed to close some ports");
            }
        }
        WALManager.getInstance().clear();
        WALRecoverManager.getInstance().clear();
        StorageEngineV2.getInstance().stop();
        CommonDescriptor.getInstance().getConfig().setNodeStatus(NodeStatus.Running);
        IoTDBDescriptor.getInstance().getConfig().setEnableMQTTService(false);
        if (config.isMetaDataCacheEnable()) {
            ChunkCache.getInstance().clear();
            TimeSeriesMetadataCache.getInstance().clear();
            BloomFilterCache.getInstance().clear();
        }
        NewIoTDB.configManager.clear();
        QueryTimeManager.getInstance().clear();
        PrimitiveArrayManager.close();
        SystemInfo.getInstance().close();
        MemTableManager.getInstance().close();
        TsFileResourceManager.getInstance().clear();
        IDTableManager.getInstance().clear();
        LastQueryExecutor.clear();
        LocalSyncInfoFetcher.getInstance().close();
        EnvironmentUtils.cleanAllDir();
        config.setSeqTsFileSize(oldSeqTsFileSize);
        config.setUnSeqTsFileSize(oldUnSeqTsFileSize);
        config.setMemtableSizeThreshold(oldGroupSizeInByte);
    }

    private static boolean examinePorts() {
        TSocket transport = TSocketWrapper.wrap((TConfiguration)tConfiguration, (String)"127.0.0.1", (int)6667, (int)100);
        if (!transport.isOpen()) {
            try {
                transport.open();
                logger.error("stop daemon failed. 6667 can be connected now.");
                transport.close();
                return false;
            }
            catch (TTransportException tTransportException) {
                // empty catch block
            }
        }
        if (!(transport = TSocketWrapper.wrap((TConfiguration)tConfiguration, (String)"127.0.0.1", (int)5555, (int)100)).isOpen()) {
            try {
                transport.open();
                logger.error("stop Sync daemon failed. 5555 can be connected now.");
                transport.close();
                return false;
            }
            catch (TTransportException tTransportException) {
                // empty catch block
            }
        }
        try {
            JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:31999/jmxrmi");
            JMXConnector jmxConnector = JMXConnectorFactory.connect(url);
            logger.error("stop JMX failed. 31999 can be connected now.");
            jmxConnector.close();
            return false;
        }
        catch (IOException url) {
            boolean bl;
            Socket socket = new Socket();
            try {
                socket.connect(new InetSocketAddress("127.0.0.1", 9091), 100);
                logger.error("stop MetricService failed. 9091 can be connected now.");
                bl = false;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        socket.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    return true;
                }
            }
            socket.close();
            return bl;
        }
    }

    public static void cleanAllDir() throws IOException {
        for (String path : directoryManager.getAllSequenceFileFolders()) {
            EnvironmentUtils.cleanDir(path);
        }
        for (String path : directoryManager.getAllUnSequenceFileFolders()) {
            EnvironmentUtils.cleanDir(path);
        }
        EnvironmentUtils.cleanDir(config.getSystemDir());
        EnvironmentUtils.cleanDir(config.getQueryDir());
        EnvironmentUtils.cleanDir(config.getTracingDir());
        EnvironmentUtils.cleanDir(config.getUdfDir());
        EnvironmentUtils.cleanDir(config.getTriggerDir());
        EnvironmentUtils.cleanDir(config.getExtPipeDir());
        EnvironmentUtils.cleanDir(config.getExtDir());
        EnvironmentUtils.cleanDir(config.getMqttDir());
        for (String walDir : commonConfig.getWalDirs()) {
            EnvironmentUtils.cleanDir(walDir);
        }
        EnvironmentUtils.cleanDir(commonConfig.getSyncDir());
        for (String dataDir : config.getDataDirs()) {
            EnvironmentUtils.cleanDir(dataDir);
        }
    }

    public static void cleanDir(String dir) throws IOException {
        FileUtils.deleteDirectory((File)new File(dir));
    }

    public static void envSetUp() {
        logger.debug("EnvironmentUtil setup...");
        config.setThriftServerAwaitTimeForStopService(60);
        config.setAvgSeriesPointNumberThreshold(Integer.MAX_VALUE);
        config.setAvgSeriesPointNumberThreshold(Integer.MAX_VALUE);
        if (daemon == null) {
            daemon = new NewIoTDB();
        }
        try {
            daemon.active(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        EnvironmentUtils.createAllDir();
        DeviceIDFactory.getInstance().reset();
        TEST_QUERY_JOB_ID = QueryResourceManager.getInstance().assignQueryId();
        TEST_QUERY_CONTEXT = new QueryContext(TEST_QUERY_JOB_ID);
    }

    public static void stopDaemon() {
        if (daemon != null) {
            daemon.stop();
        }
    }

    public static void shutdownDaemon() throws Exception {
        if (daemon != null) {
            daemon.shutdown();
        }
    }

    public static void activeDaemon() {
        if (daemon != null) {
            daemon.active(true);
        }
    }

    public static void reactiveDaemon() {
        if (daemon == null) {
            daemon = new NewIoTDB();
            daemon.active(true);
        } else {
            EnvironmentUtils.activeDaemon();
        }
    }

    public static void restartDaemon() throws Exception {
        EnvironmentUtils.shutdownDaemon();
        EnvironmentUtils.stopDaemon();
        NewIoTDB.configManager.clear();
        IDTableManager.getInstance().clear();
        TsFileResourceManager.getInstance().clear();
        WALManager.getInstance().clear();
        WALRecoverManager.getInstance().clear();
        EnvironmentUtils.reactiveDaemon();
    }

    private static void createAllDir() {
        for (String[] path : directoryManager.getAllSequenceFileFolders()) {
            EnvironmentUtils.createDir((String)path);
        }
        for (String[] path : directoryManager.getAllUnSequenceFileFolders()) {
            EnvironmentUtils.createDir((String)path);
        }
        EnvironmentUtils.createDir(config.getSystemDir());
        String sgDir = FilePathUtils.regularizePath((String)config.getSystemDir()) + "databases";
        EnvironmentUtils.createDir(sgDir);
        EnvironmentUtils.createDir(commonConfig.getSyncDir());
        EnvironmentUtils.createDir(config.getQueryDir());
        EnvironmentUtils.createDir(TestConstant.OUTPUT_DATA_DIR);
        for (String walDir : commonConfig.getWalDirs()) {
            EnvironmentUtils.createDir(walDir);
        }
        for (String dataDir : config.getDataDirs()) {
            EnvironmentUtils.createDir(dataDir);
        }
        try {
            AuthorizerManager.getInstance().reset();
        }
        catch (AuthException e) {
            logger.error("create user and role folders failed", (Throwable)e);
            Assert.fail((String)e.getMessage());
        }
    }

    private static void createDir(String dir) {
        File file = new File(dir);
        file.mkdirs();
    }

    public static void recursiveDeleteFolder(String path) throws IOException {
        File file = new File(path);
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files == null || files.length == 0) {
                FileUtils.deleteDirectory((File)file);
            } else {
                for (File f : files) {
                    EnvironmentUtils.recursiveDeleteFolder(f.getAbsolutePath());
                }
                FileUtils.deleteDirectory((File)file);
            }
        } else {
            FileUtils.delete((File)file);
        }
    }

    static {
        tConfiguration = TConfigurationConst.defaultTConfiguration;
        examinePorts = Boolean.parseBoolean(System.getProperty("test.port.closed", "false"));
    }
}

