/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.tools.WalChecker;
import org.apache.iotdb.db.wal.buffer.IWALByteBufferView;
import org.apache.iotdb.db.wal.buffer.WALEntry;
import org.apache.iotdb.db.wal.buffer.WALEntryValue;
import org.apache.iotdb.db.wal.buffer.WALInfoEntry;
import org.apache.iotdb.db.wal.exception.WALException;
import org.apache.iotdb.db.wal.io.WALFileTest;
import org.apache.iotdb.db.wal.io.WALWriter;
import org.apache.iotdb.db.wal.utils.WALByteBufferForTest;
import org.apache.iotdb.db.wal.utils.WALFileStatus;
import org.apache.iotdb.db.wal.utils.WALFileUtils;
import org.junit.Assert;
import org.junit.Test;

public class WalCheckerTest {
    private static final String DEVICE_ID = "root.test_sg.test_d";

    @Test
    public void testNoDir() {
        WalChecker checker = new WalChecker("no such dir");
        boolean caught = false;
        try {
            checker.doCheck();
        }
        catch (WALException e) {
            caught = true;
        }
        Assert.assertTrue((boolean)caught);
    }

    @Test
    public void testEmpty() throws IOException, WALException {
        File tempRoot = new File(TestConstant.BASE_OUTPUT_PATH.concat("root"));
        tempRoot.mkdir();
        try {
            WalChecker checker = new WalChecker(tempRoot.getAbsolutePath());
            Assert.assertTrue((boolean)checker.doCheck().isEmpty());
        }
        finally {
            FileUtils.deleteDirectory((File)tempRoot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNormalCheck() throws IOException, WALException, IllegalPathException {
        File tempRoot = new File(TestConstant.BASE_OUTPUT_PATH.concat("wal"));
        tempRoot.mkdir();
        try {
            for (int i = 0; i < 5; ++i) {
                File walNodeDir = new File(tempRoot, String.valueOf(i));
                walNodeDir.mkdir();
                File walFile = new File(walNodeDir, WALFileUtils.getLogFileName((long)i, (long)0L, (WALFileStatus)WALFileStatus.CONTAINS_SEARCH_INDEX));
                int fakeMemTableId = 1;
                ArrayList<WALInfoEntry> walEntries = new ArrayList<WALInfoEntry>();
                walEntries.add(new WALInfoEntry((long)fakeMemTableId, (WALEntryValue)WALFileTest.getInsertRowNode(DEVICE_ID)));
                walEntries.add(new WALInfoEntry((long)fakeMemTableId, (WALEntryValue)WALFileTest.getInsertTabletNode(DEVICE_ID)));
                walEntries.add(new WALInfoEntry((long)fakeMemTableId, (WALEntryValue)WALFileTest.getDeleteDataNode(DEVICE_ID)));
                int size = 0;
                for (WALEntry wALEntry : walEntries) {
                    size += wALEntry.serializedSize();
                }
                WALByteBufferForTest buffer = new WALByteBufferForTest(ByteBuffer.allocate(size));
                for (WALEntry walEntry3 : walEntries) {
                    walEntry3.serialize((IWALByteBufferView)buffer);
                }
                try (WALWriter wALWriter = new WALWriter(walFile);){
                    wALWriter.write(buffer.getBuffer());
                    continue;
                }
            }
            WalChecker checker = new WalChecker(tempRoot.getAbsolutePath());
            Assert.assertTrue((boolean)checker.doCheck().isEmpty());
        }
        finally {
            FileUtils.deleteDirectory((File)tempRoot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAbnormalCheck() throws IOException, WALException, IllegalPathException {
        File tempRoot = new File(TestConstant.BASE_OUTPUT_PATH.concat("wal"));
        tempRoot.mkdir();
        try {
            for (int i = 0; i < 5; ++i) {
                File walNodeDir = new File(tempRoot, String.valueOf(i));
                walNodeDir.mkdir();
                File walFile = new File(walNodeDir, WALFileUtils.getLogFileName((long)i, (long)0L, (WALFileStatus)WALFileStatus.CONTAINS_SEARCH_INDEX));
                int fakeMemTableId = 1;
                ArrayList<WALInfoEntry> walEntries = new ArrayList<WALInfoEntry>();
                walEntries.add(new WALInfoEntry((long)fakeMemTableId, (WALEntryValue)WALFileTest.getInsertRowNode(DEVICE_ID)));
                walEntries.add(new WALInfoEntry((long)fakeMemTableId, (WALEntryValue)WALFileTest.getInsertTabletNode(DEVICE_ID)));
                walEntries.add(new WALInfoEntry((long)fakeMemTableId, (WALEntryValue)WALFileTest.getDeleteDataNode(DEVICE_ID)));
                int size = 0;
                for (WALEntry wALEntry : walEntries) {
                    size += wALEntry.serializedSize();
                }
                WALByteBufferForTest buffer = new WALByteBufferForTest(ByteBuffer.allocate(size));
                for (WALEntry walEntry3 : walEntries) {
                    walEntry3.serialize((IWALByteBufferView)buffer);
                }
                try (WALWriter wALWriter = new WALWriter(walFile);){
                    wALWriter.write(buffer.getBuffer());
                    if (i != 0) continue;
                    ByteBuffer errorBuffer = ByteBuffer.allocate(2);
                    errorBuffer.put((byte)3);
                    wALWriter.write(errorBuffer);
                    continue;
                }
            }
            WalChecker checker = new WalChecker(tempRoot.getAbsolutePath());
            Assert.assertEquals((long)1L, (long)checker.doCheck().size());
        }
        finally {
            FileUtils.deleteDirectory((File)tempRoot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOneDamagedCheck() throws IOException, WALException {
        File tempRoot = new File(TestConstant.BASE_OUTPUT_PATH.concat("wal"));
        tempRoot.mkdir();
        try {
            for (int i = 0; i < 5; ++i) {
                File walNodeDir = new File(tempRoot, String.valueOf(i));
                walNodeDir.mkdir();
                File walFile = new File(walNodeDir, WALFileUtils.getLogFileName((long)i, (long)0L, (WALFileStatus)WALFileStatus.CONTAINS_SEARCH_INDEX));
                try (FileOutputStream fileOutputStream = new FileOutputStream(walFile);){
                    fileOutputStream.write(i);
                    continue;
                }
            }
            WalChecker checker = new WalChecker(tempRoot.getAbsolutePath());
            Assert.assertEquals((long)5L, (long)checker.doCheck().size());
        }
        finally {
            FileUtils.deleteDirectory((File)tempRoot);
        }
    }
}

