/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.tools.TsFileSketchTool;
import org.apache.iotdb.tsfile.file.metadata.ChunkGroupMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.utils.MeasurementGroup;
import org.apache.iotdb.tsfile.write.TsFileWriter;
import org.apache.iotdb.tsfile.write.record.Tablet;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.Schema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TsFileSketchToolTest {
    String path = "data".concat(File.separator).concat("data").concat(File.separator).concat("sequence").concat(File.separator).concat("root.sg1").concat(File.separator).concat("0").concat(File.separator).concat("0").concat(File.separator).concat("1-0-0-0.tsfile");
    String sketchOut = "sketch.out";
    String device = "root.device_0";
    String alignedDevice = "root.device_1";
    String sensorPrefix = "sensor_";
    int rowNum = 1000000;
    int sensorNum = 10;

    @Before
    public void setUp() throws Exception {
        try {
            File f = FSFactoryProducer.getFSFactory().getFile(this.path);
            if (f.exists() && !f.delete()) {
                throw new RuntimeException("can not delete " + f.getAbsolutePath());
            }
            Schema schema = new Schema();
            ArrayList<MeasurementSchema> measurementSchemas = new ArrayList<MeasurementSchema>();
            for (int i = 0; i < this.sensorNum; ++i) {
                MeasurementSchema measurementSchema = new MeasurementSchema(this.sensorPrefix + (i + 1), TSDataType.INT64, TSEncoding.TS_2DIFF);
                measurementSchemas.add(measurementSchema);
                schema.registerTimeseries(new Path(this.device), new MeasurementSchema(this.sensorPrefix + (i + 1), TSDataType.INT64, TSEncoding.TS_2DIFF));
            }
            ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
            ArrayList<MeasurementSchema> alignedMeasurementSchemas = new ArrayList<MeasurementSchema>();
            for (int i = 0; i < this.sensorNum; ++i) {
                MeasurementSchema schema1 = new MeasurementSchema(this.sensorPrefix + (i + 1), TSDataType.INT64, TSEncoding.RLE);
                schemas.add(schema1);
                alignedMeasurementSchemas.add(schema1);
            }
            MeasurementGroup group = new MeasurementGroup(true, schemas);
            schema.registerMeasurementGroup(new Path(this.alignedDevice), group);
            try (TsFileWriter tsFileWriter = new TsFileWriter(f, schema);){
                long[] sensor;
                int i;
                Tablet tablet = new Tablet(this.device, measurementSchemas);
                long[] timestamps = tablet.timestamps;
                Object[] values = tablet.values;
                long timestamp = 1L;
                long value = 1000000L;
                int r = 0;
                while (r < this.rowNum) {
                    ++tablet.rowSize;
                    ++timestamp;
                    for (i = 0; i < this.sensorNum; ++i) {
                        sensor = (long[])values[i];
                        sensor[row] = value;
                    }
                    if (tablet.rowSize == tablet.getMaxRowNumber()) {
                        tsFileWriter.write(tablet);
                        tablet.reset();
                    }
                    ++r;
                    ++value;
                }
                if (tablet.rowSize != 0) {
                    tsFileWriter.write(tablet);
                    tablet.reset();
                }
                tablet = new Tablet(this.alignedDevice, alignedMeasurementSchemas);
                timestamps = tablet.timestamps;
                values = tablet.values;
                timestamp = 1L;
                value = 1000000L;
                r = 0;
                while (r < this.rowNum) {
                    ++tablet.rowSize;
                    ++timestamp;
                    for (i = 0; i < this.sensorNum; ++i) {
                        sensor = (long[])values[i];
                        sensor[row] = value;
                    }
                    if (tablet.rowSize == tablet.getMaxRowNumber()) {
                        tsFileWriter.writeAligned(tablet);
                        tablet.reset();
                    }
                    ++r;
                    ++value;
                }
                if (tablet.rowSize != 0) {
                    tsFileWriter.writeAligned(tablet);
                    tablet.reset();
                }
            }
        }
        catch (Exception e) {
            throw new Exception("meet error in TsFileWrite with tablet", e);
        }
    }

    @Test
    public void tsFileSketchToolTest() {
        String[] args = new String[]{this.path, this.sketchOut};
        TsFileSketchTool tool = new TsFileSketchTool(this.path, this.sketchOut);
        try {
            tool.run();
            List chunkGroupMetadataList = tool.getAllChunkGroupMetadata();
            Assert.assertEquals((long)2L, (long)chunkGroupMetadataList.size());
            for (ChunkGroupMetadata chunkGroupMetadata : chunkGroupMetadataList) {
                if (this.device.equals(chunkGroupMetadata.getDevice())) {
                    Assert.assertEquals((long)this.sensorNum, (long)chunkGroupMetadata.getChunkMetadataList().size());
                    continue;
                }
                if (this.alignedDevice.equals(chunkGroupMetadata.getDevice())) {
                    Assert.assertEquals((long)(this.sensorNum + 1), (long)chunkGroupMetadata.getChunkMetadataList().size());
                    continue;
                }
                Assert.fail();
            }
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @After
    public void tearDown() {
        try {
            FileUtils.forceDelete((File)new File(this.path));
            FileUtils.forceDelete((File)new File(this.sketchOut));
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

