/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.qp.physical.sys.CreateTimeSeriesPlan;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.tools.schema.MLogParser;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MLogParserTest {
    private String[] storageGroups = new String[]{"root.sg0", "root.sg1", "root.sgcc", "root.sg"};
    private int[] storageGroupIndex = new int[]{0, 1, 3, 4};
    private int[] mlogLineNum = new int[]{50, 53, 0, 0};

    @Before
    public void setUp() {
        EnvironmentUtils.envSetUp();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
        File file = new File("target" + File.separator + "tmp" + File.separator + "text.mlog");
        file.deleteOnExit();
        file = new File("target" + File.separator + "tmp" + File.separator + "text.snapshot");
        file.deleteOnExit();
    }

    private void prepareData() {
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 5; ++j) {
                for (int k = 0; k < 10; ++k) {
                    CreateTimeSeriesPlan plan = new CreateTimeSeriesPlan();
                    try {
                        plan.setPath(new PartialPath("root.sg" + i + ".device" + j + ".s" + k));
                        plan.setDataType(TSDataType.INT32);
                        plan.setEncoding(TSEncoding.PLAIN);
                        plan.setCompressor(CompressionType.GZIP);
                        IoTDB.schemaProcessor.createTimeseries(plan);
                        continue;
                    }
                    catch (MetadataException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        try {
            IoTDB.schemaProcessor.setStorageGroup(new PartialPath("root.ln.cc"));
            IoTDB.schemaProcessor.setStorageGroup(new PartialPath("root.sgcc"));
            IoTDB.schemaProcessor.setTTL(new PartialPath("root.sgcc"), 1234L);
            IoTDB.schemaProcessor.deleteTimeseries(new PartialPath("root.sg1.device1.s1"));
            ArrayList<PartialPath> paths = new ArrayList<PartialPath>();
            paths.add(new PartialPath("root.ln.cc"));
            IoTDB.schemaProcessor.deleteStorageGroups(paths);
            HashMap<String, String> tags = new HashMap<String, String>();
            tags.put("tag1", "value1");
            IoTDB.schemaProcessor.addTags(tags, new PartialPath("root.sg1.device1.s2"));
            IoTDB.schemaProcessor.changeAlias(new PartialPath("root.sg1.device1.s3"), "hello");
        }
        catch (IOException | MetadataException e) {
            e.printStackTrace();
        }
        try {
            IoTDB.schemaProcessor.setStorageGroup(new PartialPath("root.sg"));
        }
        catch (MetadataException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testMLogParser() throws Exception {
        this.prepareData();
        this.testNonExistingStorageGroupDir("root.ln.cc");
        IoTDB.schemaProcessor.forceMlog();
        for (int i = 0; i < this.storageGroups.length; ++i) {
            this.testParseMLog(this.storageGroups[i], this.storageGroupIndex[i], this.mlogLineNum[i]);
        }
    }

    private void testNonExistingStorageGroupDir(String storageGroup) {
        File storageGroupDir = new File(IoTDBDescriptor.getInstance().getConfig().getSchemaDir() + File.separator + storageGroup);
        Assert.assertFalse((boolean)storageGroupDir.exists());
    }

    private void testParseMLog(String storageGroup, int storageGroupId, int expectedLineNum) throws IOException {
        this.testParseLog(IoTDBDescriptor.getInstance().getConfig().getSchemaDir() + File.separator + storageGroup + File.separator + storageGroupId + File.separator + "mlog.bin", expectedLineNum);
    }

    private void testParseLog(String path, int expectedNum) throws IOException {
        File file = new File("target" + File.separator + "tmp" + File.separator + "text.mlog");
        file.delete();
        MLogParser.parseFromFile((String)path, (String)("target" + File.separator + "tmp" + File.separator + "text.mlog"));
        try (BufferedReader reader = new BufferedReader(new FileReader("target" + File.separator + "tmp" + File.separator + "text.mlog"));){
            String line;
            int lineNum = 0;
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                ++lineNum;
                lines.add(line);
            }
            if (lineNum != expectedNum) {
                for (String content : lines) {
                    System.out.println(content);
                }
            }
            Assert.assertEquals((long)expectedNum, (long)lineNum);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

