/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.persistence;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.commons.sync.persistence.SyncLogReader;
import org.apache.iotdb.commons.sync.persistence.SyncLogWriter;
import org.apache.iotdb.commons.sync.pipe.PipeInfo;
import org.apache.iotdb.commons.sync.pipe.PipeMessage;
import org.apache.iotdb.commons.sync.pipe.PipeStatus;
import org.apache.iotdb.commons.sync.pipe.SyncOperation;
import org.apache.iotdb.commons.sync.pipe.TsFilePipeInfo;
import org.apache.iotdb.commons.sync.pipesink.IoTDBPipeSink;
import org.apache.iotdb.commons.sync.pipesink.PipeSink;
import org.apache.iotdb.commons.sync.utils.SyncPathUtil;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.sync.SyncTestUtils;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SyncLogTest {
    private static final String pipe1 = "pipe1";
    private static final String pipe2 = "pipe2";
    private static final String pipe3 = "pipe3";
    private static final long createdTime1 = System.currentTimeMillis();
    private static final long createdTime2 = System.currentTimeMillis() + 1L;
    private static final long createdTime3 = System.currentTimeMillis() + 2L;

    @Before
    public void setUp() throws Exception {
        EnvironmentUtils.envSetUp();
    }

    @After
    public void tearDown() throws IOException, StorageEngineException {
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void testServiceLog() {
        try {
            SyncLogWriter log = new SyncLogWriter(new File(SyncPathUtil.getSysDir()));
            IoTDBPipeSink pipeSink = new IoTDBPipeSink("demo");
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("ip", "192.168.11.11");
            attributes.put("port", "7766");
            pipeSink.setAttribute(attributes);
            log.addPipeSink((PipeSink)pipeSink);
            TsFilePipeInfo pipeInfo1 = new TsFilePipeInfo(pipe1, "demo", createdTime1, 0L, true);
            TsFilePipeInfo pipeInfo2 = new TsFilePipeInfo(pipe2, "demo", createdTime2, 99L, false);
            TsFilePipeInfo pipeInfo3 = new TsFilePipeInfo(pipe3, "demo", createdTime3, 199L, true);
            log.addPipe((PipeInfo)pipeInfo1);
            log.operatePipe(pipe1, SyncOperation.DROP_PIPE);
            log.addPipe((PipeInfo)pipeInfo2);
            log.operatePipe(pipe2, SyncOperation.STOP_PIPE);
            log.operatePipe(pipe2, SyncOperation.START_PIPE);
            log.addPipe((PipeInfo)pipeInfo3);
            log.close();
            SyncLogReader syncLogReader = new SyncLogReader(new File(SyncPathUtil.getSysDir()));
            syncLogReader.recover();
            Map allPipeSinks = syncLogReader.getAllPipeSinks();
            Assert.assertEquals((long)1L, (long)allPipeSinks.size());
            Map pipeInfoMap = syncLogReader.getPipes();
            Assert.assertEquals((long)2L, (long)pipeInfoMap.size());
            PipeInfo pipeInfoRecover1 = (PipeInfo)pipeInfoMap.get(pipe1);
            Assert.assertNull((Object)pipeInfoRecover1);
            PipeInfo pipeInfoRecover2 = (PipeInfo)pipeInfoMap.get(pipe2);
            SyncTestUtils.checkPipeInfo(pipeInfoRecover2, pipe2, "demo", PipeStatus.RUNNING, createdTime2, PipeMessage.PipeMessageType.NORMAL);
            PipeInfo pipeInfoRecover3 = (PipeInfo)pipeInfoMap.get(pipe3);
            SyncTestUtils.checkPipeInfo(pipeInfoRecover3, pipe3, "demo", PipeStatus.STOP, createdTime3, PipeMessage.PipeMessageType.NORMAL);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }
}

