/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.persistence;

import java.io.IOException;
import java.util.HashMap;
import org.apache.iotdb.commons.exception.sync.PipeException;
import org.apache.iotdb.commons.exception.sync.PipeSinkNotExistException;
import org.apache.iotdb.commons.sync.pipe.PipeInfo;
import org.apache.iotdb.commons.sync.pipe.PipeMessage;
import org.apache.iotdb.commons.sync.pipe.SyncOperation;
import org.apache.iotdb.commons.sync.pipe.TsFilePipeInfo;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.mpp.plan.statement.sys.sync.CreatePipeSinkStatement;
import org.apache.iotdb.db.sync.common.LocalSyncInfo;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LocalSyncInfoTest {
    private static final String pipe1 = "pipe1";
    private static final String pipe2 = "pipe2";
    private static final long createdTime1 = System.currentTimeMillis();
    private static final long createdTime2 = System.currentTimeMillis() + 1L;

    @Before
    public void setUp() throws Exception {
        EnvironmentUtils.envSetUp();
    }

    @After
    public void tearDown() throws IOException, StorageEngineException {
        EnvironmentUtils.cleanEnv();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOperatePipe() throws Exception {
        try (LocalSyncInfo localSyncInfo = new LocalSyncInfo();){
            CreatePipeSinkStatement createPipeSinkStatement = new CreatePipeSinkStatement();
            createPipeSinkStatement.setPipeSinkName("demo");
            createPipeSinkStatement.setPipeSinkType("IoTDB");
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("ip", "127.0.0.1");
            attributes.put("port", "6667");
            createPipeSinkStatement.setAttributes(attributes);
            try {
                localSyncInfo.addPipe((PipeInfo)new TsFilePipeInfo(pipe1, "demo", createdTime1, 0L, true));
                Assert.fail();
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)(e instanceof PipeSinkNotExistException));
            }
            localSyncInfo.addPipeSink(createPipeSinkStatement);
            localSyncInfo.addPipe((PipeInfo)new TsFilePipeInfo(pipe1, "demo", createdTime1, 0L, true));
            localSyncInfo.addPipe((PipeInfo)new TsFilePipeInfo(pipe2, "demo", createdTime2, 0L, true));
            try {
                localSyncInfo.addPipe((PipeInfo)new TsFilePipeInfo(pipe2, "demo", createdTime2, 0L, true));
                Assert.fail();
            }
            catch (PipeException e) {
                // empty catch block
            }
            localSyncInfo.operatePipe(pipe2, SyncOperation.STOP_PIPE);
            localSyncInfo.operatePipe(pipe2, SyncOperation.START_PIPE);
            Assert.assertEquals((long)1L, (long)localSyncInfo.getAllPipeSink().size());
            Assert.assertEquals((long)2L, (long)localSyncInfo.getAllPipeInfos().size());
            localSyncInfo.changePipeMessage(pipe2, PipeMessage.PipeMessageType.WARN);
            localSyncInfo.changePipeMessage(pipe2, PipeMessage.PipeMessageType.NORMAL);
            PipeInfo pipeInfo1 = localSyncInfo.getPipeInfo(pipe2);
            Assert.assertEquals((Object)PipeMessage.PipeMessageType.WARN, (Object)pipeInfo1.getMessageType());
            localSyncInfo.changePipeMessage(pipe2, PipeMessage.PipeMessageType.ERROR);
            PipeInfo pipeInfo2 = localSyncInfo.getPipeInfo(pipe2);
            Assert.assertEquals((Object)PipeMessage.PipeMessageType.ERROR, (Object)pipeInfo2.getMessageType());
            localSyncInfo.operatePipe(pipe1, SyncOperation.DROP_PIPE);
            Assert.assertEquals((long)1L, (long)localSyncInfo.getAllPipeInfos().size());
        }
    }
}

