/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.datasource;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.modification.ModificationFile;
import org.apache.iotdb.db.sync.datasource.TsFileOpBlock;
import org.apache.iotdb.db.sync.externalpipe.operation.InsertOperation;
import org.apache.iotdb.db.sync.externalpipe.operation.Operation;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.utils.MeasurementGroup;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.TsFileWriter;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.record.Tablet;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.FloatDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.IntDataPoint;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.Schema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TsFileOpBlockTest {
    public static final String TMP_DIR = "target" + File.separator + "TsFileOpBlockTest";
    private final String tsFileName1 = TMP_DIR + File.separator + "test1.tsfile";
    private final String tsFileName2 = TMP_DIR + File.separator + "test2.tsfile";
    private final String modsFileName2 = this.tsFileName2 + ".mods";
    private final String tsFileName3 = TMP_DIR + File.separator + "test3.tsfile";
    private final String modsFileName3 = this.tsFileName3 + ".mods";
    private final String alignedTsFileName1 = TMP_DIR + File.separator + "aligned1.tsfile";
    private final String alignedModsFileName1 = this.alignedTsFileName1 + ".mods";
    private final String alignedTsFileName2 = TMP_DIR + File.separator + "aligned2.tsfile";
    public final List<String> fileNameList = new LinkedList<String>();
    public final String DEFAULT_TEMPLATE = "template";
    String nonAlignedDevice = "root.sg0.d0";
    String alignedDevice = "root.sg0.d1";
    String sensorPrefix = "sensor_";
    String alignedSensorPrefix = "alignedSensor_";
    int rowNumPerSensor = 20;
    int sensorNum = 13;
    int oldMaxNumberOfPointsInPage;

    @Before
    public void prepareTestData() throws Exception {
        this.oldMaxNumberOfPointsInPage = TSFileDescriptor.getInstance().getConfig().getMaxNumberOfPointsInPage();
        this.createTsfile1(this.tsFileName1);
        this.fileNameList.add(this.tsFileName1);
        this.createTsfile2(this.tsFileName2);
        this.fileNameList.add(this.tsFileName2);
        this.creatModsFile2(this.modsFileName2);
        this.fileNameList.add(this.modsFileName2);
        this.createTsfile2(this.tsFileName3);
        this.fileNameList.add(this.tsFileName3);
        this.creatModsFile3(this.modsFileName3);
        this.fileNameList.add(this.modsFileName3);
        this.createAlignedTsfile1(this.alignedTsFileName1);
        this.fileNameList.add(this.alignedTsFileName1);
        this.creatAlignedModsFile1(this.alignedModsFileName1);
        this.fileNameList.add(this.alignedModsFileName1);
    }

    @After
    public void removeTestData() throws Exception {
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(this.oldMaxNumberOfPointsInPage);
        for (String fileName : this.fileNameList) {
            File file = new File(fileName);
            if (!file.exists()) continue;
            file.delete();
        }
    }

    private void createTsfile1(String tsfilePath) throws Exception {
        File file = new File(tsfilePath);
        if (file.exists()) {
            file.delete();
        }
        Schema schema = new Schema();
        schema.extendTemplate("template", new MeasurementSchema("sensor1", TSDataType.FLOAT, TSEncoding.RLE));
        schema.extendTemplate("template", new MeasurementSchema("sensor2", TSDataType.INT32, TSEncoding.TS_2DIFF));
        schema.extendTemplate("template", new MeasurementSchema("sensor3", TSDataType.INT32, TSEncoding.TS_2DIFF));
        TsFileWriter tsFileWriter = new TsFileWriter(file, schema);
        TSRecord tsRecord = new TSRecord(1617206403001L, "root.lemming.device1");
        FloatDataPoint dPoint1 = new FloatDataPoint("sensor1", 1.1f);
        IntDataPoint dPoint2 = new IntDataPoint("sensor2", 12);
        IntDataPoint dPoint3 = new IntDataPoint("sensor3", 13);
        tsRecord.addTuple((DataPoint)dPoint1);
        tsRecord.addTuple((DataPoint)dPoint2);
        tsRecord.addTuple((DataPoint)dPoint3);
        tsFileWriter.write(tsRecord);
        tsFileWriter.flushAllChunkGroups();
        tsRecord = new TSRecord(1617206403002L, "root.lemming.device2");
        dPoint2 = new IntDataPoint("sensor2", 22);
        tsRecord.addTuple((DataPoint)dPoint2);
        tsFileWriter.write(tsRecord);
        tsFileWriter.flushAllChunkGroups();
        tsRecord = new TSRecord(1617206403003L, "root.lemming.device3");
        dPoint1 = new FloatDataPoint("sensor1", 3.1f);
        dPoint2 = new IntDataPoint("sensor2", 32);
        tsRecord.addTuple((DataPoint)dPoint1);
        tsRecord.addTuple((DataPoint)dPoint2);
        tsFileWriter.write(tsRecord);
        tsFileWriter.flushAllChunkGroups();
        tsFileWriter.close();
    }

    @Test(timeout=10000L)
    public void testOpBlock() throws IOException {
        TsFileOpBlock tsFileOpBlock = new TsFileOpBlock("root", this.tsFileName1, 0L);
        Assert.assertEquals((Object)"root", (Object)tsFileOpBlock.getStorageGroup());
        Assert.assertEquals((long)0L, (long)tsFileOpBlock.getBeginIndex());
        Assert.assertEquals((long)6L, (long)tsFileOpBlock.getDataCount());
        Assert.assertEquals((long)6L, (long)tsFileOpBlock.getNextIndex());
        tsFileOpBlock.setBeginIndex(2L);
        Assert.assertEquals((long)8L, (long)tsFileOpBlock.getNextIndex());
        Operation operation = null;
        int i = 0;
        while ((long)i < tsFileOpBlock.getDataCount()) {
            operation = tsFileOpBlock.getOperation((long)(i + 2), 1L);
            Assert.assertEquals((Object)"root", (Object)operation.getStorageGroup());
            Assert.assertEquals((long)1L, (long)operation.getDataCount());
            Assert.assertEquals((long)(i + 2), (long)operation.getStartIndex());
            Assert.assertEquals((long)(i + 3), (long)operation.getEndIndex());
            Assert.assertEquals((Object)true, (Object)(operation instanceof InsertOperation));
            InsertOperation insertOperation = (InsertOperation)operation;
            Assert.assertEquals((long)1L, (long)insertOperation.getDataList().size());
            ++i;
        }
        InsertOperation insertOperation = (InsertOperation)operation;
        int k = 0;
        Assert.assertEquals((Object)"root.lemming.device3.sensor2", (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)k)).left).getFullPath());
        Assert.assertEquals((long)1617206403003L, (long)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)k)).right).get(0)).getTimestamp());
        Assert.assertEquals((Object)"32", (Object)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)k)).right).get(0)).getValue().toString());
        int i2 = 0;
        while ((long)i2 <= tsFileOpBlock.getDataCount() - 3L) {
            operation = tsFileOpBlock.getOperation((long)(i2 + 2), 3L);
            Assert.assertEquals((Object)"root", (Object)operation.getStorageGroup());
            Assert.assertEquals((long)3L, (long)operation.getDataCount());
            Assert.assertEquals((long)(i2 + 2), (long)operation.getStartIndex());
            Assert.assertEquals((long)(i2 + 5), (long)operation.getEndIndex());
            ++i2;
        }
        for (long i3 = 6L; i3 < 8L; ++i3) {
            operation = tsFileOpBlock.getOperation(i3, 3L);
            Assert.assertEquals((Object)"root", (Object)operation.getStorageGroup());
            Assert.assertEquals((long)(8L - i3), (long)operation.getDataCount());
            Assert.assertEquals((long)i3, (long)operation.getStartIndex());
            Assert.assertEquals((long)8L, (long)operation.getEndIndex());
        }
        tsFileOpBlock.close();
    }

    private void createTsfile2(String tsfilePath) throws Exception {
        File file = new File(tsfilePath);
        if (file.exists()) {
            file.delete();
        }
        Schema schema = new Schema();
        schema.extendTemplate("template", new MeasurementSchema("sensor1", TSDataType.FLOAT, TSEncoding.RLE));
        schema.extendTemplate("template", new MeasurementSchema("sensor2", TSDataType.INT32, TSEncoding.TS_2DIFF));
        schema.extendTemplate("template", new MeasurementSchema("sensor3", TSDataType.INT32, TSEncoding.TS_2DIFF));
        TsFileWriter tsFileWriter = new TsFileWriter(file, schema);
        TSRecord tsRecord = new TSRecord(1617206403001L, "root.lemming.device1");
        FloatDataPoint dPoint1 = new FloatDataPoint("sensor1", 1.1f);
        IntDataPoint dPoint2 = new IntDataPoint("sensor2", 12);
        IntDataPoint dPoint3 = new IntDataPoint("sensor3", 13);
        tsRecord.addTuple((DataPoint)dPoint1);
        tsRecord.addTuple((DataPoint)dPoint2);
        tsRecord.addTuple((DataPoint)dPoint3);
        tsFileWriter.write(tsRecord);
        tsFileWriter.flushAllChunkGroups();
        tsRecord = new TSRecord(1617206403002L, "root.lemming.device2");
        dPoint2 = new IntDataPoint("sensor2", 22);
        tsRecord.addTuple((DataPoint)dPoint2);
        tsFileWriter.write(tsRecord);
        tsFileWriter.flushAllChunkGroups();
        tsRecord = new TSRecord(1617206403003L, "root.lemming.device3");
        dPoint1 = new FloatDataPoint("sensor1", 3.1f);
        dPoint2 = new IntDataPoint("sensor2", 32);
        tsRecord.addTuple((DataPoint)dPoint1);
        tsRecord.addTuple((DataPoint)dPoint2);
        tsFileWriter.write(tsRecord);
        tsFileWriter.flushAllChunkGroups();
        tsRecord = new TSRecord(1617206403004L, "root.lemming.device1");
        dPoint1 = new FloatDataPoint("sensor1", 4.1f);
        dPoint2 = new IntDataPoint("sensor2", 42);
        dPoint3 = new IntDataPoint("sensor3", 43);
        tsRecord.addTuple((DataPoint)dPoint1);
        tsRecord.addTuple((DataPoint)dPoint2);
        tsRecord.addTuple((DataPoint)dPoint3);
        tsFileWriter.write(tsRecord);
        tsFileWriter.flushAllChunkGroups();
        tsFileWriter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void creatModsFile2(String modsFilePath) throws IllegalPathException {
        Modification[] modifications = new Modification[]{new Deletion(new PartialPath("root.lemming.device1.sensor1"), 2L, 1L), new Deletion(new PartialPath("root.lemming.device1.sensor1"), 3L, 2L, 5L), new Deletion(new PartialPath("root.lemming.**"), 11L, 1L, Long.MAX_VALUE)};
        try (ModificationFile mFile = new ModificationFile(modsFilePath);){
            for (Modification mod : modifications) {
                mFile.write(mod);
            }
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void creatModsFile3(String modsFilePath) throws IllegalPathException {
        Modification[] modifications = new Modification[]{new Deletion(new PartialPath("root.lemming.device1.sensor1"), 2L, 1617206403001L), new Deletion(new PartialPath("root.lemming.device2.*"), 3L, 2L, Long.MAX_VALUE)};
        try (ModificationFile mFile = new ModificationFile(modsFilePath);){
            for (Modification mod : modifications) {
                mFile.write(mod);
            }
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test(timeout=10000L)
    public void testOpBlockMods2() throws IOException {
        List modificationList = null;
        try (ModificationFile mFile = new ModificationFile(this.modsFileName2);){
            modificationList = (List)mFile.getModifications();
        }
        TsFileOpBlock tsFileOpBlock = new TsFileOpBlock("root", this.tsFileName2, this.modsFileName2, 0L);
        Assert.assertEquals((Object)"root", (Object)tsFileOpBlock.getStorageGroup());
        Assert.assertEquals((long)0L, (long)tsFileOpBlock.getBeginIndex());
        Assert.assertEquals((long)9L, (long)tsFileOpBlock.getDataCount());
        Assert.assertEquals((long)9L, (long)tsFileOpBlock.getNextIndex());
        tsFileOpBlock.setBeginIndex(55L);
        Assert.assertEquals((long)64L, (long)tsFileOpBlock.getNextIndex());
        Assert.assertNull((Object)tsFileOpBlock.getFullPathToDeletionMap());
        Assert.assertNull((Object)tsFileOpBlock.getModificationList());
        Operation operation = tsFileOpBlock.getOperation(55L, 1L);
        Assert.assertNotNull((Object)tsFileOpBlock.getFullPathToDeletionMap());
        Assert.assertEquals((Object)modificationList, (Object)tsFileOpBlock.getModificationList());
        Assert.assertEquals((long)9L, (long)tsFileOpBlock.getDataCount());
        int i = 0;
        while ((long)i < tsFileOpBlock.getDataCount()) {
            operation = tsFileOpBlock.getOperation((long)(i + 55), 1L);
            Assert.assertEquals((Object)"root", (Object)operation.getStorageGroup());
            Assert.assertEquals((long)1L, (long)operation.getDataCount());
            Assert.assertEquals((long)(i + 55), (long)operation.getStartIndex());
            Assert.assertEquals((long)(i + 56), (long)operation.getEndIndex());
            Assert.assertEquals((Object)true, (Object)(operation instanceof InsertOperation));
            InsertOperation insertOperation = (InsertOperation)operation;
            Assert.assertEquals((long)1L, (long)insertOperation.getDataList().size());
            ++i;
        }
        operation = tsFileOpBlock.getOperation(55L, 15L);
        Assert.assertEquals((long)9L, (long)operation.getDataCount());
        InsertOperation insertOperation = (InsertOperation)operation;
        int i2 = 0;
        Assert.assertEquals((Object)"root.lemming.device1.sensor1", (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)i2)).left).getFullPath());
        Assert.assertEquals(null, ((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0));
        i2 = 1;
        Assert.assertEquals((Object)"root.lemming.device1.sensor2", (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)i2)).left).getFullPath());
        Assert.assertEquals(null, ((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0));
        i2 = 2;
        Assert.assertEquals((Object)"root.lemming.device1.sensor3", (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)i2)).left).getFullPath());
        Assert.assertEquals(null, ((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0));
        i2 = 3;
        Assert.assertEquals((Object)"root.lemming.device2.sensor2", (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)i2)).left).getFullPath());
        Assert.assertEquals(null, ((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0));
        i2 = 4;
        Assert.assertEquals((Object)"root.lemming.device3.sensor1", (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)i2)).left).getFullPath());
        Assert.assertEquals(null, ((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0));
        i2 = 5;
        Assert.assertEquals((Object)"root.lemming.device3.sensor2", (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)i2)).left).getFullPath());
        Assert.assertEquals(null, ((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0));
        tsFileOpBlock.close();
    }

    @Test(timeout=10000L)
    public void testOpBlockMods3() throws IOException {
        List modificationList = null;
        try (ModificationFile mFile = new ModificationFile(this.modsFileName3);){
            modificationList = (List)mFile.getModifications();
        }
        TsFileOpBlock tsFileOpBlock = new TsFileOpBlock("root", this.tsFileName2, this.modsFileName3, 0L);
        Assert.assertEquals((Object)"root", (Object)tsFileOpBlock.getStorageGroup());
        Assert.assertEquals((long)0L, (long)tsFileOpBlock.getBeginIndex());
        Assert.assertEquals((long)9L, (long)tsFileOpBlock.getDataCount());
        Assert.assertEquals((long)9L, (long)tsFileOpBlock.getNextIndex());
        tsFileOpBlock.setBeginIndex(55L);
        Assert.assertEquals((long)64L, (long)tsFileOpBlock.getNextIndex());
        Assert.assertNull((Object)tsFileOpBlock.getFullPathToDeletionMap());
        Assert.assertNull((Object)tsFileOpBlock.getModificationList());
        Operation operation = tsFileOpBlock.getOperation(55L, 1L);
        Assert.assertNotNull((Object)tsFileOpBlock.getFullPathToDeletionMap());
        Assert.assertEquals((Object)modificationList, (Object)tsFileOpBlock.getModificationList());
        Assert.assertEquals((long)9L, (long)tsFileOpBlock.getDataCount());
        int i = 0;
        while ((long)i < tsFileOpBlock.getDataCount()) {
            operation = tsFileOpBlock.getOperation((long)(i + 55), 1L);
            Assert.assertEquals((Object)"root", (Object)operation.getStorageGroup());
            Assert.assertEquals((long)1L, (long)operation.getDataCount());
            Assert.assertEquals((long)(i + 55), (long)operation.getStartIndex());
            Assert.assertEquals((long)(i + 56), (long)operation.getEndIndex());
            Assert.assertEquals((Object)true, (Object)(operation instanceof InsertOperation));
            InsertOperation insertOperation = (InsertOperation)operation;
            Assert.assertEquals((long)1L, (long)insertOperation.getDataList().size());
            ++i;
        }
        operation = tsFileOpBlock.getOperation(55L, 20L);
        Assert.assertEquals((long)9L, (long)operation.getDataCount());
        InsertOperation insertOperation = (InsertOperation)operation;
        int i2 = 0;
        Assert.assertEquals((Object)"root.lemming.device1.sensor1", (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)i2)).left).getFullPath());
        Assert.assertEquals(null, ((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0));
        i2 = 1;
        Assert.assertEquals((Object)"root.lemming.device1.sensor2", (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)i2)).left).getFullPath());
        Assert.assertEquals((long)1617206403001L, (long)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0)).getTimestamp());
        Assert.assertEquals((Object)"12", (Object)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0)).getValue().toString());
        i2 = 2;
        Assert.assertEquals((Object)"root.lemming.device1.sensor3", (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)i2)).left).getFullPath());
        Assert.assertEquals((long)1617206403001L, (long)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0)).getTimestamp());
        Assert.assertEquals((Object)"13", (Object)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0)).getValue().toString());
        i2 = 3;
        Assert.assertEquals((Object)"root.lemming.device2.sensor2", (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)i2)).left).getFullPath());
        Assert.assertEquals(null, ((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0));
        i2 = 4;
        Assert.assertEquals((Object)"root.lemming.device3.sensor1", (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)i2)).left).getFullPath());
        Assert.assertEquals((long)1617206403003L, (long)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0)).getTimestamp());
        Assert.assertEquals((Object)"3.1", (Object)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0)).getValue().toString());
        i2 = 5;
        Assert.assertEquals((Object)"root.lemming.device3.sensor2", (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)i2)).left).getFullPath());
        Assert.assertEquals((long)1617206403003L, (long)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0)).getTimestamp());
        Assert.assertEquals((Object)"32", (Object)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0)).getValue().toString());
        i2 = 6;
        Assert.assertEquals((Object)"root.lemming.device1.sensor1", (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)i2)).left).getFullPath());
        Assert.assertEquals((long)1617206403004L, (long)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0)).getTimestamp());
        Assert.assertEquals((Object)"4.1", (Object)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0)).getValue().toString());
        i2 = 7;
        Assert.assertEquals((Object)"root.lemming.device1.sensor2", (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)i2)).left).getFullPath());
        Assert.assertEquals((long)1617206403004L, (long)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0)).getTimestamp());
        Assert.assertEquals((Object)"42", (Object)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0)).getValue().toString());
        i2 = 8;
        Assert.assertEquals((Object)"root.lemming.device1.sensor3", (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)i2)).left).getFullPath());
        Assert.assertEquals((long)1617206403004L, (long)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0)).getTimestamp());
        Assert.assertEquals((Object)"43", (Object)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0)).getValue().toString());
        operation = tsFileOpBlock.getOperation(59L, 20L);
        Assert.assertEquals((long)5L, (long)operation.getDataCount());
        insertOperation = (InsertOperation)operation;
        i2 = 0;
        Assert.assertEquals((Object)"root.lemming.device3.sensor1", (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)i2)).left).getFullPath());
        Assert.assertEquals((long)1617206403003L, (long)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0)).getTimestamp());
        Assert.assertEquals((Object)"3.1", (Object)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0)).getValue().toString());
        i2 = 1;
        Assert.assertEquals((Object)"root.lemming.device3.sensor2", (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)i2)).left).getFullPath());
        Assert.assertEquals((long)1617206403003L, (long)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0)).getTimestamp());
        Assert.assertEquals((Object)"32", (Object)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0)).getValue().toString());
        i2 = 2;
        Assert.assertEquals((Object)"root.lemming.device1.sensor1", (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)i2)).left).getFullPath());
        Assert.assertEquals((long)1617206403004L, (long)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0)).getTimestamp());
        Assert.assertEquals((Object)"4.1", (Object)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0)).getValue().toString());
        i2 = 3;
        Assert.assertEquals((Object)"root.lemming.device1.sensor2", (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)i2)).left).getFullPath());
        Assert.assertEquals((long)1617206403004L, (long)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0)).getTimestamp());
        Assert.assertEquals((Object)"42", (Object)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0)).getValue().toString());
        i2 = 4;
        Assert.assertEquals((Object)"root.lemming.device1.sensor3", (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)i2)).left).getFullPath());
        Assert.assertEquals((long)1617206403004L, (long)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0)).getTimestamp());
        Assert.assertEquals((Object)"43", (Object)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0)).getValue().toString());
        tsFileOpBlock.close();
    }

    private void createAlignedTsfile1(String tsfilePath) throws Exception {
        File file = new File(tsfilePath);
        if (file.exists() && !file.delete()) {
            throw new RuntimeException("Can not delete: " + file.getAbsolutePath());
        }
        try {
            Schema schema = new Schema();
            ArrayList<MeasurementSchema> measurementSchemas = new ArrayList<MeasurementSchema>();
            for (int i = 0; i < this.sensorNum; ++i) {
                MeasurementSchema measurementSchema1 = new MeasurementSchema(this.sensorPrefix + i, TSDataType.INT64, TSEncoding.TS_2DIFF);
                measurementSchemas.add(measurementSchema1);
                schema.registerTimeseries(new Path(this.nonAlignedDevice), measurementSchema1);
            }
            ArrayList<MeasurementSchema> alignedMeasurementSchemas = new ArrayList<MeasurementSchema>();
            for (int i = 0; i < this.sensorNum; ++i) {
                MeasurementSchema measurementSchema2 = new MeasurementSchema(this.alignedSensorPrefix + i, TSDataType.INT64, TSEncoding.RLE);
                alignedMeasurementSchemas.add(measurementSchema2);
            }
            MeasurementGroup group = new MeasurementGroup(true, alignedMeasurementSchemas);
            schema.registerMeasurementGroup(new Path(this.alignedDevice), group);
            TSFileConfig tsFileConfig = TSFileDescriptor.getInstance().getConfig();
            tsFileConfig.setMaxNumberOfPointsInPage(5);
            try (TsFileWriter tsFileWriter = new TsFileWriter(file, schema, tsFileConfig);){
                long[] sensor;
                int i;
                int r;
                Tablet tablet = new Tablet(this.nonAlignedDevice, measurementSchemas);
                long[] timestamps = tablet.timestamps;
                Object[] values = tablet.values;
                long timestamp = 1617206401000L;
                long value = 1000000L;
                for (r = 0; r < this.rowNumPerSensor; ++r) {
                    ++tablet.rowSize;
                    ++timestamp;
                    for (i = 0; i < this.sensorNum; ++i) {
                        sensor = (long[])values[i];
                        sensor[row] = value + (long)(i * 1000) + (long)r;
                    }
                    if (tablet.rowSize != tablet.getMaxRowNumber()) continue;
                    tsFileWriter.write(tablet);
                    tablet.reset();
                }
                if (tablet.rowSize != 0) {
                    tsFileWriter.write(tablet);
                    tablet.reset();
                }
                tablet = new Tablet(this.alignedDevice, alignedMeasurementSchemas);
                timestamps = tablet.timestamps;
                values = tablet.values;
                timestamp = 1617206402000L;
                value = 2000000L;
                for (r = 0; r < this.rowNumPerSensor; ++r) {
                    ++tablet.rowSize;
                    ++timestamp;
                    for (i = 0; i < this.sensorNum; ++i) {
                        if (i + r == 4) {
                            tablet.addValue(this.alignedSensorPrefix + i, r, null);
                            continue;
                        }
                        sensor = (long[])values[i];
                        sensor[row] = value + (long)(i * 1000) + (long)r;
                    }
                    if (tablet.rowSize != tablet.getMaxRowNumber()) continue;
                    tsFileWriter.writeAligned(tablet);
                    tablet.reset();
                }
                if (tablet.rowSize != 0) {
                    tsFileWriter.writeAligned(tablet);
                    tablet.reset();
                }
                tsFileWriter.flushAllChunkGroups();
                tablet = new Tablet(this.nonAlignedDevice, measurementSchemas);
                timestamps = tablet.timestamps;
                values = tablet.values;
                timestamp = 1617206403000L;
                value = 3000000L;
                for (r = 0; r < this.rowNumPerSensor; ++r) {
                    ++tablet.rowSize;
                    ++timestamp;
                    for (i = 0; i < this.sensorNum; ++i) {
                        sensor = (long[])values[i];
                        sensor[row] = value + (long)(i * 1000) + (long)r;
                    }
                    if (tablet.rowSize != tablet.getMaxRowNumber()) continue;
                    tsFileWriter.write(tablet);
                    tablet.reset();
                }
                if (tablet.rowSize != 0) {
                    tsFileWriter.write(tablet);
                    tablet.reset();
                }
                tablet = new Tablet(this.alignedDevice, alignedMeasurementSchemas);
                timestamps = tablet.timestamps;
                values = tablet.values;
                timestamp = 1617206404000L;
                value = 4000000L;
                for (r = 0; r < this.rowNumPerSensor; ++r) {
                    ++tablet.rowSize;
                    ++timestamp;
                    for (i = 0; i < this.sensorNum; ++i) {
                        if (i == r) {
                            tablet.addValue(this.alignedSensorPrefix + i, r, null);
                            continue;
                        }
                        sensor = (long[])values[i];
                        sensor[row] = value + (long)(i * 1000) + (long)r;
                    }
                    if (tablet.rowSize != tablet.getMaxRowNumber()) continue;
                    tsFileWriter.writeAligned(tablet);
                    tablet.reset();
                }
                if (tablet.rowSize != 0) {
                    tsFileWriter.writeAligned(tablet);
                    tablet.reset();
                }
            }
        }
        catch (Exception e) {
            throw new Exception("meet error in TsFileWrite with tablet", e);
        }
    }

    @Test(timeout=10000L)
    public void testOpBlockTimeAligned1() throws IOException {
        int j;
        int listIndex;
        int i;
        TsFileOpBlock tsFileOpBlock = new TsFileOpBlock("root", this.alignedTsFileName1, null, 0L);
        int allDataCount = this.rowNumPerSensor * this.sensorNum * 4;
        Assert.assertEquals((Object)"root", (Object)tsFileOpBlock.getStorageGroup());
        Assert.assertEquals((long)0L, (long)tsFileOpBlock.getBeginIndex());
        Assert.assertEquals((long)allDataCount, (long)tsFileOpBlock.getDataCount());
        Assert.assertEquals((long)allDataCount, (long)tsFileOpBlock.getNextIndex());
        tsFileOpBlock.setBeginIndex(55L);
        Assert.assertEquals((long)(55 + allDataCount), (long)tsFileOpBlock.getNextIndex());
        Assert.assertNull((Object)tsFileOpBlock.getFullPathToDeletionMap());
        Assert.assertNull((Object)tsFileOpBlock.getModificationList());
        Operation operation = tsFileOpBlock.getOperation(55L, 1L);
        Assert.assertEquals((long)1L, (long)operation.getDataCount());
        Assert.assertEquals((long)allDataCount, (long)tsFileOpBlock.getDataCount());
        int i2 = 0;
        while ((long)i2 < tsFileOpBlock.getDataCount()) {
            operation = tsFileOpBlock.getOperation((long)(i2 + 55), 1L);
            Assert.assertEquals((Object)"root", (Object)operation.getStorageGroup());
            Assert.assertEquals((long)1L, (long)operation.getDataCount());
            Assert.assertEquals((long)(i2 + 55), (long)operation.getStartIndex());
            Assert.assertEquals((long)(i2 + 56), (long)operation.getEndIndex());
            Assert.assertEquals((Object)true, (Object)(operation instanceof InsertOperation));
            InsertOperation insertOperation = (InsertOperation)operation;
            Assert.assertEquals((long)1L, (long)insertOperation.getDataList().size());
            ++i2;
        }
        operation = tsFileOpBlock.getOperation(55L, 45L);
        Assert.assertEquals((long)45L, (long)operation.getDataCount());
        operation = tsFileOpBlock.getOperation(55L, 5000L);
        Assert.assertEquals((long)allDataCount, (long)operation.getDataCount());
        InsertOperation insertOperation = (InsertOperation)operation;
        Assert.assertEquals((long)(this.sensorNum * 4), (long)insertOperation.getDataList().size());
        for (i = 0; i < this.sensorNum; ++i) {
            Assert.assertEquals((Object)(this.nonAlignedDevice + "." + this.sensorPrefix + i), (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)i)).left).getFullPath());
            for (int j2 = 0; j2 < this.rowNumPerSensor; ++j2) {
                Assert.assertEquals((long)(1617206401000L + (long)j2), (long)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i)).right).get(j2)).getTimestamp());
                Assert.assertEquals((Object)Long.toString(1000000L + (long)(i * 1000) + (long)j2), (Object)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i)).right).get(j2)).getValue().toString());
            }
        }
        for (i = 0; i < this.sensorNum; ++i) {
            listIndex = this.sensorNum + i;
            Assert.assertEquals((Object)(this.alignedDevice + "." + this.alignedSensorPrefix + i), (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)listIndex)).left).getFullPath());
            for (j = 0; j < this.rowNumPerSensor; ++j) {
                if (i + j == 4) {
                    Assert.assertNull(((List)((Pair)insertOperation.getDataList().get((int)listIndex)).right).get(j));
                    continue;
                }
                Assert.assertEquals((long)(1617206402000L + (long)j), (long)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)listIndex)).right).get(j)).getTimestamp());
                Assert.assertEquals((Object)Long.toString(2000000L + (long)(i * 1000) + (long)j), (Object)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)listIndex)).right).get(j)).getValue().toString());
            }
        }
        for (i = 0; i < this.sensorNum; ++i) {
            listIndex = this.sensorNum * 2 + i;
            Assert.assertEquals((Object)(this.nonAlignedDevice + "." + this.sensorPrefix + i), (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)listIndex)).left).getFullPath());
            for (j = 0; j < this.rowNumPerSensor; ++j) {
                Assert.assertEquals((long)(1617206403000L + (long)j), (long)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)listIndex)).right).get(j)).getTimestamp());
                Assert.assertEquals((Object)Long.toString(3000000L + (long)(i * 1000) + (long)j), (Object)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)listIndex)).right).get(j)).getValue().toString());
            }
        }
        for (i = 0; i < this.sensorNum; ++i) {
            listIndex = this.sensorNum * 3 + i;
            Assert.assertEquals((Object)(this.alignedDevice + "." + this.alignedSensorPrefix + i), (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)listIndex)).left).getFullPath());
            for (j = 0; j < this.rowNumPerSensor; ++j) {
                if (i == j) {
                    Assert.assertNull(((List)((Pair)insertOperation.getDataList().get((int)listIndex)).right).get(j));
                    continue;
                }
                Assert.assertEquals((long)(1617206404000L + (long)j), (long)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)listIndex)).right).get(j)).getTimestamp());
                Assert.assertEquals((Object)Long.toString(4000000L + (long)(i * 1000) + (long)j), (Object)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)listIndex)).right).get(j)).getValue().toString());
            }
        }
        tsFileOpBlock.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void creatAlignedModsFile1(String modsFilePath) throws IllegalPathException {
        Modification[] modifications = new Modification[]{new Deletion(new PartialPath("root.sg0.d0.sensor_0"), 1L, Long.MAX_VALUE), new Deletion(new PartialPath("root.sg0.d0.sensor_1"), 2L, 1617206401001L), new Deletion(new PartialPath("root.sg0.d1.alignedSensor_0"), 3L, 1617206402002L), new Deletion(new PartialPath("root.sg0.d1.alignedSensor_1"), 4L, 1617206402003L)};
        try (ModificationFile mFile = new ModificationFile(modsFilePath);){
            for (Modification mod : modifications) {
                mFile.write(mod);
            }
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test(timeout=10000L)
    public void testOpBlockTimeAlignedMods1() throws IOException {
        TsFileOpBlock tsFileOpBlock = new TsFileOpBlock("root", this.alignedTsFileName1, this.alignedModsFileName1, 0L);
        int allDataCount = this.rowNumPerSensor * this.sensorNum * 4;
        Assert.assertEquals((Object)"root", (Object)tsFileOpBlock.getStorageGroup());
        Assert.assertEquals((long)0L, (long)tsFileOpBlock.getBeginIndex());
        Assert.assertEquals((long)allDataCount, (long)tsFileOpBlock.getDataCount());
        Assert.assertEquals((long)allDataCount, (long)tsFileOpBlock.getNextIndex());
        tsFileOpBlock.setBeginIndex(55L);
        Assert.assertEquals((long)(55 + allDataCount), (long)tsFileOpBlock.getNextIndex());
        Assert.assertNull((Object)tsFileOpBlock.getFullPathToDeletionMap());
        Assert.assertNull((Object)tsFileOpBlock.getModificationList());
        Operation operation = tsFileOpBlock.getOperation(55L, 1L);
        Assert.assertEquals((long)1L, (long)operation.getDataCount());
        Assert.assertNotNull((Object)tsFileOpBlock.getFullPathToDeletionMap());
        Assert.assertNotNull((Object)tsFileOpBlock.getModificationList());
        Assert.assertEquals((long)allDataCount, (long)tsFileOpBlock.getDataCount());
        int i = 0;
        while ((long)i < tsFileOpBlock.getDataCount()) {
            operation = tsFileOpBlock.getOperation((long)(i + 55), 1L);
            Assert.assertEquals((Object)"root", (Object)operation.getStorageGroup());
            Assert.assertEquals((long)1L, (long)operation.getDataCount());
            Assert.assertEquals((long)(i + 55), (long)operation.getStartIndex());
            Assert.assertEquals((long)(i + 56), (long)operation.getEndIndex());
            Assert.assertEquals((Object)true, (Object)(operation instanceof InsertOperation));
            InsertOperation insertOperation = (InsertOperation)operation;
            Assert.assertEquals((long)1L, (long)insertOperation.getDataList().size());
            ++i;
        }
        operation = tsFileOpBlock.getOperation(55L, 45L);
        Assert.assertEquals((long)45L, (long)operation.getDataCount());
        operation = tsFileOpBlock.getOperation(55L, 5000L);
        Assert.assertEquals((long)allDataCount, (long)operation.getDataCount());
        InsertOperation insertOperation = (InsertOperation)operation;
        Assert.assertEquals((long)(this.sensorNum * 4), (long)insertOperation.getDataList().size());
        int sensorIndex = 0;
        int rowIndex = 0;
        Assert.assertEquals((Object)(this.nonAlignedDevice + "." + this.sensorPrefix + sensorIndex), (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)sensorIndex)).left).getFullPath());
        for (rowIndex = 0; rowIndex < this.rowNumPerSensor; ++rowIndex) {
            Assert.assertNull(((List)((Pair)insertOperation.getDataList().get((int)sensorIndex)).right).get(rowIndex));
        }
        sensorIndex = 1;
        Assert.assertEquals((Object)(this.nonAlignedDevice + "." + this.sensorPrefix + sensorIndex), (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)sensorIndex)).left).getFullPath());
        for (rowIndex = 0; rowIndex < this.rowNumPerSensor; ++rowIndex) {
            if (rowIndex <= 1) {
                Assert.assertNull(((List)((Pair)insertOperation.getDataList().get((int)sensorIndex)).right).get(rowIndex));
                continue;
            }
            Assert.assertEquals((long)(1617206401000L + (long)rowIndex), (long)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)sensorIndex)).right).get(rowIndex)).getTimestamp());
            Assert.assertEquals((Object)Long.toString(1000000L + (long)(sensorIndex * 1000) + (long)rowIndex), (Object)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)sensorIndex)).right).get(rowIndex)).getValue().toString());
        }
        for (sensorIndex = 2; sensorIndex < this.sensorNum; ++sensorIndex) {
            Assert.assertEquals((Object)(this.nonAlignedDevice + "." + this.sensorPrefix + sensorIndex), (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)sensorIndex)).left).getFullPath());
            for (rowIndex = 0; rowIndex < this.rowNumPerSensor; ++rowIndex) {
                Assert.assertEquals((long)(1617206401000L + (long)rowIndex), (long)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)sensorIndex)).right).get(rowIndex)).getTimestamp());
                Assert.assertEquals((Object)Long.toString(1000000L + (long)(sensorIndex * 1000) + (long)rowIndex), (Object)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)sensorIndex)).right).get(rowIndex)).getValue().toString());
            }
        }
        int listIndex = 0;
        for (sensorIndex = 0; sensorIndex < 2; ++sensorIndex) {
            listIndex = this.sensorNum + sensorIndex;
            Assert.assertEquals((Object)(this.alignedDevice + "." + this.alignedSensorPrefix + sensorIndex), (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)listIndex)).left).getFullPath());
            for (rowIndex = 0; rowIndex < this.rowNumPerSensor; ++rowIndex) {
                if (sensorIndex + rowIndex == 4) {
                    Assert.assertNull(((List)((Pair)insertOperation.getDataList().get((int)listIndex)).right).get(rowIndex));
                    continue;
                }
                if (rowIndex <= 2) {
                    Assert.assertNull(((List)((Pair)insertOperation.getDataList().get((int)listIndex)).right).get(rowIndex));
                    continue;
                }
                Assert.assertEquals((long)(1617206402000L + (long)rowIndex), (long)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)listIndex)).right).get(rowIndex)).getTimestamp());
                Assert.assertEquals((Object)Long.toString(2000000L + (long)(sensorIndex * 1000) + (long)rowIndex), (Object)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)listIndex)).right).get(rowIndex)).getValue().toString());
            }
        }
        for (sensorIndex = 2; sensorIndex < this.sensorNum; ++sensorIndex) {
            listIndex = this.sensorNum + sensorIndex;
            Assert.assertEquals((Object)(this.alignedDevice + "." + this.alignedSensorPrefix + sensorIndex), (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)listIndex)).left).getFullPath());
            for (rowIndex = 0; rowIndex < this.rowNumPerSensor; ++rowIndex) {
                if (sensorIndex + rowIndex == 4) {
                    Assert.assertNull(((List)((Pair)insertOperation.getDataList().get((int)listIndex)).right).get(rowIndex));
                    continue;
                }
                if (rowIndex > 2) continue;
                Assert.assertEquals((long)(1617206402000L + (long)rowIndex), (long)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)listIndex)).right).get(rowIndex)).getTimestamp());
                Assert.assertEquals((Object)Long.toString(2000000L + (long)(sensorIndex * 1000) + (long)rowIndex), (Object)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)listIndex)).right).get(rowIndex)).getValue().toString());
            }
        }
        sensorIndex = 0;
        listIndex = this.sensorNum * 2;
        Assert.assertEquals((Object)(this.nonAlignedDevice + "." + this.sensorPrefix + sensorIndex), (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)listIndex)).left).getFullPath());
        for (rowIndex = 0; rowIndex < this.rowNumPerSensor; ++rowIndex) {
            Assert.assertNull(((List)((Pair)insertOperation.getDataList().get((int)listIndex)).right).get(rowIndex));
        }
        sensorIndex = 1;
        listIndex = this.sensorNum * 2 + sensorIndex;
        Assert.assertEquals((Object)(this.nonAlignedDevice + "." + this.sensorPrefix + sensorIndex), (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)listIndex)).left).getFullPath());
        for (rowIndex = 0; rowIndex < this.rowNumPerSensor; ++rowIndex) {
            if (rowIndex <= 1) {
                Assert.assertNull(((List)((Pair)insertOperation.getDataList().get((int)sensorIndex)).right).get(rowIndex));
                continue;
            }
            Assert.assertEquals((long)(1617206403000L + (long)rowIndex), (long)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)listIndex)).right).get(rowIndex)).getTimestamp());
            Assert.assertEquals((Object)Long.toString(3000000L + (long)(sensorIndex * 1000) + (long)rowIndex), (Object)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)listIndex)).right).get(rowIndex)).getValue().toString());
        }
        for (sensorIndex = 2; sensorIndex < this.sensorNum; ++sensorIndex) {
            listIndex = this.sensorNum * 2 + sensorIndex;
            Assert.assertEquals((Object)(this.nonAlignedDevice + "." + this.sensorPrefix + sensorIndex), (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)listIndex)).left).getFullPath());
            for (rowIndex = 0; rowIndex < this.rowNumPerSensor; ++rowIndex) {
                Assert.assertEquals((long)(1617206403000L + (long)rowIndex), (long)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)listIndex)).right).get(rowIndex)).getTimestamp());
                Assert.assertEquals((Object)Long.toString(3000000L + (long)(sensorIndex * 1000) + (long)rowIndex), (Object)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)listIndex)).right).get(rowIndex)).getValue().toString());
            }
        }
        for (sensorIndex = 0; sensorIndex < this.sensorNum; ++sensorIndex) {
            listIndex = this.sensorNum * 3 + sensorIndex;
            Assert.assertEquals((Object)(this.alignedDevice + "." + this.alignedSensorPrefix + sensorIndex), (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)listIndex)).left).getFullPath());
            for (rowIndex = 0; rowIndex < this.rowNumPerSensor; ++rowIndex) {
                if (sensorIndex == rowIndex) {
                    Assert.assertNull(((List)((Pair)insertOperation.getDataList().get((int)listIndex)).right).get(rowIndex));
                    continue;
                }
                Assert.assertEquals((long)(1617206404000L + (long)rowIndex), (long)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)listIndex)).right).get(rowIndex)).getTimestamp());
                Assert.assertEquals((Object)Long.toString(4000000L + (long)(sensorIndex * 1000) + (long)rowIndex), (Object)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)listIndex)).right).get(rowIndex)).getValue().toString());
            }
        }
        tsFileOpBlock.close();
    }

    @Test(timeout=10000L)
    public void testOpBlockTimeAlignedModsRandomAccess() throws IOException {
        TsFileOpBlock tsFileOpBlock = new TsFileOpBlock("root", this.alignedTsFileName1, this.alignedModsFileName1, 0L);
        int allDataCount = this.rowNumPerSensor * this.sensorNum * 4;
        Assert.assertEquals((long)allDataCount, (long)tsFileOpBlock.getDataCount());
        int beginIndex = 100;
        tsFileOpBlock.setBeginIndex((long)beginIndex);
        int dataIndex = beginIndex + this.rowNumPerSensor * this.sensorNum + 3;
        Operation operation = tsFileOpBlock.getOperation((long)dataIndex, 1L);
        Assert.assertEquals((long)1L, (long)operation.getDataCount());
        InsertOperation insertOperation = (InsertOperation)operation;
        Assert.assertEquals((long)1L, (long)insertOperation.getDataList().size());
        Assert.assertEquals((long)1L, (long)((List)((Pair)insertOperation.getDataList().get((int)0)).right).size());
        Assert.assertEquals((long)1617206402003L, (long)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)0)).right).get(0)).getTimestamp());
        Assert.assertEquals((Object)Long.toString(2000003L), (Object)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)0)).right).get(0)).getValue().toString());
        dataIndex = beginIndex + this.rowNumPerSensor * this.sensorNum;
        operation = tsFileOpBlock.getOperation((long)dataIndex, 3L);
        Assert.assertEquals((long)3L, (long)operation.getDataCount());
        insertOperation = (InsertOperation)operation;
        Assert.assertEquals((long)1L, (long)insertOperation.getDataList().size());
        Assert.assertEquals((long)3L, (long)((List)((Pair)insertOperation.getDataList().get((int)0)).right).size());
        Assert.assertNull(((List)((Pair)insertOperation.getDataList().get((int)0)).right).get(0));
        Assert.assertNull(((List)((Pair)insertOperation.getDataList().get((int)0)).right).get(1));
        Assert.assertNull(((List)((Pair)insertOperation.getDataList().get((int)0)).right).get(2));
        dataIndex = beginIndex + this.rowNumPerSensor * this.sensorNum * 3 + 3;
        operation = tsFileOpBlock.getOperation((long)dataIndex, 1L);
        Assert.assertEquals((long)1L, (long)operation.getDataCount());
        insertOperation = (InsertOperation)operation;
        Assert.assertEquals((long)1L, (long)insertOperation.getDataList().size());
        Assert.assertEquals((long)1L, (long)((List)((Pair)insertOperation.getDataList().get((int)0)).right).size());
        Assert.assertEquals((long)1617206404003L, (long)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)0)).right).get(0)).getTimestamp());
        Assert.assertEquals((Object)Long.toString(4000003L), (Object)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)0)).right).get(0)).getValue().toString());
        tsFileOpBlock.close();
    }
}

