/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.datasource;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.modification.ModificationFile;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.sync.datasource.AbstractOpBlock;
import org.apache.iotdb.db.sync.datasource.DeletionOpBlock;
import org.apache.iotdb.db.sync.datasource.PipeOpManager;
import org.apache.iotdb.db.sync.datasource.TsFileOpBlock;
import org.apache.iotdb.db.sync.externalpipe.operation.DeleteOperation;
import org.apache.iotdb.db.sync.externalpipe.operation.InsertOperation;
import org.apache.iotdb.db.sync.externalpipe.operation.Operation;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.TsFileWriter;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.FloatDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.IntDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.LongDataPoint;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.Schema;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class PipeOpManagerTest {
    public static final String TMP_DIR = "target" + File.separator + "PipeOpManagerTest";
    private static final String seqTsFileName1 = TMP_DIR + File.separator + "test1.tsfile";
    private static final String seqModsFileName1 = seqTsFileName1 + ".mods";
    private static final String unSeqTsFileName1 = TMP_DIR + File.separator + "test2.unseq.tsfile";
    private static final String unSeqModsFileName1 = unSeqTsFileName1 + ".mods";
    public static final String DEFAULT_TEMPLATE = "template";
    public static final List<String> delFileList = new LinkedList<String>();
    private static final String bigSeqTsFileName1 = TMP_DIR + File.separator + "test1.big.seq.tsfile";
    private static final String bigSeqTsFileName2 = TMP_DIR + File.separator + "test2.big.seq.tsfile";
    private static final String bigSeqTsFileName3 = TMP_DIR + File.separator + "test3.big.seq.tsfile";
    private static int oldMaxNumberOfPointsInPage;

    @BeforeClass
    public static void prepareTestData() throws Exception {
        oldMaxNumberOfPointsInPage = TSFileDescriptor.getInstance().getConfig().getMaxNumberOfPointsInPage();
        EnvironmentUtils.envSetUp();
        IoTDB.configManager.init();
        PipeOpManagerTest.createSeqTsfile(seqTsFileName1);
        delFileList.add(seqTsFileName1);
        PipeOpManagerTest.creatSeqModsFile(seqModsFileName1);
        delFileList.add(seqModsFileName1);
        PipeOpManagerTest.createUnSeqTsfile(unSeqTsFileName1);
        delFileList.add(unSeqTsFileName1);
        PipeOpManagerTest.creatUnSeqModsFile(unSeqModsFileName1);
        delFileList.add(unSeqModsFileName1);
        PipeOpManagerTest.createBigSeqTsfile(bigSeqTsFileName1, 1, -1);
        delFileList.add(bigSeqTsFileName1);
        PipeOpManagerTest.createBigSeqTsfile(bigSeqTsFileName2, 2, 100);
        delFileList.add(bigSeqTsFileName2);
        PipeOpManagerTest.createBigSeqTsfile(bigSeqTsFileName3, 3, 57);
        delFileList.add(bigSeqTsFileName3);
    }

    @AfterClass
    public static void removeTestData() throws Exception {
        for (String fileName : delFileList) {
            File file = new File(fileName);
            if (!file.exists()) continue;
            file.delete();
        }
        IoTDB.configManager.clear();
        EnvironmentUtils.cleanEnv();
        EnvironmentUtils.cleanAllDir();
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(oldMaxNumberOfPointsInPage);
    }

    private static void createSeqTsfile(String tsfilePath) throws Exception {
        File file = new File(tsfilePath);
        if (file.exists()) {
            file.delete();
        }
        Schema schema = new Schema();
        schema.extendTemplate(DEFAULT_TEMPLATE, new MeasurementSchema("sensor1", TSDataType.FLOAT, TSEncoding.RLE));
        schema.extendTemplate(DEFAULT_TEMPLATE, new MeasurementSchema("sensor2", TSDataType.INT32, TSEncoding.TS_2DIFF));
        schema.extendTemplate(DEFAULT_TEMPLATE, new MeasurementSchema("sensor3", TSDataType.INT32, TSEncoding.TS_2DIFF));
        TsFileWriter tsFileWriter = new TsFileWriter(file, schema);
        TSRecord tsRecord = new TSRecord(1617206403001L, "root.lemming.device1");
        FloatDataPoint dPoint1 = new FloatDataPoint("sensor1", 1.1f);
        IntDataPoint dPoint2 = new IntDataPoint("sensor2", 12);
        IntDataPoint dPoint3 = new IntDataPoint("sensor3", 13);
        tsRecord.addTuple((DataPoint)dPoint1);
        tsRecord.addTuple((DataPoint)dPoint2);
        tsRecord.addTuple((DataPoint)dPoint3);
        tsFileWriter.write(tsRecord);
        tsFileWriter.flushAllChunkGroups();
        tsRecord = new TSRecord(1617206403002L, "root.lemming.device2");
        dPoint2 = new IntDataPoint("sensor2", 22);
        tsRecord.addTuple((DataPoint)dPoint2);
        tsFileWriter.write(tsRecord);
        tsFileWriter.flushAllChunkGroups();
        tsRecord = new TSRecord(1617206403003L, "root.lemming.device3");
        dPoint1 = new FloatDataPoint("sensor1", 3.1f);
        dPoint2 = new IntDataPoint("sensor2", 32);
        tsRecord.addTuple((DataPoint)dPoint1);
        tsRecord.addTuple((DataPoint)dPoint2);
        tsFileWriter.write(tsRecord);
        tsFileWriter.flushAllChunkGroups();
        tsRecord = new TSRecord(1617206403004L, "root.lemming.device3");
        dPoint1 = new FloatDataPoint("sensor1", 4.1f);
        dPoint2 = new IntDataPoint("sensor2", 42);
        tsRecord.addTuple((DataPoint)dPoint1);
        tsRecord.addTuple((DataPoint)dPoint2);
        tsFileWriter.write(tsRecord);
        tsFileWriter.flushAllChunkGroups();
        tsFileWriter.close();
    }

    private static void createUnSeqTsfile(String tsfilePath) throws Exception {
        File file = new File(tsfilePath);
        if (file.exists()) {
            file.delete();
        }
        Schema schema = new Schema();
        schema.extendTemplate(DEFAULT_TEMPLATE, new MeasurementSchema("sensor1", TSDataType.FLOAT, TSEncoding.RLE));
        schema.extendTemplate(DEFAULT_TEMPLATE, new MeasurementSchema("sensor2", TSDataType.INT32, TSEncoding.TS_2DIFF));
        schema.extendTemplate(DEFAULT_TEMPLATE, new MeasurementSchema("sensor3", TSDataType.INT32, TSEncoding.TS_2DIFF));
        TsFileWriter tsFileWriter = new TsFileWriter(file, schema);
        TSRecord tsRecord = new TSRecord(1617206403001L, "root2.lemming.device1");
        FloatDataPoint dPoint1 = new FloatDataPoint("sensor1", 1.1f);
        IntDataPoint dPoint2 = new IntDataPoint("sensor2", 12);
        IntDataPoint dPoint3 = new IntDataPoint("sensor3", 13);
        tsRecord.addTuple((DataPoint)dPoint1);
        tsRecord.addTuple((DataPoint)dPoint2);
        tsRecord.addTuple((DataPoint)dPoint3);
        tsFileWriter.write(tsRecord);
        tsFileWriter.flushAllChunkGroups();
        tsRecord = new TSRecord(1617206403002L, "root2.lemming.device2");
        dPoint2 = new IntDataPoint("sensor2", 22);
        tsRecord.addTuple((DataPoint)dPoint2);
        tsFileWriter.write(tsRecord);
        tsFileWriter.flushAllChunkGroups();
        tsRecord = new TSRecord(1617206403003L, "root2.lemming.device3");
        dPoint1 = new FloatDataPoint("sensor1", 33.1f);
        dPoint2 = new IntDataPoint("sensor2", 332);
        dPoint3 = new IntDataPoint("sensor3", 333);
        tsRecord.addTuple((DataPoint)dPoint1);
        tsRecord.addTuple((DataPoint)dPoint2);
        tsRecord.addTuple((DataPoint)dPoint3);
        tsFileWriter.write(tsRecord);
        tsFileWriter.flushAllChunkGroups();
        tsRecord = new TSRecord(1617206403004L, "root2.lemming.device3");
        dPoint1 = new FloatDataPoint("sensor1", 44.1f);
        dPoint2 = new IntDataPoint("sensor2", 442);
        dPoint3 = new IntDataPoint("sensor3", 443);
        tsRecord.addTuple((DataPoint)dPoint1);
        tsRecord.addTuple((DataPoint)dPoint2);
        tsRecord.addTuple((DataPoint)dPoint3);
        tsFileWriter.write(tsRecord);
        tsFileWriter.flushAllChunkGroups();
        tsFileWriter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void creatSeqModsFile(String modsFilePath) throws IllegalPathException {
        Modification[] modifications = new Modification[]{new Deletion(new PartialPath("root.lemming.device2.sensor2"), 2L, 1617206403002L), new Deletion(new PartialPath("root.lemming.device3.sensor1"), 3L, 1617206403003L, 1617206403009L)};
        try (ModificationFile mFile = new ModificationFile(modsFilePath);){
            for (Modification mod : modifications) {
                mFile.write(mod);
            }
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void creatUnSeqModsFile(String modsFilePath) throws IllegalPathException {
        Modification[] modifications = new Modification[]{new Deletion(new PartialPath("root2.lemming.device1.sensor1"), 2L, 1617206403001L), new Deletion(new PartialPath("root2.lemming.device2.*"), 3L, 2L, Long.MAX_VALUE), new Deletion(new PartialPath("root1.lemming.**"), 3L, 2L, Long.MAX_VALUE)};
        try (ModificationFile mFile = new ModificationFile(modsFilePath);){
            for (Modification mod : modifications) {
                mFile.write(mod);
            }
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test(timeout=10000L)
    public void testOpManager() throws IOException {
        PipeOpManager pipeOpManager = new PipeOpManager(null);
        String sgName1 = "root1";
        String sgName2 = "root2";
        TsFileOpBlock tsFileOpBlock1 = new TsFileOpBlock(sgName1, seqTsFileName1, 1L);
        pipeOpManager.appendOpBlock(sgName1, (AbstractOpBlock)tsFileOpBlock1);
        TsFileOpBlock tsFileOpBlock2 = new TsFileOpBlock(sgName2, unSeqTsFileName1, 2L);
        pipeOpManager.appendOpBlock(sgName2, (AbstractOpBlock)tsFileOpBlock2);
        long count1 = tsFileOpBlock1.getDataCount();
        Assert.assertEquals((long)8L, (long)count1);
        int i = 0;
        while ((long)i < count1) {
            Operation operation = pipeOpManager.getOperation(sgName1, (long)i, 8L);
            System.out.println("=== data" + i + ": " + operation + ", ");
            Assert.assertEquals((Object)"root1", (Object)operation.getStorageGroup());
            ++i;
        }
        Operation operation = pipeOpManager.getOperation(sgName1, 0L, 18L);
        InsertOperation insertOperation = (InsertOperation)operation;
        System.out.println("+++ data10: " + operation + ", ");
        Assert.assertEquals((Object)"root.lemming.device1.sensor1", (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)0)).left).toString());
        pipeOpManager.commitData(sgName1, count1 - 1L);
        operation = pipeOpManager.getOperation(sgName1, 9L, 18L);
        System.out.println("+++ data11: " + operation + ", ");
        Assert.assertNull((Object)operation);
        operation = pipeOpManager.getOperation(sgName2, 6L, 18L);
        System.out.println("+++ data12: " + operation + ", ");
        Assert.assertEquals((long)4L, (long)operation.getDataCount());
        insertOperation = (InsertOperation)operation;
        Assert.assertEquals((Object)"root2.lemming.device3.sensor3", (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)0)).left).toString());
        Assert.assertEquals((long)1617206403003L, (long)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)0)).right).get(0)).getTimestamp());
        Assert.assertEquals((Object)"333", (Object)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)0)).right).get(0)).getValue().toString());
    }

    @Test(timeout=10000L)
    public void testOpManager_Mods() throws IOException {
        PipeOpManager pipeOpManager = new PipeOpManager(null);
        String sgName1 = "root1";
        TsFileOpBlock tsFileOpBlock1 = new TsFileOpBlock(sgName1, seqTsFileName1, seqModsFileName1, 1L);
        pipeOpManager.appendOpBlock(sgName1, (AbstractOpBlock)tsFileOpBlock1);
        TsFileOpBlock tsFileOpBlock2 = new TsFileOpBlock(sgName1, unSeqTsFileName1, unSeqModsFileName1, 2L);
        pipeOpManager.appendOpBlock(sgName1, (AbstractOpBlock)tsFileOpBlock2);
        long count1 = tsFileOpBlock1.getDataCount();
        Assert.assertEquals((long)8L, (long)count1);
        for (int i = 0; i < 18; ++i) {
            Operation operation = pipeOpManager.getOperation(sgName1, (long)i, 8L);
            Assert.assertEquals((Object)sgName1, (Object)operation.getStorageGroup());
        }
        Operation operation = pipeOpManager.getOperation(sgName1, 0L, 18L);
        Assert.assertEquals((long)8L, (long)operation.getDataCount());
        InsertOperation insertOperation = (InsertOperation)operation;
        int i = 0;
        Assert.assertEquals((long)1617206403001L, (long)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i)).right).get(0)).getTimestamp());
        Assert.assertEquals((Object)"1.1", (Object)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i)).right).get(0)).getValue().toString());
        i = 1;
        Assert.assertEquals((long)1617206403001L, (long)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i)).right).get(0)).getTimestamp());
        Assert.assertEquals((Object)"12", (Object)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i)).right).get(0)).getValue().toString());
        i = 2;
        Assert.assertEquals((long)1617206403001L, (long)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i)).right).get(0)).getTimestamp());
        Assert.assertEquals((Object)"13", (Object)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i)).right).get(0)).getValue().toString());
        i = 3;
        Assert.assertEquals((long)1L, (long)((List)((Pair)insertOperation.getDataList().get((int)i)).right).size());
        Assert.assertNull(((List)((Pair)insertOperation.getDataList().get((int)i)).right).get(0));
        i = 4;
        Assert.assertEquals((long)1L, (long)((List)((Pair)insertOperation.getDataList().get((int)i)).right).size());
        Assert.assertNull(((List)((Pair)insertOperation.getDataList().get((int)i)).right).get(0));
        i = 5;
        Assert.assertEquals((long)1617206403003L, (long)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i)).right).get(0)).getTimestamp());
        Assert.assertEquals((Object)"32", (Object)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i)).right).get(0)).getValue().toString());
        i = 6;
        Assert.assertEquals((long)1L, (long)((List)((Pair)insertOperation.getDataList().get((int)i)).right).size());
        Assert.assertNull(((List)((Pair)insertOperation.getDataList().get((int)i)).right).get(0));
        i = 7;
        Assert.assertEquals((long)1617206403004L, (long)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i)).right).get(0)).getTimestamp());
        Assert.assertEquals((Object)"42", (Object)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i)).right).get(0)).getValue().toString());
        operation = pipeOpManager.getOperation(sgName1, 8L, 18L);
        Assert.assertEquals((long)10L, (long)operation.getDataCount());
        insertOperation = (InsertOperation)operation;
        i = 0;
        Assert.assertEquals((Object)"root2.lemming.device1.sensor1", (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)i)).left).toString());
        Assert.assertEquals((long)1L, (long)((List)((Pair)insertOperation.getDataList().get((int)i)).right).size());
        Assert.assertNull(((List)((Pair)insertOperation.getDataList().get((int)i)).right).get(0));
        i = 1;
        Assert.assertEquals((Object)"root2.lemming.device1.sensor2", (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)i)).left).getFullPath());
        Assert.assertEquals((long)1617206403001L, (long)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i)).right).get(0)).getTimestamp());
        Assert.assertEquals((Object)"12", (Object)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i)).right).get(0)).getValue().toString());
        i = 2;
        Assert.assertEquals((Object)"root2.lemming.device1.sensor3", (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)i)).left).getFullPath());
        Assert.assertEquals((long)1617206403001L, (long)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i)).right).get(0)).getTimestamp());
        Assert.assertEquals((Object)"13", (Object)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i)).right).get(0)).getValue().toString());
        i = 3;
        Assert.assertEquals((Object)"root2.lemming.device2.sensor2", (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)i)).left).getFullPath());
        Assert.assertEquals((long)1L, (long)((List)((Pair)insertOperation.getDataList().get((int)i)).right).size());
        Assert.assertNull(((List)((Pair)insertOperation.getDataList().get((int)i)).right).get(0));
        i = 4;
        Assert.assertEquals((Object)"root2.lemming.device3.sensor1", (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)i)).left).getFullPath());
        Assert.assertEquals((long)1617206403003L, (long)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i)).right).get(0)).getTimestamp());
        Assert.assertEquals((Object)"33.1", (Object)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i)).right).get(0)).getValue().toString());
        i = 5;
        Assert.assertEquals((Object)"root2.lemming.device3.sensor2", (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)i)).left).getFullPath());
        Assert.assertEquals((long)1617206403003L, (long)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i)).right).get(0)).getTimestamp());
        Assert.assertEquals((Object)"332", (Object)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i)).right).get(0)).getValue().toString());
        i = 6;
        Assert.assertEquals((Object)"root2.lemming.device3.sensor3", (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)i)).left).getFullPath());
        Assert.assertEquals((long)1617206403003L, (long)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i)).right).get(0)).getTimestamp());
        Assert.assertEquals((Object)"333", (Object)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i)).right).get(0)).getValue().toString());
        i = 7;
        Assert.assertEquals((Object)"root2.lemming.device3.sensor1", (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)i)).left).getFullPath());
        Assert.assertEquals((long)1617206403004L, (long)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i)).right).get(0)).getTimestamp());
        Assert.assertEquals((Object)"44.1", (Object)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i)).right).get(0)).getValue().toString());
        i = 8;
        Assert.assertEquals((Object)"root2.lemming.device3.sensor2", (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)i)).left).getFullPath());
        Assert.assertEquals((long)1617206403004L, (long)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i)).right).get(0)).getTimestamp());
        Assert.assertEquals((Object)"442", (Object)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i)).right).get(0)).getValue().toString());
        i = 9;
        Assert.assertEquals((Object)"root2.lemming.device3.sensor3", (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)i)).left).getFullPath());
        Assert.assertEquals((long)1617206403004L, (long)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i)).right).get(0)).getTimestamp());
        Assert.assertEquals((Object)"443", (Object)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i)).right).get(0)).getValue().toString());
    }

    @Test(timeout=10000L)
    public void testOpManager_deletion() throws IOException, IllegalPathException {
        PipeOpManager pipeOpManager = new PipeOpManager(null);
        String sgName1 = "root1";
        String sgName2 = "root2";
        TsFileOpBlock tsFileOpBlock1 = new TsFileOpBlock(sgName1, seqTsFileName1, seqModsFileName1, 1L);
        pipeOpManager.appendOpBlock(sgName1, (AbstractOpBlock)tsFileOpBlock1);
        TsFileOpBlock tsFileOpBlock2 = new TsFileOpBlock(sgName1, unSeqTsFileName1, unSeqModsFileName1, 2L);
        pipeOpManager.appendOpBlock(sgName2, (AbstractOpBlock)tsFileOpBlock2);
        pipeOpManager.commitData(sgName1, tsFileOpBlock1.getDataCount() - 1L);
        pipeOpManager.commitData(sgName2, tsFileOpBlock2.getDataCount() - 1L);
        Assert.assertTrue((boolean)pipeOpManager.isEmpty());
        PartialPath partialPath = new PartialPath("root.a.**");
        DeletionOpBlock deletionOpBlock = new DeletionOpBlock("root.a", partialPath, -100L, 200L, 5L);
        pipeOpManager.appendOpBlock(sgName1, (AbstractOpBlock)deletionOpBlock);
        long beginIndex = pipeOpManager.getFirstAvailableIndex(sgName1);
        Assert.assertEquals((long)8L, (long)beginIndex);
        Operation operation = pipeOpManager.getOperation(sgName1, beginIndex, 10L);
        Assert.assertEquals((long)beginIndex, (long)operation.getStartIndex());
        Assert.assertEquals((long)1L, (long)operation.getDataCount());
        DeleteOperation deleteOperation = (DeleteOperation)operation;
        Assert.assertNotNull((Object)deleteOperation);
        Assert.assertEquals((Object)partialPath, (Object)deleteOperation.getDeletePath());
        Assert.assertEquals((long)-100L, (long)deleteOperation.getStartTime());
        Assert.assertEquals((long)200L, (long)deleteOperation.getEndTime());
        String sgName = "root.a";
        Deletion deletion = new Deletion(partialPath, 0L, -200L, 400L);
        pipeOpManager.appendDeletionOpBlock(sgName, deletion, 4L);
        beginIndex = pipeOpManager.getFirstAvailableIndex(sgName);
        Assert.assertEquals((long)0L, (long)beginIndex);
        operation = pipeOpManager.getOperation(sgName, beginIndex, 10L);
        Assert.assertEquals((long)beginIndex, (long)operation.getStartIndex());
        Assert.assertEquals((long)1L, (long)operation.getDataCount());
        deleteOperation = (DeleteOperation)operation;
        Assert.assertNotNull((Object)deleteOperation);
        Assert.assertEquals((Object)partialPath, (Object)deleteOperation.getDeletePath());
        Assert.assertEquals((long)-200L, (long)deleteOperation.getStartTime());
        Assert.assertEquals((long)400L, (long)deleteOperation.getEndTime());
    }

    private static void createBigSeqTsfile(String tsfilePath, int seed, int maxPointNumInPage) throws Exception {
        File file = new File(tsfilePath);
        if (file.exists()) {
            file.delete();
        }
        if (maxPointNumInPage > 0) {
            TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(maxPointNumInPage);
        }
        Schema schema = new Schema();
        schema.extendTemplate(DEFAULT_TEMPLATE, new MeasurementSchema("sensor1", TSDataType.FLOAT, TSEncoding.RLE));
        schema.extendTemplate(DEFAULT_TEMPLATE, new MeasurementSchema("sensor2", TSDataType.INT32, TSEncoding.RLE));
        schema.extendTemplate(DEFAULT_TEMPLATE, new MeasurementSchema("sensor3", TSDataType.INT64, TSEncoding.RLE));
        TsFileWriter tsFileWriter = new TsFileWriter(file, schema);
        long ts = 1617206403000L;
        for (int i = 0; i < 1000; ++i) {
            TSRecord tsRecord;
            int k;
            int j;
            for (j = 0; j < 1000; ++j) {
                k = seed * 100000000 + i * 1000 + j;
                tsRecord = new TSRecord(++ts, "root.lemming.device1");
                tsRecord.addTuple((DataPoint)new FloatDataPoint("sensor1", (float)k * 1.3f));
                tsRecord.addTuple((DataPoint)new IntDataPoint("sensor2", k));
                tsRecord.addTuple((DataPoint)new LongDataPoint("sensor3", (long)(k * k)));
                tsFileWriter.write(tsRecord);
            }
            tsFileWriter.flushAllChunkGroups();
            for (j = 0; j < 1000; ++j) {
                k = seed * 100000000 + i * 2000 + j;
                tsRecord = new TSRecord(++ts, "root.lemming.device2");
                tsRecord.addTuple((DataPoint)new IntDataPoint("sensor2", k));
                tsFileWriter.write(tsRecord);
            }
            tsFileWriter.flushAllChunkGroups();
            for (j = 0; j < 1000; ++j) {
                k = seed * 100000000 + i * 3000 + j;
                tsRecord = new TSRecord(++ts, "root.lemming.device3");
                tsRecord.addTuple((DataPoint)new FloatDataPoint("sensor1", (float)k * 1.3f));
                tsRecord.addTuple((DataPoint)new IntDataPoint("sensor2", k));
                tsFileWriter.write(tsRecord);
            }
            tsFileWriter.flushAllChunkGroups();
        }
        tsFileWriter.close();
    }

    @Test
    public void testManyBigTsfiles() throws IOException {
        long count;
        Operation operation;
        PipeOpManager pipeOpManager = new PipeOpManager(null);
        String sgName1 = "root.test1";
        pipeOpManager.appendOpBlock(sgName1, (AbstractOpBlock)new TsFileOpBlock(sgName1, bigSeqTsFileName1, 1L));
        pipeOpManager.appendOpBlock(sgName1, (AbstractOpBlock)new TsFileOpBlock(sgName1, bigSeqTsFileName2, 2L));
        pipeOpManager.appendOpBlock(sgName1, (AbstractOpBlock)new TsFileOpBlock(sgName1, bigSeqTsFileName3, 3L));
        long idx = pipeOpManager.getFirstAvailableIndex(sgName1);
        long sum = 0L;
        int bulkSize = 1000;
        while (true) {
            if ((operation = pipeOpManager.getOperation(sgName1, idx, (long)bulkSize)) == null) {
                System.out.println("operation == null, idx=" + idx + " length=" + bulkSize);
                Assert.assertEquals((long)18000000L, (long)idx);
                break;
            }
            count = operation.getDataCount();
            if (count == 0L) break;
            sum += count;
            pipeOpManager.commitData(sgName1, (idx += count) - 1L);
        }
        Assert.assertEquals((long)18000000L, (long)sum);
        bulkSize = 777;
        while (true) {
            if ((operation = pipeOpManager.getOperation(sgName1, idx, (long)bulkSize)) == null) {
                System.out.println("operation == null, idx=" + idx + " length=" + bulkSize);
                Assert.assertEquals((long)18000000L, (long)idx);
                break;
            }
            count = operation.getDataCount();
            if (count == 0L) break;
            sum += count;
            pipeOpManager.commitData(sgName1, (idx += count) - 1L);
        }
        Assert.assertEquals((long)18000000L, (long)sum);
    }
}

