/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.datasource;

import java.io.IOException;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.sync.datasource.DeletionOpBlock;
import org.apache.iotdb.db.sync.externalpipe.operation.DeleteOperation;
import org.apache.iotdb.db.sync.externalpipe.operation.Operation;
import org.junit.Assert;
import org.junit.Test;

public class DeletionOpBlockTest {
    @Test
    public void TstDeletionOpBlock() throws IOException, IllegalPathException {
        PartialPath partialPath = new PartialPath("root.a.b.**");
        DeletionOpBlock deletionOpBlock = new DeletionOpBlock("delete", partialPath, -111L, 222L, 5L);
        deletionOpBlock.setBeginIndex(101L);
        System.out.println(deletionOpBlock);
        Operation operation = deletionOpBlock.getOperation(0L, 5L);
        Assert.assertNull((Object)operation);
        operation = deletionOpBlock.getOperation(101L, 5L);
        DeleteOperation deleteOperation = (DeleteOperation)operation;
        Assert.assertEquals((long)101L, (long)deleteOperation.getStartIndex());
        Assert.assertEquals((long)102L, (long)deleteOperation.getEndIndex());
        Assert.assertEquals((long)1L, (long)deleteOperation.getDataCount());
        Assert.assertEquals((long)-111L, (long)deleteOperation.getStartTime());
        Assert.assertEquals((long)222L, (long)deleteOperation.getEndTime());
        Assert.assertEquals((Object)partialPath, (Object)deleteOperation.getDeletePath());
        Assert.assertEquals((Object)Operation.OperationType.DELETE, (Object)deleteOperation.getOperationType());
        Assert.assertEquals((Object)"DELETE", (Object)deleteOperation.getOperationTypeName());
    }
}

