/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.datasource;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.iotdb.db.sync.datasource.DeletionGroup;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class DeletionGroupTest {
    private static DeletionGroup deletionGroup1;
    private static DeletionGroup deletionGroup2;

    @BeforeClass
    public static void prepareData() {
        deletionGroup1 = new DeletionGroup();
        deletionGroup1.addDelInterval(10L, 30L);
        deletionGroup1.addDelInterval(20L, 40L);
        deletionGroup1.addDelInterval(150L, 200L);
        deletionGroup1.addDelInterval(150L, 200L);
        deletionGroup1.addDelInterval(50L, 50L);
        deletionGroup1.addDelInterval(50L, 50L);
        deletionGroup1.addDelInterval(220L, 300L);
        deletionGroup1.addDelInterval(250L, 290L);
        deletionGroup1.addDelInterval(70L, 110L);
        deletionGroup1.addDelInterval(70L, 80L);
        deletionGroup1.addDelInterval(80L, 90L);
        deletionGroup1.addDelInterval(100L, 120L);
        deletionGroup2 = new DeletionGroup();
    }

    @Test
    public void testAddDelInterval() {
        boolean hasException = false;
        try {
            deletionGroup1.addDelInterval(10L, 5L);
        }
        catch (IllegalArgumentException e) {
            hasException = true;
        }
        Assert.assertTrue((boolean)hasException);
        TreeMap delIntervalMap = deletionGroup1.getDelIntervalMap();
        Iterator iter1 = delIntervalMap.entrySet().iterator();
        Map.Entry entry1 = iter1.next();
        Assert.assertEquals((long)10L, (long)((Long)entry1.getKey()));
        Assert.assertEquals((long)40L, (long)((Long)entry1.getValue()));
        entry1 = iter1.next();
        Assert.assertEquals((long)50L, (long)((Long)entry1.getKey()));
        Assert.assertEquals((long)50L, (long)((Long)entry1.getValue()));
        entry1 = iter1.next();
        Assert.assertEquals((long)70L, (long)((Long)entry1.getKey()));
        Assert.assertEquals((long)120L, (long)((Long)entry1.getValue()));
        entry1 = iter1.next();
        Assert.assertEquals((long)150L, (long)((Long)entry1.getKey()));
        Assert.assertEquals((long)200L, (long)((Long)entry1.getValue()));
        entry1 = iter1.next();
        Assert.assertEquals((long)220L, (long)((Long)entry1.getKey()));
        Assert.assertEquals((long)300L, (long)((Long)entry1.getValue()));
    }

    @Test
    public void testCheckDeletedState() {
        boolean hasException = false;
        try {
            deletionGroup1.checkDeletedState(5L, 1L);
        }
        catch (IllegalArgumentException e) {
            hasException = true;
        }
        Assert.assertTrue((boolean)hasException);
        Assert.assertEquals((Object)DeletionGroup.DeletedType.NO_DELETED, (Object)deletionGroup1.checkDeletedState(1L, 5L));
        Assert.assertEquals((Object)DeletionGroup.DeletedType.PARTIAL_DELETED, (Object)deletionGroup1.checkDeletedState(1L, 10L));
        Assert.assertEquals((Object)DeletionGroup.DeletedType.PARTIAL_DELETED, (Object)deletionGroup1.checkDeletedState(2L, 15L));
        Assert.assertEquals((Object)DeletionGroup.DeletedType.FULL_DELETED, (Object)deletionGroup1.checkDeletedState(10L, 10L));
        Assert.assertEquals((Object)DeletionGroup.DeletedType.FULL_DELETED, (Object)deletionGroup1.checkDeletedState(10L, 20L));
        Assert.assertEquals((Object)DeletionGroup.DeletedType.FULL_DELETED, (Object)deletionGroup1.checkDeletedState(30L, 40L));
        Assert.assertEquals((Object)DeletionGroup.DeletedType.FULL_DELETED, (Object)deletionGroup1.checkDeletedState(10L, 40L));
        Assert.assertEquals((Object)DeletionGroup.DeletedType.FULL_DELETED, (Object)deletionGroup1.checkDeletedState(40L, 40L));
        Assert.assertEquals((Object)DeletionGroup.DeletedType.PARTIAL_DELETED, (Object)deletionGroup1.checkDeletedState(35L, 45L));
        Assert.assertEquals((Object)DeletionGroup.DeletedType.PARTIAL_DELETED, (Object)deletionGroup1.checkDeletedState(40L, 45L));
        Assert.assertEquals((Object)DeletionGroup.DeletedType.FULL_DELETED, (Object)deletionGroup1.checkDeletedState(50L, 50L));
        Assert.assertEquals((Object)DeletionGroup.DeletedType.PARTIAL_DELETED, (Object)deletionGroup1.checkDeletedState(45L, 50L));
        Assert.assertEquals((Object)DeletionGroup.DeletedType.PARTIAL_DELETED, (Object)deletionGroup1.checkDeletedState(50L, 55L));
        Assert.assertEquals((Object)DeletionGroup.DeletedType.PARTIAL_DELETED, (Object)deletionGroup1.checkDeletedState(45L, 55L));
        Assert.assertEquals((Object)DeletionGroup.DeletedType.PARTIAL_DELETED, (Object)deletionGroup1.checkDeletedState(5L, 55L));
        Assert.assertEquals((Object)DeletionGroup.DeletedType.PARTIAL_DELETED, (Object)deletionGroup1.checkDeletedState(5L, 500L));
        Assert.assertEquals((Object)DeletionGroup.DeletedType.PARTIAL_DELETED, (Object)deletionGroup1.checkDeletedState(120L, 140L));
        Assert.assertEquals((Object)DeletionGroup.DeletedType.PARTIAL_DELETED, (Object)deletionGroup1.checkDeletedState(120L, 150L));
        Assert.assertEquals((Object)DeletionGroup.DeletedType.NO_DELETED, (Object)deletionGroup1.checkDeletedState(201L, 201L));
        Assert.assertEquals((Object)DeletionGroup.DeletedType.NO_DELETED, (Object)deletionGroup1.checkDeletedState(400L, 500L));
        Assert.assertEquals((Object)DeletionGroup.DeletedType.NO_DELETED, (Object)deletionGroup1.checkDeletedState(201L, 219L));
        Assert.assertEquals((Object)DeletionGroup.DeletedType.PARTIAL_DELETED, (Object)deletionGroup1.checkDeletedState(201L, 220L));
        Assert.assertEquals((Object)DeletionGroup.DeletedType.FULL_DELETED, (Object)deletionGroup1.checkDeletedState(220L, 220L));
        Assert.assertEquals((Object)DeletionGroup.DeletedType.FULL_DELETED, (Object)deletionGroup1.checkDeletedState(220L, 230L));
        Assert.assertEquals((Object)DeletionGroup.DeletedType.FULL_DELETED, (Object)deletionGroup1.checkDeletedState(230L, 250L));
        Assert.assertEquals((Object)DeletionGroup.DeletedType.FULL_DELETED, (Object)deletionGroup1.checkDeletedState(250L, 300L));
        Assert.assertEquals((Object)DeletionGroup.DeletedType.FULL_DELETED, (Object)deletionGroup1.checkDeletedState(220L, 300L));
        Assert.assertEquals((Object)DeletionGroup.DeletedType.PARTIAL_DELETED, (Object)deletionGroup1.checkDeletedState(220L, 330L));
        Assert.assertEquals((Object)DeletionGroup.DeletedType.PARTIAL_DELETED, (Object)deletionGroup1.checkDeletedState(240L, 350L));
        Assert.assertEquals((Object)DeletionGroup.DeletedType.NO_DELETED, (Object)deletionGroup2.checkDeletedState(1L, 500L));
    }

    @Test
    public void testIsDeleted() {
        Assert.assertEquals((Object)false, (Object)deletionGroup1.isDeleted(5L));
        Assert.assertEquals((Object)true, (Object)deletionGroup1.isDeleted(10L));
        Assert.assertEquals((Object)true, (Object)deletionGroup1.isDeleted(20L));
        Assert.assertEquals((Object)true, (Object)deletionGroup1.isDeleted(40L));
        Assert.assertEquals((Object)false, (Object)deletionGroup1.isDeleted(45L));
        Assert.assertEquals((Object)true, (Object)deletionGroup1.isDeleted(50L));
        Assert.assertEquals((Object)false, (Object)deletionGroup1.isDeleted(60L));
        Assert.assertEquals((Object)true, (Object)deletionGroup1.isDeleted(70L));
        Assert.assertEquals((Object)true, (Object)deletionGroup1.isDeleted(100L));
        Assert.assertEquals((Object)true, (Object)deletionGroup1.isDeleted(120L));
        Assert.assertEquals((Object)false, (Object)deletionGroup1.isDeleted(122L));
        Assert.assertEquals((Object)true, (Object)deletionGroup1.isDeleted(220L));
        Assert.assertEquals((Object)true, (Object)deletionGroup1.isDeleted(250L));
        Assert.assertEquals((Object)true, (Object)deletionGroup1.isDeleted(300L));
        Assert.assertEquals((Object)false, (Object)deletionGroup1.isDeleted(400L));
        Assert.assertEquals((Object)false, (Object)deletionGroup2.isDeleted(100L));
    }

    @Test
    public void testIsDeleted2() {
        DeletionGroup.IntervalCursor intervalCursor = new DeletionGroup.IntervalCursor();
        Assert.assertEquals((Object)false, (Object)deletionGroup1.isDeleted(1L, intervalCursor));
        Assert.assertEquals((Object)false, (Object)deletionGroup1.isDeleted(5L, intervalCursor));
        Assert.assertEquals((Object)true, (Object)deletionGroup1.isDeleted(10L, intervalCursor));
        Assert.assertEquals((Object)true, (Object)deletionGroup1.isDeleted(20L, intervalCursor));
        Assert.assertEquals((Object)true, (Object)deletionGroup1.isDeleted(40L, intervalCursor));
        Assert.assertEquals((Object)false, (Object)deletionGroup1.isDeleted(45L, intervalCursor));
        Assert.assertEquals((Object)true, (Object)deletionGroup1.isDeleted(50L, intervalCursor));
        Assert.assertEquals((Object)false, (Object)deletionGroup1.isDeleted(55L, intervalCursor));
        Assert.assertEquals((Object)true, (Object)deletionGroup1.isDeleted(70L, intervalCursor));
        Assert.assertEquals((Object)true, (Object)deletionGroup1.isDeleted(100L, intervalCursor));
        Assert.assertEquals((Object)true, (Object)deletionGroup1.isDeleted(120L, intervalCursor));
        Assert.assertEquals((Object)false, (Object)deletionGroup1.isDeleted(125L, intervalCursor));
        Assert.assertEquals((Object)true, (Object)deletionGroup1.isDeleted(300L, intervalCursor));
        Assert.assertEquals((Object)false, (Object)deletionGroup1.isDeleted(301L, intervalCursor));
        intervalCursor = new DeletionGroup.IntervalCursor();
        Assert.assertEquals((Object)true, (Object)deletionGroup1.isDeleted(10L, intervalCursor));
        Assert.assertEquals((Object)true, (Object)deletionGroup1.isDeleted(20L, intervalCursor));
        Assert.assertEquals((Object)true, (Object)deletionGroup1.isDeleted(40L, intervalCursor));
        Assert.assertEquals((Object)false, (Object)deletionGroup1.isDeleted(45L, intervalCursor));
        Assert.assertEquals((Object)true, (Object)deletionGroup1.isDeleted(50L, intervalCursor));
        Assert.assertEquals((Object)false, (Object)deletionGroup1.isDeleted(55L, intervalCursor));
        Assert.assertEquals((Object)true, (Object)deletionGroup1.isDeleted(70L, intervalCursor));
        Assert.assertEquals((Object)true, (Object)deletionGroup1.isDeleted(100L, intervalCursor));
        Assert.assertEquals((Object)true, (Object)deletionGroup1.isDeleted(120L, intervalCursor));
        Assert.assertEquals((Object)false, (Object)deletionGroup1.isDeleted(125L, intervalCursor));
        Assert.assertEquals((Object)true, (Object)deletionGroup1.isDeleted(300L, intervalCursor));
        Assert.assertEquals((Object)false, (Object)deletionGroup1.isDeleted(301L, intervalCursor));
        intervalCursor.reset();
        Assert.assertEquals((Object)true, (Object)deletionGroup1.isDeleted(50L, intervalCursor));
        Assert.assertEquals((Object)false, (Object)deletionGroup1.isDeleted(55L, intervalCursor));
        Assert.assertEquals((Object)true, (Object)deletionGroup1.isDeleted(70L, intervalCursor));
        Assert.assertEquals((Object)true, (Object)deletionGroup1.isDeleted(100L, intervalCursor));
        Assert.assertEquals((Object)true, (Object)deletionGroup1.isDeleted(120L, intervalCursor));
        Assert.assertEquals((Object)false, (Object)deletionGroup1.isDeleted(125L, intervalCursor));
        Assert.assertEquals((Object)true, (Object)deletionGroup1.isDeleted(300L, intervalCursor));
        Assert.assertEquals((Object)false, (Object)deletionGroup1.isDeleted(301L, intervalCursor));
        intervalCursor.reset();
        Assert.assertEquals((Object)false, (Object)deletionGroup1.isDeleted(301L, intervalCursor));
        intervalCursor = new DeletionGroup.IntervalCursor();
        Assert.assertEquals((Object)false, (Object)deletionGroup2.isDeleted(301L, intervalCursor));
    }
}

