/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.consensus.SchemaRegionId;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.consensus.common.Peer;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.consensus.DataRegionConsensusImpl;
import org.apache.iotdb.db.consensus.SchemaRegionConsensusImpl;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.localconfignode.LocalConfigNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.write.CreateAlignedTimeSeriesNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.write.CreateMultiTimeSeriesNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.write.CreateTimeSeriesNode;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.service.thrift.impl.DataNodeInternalRPCServiceImpl;
import org.apache.iotdb.db.service.thrift.impl.DataNodeRegionManager;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.mpp.rpc.thrift.TPlanNode;
import org.apache.iotdb.mpp.rpc.thrift.TSendPlanNodeReq;
import org.apache.iotdb.mpp.rpc.thrift.TSendPlanNodeResp;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.ratis.util.FileUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class DataNodeInternalRPCServiceImplTest {
    private static final IoTDBConfig conf = IoTDBDescriptor.getInstance().getConfig();
    DataNodeInternalRPCServiceImpl dataNodeInternalRPCServiceImpl;
    static LocalConfigNode configNode;
    private static final int dataNodeId = 0;

    @BeforeClass
    public static void setUpBeforeClass() throws IOException, MetadataException {
        conf.setDataNodeId(0);
        IoTDB.configManager.init();
        configNode = LocalConfigNode.getInstance();
        configNode.getBelongedSchemaRegionIdWithAutoCreate(new PartialPath("root.ln"));
        DataRegionConsensusImpl.setupAndGetInstance().start();
        SchemaRegionConsensusImpl.setupAndGetInstance().start();
        DataNodeRegionManager.getInstance().init();
    }

    @Before
    public void setUp() throws Exception {
        TRegionReplicaSet regionReplicaSet = this.genRegionReplicaSet();
        SchemaRegionConsensusImpl.getInstance().createPeer(ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)regionReplicaSet.getRegionId()), this.genSchemaRegionPeerList(regionReplicaSet));
        this.dataNodeInternalRPCServiceImpl = new DataNodeInternalRPCServiceImpl();
    }

    @After
    public void tearDown() throws Exception {
        TRegionReplicaSet regionReplicaSet = this.genRegionReplicaSet();
        SchemaRegionConsensusImpl.getInstance().deletePeer(ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)regionReplicaSet.getRegionId()));
        FileUtils.deleteFully((File)new File(conf.getConsensusDir()));
    }

    @AfterClass
    public static void tearDownAfterClass() throws IOException, StorageEngineException {
        DataNodeRegionManager.getInstance().clear();
        DataRegionConsensusImpl.getInstance().stop();
        SchemaRegionConsensusImpl.getInstance().stop();
        IoTDB.configManager.clear();
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void testCreateTimeseries() throws MetadataException {
        CreateTimeSeriesNode createTimeSeriesNode = new CreateTimeSeriesNode(new PlanNodeId("0"), new PartialPath("root.ln.wf01.wt01.status"), TSDataType.BOOLEAN, TSEncoding.PLAIN, CompressionType.SNAPPY, (Map)new HashMap<String, String>(){
            {
                this.put("MAX_POINT_NUMBER", "3");
            }
        }, (Map)new HashMap<String, String>(){
            {
                this.put("tag1", "v1");
                this.put("tag2", "v2");
            }
        }, (Map)new HashMap<String, String>(){
            {
                this.put("attr1", "a1");
                this.put("attr2", "a2");
            }
        }, "meter1");
        TRegionReplicaSet regionReplicaSet = this.genRegionReplicaSet();
        ByteBuffer byteBuffer = createTimeSeriesNode.serializeToByteBuffer();
        TSendPlanNodeReq request = new TSendPlanNodeReq();
        TPlanNode tPlanNode = new TPlanNode();
        tPlanNode.setBody(byteBuffer);
        request.setPlanNode(tPlanNode);
        request.setConsensusGroupId(regionReplicaSet.getRegionId());
        TSendPlanNodeResp response = this.dataNodeInternalRPCServiceImpl.sendPlanNode(request);
        Assert.assertTrue((boolean)response.accepted);
    }

    @Test
    public void testCreateAlignedTimeseries() throws MetadataException {
        CreateAlignedTimeSeriesNode createAlignedTimeSeriesNode = new CreateAlignedTimeSeriesNode(new PlanNodeId("0"), new PartialPath("root.ln.wf01.GPS"), (List)new ArrayList<String>(){
            {
                this.add("latitude");
                this.add("longitude");
            }
        }, (List)new ArrayList<TSDataType>(){
            {
                this.add(TSDataType.FLOAT);
                this.add(TSDataType.FLOAT);
            }
        }, (List)new ArrayList<TSEncoding>(){
            {
                this.add(TSEncoding.PLAIN);
                this.add(TSEncoding.PLAIN);
            }
        }, (List)new ArrayList<CompressionType>(){
            {
                this.add(CompressionType.SNAPPY);
                this.add(CompressionType.SNAPPY);
            }
        }, (List)new ArrayList<String>(){
            {
                this.add("meter1");
                this.add(null);
            }
        }, (List)new ArrayList<Map<String, String>>(){
            {
                this.add(new HashMap<String, String>(){
                    {
                        this.put("tag1", "t1");
                    }
                });
                this.add(null);
            }
        }, (List)new ArrayList<Map<String, String>>(){
            {
                this.add(new HashMap<String, String>(){
                    {
                        this.put("tag1", "t1");
                    }
                });
                this.add(null);
            }
        });
        TRegionReplicaSet regionReplicaSet = this.genRegionReplicaSet();
        ByteBuffer byteBuffer = createAlignedTimeSeriesNode.serializeToByteBuffer();
        TSendPlanNodeReq request = new TSendPlanNodeReq();
        TPlanNode tPlanNode = new TPlanNode();
        tPlanNode.setBody(byteBuffer);
        request.setPlanNode(tPlanNode);
        request.setConsensusGroupId(regionReplicaSet.getRegionId());
        TSendPlanNodeResp response = this.dataNodeInternalRPCServiceImpl.sendPlanNode(request);
        Assert.assertTrue((boolean)response.accepted);
    }

    @Test
    public void testCreateMultiTimeSeries() throws MetadataException {
        CreateMultiTimeSeriesNode createMultiTimeSeriesNode = new CreateMultiTimeSeriesNode(new PlanNodeId("0"), (List)new ArrayList<PartialPath>(){
            {
                this.add(new PartialPath("root.ln.d3.s1"));
                this.add(new PartialPath("root.ln.d3.s2"));
            }
        }, (List)new ArrayList<TSDataType>(){
            {
                this.add(TSDataType.FLOAT);
                this.add(TSDataType.FLOAT);
            }
        }, (List)new ArrayList<TSEncoding>(){
            {
                this.add(TSEncoding.PLAIN);
                this.add(TSEncoding.PLAIN);
            }
        }, (List)new ArrayList<CompressionType>(){
            {
                this.add(CompressionType.SNAPPY);
                this.add(CompressionType.SNAPPY);
            }
        }, (List)new ArrayList<Map<String, String>>(){
            {
                this.add(new HashMap<String, String>(){
                    {
                        this.put("MAX_POINT_NUMBER", "3");
                    }
                });
                this.add(null);
            }
        }, (List)new ArrayList<String>(){
            {
                this.add("meter1");
                this.add(null);
            }
        }, (List)new ArrayList<Map<String, String>>(){
            {
                this.add(new HashMap<String, String>(){
                    {
                        this.put("tag1", "t1");
                    }
                });
                this.add(null);
            }
        }, (List)new ArrayList<Map<String, String>>(){
            {
                this.add(new HashMap<String, String>(){
                    {
                        this.put("tag1", "t1");
                    }
                });
                this.add(null);
            }
        });
        TRegionReplicaSet regionReplicaSet = this.genRegionReplicaSet();
        ByteBuffer byteBuffer = createMultiTimeSeriesNode.serializeToByteBuffer();
        TSendPlanNodeReq request = new TSendPlanNodeReq();
        TPlanNode tPlanNode = new TPlanNode();
        tPlanNode.setBody(byteBuffer);
        request.setPlanNode(tPlanNode);
        request.setConsensusGroupId(regionReplicaSet.getRegionId());
        TSendPlanNodeResp response = this.dataNodeInternalRPCServiceImpl.sendPlanNode(request);
        Assert.assertTrue((boolean)response.accepted);
    }

    private TRegionReplicaSet genRegionReplicaSet() {
        ArrayList<TDataNodeLocation> dataNodeList = new ArrayList<TDataNodeLocation>();
        dataNodeList.add(new TDataNodeLocation().setClientRpcEndPoint(new TEndPoint(conf.getRpcAddress(), conf.getRpcPort())).setInternalEndPoint(new TEndPoint(conf.getInternalAddress(), conf.getInternalPort())).setMPPDataExchangeEndPoint(new TEndPoint(conf.getInternalAddress(), conf.getMppDataExchangePort())).setDataRegionConsensusEndPoint(new TEndPoint(conf.getInternalAddress(), conf.getDataRegionConsensusPort())).setSchemaRegionConsensusEndPoint(new TEndPoint(conf.getInternalAddress(), conf.getSchemaRegionConsensusPort())));
        return new TRegionReplicaSet(new TConsensusGroupId(TConsensusGroupType.SchemaRegion, conf.getDataNodeId()), dataNodeList);
    }

    private List<Peer> genSchemaRegionPeerList(TRegionReplicaSet regionReplicaSet) {
        ArrayList<Peer> peerList = new ArrayList<Peer>();
        for (TDataNodeLocation node : regionReplicaSet.getDataNodeLocations()) {
            peerList.add(new Peer((ConsensusGroupId)new SchemaRegionId(regionReplicaSet.getRegionId().getId()), node.getDataNodeId(), node.getSchemaRegionConsensusEndPoint()));
        }
        return peerList;
    }
}

