/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.rescon;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.engine.cache.ChunkCache;
import org.apache.iotdb.db.engine.cache.TimeSeriesMetadataCache;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResourceStatus;
import org.apache.iotdb.db.engine.storagegroup.timeindex.TimeIndexLevel;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.query.control.FileReaderManager;
import org.apache.iotdb.db.rescon.TsFileResourceManager;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.write.TsFileWriter;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ResourceManagerTest {
    static final String RESOURCE_MANAGER_TEST_SG = "root.resourceManagerTest";
    private int seqFileNum = 10;
    private int measurementNum = 10;
    int deviceNum = 10;
    long ptNum = 100L;
    long flushInterval = 20L;
    TSEncoding encoding = TSEncoding.PLAIN;
    String[] deviceIds;
    MeasurementSchema[] measurementSchemas;
    List<TsFileResource> seqResources = new ArrayList<TsFileResource>();
    List<TsFileResource> unseqResources = new ArrayList<TsFileResource>();
    private static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private final TsFileResourceManager tsFileResourceManager = TsFileResourceManager.getInstance();
    private long prevTimeIndexMemoryThreshold;
    private TimeIndexLevel timeIndexLevel;

    @Before
    public void setUp() throws IOException, WriteProcessException, MetadataException {
        IoTDB.configManager.init();
        this.prevTimeIndexMemoryThreshold = CONFIG.getAllocateMemoryForTimeIndex();
        this.timeIndexLevel = CONFIG.getTimeIndexLevel();
        this.prepareSeries();
    }

    @After
    public void tearDown() throws IOException, StorageEngineException {
        this.removeFiles();
        this.seqResources.clear();
        this.unseqResources.clear();
        CONFIG.setTimeIndexLevel(String.valueOf(this.timeIndexLevel));
        this.tsFileResourceManager.setTimeIndexMemoryThreshold((double)this.prevTimeIndexMemoryThreshold);
        ChunkCache.getInstance().clear();
        TimeSeriesMetadataCache.getInstance().clear();
        IoTDB.configManager.clear();
        TsFileResourceManager.getInstance().clear();
        EnvironmentUtils.cleanAllDir();
    }

    void prepareSeries() throws MetadataException {
        int i;
        this.measurementSchemas = new MeasurementSchema[this.measurementNum];
        for (i = 0; i < this.measurementNum; ++i) {
            this.measurementSchemas[i] = new MeasurementSchema("sensor" + i, TSDataType.DOUBLE, this.encoding, CompressionType.UNCOMPRESSED);
        }
        this.deviceIds = new String[this.deviceNum];
        for (i = 0; i < this.deviceNum; ++i) {
            this.deviceIds[i] = "root.resourceManagerTest.device" + i;
        }
        IoTDB.schemaProcessor.setStorageGroup(new PartialPath(RESOURCE_MANAGER_TEST_SG));
        for (String device : this.deviceIds) {
            for (MeasurementSchema measurementSchema : this.measurementSchemas) {
                PartialPath devicePath = new PartialPath(device);
                IoTDB.schemaProcessor.createTimeseries(devicePath.concatNode(measurementSchema.getMeasurementId()), measurementSchema.getType(), measurementSchema.getEncodingType(), measurementSchema.getCompressor(), Collections.emptyMap());
            }
        }
    }

    private void removeFiles() throws IOException {
        File[] resourceFiles;
        TsFileResource files;
        for (TsFileResource tsFileResource : this.seqResources) {
            if (!tsFileResource.getTsFile().exists()) continue;
            tsFileResource.remove();
        }
        for (TsFileResource tsFileResource : this.unseqResources) {
            if (!tsFileResource.getTsFile().exists()) continue;
            tsFileResource.remove();
        }
        for (File file : files = FSFactoryProducer.getFSFactory().listFilesBySuffix("target", ".tsfile")) {
            file.delete();
        }
        for (File resourceFile : resourceFiles = FSFactoryProducer.getFSFactory().listFilesBySuffix("target", ".resource")) {
            resourceFile.delete();
        }
        FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
    }

    void prepareFile(TsFileResource tsFileResource, long timeOffset, long ptNum, long valueOffset) throws IOException, WriteProcessException {
        TsFileWriter fileWriter = new TsFileWriter(tsFileResource.getTsFile());
        for (String deviceId : this.deviceIds) {
            for (MeasurementSchema measurementSchema : this.measurementSchemas) {
                fileWriter.registerTimeseries(new Path(deviceId), measurementSchema);
            }
        }
        for (long i = timeOffset; i < timeOffset + ptNum; ++i) {
            for (int j = 0; j < this.deviceNum; ++j) {
                TSRecord record = new TSRecord(i, this.deviceIds[j]);
                for (int k = 0; k < this.measurementNum; ++k) {
                    record.addTuple(DataPoint.getDataPoint((TSDataType)this.measurementSchemas[k].getType(), (String)this.measurementSchemas[k].getMeasurementId(), (String)String.valueOf(i + valueOffset)));
                }
                fileWriter.write(record);
                tsFileResource.updateStartTime(this.deviceIds[j], i);
                tsFileResource.updateEndTime(this.deviceIds[j], i);
            }
            if ((i + 1L) % this.flushInterval != 0L) continue;
            fileWriter.flushAllChunkGroups();
        }
        fileWriter.close();
    }

    @Test
    public void testDegradeMethod() throws IOException, WriteProcessException {
        File file = new File(TestConstant.BASE_OUTPUT_PATH.concat("0-0-0-0.tsfile"));
        TsFileResource tsFileResource = new TsFileResource(file);
        tsFileResource.setStatus(TsFileResourceStatus.CLOSED);
        tsFileResource.updatePlanIndexes(0L);
        this.prepareFile(tsFileResource, 0L, this.ptNum, 0L);
        long previousRamSize = tsFileResource.calculateRamSize();
        Assert.assertEquals((Object)TimeIndexLevel.DEVICE_TIME_INDEX, (Object)TimeIndexLevel.valueOf((int)tsFileResource.getTimeIndexType()));
        long reducedMemory = tsFileResource.degradeTimeIndex();
        Assert.assertEquals((long)(previousRamSize - tsFileResource.calculateRamSize()), (long)reducedMemory);
        Assert.assertEquals((Object)TimeIndexLevel.FILE_TIME_INDEX, (Object)TimeIndexLevel.valueOf((int)tsFileResource.getTimeIndexType()));
    }

    @Test
    public void testDegradeToFileTimeIndex() throws IOException, WriteProcessException {
        File file = new File(TestConstant.BASE_OUTPUT_PATH.concat("0-0-0-0.tsfile"));
        TsFileResource tsFileResource = new TsFileResource(file);
        tsFileResource.setStatus(TsFileResourceStatus.CLOSED);
        tsFileResource.updatePlanIndexes(0L);
        this.prepareFile(tsFileResource, 0L, this.ptNum, 0L);
        Assert.assertEquals((Object)TimeIndexLevel.DEVICE_TIME_INDEX, (Object)TimeIndexLevel.valueOf((int)tsFileResource.getTimeIndexType()));
        double curTimeIndexMemoryThreshold = 322.0;
        this.tsFileResourceManager.setTimeIndexMemoryThreshold(curTimeIndexMemoryThreshold);
        this.tsFileResourceManager.registerSealedTsFileResource(tsFileResource);
        Assert.assertEquals((Object)TimeIndexLevel.FILE_TIME_INDEX, (Object)TimeIndexLevel.valueOf((int)tsFileResource.getTimeIndexType()));
    }

    @Test
    public void testNotDegradeToFileTimeIndex() throws IOException, WriteProcessException {
        File file = new File(TestConstant.BASE_OUTPUT_PATH.concat("0-0-0-0.tsfile"));
        TsFileResource tsFileResource = new TsFileResource(file);
        tsFileResource.setStatus(TsFileResourceStatus.CLOSED);
        tsFileResource.updatePlanIndexes(0L);
        this.prepareFile(tsFileResource, 0L, this.ptNum, 0L);
        Assert.assertEquals((Object)TimeIndexLevel.DEVICE_TIME_INDEX, (Object)TimeIndexLevel.valueOf((int)tsFileResource.getTimeIndexType()));
        long previousRamSize = tsFileResource.calculateRamSize();
        double curTimeIndexMemoryThreshold = 3221.0;
        this.tsFileResourceManager.setTimeIndexMemoryThreshold(curTimeIndexMemoryThreshold);
        this.tsFileResourceManager.registerSealedTsFileResource(tsFileResource);
        Assert.assertEquals((long)0L, (long)(previousRamSize - tsFileResource.calculateRamSize()));
        Assert.assertEquals((Object)TimeIndexLevel.DEVICE_TIME_INDEX, (Object)TimeIndexLevel.valueOf((int)tsFileResource.getTimeIndexType()));
    }

    @Test
    public void testTwoResourceToDegrade() throws IOException, WriteProcessException {
        File file1 = new File(TestConstant.BASE_OUTPUT_PATH.concat("0-0-0-0.tsfile"));
        TsFileResource tsFileResource1 = new TsFileResource(file1);
        tsFileResource1.setStatus(TsFileResourceStatus.CLOSED);
        tsFileResource1.updatePlanIndexes(0L);
        this.prepareFile(tsFileResource1, 0L, this.ptNum, 0L);
        Assert.assertEquals((Object)TimeIndexLevel.DEVICE_TIME_INDEX, (Object)TimeIndexLevel.valueOf((int)tsFileResource1.getTimeIndexType()));
        double curTimeIndexMemoryThreshold = 3221.0;
        this.tsFileResourceManager.setTimeIndexMemoryThreshold(curTimeIndexMemoryThreshold);
        this.tsFileResourceManager.registerSealedTsFileResource(tsFileResource1);
        Assert.assertEquals((Object)TimeIndexLevel.DEVICE_TIME_INDEX, (Object)TimeIndexLevel.valueOf((int)tsFileResource1.getTimeIndexType()));
        File file2 = new File(TestConstant.BASE_OUTPUT_PATH.concat("1-0-0-0.tsfile"));
        TsFileResource tsFileResource2 = new TsFileResource(file2);
        tsFileResource2.setStatus(TsFileResourceStatus.CLOSED);
        tsFileResource2.updatePlanIndexes(1L);
        this.prepareFile(tsFileResource2, this.ptNum, this.ptNum, 0L);
        Assert.assertEquals((Object)TimeIndexLevel.DEVICE_TIME_INDEX, (Object)TimeIndexLevel.valueOf((int)tsFileResource2.getTimeIndexType()));
        this.tsFileResourceManager.registerSealedTsFileResource(tsFileResource2);
        Assert.assertEquals((Object)TimeIndexLevel.FILE_TIME_INDEX, (Object)TimeIndexLevel.valueOf((int)tsFileResource1.getTimeIndexType()));
        Assert.assertEquals((Object)TimeIndexLevel.DEVICE_TIME_INDEX, (Object)TimeIndexLevel.valueOf((int)tsFileResource2.getTimeIndexType()));
    }

    @Test
    public void testMultiDeviceTimeIndexDegrade() throws IOException, WriteProcessException {
        int i;
        double curTimeIndexMemoryThreshold = 9663.7;
        this.tsFileResourceManager.setTimeIndexMemoryThreshold(curTimeIndexMemoryThreshold);
        for (i = 0; i < this.seqFileNum; ++i) {
            File file = new File(TestConstant.BASE_OUTPUT_PATH.concat(i + "-" + i + "-" + 0 + "-" + 0 + ".tsfile"));
            TsFileResource tsFileResource = new TsFileResource(file);
            tsFileResource.setStatus(TsFileResourceStatus.CLOSED);
            tsFileResource.updatePlanIndexes((long)i);
            Assert.assertEquals((Object)TimeIndexLevel.DEVICE_TIME_INDEX, (Object)TimeIndexLevel.valueOf((int)tsFileResource.getTimeIndexType()));
            this.seqResources.add(tsFileResource);
            this.prepareFile(tsFileResource, (long)i * this.ptNum, this.ptNum, 0L);
            this.tsFileResourceManager.registerSealedTsFileResource(tsFileResource);
        }
        Assert.assertEquals((long)10L, (long)this.tsFileResourceManager.getPriorityQueueSize());
        for (i = 0; i < this.seqFileNum; ++i) {
            if (i < 7) {
                Assert.assertEquals((Object)TimeIndexLevel.FILE_TIME_INDEX, (Object)TimeIndexLevel.valueOf((int)this.seqResources.get(i).getTimeIndexType()));
                continue;
            }
            Assert.assertEquals((Object)TimeIndexLevel.DEVICE_TIME_INDEX, (Object)TimeIndexLevel.valueOf((int)this.seqResources.get(i).getTimeIndexType()));
        }
    }

    @Test(expected=RuntimeException.class)
    public void testAllFileTimeIndexDegrade() throws IOException, WriteProcessException {
        long reducedMemory = 0L;
        double curTimeIndexMemoryThreshold = 322.0;
        this.tsFileResourceManager.setTimeIndexMemoryThreshold(curTimeIndexMemoryThreshold);
        try {
            for (int i = 0; i < this.seqFileNum; ++i) {
                File file = new File(TestConstant.BASE_OUTPUT_PATH.concat(i + "-" + i + "-" + 0 + "-" + 0 + ".tsfile"));
                TsFileResource tsFileResource = new TsFileResource(file);
                Assert.assertEquals((Object)TimeIndexLevel.DEVICE_TIME_INDEX, (Object)TimeIndexLevel.valueOf((int)tsFileResource.getTimeIndexType()));
                this.seqResources.add(tsFileResource);
                long previousRamSize = tsFileResource.calculateRamSize();
                System.out.println(previousRamSize);
                this.prepareFile(tsFileResource, (long)i * this.ptNum, this.ptNum, 0L);
                this.tsFileResourceManager.registerSealedTsFileResource(tsFileResource);
                Assert.assertEquals((Object)TimeIndexLevel.FILE_TIME_INDEX, (Object)TimeIndexLevel.valueOf((int)tsFileResource.getTimeIndexType()));
                reducedMemory = previousRamSize - tsFileResource.calculateRamSize();
            }
        }
        catch (RuntimeException e) {
            Assert.assertEquals((long)1072L, (long)reducedMemory);
            Assert.assertEquals((long)7L, (long)this.seqResources.size());
            throw e;
        }
    }
}

