/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.universal;

import org.apache.iotdb.db.query.reader.universal.AlignedPriorityMergeReader;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;
import org.junit.Assert;
import org.junit.Test;

public class AlignedPriorityMergeReaderTest {
    @Test
    public void test1() {
        TsPrimitiveType[] vector = new TsPrimitiveType[3];
        vector[0] = new TsPrimitiveType.TsInt(10);
        TimeValuePair v = new TimeValuePair(1L, (TsPrimitiveType)new TsPrimitiveType.TsVector(vector));
        vector = new TsPrimitiveType[3];
        vector[1] = new TsPrimitiveType.TsInt(2);
        vector[2] = new TsPrimitiveType.TsInt(3);
        TimeValuePair c = new TimeValuePair(1L, (TsPrimitiveType)new TsPrimitiveType.TsVector(vector));
        AlignedPriorityMergeReader.fillNullValueInAligned((TimeValuePair)v, (TimeValuePair)c);
        Assert.assertEquals((long)10L, (long)v.getValue().getVector()[0].getInt());
        Assert.assertEquals((long)2L, (long)v.getValue().getVector()[1].getInt());
        Assert.assertEquals((long)3L, (long)v.getValue().getVector()[2].getInt());
    }

    @Test
    public void test2() {
        TsPrimitiveType[] vector = new TsPrimitiveType[3];
        vector[0] = new TsPrimitiveType.TsInt(10);
        vector[1] = new TsPrimitiveType.TsInt(20);
        TimeValuePair v = new TimeValuePair(1L, (TsPrimitiveType)new TsPrimitiveType.TsVector(vector));
        vector = new TsPrimitiveType[3];
        vector[1] = new TsPrimitiveType.TsInt(2);
        vector[2] = new TsPrimitiveType.TsInt(3);
        TimeValuePair c = new TimeValuePair(1L, (TsPrimitiveType)new TsPrimitiveType.TsVector(vector));
        AlignedPriorityMergeReader.fillNullValueInAligned((TimeValuePair)v, (TimeValuePair)c);
        Assert.assertEquals((long)10L, (long)v.getValue().getVector()[0].getInt());
        Assert.assertEquals((long)20L, (long)v.getValue().getVector()[1].getInt());
        Assert.assertEquals((long)3L, (long)v.getValue().getVector()[2].getInt());
    }

    @Test
    public void test3() {
        TsPrimitiveType[] vector = new TsPrimitiveType[]{new TsPrimitiveType.TsInt(10), new TsPrimitiveType.TsInt(20), new TsPrimitiveType.TsInt(30)};
        TimeValuePair v = new TimeValuePair(1L, (TsPrimitiveType)new TsPrimitiveType.TsVector(vector));
        vector = new TsPrimitiveType[3];
        vector[1] = new TsPrimitiveType.TsInt(2);
        vector[2] = new TsPrimitiveType.TsInt(3);
        TimeValuePair c = new TimeValuePair(1L, (TsPrimitiveType)new TsPrimitiveType.TsVector(vector));
        AlignedPriorityMergeReader.fillNullValueInAligned((TimeValuePair)v, (TimeValuePair)c);
        Assert.assertEquals((long)10L, (long)v.getValue().getVector()[0].getInt());
        Assert.assertEquals((long)20L, (long)v.getValue().getVector()[1].getInt());
        Assert.assertEquals((long)30L, (long)v.getValue().getVector()[2].getInt());
    }
}

