/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.series;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.query.aggregation.AggregateResult;
import org.apache.iotdb.db.query.factory.AggregateResultFactory;
import org.apache.iotdb.db.query.reader.series.SeriesAggregateReader;
import org.apache.iotdb.db.query.reader.series.SeriesReaderTestUtil;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.db.utils.SchemaTestUtils;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.IBatchDataIterator;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SeriesAggregateReaderTest {
    private static final String SERIES_READER_TEST_SG = "root.seriesReaderTest";
    private List<String> deviceIds = new ArrayList<String>();
    private List<MeasurementSchema> measurementSchemas = new ArrayList<MeasurementSchema>();
    private List<TsFileResource> seqResources = new ArrayList<TsFileResource>();
    private List<TsFileResource> unseqResources = new ArrayList<TsFileResource>();

    @Before
    public void setUp() throws MetadataException, IOException, WriteProcessException {
        EnvironmentUtils.envSetUp();
        SeriesReaderTestUtil.setUp(this.measurementSchemas, this.deviceIds, this.seqResources, this.unseqResources, SERIES_READER_TEST_SG);
    }

    @After
    public void tearDown() throws IOException, StorageEngineException {
        EnvironmentUtils.cleanEnv();
        SeriesReaderTestUtil.tearDown(this.seqResources, this.unseqResources);
    }

    @Test
    public void aggregateTest() {
        try {
            MeasurementPath path = SchemaTestUtils.getMeasurementPath("root.seriesReaderTest.device0.sensor0");
            HashSet<String> allSensors = new HashSet<String>();
            allSensors.add("sensor0");
            SeriesAggregateReader seriesReader = new SeriesAggregateReader((PartialPath)path, allSensors, TSDataType.INT32, EnvironmentUtils.TEST_QUERY_CONTEXT, this.seqResources, this.unseqResources, null, null, true);
            AggregateResult aggregateResult = AggregateResultFactory.getAggrResultByName((String)"count", (TSDataType)TSDataType.INT32, (boolean)true);
            int loopTime = 0;
            while (seriesReader.hasNextFile()) {
                if (seriesReader.canUseCurrentFileStatistics()) {
                    Statistics fileStatistics = seriesReader.currentFileStatistics();
                    aggregateResult.updateResultFromStatistics(fileStatistics);
                    seriesReader.skipCurrentFile();
                    continue;
                }
                while (seriesReader.hasNextChunk()) {
                    if (seriesReader.canUseCurrentChunkStatistics()) {
                        Statistics chunkStatistics = seriesReader.currentChunkStatistics();
                        aggregateResult.updateResultFromStatistics(chunkStatistics);
                        seriesReader.skipCurrentChunk();
                        continue;
                    }
                    while (seriesReader.hasNextPage()) {
                        if (seriesReader.canUseCurrentPageStatistics()) {
                            Statistics pageStatistic = seriesReader.currentPageStatistics();
                            aggregateResult.updateResultFromStatistics(pageStatistic);
                            seriesReader.skipCurrentPage();
                            continue;
                        }
                        if (loopTime >= 0 && loopTime < 13) {
                            Assert.assertEquals((Object)((long)loopTime * 20L), (Object)aggregateResult.getResult());
                        } else if (loopTime >= 13 && loopTime < 17) {
                            Assert.assertEquals((Object)((long)loopTime * 20L + 40L), (Object)aggregateResult.getResult());
                        } else if (loopTime >= 17) {
                            Assert.assertEquals((Object)((long)loopTime * 20L + 60L), (Object)aggregateResult.getResult());
                        }
                        while (seriesReader.hasNextPage()) {
                            BatchData.BatchDataIterator batchDataIterator = seriesReader.nextPage().getBatchDataIterator();
                            aggregateResult.updateResultFromPageData((IBatchDataIterator)batchDataIterator);
                            batchDataIterator.reset();
                            Assert.assertTrue((boolean)batchDataIterator.hasNext());
                        }
                        ++loopTime;
                    }
                }
            }
            Assert.assertEquals((Object)500L, (Object)aggregateResult.getResult());
        }
        catch (IOException | MetadataException | QueryProcessException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }
}

