/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.dataset.groupby;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimeZone;
import org.apache.iotdb.db.qp.physical.crud.GroupByTimePlan;
import org.apache.iotdb.db.query.aggregation.impl.CountAggrResult;
import org.apache.iotdb.db.query.dataset.groupby.GroupByWithValueFilterDataSet;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.junit.Assert;
import org.junit.Test;

public class GroupByTimeDataSetTest {
    @Test
    public void calNextTimePartitionTest1() throws IOException {
        long queryId = 1000L;
        long unit = 3L;
        long slidingStep = 5L;
        long startTime = 8L;
        long endTime = 31L;
        long[] startTimeArray = new long[]{8L, 13L, 18L, 23L, 28L};
        long[] endTimeArray = new long[]{11L, 16L, 21L, 26L, 31L};
        GroupByTimePlan groupByTimePlan = new GroupByTimePlan();
        groupByTimePlan.setInterval(unit);
        groupByTimePlan.setSlidingStep(slidingStep);
        groupByTimePlan.setStartTime(startTime);
        groupByTimePlan.setEndTime(endTime);
        GroupByWithValueFilterDataSet groupByEngine = new GroupByWithValueFilterDataSet(queryId, groupByTimePlan);
        int cnt = 0;
        while (groupByEngine.hasNext()) {
            TimeRange timeRange = groupByEngine.nextTimePartition();
            Assert.assertEquals((long)startTimeArray[cnt], (long)timeRange.getMin());
            Assert.assertEquals((long)endTimeArray[cnt], (long)timeRange.getMax());
            ++cnt;
        }
        Assert.assertEquals((long)startTimeArray.length, (long)cnt);
    }

    @Test
    public void calNextTimePartitionTest2() throws IOException {
        long queryId = 1000L;
        long unit = 3L;
        long slidingStep = 3L;
        long startTime = 8L;
        long endTime = 23L;
        long[] startTimeArray = new long[]{8L, 11L, 14L, 17L, 20L};
        long[] endTimeArray = new long[]{11L, 14L, 17L, 20L, 23L};
        GroupByTimePlan groupByTimePlan = new GroupByTimePlan();
        groupByTimePlan.setInterval(unit);
        groupByTimePlan.setSlidingStep(slidingStep);
        groupByTimePlan.setStartTime(startTime);
        groupByTimePlan.setEndTime(endTime);
        GroupByWithValueFilterDataSet groupByEngine = new GroupByWithValueFilterDataSet(queryId, groupByTimePlan);
        int cnt = 0;
        while (groupByEngine.hasNext()) {
            TimeRange timeRange = groupByEngine.nextTimePartition();
            Assert.assertEquals((long)startTimeArray[cnt], (long)timeRange.getMin());
            Assert.assertEquals((long)endTimeArray[cnt], (long)timeRange.getMax());
            ++cnt;
        }
        Assert.assertEquals((long)startTimeArray.length, (long)cnt);
    }

    @Test
    public void calNextTimePartitionTest3() throws IOException {
        long queryId = 1000L;
        long unit = 3L;
        long slidingStep = 3L;
        long startTime = 8L;
        long endTime = 25L;
        long[] startTimeArray = new long[]{8L, 11L, 14L, 17L, 20L, 23L};
        long[] endTimeArray = new long[]{11L, 14L, 17L, 20L, 23L, 25L};
        GroupByTimePlan groupByTimePlan = new GroupByTimePlan();
        groupByTimePlan.setInterval(unit);
        groupByTimePlan.setSlidingStep(slidingStep);
        groupByTimePlan.setStartTime(startTime);
        groupByTimePlan.setEndTime(endTime);
        GroupByWithValueFilterDataSet groupByEngine = new GroupByWithValueFilterDataSet(queryId, groupByTimePlan);
        int cnt = 0;
        while (groupByEngine.hasNext()) {
            TimeRange timeRange = groupByEngine.nextTimePartition();
            Assert.assertEquals((long)startTimeArray[cnt], (long)timeRange.getMin());
            Assert.assertEquals((long)endTimeArray[cnt], (long)timeRange.getMax());
            ++cnt;
        }
        Assert.assertEquals((long)startTimeArray.length, (long)cnt);
    }

    @Test
    public void calNextTimePartitionDescTest1() throws IOException {
        long queryId = 1000L;
        long unit = 3L;
        long slidingStep = 5L;
        long startTime = 8L;
        long endTime = 31L;
        long[] startTimeArray = new long[]{28L, 23L, 18L, 13L, 8L};
        long[] endTimeArray = new long[]{31L, 26L, 21L, 16L, 11L};
        GroupByTimePlan groupByTimePlan = new GroupByTimePlan();
        groupByTimePlan.setAscending(false);
        groupByTimePlan.setInterval(unit);
        groupByTimePlan.setSlidingStep(slidingStep);
        groupByTimePlan.setStartTime(startTime);
        groupByTimePlan.setEndTime(endTime);
        GroupByWithValueFilterDataSet groupByEngine = new GroupByWithValueFilterDataSet(queryId, groupByTimePlan);
        int cnt = 0;
        while (groupByEngine.hasNext()) {
            TimeRange timeRange = groupByEngine.nextTimePartition();
            Assert.assertEquals((long)startTimeArray[cnt], (long)timeRange.getMin());
            Assert.assertEquals((long)endTimeArray[cnt], (long)timeRange.getMax());
            ++cnt;
        }
        Assert.assertEquals((long)startTimeArray.length, (long)cnt);
    }

    @Test
    public void calNextTimePartitionDescTest2() throws IOException {
        long queryId = 1000L;
        long unit = 3L;
        long slidingStep = 3L;
        long startTime = 8L;
        long endTime = 23L;
        long[] startTimeArray = new long[]{20L, 17L, 14L, 11L, 8L};
        long[] endTimeArray = new long[]{23L, 20L, 17L, 14L, 11L};
        GroupByTimePlan groupByTimePlan = new GroupByTimePlan();
        groupByTimePlan.setAscending(false);
        groupByTimePlan.setInterval(unit);
        groupByTimePlan.setSlidingStep(slidingStep);
        groupByTimePlan.setStartTime(startTime);
        groupByTimePlan.setEndTime(endTime);
        GroupByWithValueFilterDataSet groupByEngine = new GroupByWithValueFilterDataSet(queryId, groupByTimePlan);
        int cnt = 0;
        while (groupByEngine.hasNext()) {
            TimeRange timeRange = groupByEngine.nextTimePartition();
            Assert.assertEquals((long)startTimeArray[cnt], (long)timeRange.getMin());
            Assert.assertEquals((long)endTimeArray[cnt], (long)timeRange.getMax());
            ++cnt;
        }
        Assert.assertEquals((long)startTimeArray.length, (long)cnt);
    }

    @Test
    public void calNextTimePartitionDescTest3() throws IOException {
        long queryId = 1000L;
        long unit = 3L;
        long slidingStep = 3L;
        long startTime = 8L;
        long endTime = 25L;
        long[] startTimeArray = new long[]{23L, 20L, 17L, 14L, 11L, 8L};
        long[] endTimeArray = new long[]{25L, 23L, 20L, 17L, 14L, 11L};
        GroupByTimePlan groupByTimePlan = new GroupByTimePlan();
        groupByTimePlan.setAscending(false);
        groupByTimePlan.setInterval(unit);
        groupByTimePlan.setSlidingStep(slidingStep);
        groupByTimePlan.setStartTime(startTime);
        groupByTimePlan.setEndTime(endTime);
        ArrayList<CountAggrResult> aggrList = new ArrayList<CountAggrResult>();
        aggrList.add(new CountAggrResult());
        GroupByWithValueFilterDataSet groupByEngine = new GroupByWithValueFilterDataSet(queryId, groupByTimePlan);
        int cnt = 0;
        while (groupByEngine.hasNext()) {
            TimeRange timeRange = groupByEngine.nextTimePartition();
            Assert.assertTrue((cnt < startTimeArray.length ? 1 : 0) != 0);
            Assert.assertEquals((long)startTimeArray[cnt], (long)timeRange.getMin());
            Assert.assertEquals((long)endTimeArray[cnt], (long)timeRange.getMax());
            ++cnt;
        }
        Assert.assertEquals((long)startTimeArray.length, (long)cnt);
    }

    @Test
    public void testGroupByMonth1() throws IOException {
        long queryId = 1000L;
        long unit = 2592000000L;
        long slidingStep = 5184000000L;
        long startTime = 1572609438000L;
        long endTime = 1585742238000L;
        SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy:HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("GMT+8:00"));
        String[] startTimeArray = new String[]{"11/01/2019:19:57:18", "01/01/2020:19:57:18", "03/01/2020:19:57:18"};
        String[] endTimeArray = new String[]{"12/01/2019:19:57:18", "02/01/2020:19:57:18", "04/01/2020:19:57:18"};
        GroupByTimePlan groupByTimePlan = new GroupByTimePlan();
        groupByTimePlan.setInterval(unit);
        groupByTimePlan.setSlidingStep(slidingStep);
        groupByTimePlan.setStartTime(startTime);
        groupByTimePlan.setEndTime(endTime);
        groupByTimePlan.setIntervalByMonth(true);
        groupByTimePlan.setSlidingStepByMonth(true);
        GroupByWithValueFilterDataSet groupByEngine = new GroupByWithValueFilterDataSet(queryId, groupByTimePlan);
        int cnt = 0;
        while (groupByEngine.hasNext()) {
            TimeRange timeRange = groupByEngine.nextTimePartition();
            Assert.assertTrue((cnt < startTimeArray.length ? 1 : 0) != 0);
            Assert.assertEquals((Object)startTimeArray[cnt], (Object)df.format(new Date(timeRange.getMin())));
            Assert.assertEquals((Object)endTimeArray[cnt], (Object)df.format(new Date(timeRange.getMax())));
            ++cnt;
        }
        Assert.assertEquals((long)startTimeArray.length, (long)cnt);
    }

    @Test
    public void testGroupByMonth2() throws IOException {
        long queryId = 1000L;
        long unit = 2592000000L;
        long slidingStep = 2592000000L;
        long startTime = 1572523038000L;
        long endTime = 1585742238000L;
        SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy:HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("GMT+8:00"));
        String[] startTimeArray = new String[]{"10/31/2019:19:57:18", "11/30/2019:19:57:18", "12/31/2019:19:57:18", "01/31/2020:19:57:18", "02/29/2020:19:57:18", "03/31/2020:19:57:18"};
        String[] endTimeArray = new String[]{"11/30/2019:19:57:18", "12/31/2019:19:57:18", "01/31/2020:19:57:18", "02/29/2020:19:57:18", "03/31/2020:19:57:18", "04/01/2020:19:57:18"};
        GroupByTimePlan groupByTimePlan = new GroupByTimePlan();
        groupByTimePlan.setInterval(unit);
        groupByTimePlan.setSlidingStep(slidingStep);
        groupByTimePlan.setStartTime(startTime);
        groupByTimePlan.setEndTime(endTime);
        groupByTimePlan.setIntervalByMonth(true);
        groupByTimePlan.setSlidingStepByMonth(true);
        GroupByWithValueFilterDataSet groupByEngine = new GroupByWithValueFilterDataSet(queryId, groupByTimePlan);
        int cnt = 0;
        while (groupByEngine.hasNext()) {
            TimeRange timeRange = groupByEngine.nextTimePartition();
            Assert.assertTrue((cnt < startTimeArray.length ? 1 : 0) != 0);
            Assert.assertEquals((Object)startTimeArray[cnt], (Object)df.format(new Date(timeRange.getMin())));
            Assert.assertEquals((Object)endTimeArray[cnt], (Object)df.format(new Date(timeRange.getMax())));
            ++cnt;
        }
        Assert.assertEquals((long)startTimeArray.length, (long)cnt);
    }

    @Test
    public void testGroupByMonth3() throws IOException {
        long queryId = 1000L;
        long unit = 5184000000L;
        long slidingStep = 7776000000L;
        long startTime = 1572523038000L;
        long endTime = 1585742238000L;
        SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy:HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("GMT+8:00"));
        String[] startTimeArray = new String[]{"10/31/2019:19:57:18", "01/31/2020:19:57:18"};
        String[] endTimeArray = new String[]{"12/31/2019:19:57:18", "03/31/2020:19:57:18"};
        GroupByTimePlan groupByTimePlan = new GroupByTimePlan();
        groupByTimePlan.setInterval(unit);
        groupByTimePlan.setSlidingStep(slidingStep);
        groupByTimePlan.setStartTime(startTime);
        groupByTimePlan.setEndTime(endTime);
        groupByTimePlan.setIntervalByMonth(true);
        groupByTimePlan.setSlidingStepByMonth(true);
        GroupByWithValueFilterDataSet groupByEngine = new GroupByWithValueFilterDataSet(queryId, groupByTimePlan);
        int cnt = 0;
        while (groupByEngine.hasNext()) {
            TimeRange timeRange = groupByEngine.nextTimePartition();
            Assert.assertTrue((cnt < startTimeArray.length ? 1 : 0) != 0);
            Assert.assertEquals((Object)startTimeArray[cnt], (Object)df.format(new Date(timeRange.getMin())));
            Assert.assertEquals((Object)endTimeArray[cnt], (Object)df.format(new Date(timeRange.getMax())));
            ++cnt;
        }
        Assert.assertEquals((long)startTimeArray.length, (long)cnt);
    }

    @Test
    public void testGroupByMonth4() throws IOException {
        long queryId = 1000L;
        long unit = 864000000L;
        long slidingStep = 2592000000L;
        long startTime = 1572523038000L;
        long endTime = 1585742238000L;
        SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy:HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("GMT+8:00"));
        String[] startTimeArray = new String[]{"10/31/2019:19:57:18", "11/30/2019:19:57:18", "12/31/2019:19:57:18", "01/31/2020:19:57:18", "02/29/2020:19:57:18", "03/31/2020:19:57:18"};
        String[] endTimeArray = new String[]{"11/10/2019:19:57:18", "12/10/2019:19:57:18", "01/10/2020:19:57:18", "02/10/2020:19:57:18", "03/10/2020:19:57:18", "04/01/2020:19:57:18"};
        GroupByTimePlan groupByTimePlan = new GroupByTimePlan();
        groupByTimePlan.setInterval(unit);
        groupByTimePlan.setSlidingStep(slidingStep);
        groupByTimePlan.setStartTime(startTime);
        groupByTimePlan.setEndTime(endTime);
        groupByTimePlan.setIntervalByMonth(false);
        groupByTimePlan.setSlidingStepByMonth(true);
        GroupByWithValueFilterDataSet groupByEngine = new GroupByWithValueFilterDataSet(queryId, groupByTimePlan);
        int cnt = 0;
        while (groupByEngine.hasNext()) {
            TimeRange timeRange = groupByEngine.nextTimePartition();
            Assert.assertTrue((cnt < startTimeArray.length ? 1 : 0) != 0);
            Assert.assertEquals((Object)startTimeArray[cnt], (Object)df.format(new Date(timeRange.getMin())));
            Assert.assertEquals((Object)endTimeArray[cnt], (Object)df.format(new Date(timeRange.getMax())));
            ++cnt;
        }
        Assert.assertEquals((long)startTimeArray.length, (long)cnt);
    }

    @Test
    public void testGroupByMonthDescending1() throws IOException {
        long queryId = 1000L;
        long unit = 2592000000L;
        long slidingStep = 2592000000L;
        long startTime = 1572523038000L;
        long endTime = 1585742238000L;
        SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy:HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("GMT+8:00"));
        String[] startTimeArray = new String[]{"03/31/2020:19:57:18", "02/29/2020:19:57:18", "01/31/2020:19:57:18", "12/31/2019:19:57:18", "11/30/2019:19:57:18", "10/31/2019:19:57:18"};
        String[] endTimeArray = new String[]{"04/01/2020:19:57:18", "03/31/2020:19:57:18", "02/29/2020:19:57:18", "01/31/2020:19:57:18", "12/31/2019:19:57:18", "11/30/2019:19:57:18"};
        GroupByTimePlan groupByTimePlan = new GroupByTimePlan();
        groupByTimePlan.setInterval(unit);
        groupByTimePlan.setSlidingStep(slidingStep);
        groupByTimePlan.setStartTime(startTime);
        groupByTimePlan.setEndTime(endTime);
        groupByTimePlan.setIntervalByMonth(true);
        groupByTimePlan.setSlidingStepByMonth(true);
        groupByTimePlan.setAscending(false);
        GroupByWithValueFilterDataSet groupByEngine = new GroupByWithValueFilterDataSet(queryId, groupByTimePlan);
        int cnt = 0;
        while (groupByEngine.hasNext()) {
            TimeRange timeRange = groupByEngine.nextTimePartition();
            Assert.assertTrue((cnt < startTimeArray.length ? 1 : 0) != 0);
            Assert.assertEquals((Object)startTimeArray[cnt], (Object)df.format(new Date(timeRange.getMin())));
            Assert.assertEquals((Object)endTimeArray[cnt], (Object)df.format(new Date(timeRange.getMax())));
            ++cnt;
        }
        Assert.assertEquals((long)startTimeArray.length, (long)cnt);
    }

    @Test
    public void testGroupByMonthDescending2() throws IOException {
        long queryId = 1000L;
        long unit = 2592000000L;
        long slidingStep = 5184000000L;
        long startTime = 1572523038000L;
        long endTime = 1585742238000L;
        SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy:HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("GMT+8:00"));
        String[] startTimeArray = new String[]{"02/29/2020:19:57:18", "12/31/2019:19:57:18", "10/31/2019:19:57:18"};
        String[] endTimeArray = new String[]{"03/31/2020:19:57:18", "01/31/2020:19:57:18", "11/30/2019:19:57:18"};
        GroupByTimePlan groupByTimePlan = new GroupByTimePlan();
        groupByTimePlan.setInterval(unit);
        groupByTimePlan.setSlidingStep(slidingStep);
        groupByTimePlan.setStartTime(startTime);
        groupByTimePlan.setEndTime(endTime);
        groupByTimePlan.setIntervalByMonth(true);
        groupByTimePlan.setSlidingStepByMonth(true);
        groupByTimePlan.setAscending(false);
        GroupByWithValueFilterDataSet groupByEngine = new GroupByWithValueFilterDataSet(queryId, groupByTimePlan);
        int cnt = 0;
        while (groupByEngine.hasNext()) {
            TimeRange timeRange = groupByEngine.nextTimePartition();
            Assert.assertTrue((cnt < startTimeArray.length ? 1 : 0) != 0);
            Assert.assertEquals((Object)startTimeArray[cnt], (Object)df.format(new Date(timeRange.getMin())));
            Assert.assertEquals((Object)endTimeArray[cnt], (Object)df.format(new Date(timeRange.getMax())));
            ++cnt;
        }
        Assert.assertEquals((long)startTimeArray.length, (long)cnt);
    }
}

