/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.dataset;

import java.io.IOException;
import java.sql.SQLException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.Planner;
import org.apache.iotdb.db.qp.executor.IPlanExecutor;
import org.apache.iotdb.db.qp.executor.PlanExecutor;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.query.dataset.ListDataSet;
import org.apache.iotdb.db.query.dataset.ShowDevicesDataSet;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.exception.filter.QueryFilterOptimizationException;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.thrift.TException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
@Deprecated
public class ListDataSetTest {
    private final IPlanExecutor queryExecutor = new PlanExecutor();
    private final Planner processor = new Planner();
    private final String[] sqls = new String[]{"CREATE DATABASE root.vehicle", "CREATE DATABASE root.test", "CREATE TIMESERIES root.vehicle.d0.s0 WITH DATATYPE=INT32, ENCODING=RLE", "CREATE TIMESERIES root.vehicle.d0.s1 WITH DATATYPE=TEXT, ENCODING=PLAIN", "CREATE TIMESERIES root.test.d0.s0 WITH DATATYPE=INT32, ENCODING=RLE", "CREATE TIMESERIES root.test.d0.s1 WITH DATATYPE=TEXT, ENCODING=PLAIN", "CREATE TIMESERIES root.test.d1.`\"s3+xy\"` WITH DATATYPE=TEXT, ENCODING=PLAIN", "CREATE ALIGNED TIMESERIES root.test.d2(s1 DOUBLE, s2 BOOLEAN)"};

    @Before
    public void setUp() throws Exception {
        EnvironmentUtils.envSetUp();
        for (String sql : this.sqls) {
            this.queryExecutor.processNonQuery(this.processor.parseSQLToPhysicalPlan(sql));
        }
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void showStorageGroups() throws QueryProcessException, TException, StorageEngineException, QueryFilterOptimizationException, MetadataException, IOException, InterruptedException, SQLException {
        String[] results = new String[]{"0\troot.test", "0\troot.vehicle"};
        PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan("SHOW DATABASES");
        QueryDataSet dataSet = this.queryExecutor.processQuery(plan, EnvironmentUtils.TEST_QUERY_CONTEXT);
        Assert.assertTrue((boolean)(dataSet instanceof ListDataSet));
        Assert.assertEquals((Object)"[database]", (Object)dataSet.getPaths().toString());
        int i = 0;
        while (dataSet.hasNext()) {
            RowRecord record = dataSet.next();
            Assert.assertEquals((Object)results[i], (Object)record.toString());
            ++i;
        }
    }

    @Test
    public void showChildPaths() throws QueryProcessException, TException, StorageEngineException, QueryFilterOptimizationException, MetadataException, IOException, InterruptedException, SQLException {
        String[] results = new String[]{"0\troot.test.d0\tDEVICE", "0\troot.test.d1\tDEVICE", "0\troot.test.d2\tDEVICE"};
        PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan("show child paths root.test");
        QueryDataSet dataSet = this.queryExecutor.processQuery(plan, EnvironmentUtils.TEST_QUERY_CONTEXT);
        Assert.assertTrue((boolean)(dataSet instanceof ListDataSet));
        Assert.assertEquals((Object)"[child paths, node types]", (Object)dataSet.getPaths().toString());
        int i = 0;
        while (dataSet.hasNext()) {
            RowRecord record = dataSet.next();
            Assert.assertEquals((Object)results[i], (Object)record.toString());
            ++i;
        }
    }

    @Test
    public void showDevices() throws QueryProcessException, TException, StorageEngineException, QueryFilterOptimizationException, MetadataException, IOException, InterruptedException, SQLException {
        String[] results = new String[]{"0\troot.test.d0\tfalse", "0\troot.test.d1\tfalse", "0\troot.test.d2\ttrue", "0\troot.vehicle.d0\tfalse"};
        PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan("show devices");
        QueryDataSet dataSet = this.queryExecutor.processQuery(plan, EnvironmentUtils.TEST_QUERY_CONTEXT);
        Assert.assertTrue((boolean)(dataSet instanceof ShowDevicesDataSet));
        Assert.assertEquals((Object)"[devices, isAligned]", (Object)dataSet.getPaths().toString());
        int i = 0;
        while (dataSet.hasNext()) {
            RowRecord record = dataSet.next();
            Assert.assertEquals((Object)results[i], (Object)record.toString());
            ++i;
        }
    }

    @Test
    public void showDevicesWithSg() throws QueryProcessException, TException, StorageEngineException, QueryFilterOptimizationException, MetadataException, IOException, InterruptedException, SQLException {
        String[] results = new String[]{"0\troot.test.d0\troot.test\tfalse", "0\troot.test.d1\troot.test\tfalse", "0\troot.test.d2\troot.test\ttrue", "0\troot.vehicle.d0\troot.vehicle\tfalse"};
        PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan("show devices with database");
        QueryDataSet dataSet = this.queryExecutor.processQuery(plan, EnvironmentUtils.TEST_QUERY_CONTEXT);
        Assert.assertTrue((boolean)(dataSet instanceof ShowDevicesDataSet));
        Assert.assertEquals((Object)"devices", (Object)((Path)dataSet.getPaths().get(0)).toString());
        Assert.assertEquals((Object)"database", (Object)((Path)dataSet.getPaths().get(1)).toString());
        Assert.assertEquals((Object)"isAligned", (Object)((Path)dataSet.getPaths().get(2)).toString());
        int i = 0;
        while (dataSet.hasNext()) {
            RowRecord record = dataSet.next();
            Assert.assertEquals((Object)results[i], (Object)record.toString());
            ++i;
        }
    }
}

