/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.utils;

import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.apache.iotdb.db.exception.query.LogicalOperatorException;
import org.apache.iotdb.db.qp.utils.DateTimeUtils;
import org.junit.Assert;
import org.junit.Test;

public class DatetimeQueryDataSetUtilsTest {
    private ZoneOffset zoneOffset;
    private ZoneId zoneId;
    private final long timestamp = 1546413207689L;
    private long delta;

    @Test
    public void convertDatetimeStrToLongTest1() throws LogicalOperatorException {
        this.zoneOffset = ZonedDateTime.now().getOffset();
        this.zoneId = ZoneId.systemDefault();
        this.delta = this.zoneOffset.toString().equals("Z") ? 28800000L : (8L - Long.parseLong(this.zoneOffset.toString().split(":")[0])) * 3600000L;
        this.testConvertDatetimeStrToLongWithoutMS(this.zoneOffset, this.zoneId, 1546413207000L + this.delta);
        this.testConvertDatetimeStrToLongWithMS(this.zoneOffset, this.zoneId, 1546413207689L + this.delta);
    }

    @Test
    public void convertDatetimeStrToLongTest2() throws LogicalOperatorException {
        this.zoneOffset = ZoneOffset.UTC;
        this.zoneId = ZoneId.of("Etc/UTC");
        this.delta = 28800000L;
        this.testConvertDatetimeStrToLongWithoutMS(this.zoneOffset, this.zoneId, 1546413207000L + this.delta);
        this.testConvertDatetimeStrToLongWithMS(this.zoneOffset, this.zoneId, 1546413207689L + this.delta);
    }

    @Test
    public void convertDatetimeStrToLongTest3() throws LogicalOperatorException {
        this.zoneOffset = ZoneOffset.UTC;
        this.zoneId = ZoneId.of("Etc/UTC");
        this.delta = 28800000L;
        long timestamp1 = 1546358400000L;
        this.testConvertDateStrToLong(this.zoneOffset, this.zoneId, timestamp1 + this.delta);
    }

    @Test
    public void convertDurationStrToLongTest1() {
        Assert.assertEquals((long)7000L, (long)DateTimeUtils.convertDurationStrToLongForTest((long)7L, (String)"s", (String)"ms"));
        Assert.assertEquals((long)420000L, (long)DateTimeUtils.convertDurationStrToLongForTest((long)7L, (String)"m", (String)"ms"));
        Assert.assertEquals((long)25200000L, (long)DateTimeUtils.convertDurationStrToLongForTest((long)7L, (String)"h", (String)"ms"));
        Assert.assertEquals((long)604800000L, (long)DateTimeUtils.convertDurationStrToLongForTest((long)7L, (String)"d", (String)"ms"));
        Assert.assertEquals((long)4233600000L, (long)DateTimeUtils.convertDurationStrToLongForTest((long)7L, (String)"w", (String)"ms"));
        Assert.assertEquals((long)18144000000L, (long)DateTimeUtils.convertDurationStrToLongForTest((long)7L, (String)"mo", (String)"ms"));
        Assert.assertEquals((long)220752000000L, (long)DateTimeUtils.convertDurationStrToLongForTest((long)7L, (String)"y", (String)"ms"));
        Assert.assertEquals((long)7L, (long)DateTimeUtils.convertDurationStrToLongForTest((long)7L, (String)"ms", (String)"ms"));
        Assert.assertEquals((long)7L, (long)DateTimeUtils.convertDurationStrToLongForTest((long)7000L, (String)"us", (String)"ms"));
        Assert.assertEquals((long)7L, (long)DateTimeUtils.convertDurationStrToLongForTest((long)7000000L, (String)"ns", (String)"ms"));
    }

    @Test
    public void convertDurationStrToLongTest2() {
        Assert.assertEquals((long)7000000L, (long)DateTimeUtils.convertDurationStrToLongForTest((long)7L, (String)"s", (String)"us"));
        Assert.assertEquals((long)420000000L, (long)DateTimeUtils.convertDurationStrToLongForTest((long)7L, (String)"m", (String)"us"));
        Assert.assertEquals((long)25200000000L, (long)DateTimeUtils.convertDurationStrToLongForTest((long)7L, (String)"h", (String)"us"));
        Assert.assertEquals((long)604800000000L, (long)DateTimeUtils.convertDurationStrToLongForTest((long)7L, (String)"d", (String)"us"));
        Assert.assertEquals((long)4233600000000L, (long)DateTimeUtils.convertDurationStrToLongForTest((long)7L, (String)"w", (String)"us"));
        Assert.assertEquals((long)18144000000000L, (long)DateTimeUtils.convertDurationStrToLongForTest((long)7L, (String)"mo", (String)"us"));
        Assert.assertEquals((long)220752000000000L, (long)DateTimeUtils.convertDurationStrToLongForTest((long)7L, (String)"y", (String)"us"));
        Assert.assertEquals((long)7000L, (long)DateTimeUtils.convertDurationStrToLongForTest((long)7L, (String)"ms", (String)"us"));
        Assert.assertEquals((long)7L, (long)DateTimeUtils.convertDurationStrToLongForTest((long)7L, (String)"us", (String)"us"));
        Assert.assertEquals((long)7L, (long)DateTimeUtils.convertDurationStrToLongForTest((long)7000L, (String)"ns", (String)"us"));
    }

    @Test
    public void convertDurationStrToLongTest3() {
        Assert.assertEquals((long)7000000000L, (long)DateTimeUtils.convertDurationStrToLongForTest((long)7L, (String)"s", (String)"ns"));
        Assert.assertEquals((long)420000000000L, (long)DateTimeUtils.convertDurationStrToLongForTest((long)7L, (String)"m", (String)"ns"));
        Assert.assertEquals((long)25200000000000L, (long)DateTimeUtils.convertDurationStrToLongForTest((long)7L, (String)"h", (String)"ns"));
        Assert.assertEquals((long)604800000000000L, (long)DateTimeUtils.convertDurationStrToLongForTest((long)7L, (String)"d", (String)"ns"));
        Assert.assertEquals((long)4233600000000000L, (long)DateTimeUtils.convertDurationStrToLongForTest((long)7L, (String)"w", (String)"ns"));
        Assert.assertEquals((long)18144000000000000L, (long)DateTimeUtils.convertDurationStrToLongForTest((long)7L, (String)"mo", (String)"ns"));
        Assert.assertEquals((long)220752000000000000L, (long)DateTimeUtils.convertDurationStrToLongForTest((long)7L, (String)"y", (String)"ns"));
        Assert.assertEquals((long)7000000L, (long)DateTimeUtils.convertDurationStrToLongForTest((long)7L, (String)"ms", (String)"ns"));
        Assert.assertEquals((long)7000L, (long)DateTimeUtils.convertDurationStrToLongForTest((long)7L, (String)"us", (String)"ns"));
        Assert.assertEquals((long)7L, (long)DateTimeUtils.convertDurationStrToLongForTest((long)7L, (String)"ns", (String)"ns"));
    }

    @Test
    public void getInstantWithPrecisionTest() {
        Assert.assertEquals((long)7000000000L, (long)DateTimeUtils.convertDurationStrToLongForTest((long)7L, (String)"s", (String)"ns"));
        Assert.assertEquals((long)420000000000L, (long)DateTimeUtils.convertDurationStrToLongForTest((long)7L, (String)"m", (String)"ns"));
        Assert.assertEquals((long)25200000000000L, (long)DateTimeUtils.convertDurationStrToLongForTest((long)7L, (String)"h", (String)"ns"));
        Assert.assertEquals((long)604800000000000L, (long)DateTimeUtils.convertDurationStrToLongForTest((long)7L, (String)"d", (String)"ns"));
        Assert.assertEquals((long)4233600000000000L, (long)DateTimeUtils.convertDurationStrToLongForTest((long)7L, (String)"w", (String)"ns"));
        Assert.assertEquals((long)18144000000000000L, (long)DateTimeUtils.convertDurationStrToLongForTest((long)7L, (String)"mo", (String)"ns"));
        Assert.assertEquals((long)220752000000000000L, (long)DateTimeUtils.convertDurationStrToLongForTest((long)7L, (String)"y", (String)"ns"));
        Assert.assertEquals((long)7000000L, (long)DateTimeUtils.convertDurationStrToLongForTest((long)7L, (String)"ms", (String)"ns"));
        Assert.assertEquals((long)7000L, (long)DateTimeUtils.convertDurationStrToLongForTest((long)7L, (String)"us", (String)"ns"));
        Assert.assertEquals((long)7L, (long)DateTimeUtils.convertDurationStrToLongForTest((long)7L, (String)"ns", (String)"ns"));
    }

    @Test
    public void getConvertDurationIncludingMonthUnit() {
        Assert.assertEquals((long)2678400000L, (long)DateTimeUtils.convertDurationStrToLong((long)0L, (long)1L, (String)"mo", (String)"ms"));
        Assert.assertEquals((long)2419200000L, (long)DateTimeUtils.convertDurationStrToLong((long)2678400000L, (long)1L, (String)"mo", (String)"ms"));
        Assert.assertEquals((long)2678400000L, (long)DateTimeUtils.convertDurationStrToLong((long)5097600000L, (long)1L, (String)"mo", (String)"ms"));
        Assert.assertEquals((long)2592000000L, (long)DateTimeUtils.convertDurationStrToLong((long)7776000000L, (long)1L, (String)"mo", (String)"ms"));
        Assert.assertEquals((long)2678400000L, (long)DateTimeUtils.convertDurationStrToLong((long)10368000000L, (long)1L, (String)"mo", (String)"ms"));
        Assert.assertEquals((long)2592000000L, (long)DateTimeUtils.convertDurationStrToLong((long)13046400000L, (long)1L, (String)"mo", (String)"ms"));
        Assert.assertEquals((long)2678400000L, (long)DateTimeUtils.convertDurationStrToLong((long)15638400000L, (long)1L, (String)"mo", (String)"ms"));
        Assert.assertEquals((long)2678400000L, (long)DateTimeUtils.convertDurationStrToLong((long)18316800000L, (long)1L, (String)"mo", (String)"ms"));
        Assert.assertEquals((long)2592000000L, (long)DateTimeUtils.convertDurationStrToLong((long)20995200000L, (long)1L, (String)"mo", (String)"ms"));
        Assert.assertEquals((long)2678400000L, (long)DateTimeUtils.convertDurationStrToLong((long)23587200000L, (long)1L, (String)"mo", (String)"ms"));
        Assert.assertEquals((long)2592000000L, (long)DateTimeUtils.convertDurationStrToLong((long)26265600000L, (long)1L, (String)"mo", (String)"ms"));
        Assert.assertEquals((long)2678400000L, (long)DateTimeUtils.convertDurationStrToLong((long)28857600000L, (long)1L, (String)"mo", (String)"ms"));
    }

    public void testConvertDatetimeStrToLongWithoutMS(ZoneOffset zoneOffset, ZoneId zoneId, long res) throws LogicalOperatorException {
        String[] timeFormatWithoutMs;
        for (String str : timeFormatWithoutMs = new String[]{"2019-01-02 15:13:27", "2019/01/02 15:13:27", "2019.01.02 15:13:27", "2019-01-02T15:13:27", "2019/01/02T15:13:27", "2019.01.02T15:13:27", "2019-01-02 15:13:27" + zoneOffset, "2019/01/02 15:13:27" + zoneOffset, "2019.01.02 15:13:27" + zoneOffset, "2019-01-02T15:13:27" + zoneOffset, "2019/01/02T15:13:27" + zoneOffset, "2019.01.02T15:13:27" + zoneOffset}) {
            Assert.assertEquals((long)res, (long)DateTimeUtils.convertDatetimeStrToLong((String)str, (ZoneOffset)zoneOffset, (int)0, (String)"ms"));
        }
        for (String str : timeFormatWithoutMs) {
            Assert.assertEquals((long)res, (long)DateTimeUtils.convertDatetimeStrToLong((String)str, (ZoneId)zoneId));
        }
    }

    public void testConvertDatetimeStrToLongWithMS(ZoneOffset zoneOffset, ZoneId zoneId, long res) throws LogicalOperatorException {
        String[] timeFormatWithoutMs;
        for (String str : timeFormatWithoutMs = new String[]{"2019-01-02 15:13:27.689", "2019/01/02 15:13:27.689", "2019.01.02 15:13:27.689", "2019-01-02T15:13:27.689", "2019/01/02T15:13:27.689", "2019.01.02T15:13:27.689", "2019-01-02 15:13:27.689" + zoneOffset, "2019/01/02 15:13:27.689" + zoneOffset, "2019.01.02 15:13:27.689" + zoneOffset, "2019-01-02T15:13:27.689" + zoneOffset, "2019/01/02T15:13:27.689" + zoneOffset, "2019.01.02T15:13:27.689" + zoneOffset}) {
            Assert.assertEquals((long)res, (long)DateTimeUtils.convertDatetimeStrToLong((String)str, (ZoneOffset)zoneOffset, (int)0, (String)"ms"));
        }
        for (String str : timeFormatWithoutMs) {
            Assert.assertEquals((long)res, (long)DateTimeUtils.convertDatetimeStrToLong((String)str, (ZoneId)zoneId));
        }
    }

    public void testConvertDateStrToLong(ZoneOffset zoneOffset, ZoneId zoneId, long res) throws LogicalOperatorException {
        String[] timeFormatWithoutMs;
        for (String str : timeFormatWithoutMs = new String[]{"2019-01-02", "2019/01/02", "2019.01.02"}) {
            Assert.assertEquals((long)res, (long)DateTimeUtils.convertDatetimeStrToLong((String)str, (ZoneOffset)zoneOffset, (int)0, (String)"ms"));
        }
        for (String str : timeFormatWithoutMs) {
            Assert.assertEquals((long)res, (long)DateTimeUtils.convertDatetimeStrToLong((String)str, (ZoneId)zoneId));
        }
    }
}

