/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.sql;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.mpp.plan.parser.ASTVisitor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ASTVisitorTest {
    ASTVisitor visitor;

    @Before
    public void setUp() {
        this.visitor = new ASTVisitor();
        this.visitor.setZoneId((ZoneId)ZonedDateTime.now().getOffset());
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testParseTimeFormatNow() {
        long now = this.visitor.parseDateFormat("now()");
        for (int i = 0; i <= 12; ++i) {
            ZoneOffset offset2;
            ZoneOffset offset1;
            if (i < 10) {
                offset1 = ZoneOffset.of("+0" + i + ":00");
                offset2 = ZoneOffset.of("-0" + i + ":00");
            } else {
                offset1 = ZoneOffset.of("+" + i + ":00");
                offset2 = ZoneOffset.of("-" + i + ":00");
            }
            ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(now), ZoneId.of(offset1.toString()));
            Assert.assertEquals((long)now, (long)zonedDateTime.toInstant().toEpochMilli());
            zonedDateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(now), ZoneId.of(offset2.toString()));
            Assert.assertEquals((long)now, (long)zonedDateTime.toInstant().toEpochMilli());
        }
    }

    @Test
    public void testParseTimeFormatNowPrecision() {
        String timePrecision = IoTDBDescriptor.getInstance().getConfig().getTimestampPrecision();
        IoTDBDescriptor.getInstance().getConfig().setTimestampPrecision("ms");
        long now_ms = this.visitor.parseDateFormat("now()");
        String ms_str = String.valueOf(now_ms);
        IoTDBDescriptor.getInstance().getConfig().setTimestampPrecision("us");
        long now_us = this.visitor.parseDateFormat("now()");
        String us_str = String.valueOf(now_us);
        IoTDBDescriptor.getInstance().getConfig().setTimestampPrecision("ns");
        long now_ns = this.visitor.parseDateFormat("now()");
        String ns_str = String.valueOf(now_ns);
        Assert.assertEquals((long)(ms_str.length() + 3), (long)us_str.length());
        Assert.assertEquals((long)(us_str.length() + 3), (long)ns_str.length());
        IoTDBDescriptor.getInstance().getConfig().setTimestampPrecision(timePrecision);
    }

    @Test(expected=SemanticException.class)
    public void testParseTimeFormatFail1() {
        this.visitor.parseDateFormat(null);
    }

    @Test(expected=SemanticException.class)
    public void testParseTimeFormatFail2() {
        this.visitor.parseDateFormat("");
    }
}

