/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.logical;

import java.time.ZoneId;
import java.util.ArrayList;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.query.LogicalOptimizeException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.exception.sql.SQLParserException;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.mpp.plan.expression.ResultColumn;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.logical.crud.DeleteDataOperator;
import org.apache.iotdb.db.qp.logical.crud.QueryOperator;
import org.apache.iotdb.db.qp.logical.sys.DeleteStorageGroupOperator;
import org.apache.iotdb.db.qp.logical.sys.SetStorageGroupOperator;
import org.apache.iotdb.db.qp.strategy.LogicalGenerator;
import org.apache.iotdb.db.qp.strategy.optimizer.ConcatPathOptimizer;
import org.apache.iotdb.db.service.IoTDB;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
@Deprecated
public class LogicalPlanSmallTest {
    @Test
    public void testLimit() {
        String sqlStr = "select * from root.vehicle.d1 limit 10";
        QueryOperator operator = (QueryOperator)LogicalGenerator.generate((String)sqlStr, (ZoneId)ZoneId.systemDefault());
        Assert.assertEquals(QueryOperator.class, operator.getClass());
        Assert.assertEquals((long)10L, (long)operator.getSpecialClauseComponent().getRowLimit());
        Assert.assertEquals((long)0L, (long)operator.getSpecialClauseComponent().getRowOffset());
        Assert.assertEquals((long)0L, (long)operator.getSpecialClauseComponent().getSeriesLimit());
        Assert.assertEquals((long)0L, (long)operator.getSpecialClauseComponent().getSeriesOffset());
    }

    @Test
    public void testOffset() {
        String sqlStr = "select * from root.vehicle.d1 limit 10 offset 20";
        QueryOperator operator = (QueryOperator)LogicalGenerator.generate((String)sqlStr, (ZoneId)ZoneId.systemDefault());
        Assert.assertEquals(QueryOperator.class, operator.getClass());
        Assert.assertEquals((long)10L, (long)operator.getSpecialClauseComponent().getRowLimit());
        Assert.assertEquals((long)20L, (long)operator.getSpecialClauseComponent().getRowOffset());
        Assert.assertEquals((long)0L, (long)operator.getSpecialClauseComponent().getSeriesLimit());
        Assert.assertEquals((long)0L, (long)operator.getSpecialClauseComponent().getSeriesOffset());
    }

    @Test
    public void testSlimit() {
        String sqlStr = "select * from root.vehicle.d1 limit 10 slimit 1";
        QueryOperator operator = (QueryOperator)LogicalGenerator.generate((String)sqlStr, (ZoneId)ZoneId.systemDefault());
        Assert.assertEquals(QueryOperator.class, operator.getClass());
        Assert.assertEquals((long)10L, (long)operator.getSpecialClauseComponent().getRowLimit());
        Assert.assertEquals((long)0L, (long)operator.getSpecialClauseComponent().getRowOffset());
        Assert.assertEquals((long)1L, (long)operator.getSpecialClauseComponent().getSeriesLimit());
        Assert.assertEquals((long)0L, (long)operator.getSpecialClauseComponent().getSeriesOffset());
    }

    @Test
    public void testSOffset() {
        String sqlStr = "select * from root.vehicle.d1 where s1 < 20 and time <= now() limit 50 slimit 10 soffset 100";
        QueryOperator operator = (QueryOperator)LogicalGenerator.generate((String)sqlStr, (ZoneId)ZoneId.systemDefault());
        Assert.assertEquals(QueryOperator.class, operator.getClass());
        Assert.assertEquals((long)50L, (long)operator.getSpecialClauseComponent().getRowLimit());
        Assert.assertEquals((long)0L, (long)operator.getSpecialClauseComponent().getRowOffset());
        Assert.assertEquals((long)10L, (long)operator.getSpecialClauseComponent().getSeriesLimit());
        Assert.assertEquals((long)100L, (long)operator.getSpecialClauseComponent().getSeriesOffset());
    }

    @Test
    public void testSOffsetTimestamp() {
        String sqlStr = "select * from root.vehicle.d1 where s1 < 20 and timestamp <= now() limit 50 slimit 10 soffset 100";
        QueryOperator operator = (QueryOperator)LogicalGenerator.generate((String)sqlStr, (ZoneId)ZoneId.systemDefault());
        Assert.assertEquals(QueryOperator.class, operator.getClass());
        Assert.assertEquals((long)50L, (long)operator.getSpecialClauseComponent().getRowLimit());
        Assert.assertEquals((long)0L, (long)operator.getSpecialClauseComponent().getRowOffset());
        Assert.assertEquals((long)10L, (long)operator.getSpecialClauseComponent().getSeriesLimit());
        Assert.assertEquals((long)100L, (long)operator.getSpecialClauseComponent().getSeriesOffset());
    }

    @Test(expected=SQLParserException.class)
    public void testLimitOutOfRange() {
        String sqlStr = "select * from root.vehicle.d1 where s1 < 20 and time <= now() limit 1111111111111111111111";
        LogicalGenerator.generate((String)sqlStr, (ZoneId)ZoneId.systemDefault());
    }

    @Test(expected=SQLParserException.class)
    public void testLimitNotPositive() {
        String sqlStr = "select * from root.vehicle.d1 where s1 < 20 and time <= now() limit 0";
        LogicalGenerator.generate((String)sqlStr, (ZoneId)ZoneId.systemDefault());
    }

    @Test(expected=SQLParserException.class)
    public void testOffsetOutOfRange() {
        String sqlStr = "select * from root.vehicle.d1 where s1 < 20 and time <= now() limit 1 offset 1111111111111111111111";
        LogicalGenerator.generate((String)sqlStr, (ZoneId)ZoneId.systemDefault());
    }

    @Test(expected=ParseCancellationException.class)
    public void testOffsetNotPositive() {
        String sqlStr = "select * from root.vehicle.d1 where s1 < 20 and time <= now() limit 1 offset -1";
        LogicalGenerator.generate((String)sqlStr, (ZoneId)ZoneId.systemDefault());
    }

    @Test(expected=SQLParserException.class)
    public void testSlimitOutOfRange() {
        String sqlStr = "select * from root.vehicle.d1 where s1 < 20 and time <= now() slimit 1111111111111111111111";
        LogicalGenerator.generate((String)sqlStr, (ZoneId)ZoneId.systemDefault());
    }

    @Test(expected=SQLParserException.class)
    public void testSlimitNotPositive() {
        String sqlStr = "select * from root.vehicle.d1 where s1 < 20 and time <= now() slimit 0";
        LogicalGenerator.generate((String)sqlStr, (ZoneId)ZoneId.systemDefault());
    }

    @Test(expected=SQLParserException.class)
    public void testSoffsetOutOfRange() {
        String sqlStr = "select * from root.vehicle.d1 where s1 < 20 and time <= now() slimit 1 soffset 1111111111111111111111";
        LogicalGenerator.generate((String)sqlStr, (ZoneId)ZoneId.systemDefault());
    }

    @Test
    public void testSoffsetNotPositive() {
        String sqlStr = "select * from root.vehicle.d1 where s1 < 20 and time <= now() slimit 1 soffset 1";
        QueryOperator operator = (QueryOperator)LogicalGenerator.generate((String)sqlStr, (ZoneId)ZoneId.systemDefault());
        Assert.assertEquals((long)1L, (long)operator.getSpecialClauseComponent().getSeriesOffset());
        Assert.assertEquals((long)1L, (long)operator.getSpecialClauseComponent().getSeriesLimit());
    }

    @Test(expected=LogicalOptimizeException.class)
    public void testSoffsetExceedColumnNum() throws QueryProcessException {
        String sqlStr = "select s1 from root.vehicle.d1 where s1 < 20 and time <= now() slimit 2 soffset 1";
        QueryOperator operator = (QueryOperator)LogicalGenerator.generate((String)sqlStr, (ZoneId)ZoneId.systemDefault());
        IoTDB.configManager.init();
        ConcatPathOptimizer concatPathOptimizer = new ConcatPathOptimizer();
        concatPathOptimizer.transform((Operator)operator);
        IoTDB.configManager.clear();
    }

    @Test
    public void testDeleteStorageGroup() throws IllegalPathException {
        String sqlStr = "delete database root.vehicle.d1";
        DeleteStorageGroupOperator operator = (DeleteStorageGroupOperator)LogicalGenerator.generate((String)sqlStr, (ZoneId)ZoneId.systemDefault());
        Assert.assertEquals(DeleteStorageGroupOperator.class, operator.getClass());
        PartialPath path = new PartialPath("root.vehicle.d1");
        Assert.assertEquals((Object)path, operator.getDeletePathList().get(0));
    }

    @Test
    public void testDisableAlign() {
        String sqlStr = "select * from root.vehicle.** disable align";
        QueryOperator operator = (QueryOperator)LogicalGenerator.generate((String)sqlStr, (ZoneId)ZoneId.systemDefault());
        Assert.assertEquals(QueryOperator.class, operator.getClass());
        Assert.assertFalse((boolean)operator.isAlignByTime());
    }

    @Test
    public void testNotDisableAlign() {
        String sqlStr = "select * from root.vehicle.**";
        QueryOperator operator = (QueryOperator)LogicalGenerator.generate((String)sqlStr, (ZoneId)ZoneId.systemDefault());
        Assert.assertEquals(QueryOperator.class, operator.getClass());
        Assert.assertTrue((boolean)operator.isAlignByTime());
    }

    @Test(expected=ParseCancellationException.class)
    public void testDisableAlignConflictAlignByDevice() {
        String sqlStr = "select * from root.vehicle.** disable align align by device";
        LogicalGenerator.generate((String)sqlStr, (ZoneId)ZoneId.systemDefault());
    }

    @Test
    public void testChineseCharacter() throws IllegalPathException {
        String sqlStr1 = "CREATE DATABASE root.\u4e00\u7ea7";
        Operator operator = LogicalGenerator.generate((String)sqlStr1, (ZoneId)ZoneId.systemDefault());
        Assert.assertEquals(SetStorageGroupOperator.class, operator.getClass());
        Assert.assertEquals((Object)new PartialPath("root.\u4e00\u7ea7"), (Object)((SetStorageGroupOperator)operator).getPath());
        String sqlStr2 = "select * from root.\u4e00\u7ea7.\u8bbe\u59071 limit 10 offset 20";
        operator = LogicalGenerator.generate((String)sqlStr2, (ZoneId)ZoneId.systemDefault());
        Assert.assertEquals(QueryOperator.class, operator.getClass());
        ArrayList<PartialPath> paths = new ArrayList<PartialPath>();
        paths.add(new PartialPath("*"));
        Assert.assertEquals(paths, (Object)((QueryOperator)operator).getSelectComponent().getPaths());
    }

    @Test
    public void testKeyWordSQL() {
        try {
            String sql = "delete from ROOT.CREATE.INSERT.UPDATE.DELETE.SELECT.SHOW.GRANT.INTO.SET.WHERE.FROM.TO.BY.DEVICE.CONFIGURATION.DESCRIBE.SLIMIT.LIMIT.UNLINK.OFFSET.SOFFSET.FILL.LINEAR.PREVIOUS.PREVIOUSUNTILLAST.METADATA.TIMESERIES.TIMESTAMP.PROPERTY.WITH.DATATYPE.COMPRESSOR.STORAGE.GROUP.LABEL.ADD.UPSERT.VALUES.NOW.LINK.INDEX.USING.ON.DROP.MERGE.LIST.USER.PRIVILEGES.ROLE.ALL.OF.ALTER.PASSWORD.REVOKE.LOAD.WATERMARK_EMBEDDING.UNSET.TTL.FLUSH.TASK.INFO.VERSION.REMOVE.MOVE.CHILD.PATHS.DEVICES.COUNT.NODES.LEVEL.MIN_TIME.MAX_TIME.MIN_VALUE.MAX_VALUE.AVG.FIRST_VALUE.SUM.LAST_VALUE.LAST.DISABLE.ALIGN.COMPRESSION.TIME.ATTRIBUTES.TAGS.RENAME.FULL.CLEAR.CACHE.SNAPSHOT.FOR.SCHEMA.TRACING.OFF where time>=1 and time < 3";
            Operator op = LogicalGenerator.generate((String)sql, (ZoneId)ZoneId.systemDefault());
            Assert.assertEquals(DeleteDataOperator.class, op.getClass());
        }
        catch (ParseCancellationException parseCancellationException) {
            // empty catch block
        }
    }

    @Test
    public void testRangeDelete() throws IllegalPathException {
        String sql1 = "delete from root.d1.s1 where time>=1 and time < 3";
        Operator op = LogicalGenerator.generate((String)sql1, (ZoneId)ZoneId.systemDefault());
        Assert.assertEquals(DeleteDataOperator.class, op.getClass());
        ArrayList<PartialPath> paths = new ArrayList<PartialPath>();
        paths.add(new PartialPath("root.d1.s1"));
        Assert.assertEquals(paths, (Object)((DeleteDataOperator)op).getPaths());
        Assert.assertEquals((long)1L, (long)((DeleteDataOperator)op).getStartTime());
        Assert.assertEquals((long)2L, (long)((DeleteDataOperator)op).getEndTime());
        String sql2 = "delete from root.d1.s1 where time>=1";
        op = LogicalGenerator.generate((String)sql2, (ZoneId)ZoneId.systemDefault());
        Assert.assertEquals(paths, (Object)((DeleteDataOperator)op).getPaths());
        Assert.assertEquals((long)1L, (long)((DeleteDataOperator)op).getStartTime());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)((DeleteDataOperator)op).getEndTime());
        String sql3 = "delete from root.d1.s1 where time>1";
        op = LogicalGenerator.generate((String)sql3, (ZoneId)ZoneId.systemDefault());
        Assert.assertEquals(paths, (Object)((DeleteDataOperator)op).getPaths());
        Assert.assertEquals((long)2L, (long)((DeleteDataOperator)op).getStartTime());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)((DeleteDataOperator)op).getEndTime());
        String sql4 = "delete from root.d1.s1 where time <= 1";
        op = LogicalGenerator.generate((String)sql4, (ZoneId)ZoneId.systemDefault());
        Assert.assertEquals(paths, (Object)((DeleteDataOperator)op).getPaths());
        Assert.assertEquals((long)Long.MIN_VALUE, (long)((DeleteDataOperator)op).getStartTime());
        Assert.assertEquals((long)1L, (long)((DeleteDataOperator)op).getEndTime());
        String sql5 = "delete from root.d1.s1 where time<1";
        op = LogicalGenerator.generate((String)sql5, (ZoneId)ZoneId.systemDefault());
        Assert.assertEquals(paths, (Object)((DeleteDataOperator)op).getPaths());
        Assert.assertEquals((long)Long.MIN_VALUE, (long)((DeleteDataOperator)op).getStartTime());
        Assert.assertEquals((long)0L, (long)((DeleteDataOperator)op).getEndTime());
        String sql6 = "delete from root.d1.s1 where time = 3";
        op = LogicalGenerator.generate((String)sql6, (ZoneId)ZoneId.systemDefault());
        Assert.assertEquals(paths, (Object)((DeleteDataOperator)op).getPaths());
        Assert.assertEquals((long)3L, (long)((DeleteDataOperator)op).getStartTime());
        Assert.assertEquals((long)3L, (long)((DeleteDataOperator)op).getEndTime());
        String sql7 = "delete from root.d1.s1 where time > 5 and time >= 2";
        op = LogicalGenerator.generate((String)sql7, (ZoneId)ZoneId.systemDefault());
        Assert.assertEquals(paths, (Object)((DeleteDataOperator)op).getPaths());
        Assert.assertEquals((long)6L, (long)((DeleteDataOperator)op).getStartTime());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)((DeleteDataOperator)op).getEndTime());
    }

    @Test
    public void testErrorDeleteRange() {
        String sql = "delete from root.d1.s1 where time>=1 and time < 3 or time >1";
        String errorMsg = null;
        try {
            LogicalGenerator.generate((String)sql, (ZoneId)ZoneId.systemDefault());
        }
        catch (SemanticException e) {
            errorMsg = e.getMessage();
        }
        Assert.assertEquals((Object)"For delete statement, where clause can only contain atomic expressions like : time > XXX, time <= XXX, or two atomic expressions connected by 'AND'", (Object)errorMsg);
        sql = "delete from root.d1.s1 where time>=1 or time < 3";
        errorMsg = null;
        try {
            LogicalGenerator.generate((String)sql, (ZoneId)ZoneId.systemDefault());
        }
        catch (SemanticException e) {
            errorMsg = e.getMessage();
        }
        Assert.assertEquals((Object)"For delete statement, where clause can only contain atomic expressions like : time > XXX, time <= XXX, or two atomic expressions connected by 'AND'", (Object)errorMsg);
        String sql7 = "delete from root.d1.s1 where time = 1 and time < -1";
        errorMsg = null;
        try {
            LogicalGenerator.generate((String)sql7, (ZoneId)ZoneId.systemDefault());
        }
        catch (RuntimeException e) {
            errorMsg = e.getMessage();
        }
        Assert.assertEquals((Object)"Invalid delete range: [1, -2]", (Object)errorMsg);
        sql = "delete from root.d1.s1 where time > 5 and time <= 0";
        errorMsg = null;
        try {
            LogicalGenerator.generate((String)sql, (ZoneId)ZoneId.systemDefault());
        }
        catch (SQLParserException e) {
            errorMsg = e.getMessage();
        }
        Assert.assertEquals((Object)"Invalid delete range: [6, 0]", (Object)errorMsg);
    }

    @Test
    public void testRegexpQuery() {
        String sqlStr = "SELECT a FROM root.sg.* WHERE a REGEXP 'string'";
        Operator op = LogicalGenerator.generate((String)sqlStr, (ZoneId)ZoneId.systemDefault());
        Assert.assertEquals(QueryOperator.class, op.getClass());
        QueryOperator queryOperator = (QueryOperator)op;
        Assert.assertEquals((Object)Operator.OperatorType.QUERY, (Object)queryOperator.getType());
        Assert.assertEquals((Object)"a", (Object)((ResultColumn)queryOperator.getSelectComponent().getResultColumns().get(0)).getExpression().toString());
        Assert.assertEquals((Object)"root.sg.*", (Object)((PartialPath)queryOperator.getFromComponent().getPrefixPaths().get(0)).getFullPath());
    }
}

