/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.influxdb.sql;

import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.mpp.plan.expression.ResultColumn;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.protocol.influxdb.operator.InfluxQueryOperator;
import org.apache.iotdb.db.protocol.influxdb.sql.InfluxDBLogicalGenerator;
import org.apache.iotdb.db.qp.logical.crud.BasicFunctionOperator;
import org.apache.iotdb.db.qp.logical.crud.FilterOperator;
import org.apache.iotdb.db.qp.logical.crud.WhereComponent;
import org.junit.Assert;
import org.junit.Test;

public class InfluxDBLogicalGeneratorTest {
    @Test
    public void testParserSql1() {
        InfluxQueryOperator operator = (InfluxQueryOperator)InfluxDBLogicalGenerator.generate((String)"SELECT * FROM h2o_feet");
        List resultColumnList = operator.getSelectComponent().getResultColumns();
        Assert.assertEquals((long)resultColumnList.size(), (long)1L);
        TimeSeriesOperand timeSeriesOperand = (TimeSeriesOperand)((ResultColumn)resultColumnList.get(0)).getExpression();
        Assert.assertEquals((Object)timeSeriesOperand.getPath().getFullPath(), (Object)"*");
        Assert.assertEquals((Object)((PartialPath)operator.getFromComponent().getPrefixPaths().get(0)).getFullPath(), (Object)"h2o_feet");
        Assert.assertNull((Object)operator.getWhereComponent());
    }

    @Test
    public void testParserSql2() {
        InfluxQueryOperator operator = (InfluxQueryOperator)InfluxDBLogicalGenerator.generate((String)"SELECT a,b,c FROM h2o_feet where a>1 and b<1");
        List resultColumnList = operator.getSelectComponent().getResultColumns();
        Assert.assertEquals((long)resultColumnList.size(), (long)3L);
        TimeSeriesOperand timeSeriesOperand = (TimeSeriesOperand)((ResultColumn)resultColumnList.get(0)).getExpression();
        Assert.assertEquals((Object)timeSeriesOperand.getPath().getFullPath(), (Object)"a");
        WhereComponent whereComponent = operator.getWhereComponent();
        FilterOperator filterOperator = whereComponent.getFilterOperator();
        Assert.assertEquals((Object)filterOperator.getFilterType().toString(), (Object)"KW_AND");
        Assert.assertEquals((long)filterOperator.getChildren().size(), (long)2L);
        BasicFunctionOperator basicFunctionOperator = (BasicFunctionOperator)filterOperator.getChildren().get(0);
        Assert.assertEquals((Object)basicFunctionOperator.getValue(), (Object)"1");
        Assert.assertEquals((Object)basicFunctionOperator.getSinglePath().getFullPath(), (Object)"a");
        Assert.assertNotNull((Object)basicFunctionOperator.getFilterType());
    }
}

