/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.plan.node.write;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.mpp.common.QueryId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.write.InvalidateSchemaCacheNode;
import org.junit.Assert;
import org.junit.Test;

public class InvalidateSchemaCacheNodeSerdeTest {
    @Test
    public void testSerializeAndDeserialize() throws IllegalPathException {
        PlanNodeId planNodeId = new PlanNodeId("InvalidateSchemaCacheNode");
        QueryId queryId = new QueryId("query");
        ArrayList<PartialPath> pathList = new ArrayList<PartialPath>();
        pathList.add(new PartialPath("root.sg.d1.s1"));
        pathList.add(new PartialPath("root.sg.d2.*"));
        ArrayList<String> storageGroups = new ArrayList<String>();
        storageGroups.add("root.sg1");
        storageGroups.add("root.sg2");
        InvalidateSchemaCacheNode invalidateSchemaCacheNode = new InvalidateSchemaCacheNode(planNodeId, queryId, pathList, storageGroups);
        ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
        invalidateSchemaCacheNode.serialize(byteBuffer);
        byteBuffer.flip();
        PlanNode deserializedNode = PlanNodeType.deserialize((ByteBuffer)byteBuffer);
        Assert.assertTrue((boolean)(deserializedNode instanceof InvalidateSchemaCacheNode));
        Assert.assertEquals((Object)planNodeId, (Object)deserializedNode.getPlanNodeId());
        invalidateSchemaCacheNode = (InvalidateSchemaCacheNode)deserializedNode;
        Assert.assertEquals((Object)queryId, (Object)invalidateSchemaCacheNode.getQueryId());
        List deserializedPathList = invalidateSchemaCacheNode.getPathList();
        Assert.assertEquals((long)pathList.size(), (long)deserializedPathList.size());
        for (int i = 0; i < pathList.size(); ++i) {
            Assert.assertEquals(pathList.get(i), deserializedPathList.get(i));
        }
        List deserializedStorageGroups = invalidateSchemaCacheNode.getStorageGroups();
        Assert.assertEquals((long)storageGroups.size(), (long)deserializedStorageGroups.size());
        for (int i = 0; i < storageGroups.size(); ++i) {
            Assert.assertEquals(storageGroups.get(i), deserializedStorageGroups.get(i));
        }
    }
}

