/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.plan.node.sink;

import java.nio.ByteBuffer;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.mpp.common.FragmentInstanceId;
import org.apache.iotdb.db.mpp.common.PlanFragmentId;
import org.apache.iotdb.db.mpp.plan.plan.node.PlanNodeDeserializeHelper;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.DevicesSchemaScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.sink.FragmentSinkNode;
import org.junit.Assert;
import org.junit.Test;

public class FragmentSinkNodeSerdeTest {
    @Test
    public void testSerializeAndDeserialize() throws IllegalPathException {
        FragmentSinkNode fragmentSinkNode = new FragmentSinkNode(new PlanNodeId("TestFragmentSinkNode"));
        fragmentSinkNode.addChild((PlanNode)new DevicesSchemaScanNode(new PlanNodeId("deviceSchema"), new PartialPath("root.sg.device0"), 0, 0, false, false));
        fragmentSinkNode.setDownStream(new TEndPoint("127.0.0.1", 6666), new FragmentInstanceId(new PlanFragmentId("q", 1), "ds"), new PlanNodeId("test"));
        ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
        fragmentSinkNode.serialize(byteBuffer);
        byteBuffer.flip();
        Assert.assertEquals((Object)PlanNodeDeserializeHelper.deserialize(byteBuffer), (Object)fragmentSinkNode);
    }
}

