/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.plan.node.process;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.mpp.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.mpp.plan.plan.node.PlanNodeDeserializeHelper;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.GroupByTagNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.SeriesAggregationScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.AggregationDescriptor;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.AggregationStep;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.CrossSeriesAggregationDescriptor;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.GroupByTimeParameter;
import org.apache.iotdb.db.mpp.plan.statement.component.Ordering;
import org.apache.iotdb.db.query.aggregation.AggregationType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.junit.Assert;
import org.junit.Test;

public class GroupByTagNodeSerdeTest {
    @Test
    public void testSerializeAndDeserialize() throws IllegalPathException, IOException {
        GroupByTimeParameter groupByTimeParameter = new GroupByTimeParameter(1L, 100L, 1L, 1L, true, true, true);
        CrossSeriesAggregationDescriptor s1MaxTime = new CrossSeriesAggregationDescriptor(AggregationType.MAX_TIME.name().toLowerCase(), AggregationStep.FINAL, Collections.singletonList(new TimeSeriesOperand(new PartialPath("root.sg.d1.s1"))), (Expression)new FunctionExpression("max_time", new LinkedHashMap(), Collections.singletonList(new TimeSeriesOperand(new PartialPath("root.sg.d1.s1")))));
        CrossSeriesAggregationDescriptor s1Avg = new CrossSeriesAggregationDescriptor(AggregationType.AVG.name().toLowerCase(), AggregationStep.FINAL, Collections.singletonList(new TimeSeriesOperand(new PartialPath("root.sg.d1.s1"))), (Expression)new FunctionExpression("avg", new LinkedHashMap(), Collections.singletonList(new TimeSeriesOperand(new PartialPath("root.sg.d1.s1")))));
        AggregationDescriptor s1MaxTimePartial = new AggregationDescriptor(AggregationType.MAX_TIME.name().toLowerCase(), AggregationStep.PARTIAL, Collections.singletonList(new TimeSeriesOperand(new PartialPath("root.sg.d1.s1"))));
        AggregationDescriptor s1AvgTimePartial = new AggregationDescriptor(AggregationType.AVG.name().toLowerCase(), AggregationStep.PARTIAL, Collections.singletonList(new TimeSeriesOperand(new PartialPath("root.sg.d1.s1"))));
        HashMap<List<String>, List<CrossSeriesAggregationDescriptor>> tagValuesToAggregationDescriptors = new HashMap<List<String>, List<CrossSeriesAggregationDescriptor>>();
        tagValuesToAggregationDescriptors.put(Arrays.asList("v1", "v2"), Arrays.asList(s1MaxTime, s1Avg));
        GroupByTagNode expectedNode = new GroupByTagNode(new PlanNodeId("TestGroupByTagNode"), Collections.singletonList(new SeriesAggregationScanNode(new PlanNodeId("TestSeriesAggregateScanNode1"), new MeasurementPath("root.sg.d1.s1", TSDataType.INT32), Arrays.asList(s1MaxTimePartial, s1AvgTimePartial), Ordering.ASC, null, groupByTimeParameter, null)), groupByTimeParameter, Ordering.ASC, Collections.singletonList("k1"), tagValuesToAggregationDescriptors, Arrays.asList("MAX_TIME(root.sg.d1.s1)", "AVG(root.sg.d1.s1)"));
        ByteBuffer byteBuffer = ByteBuffer.allocate(4096);
        expectedNode.serialize(byteBuffer);
        byteBuffer.flip();
        Assert.assertEquals((Object)expectedNode, (Object)PlanNodeDeserializeHelper.deserialize(byteBuffer));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(baos);
        expectedNode.serialize(dataOutputStream);
        byte[] byteArray = baos.toByteArray();
        ByteBuffer buffer = ByteBuffer.wrap(byteArray);
        Assert.assertEquals((Object)expectedNode, (Object)PlanNodeDeserializeHelper.deserialize(buffer));
    }
}

