/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.plan.node.process;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.mpp.plan.plan.node.PlanNodeDeserializeHelper;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.GroupByLevelNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.SeriesAggregationScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.AggregationDescriptor;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.AggregationStep;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.CrossSeriesAggregationDescriptor;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.GroupByTimeParameter;
import org.apache.iotdb.db.mpp.plan.statement.component.Ordering;
import org.apache.iotdb.db.query.aggregation.AggregationType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.junit.Assert;
import org.junit.Test;

public class GroupByLevelNodeSerdeTest {
    @Test
    public void testSerializeAndDeserialize() throws IllegalPathException, IOException {
        GroupByTimeParameter groupByTimeParameter = new GroupByTimeParameter(1L, 100L, 1L, 1L, true, true, true);
        SeriesAggregationScanNode seriesAggregationScanNode1 = new SeriesAggregationScanNode(new PlanNodeId("TestSeriesAggregateScanNode"), new MeasurementPath("root.sg.d1.s1", TSDataType.INT32), Collections.singletonList(new AggregationDescriptor(AggregationType.MAX_TIME.name().toLowerCase(), AggregationStep.FINAL, Collections.singletonList(new TimeSeriesOperand(new PartialPath("root.sg.d1.s1"))))), Ordering.ASC, null, groupByTimeParameter, null);
        SeriesAggregationScanNode seriesAggregationScanNode2 = new SeriesAggregationScanNode(new PlanNodeId("TestSeriesAggregateScanNode"), new MeasurementPath("root.sg.d2.s1", TSDataType.INT32), Collections.singletonList(new AggregationDescriptor(AggregationType.MAX_TIME.name().toLowerCase(), AggregationStep.FINAL, Collections.singletonList(new TimeSeriesOperand(new PartialPath("root.sg.d2.s1"))))), Ordering.ASC, null, groupByTimeParameter, null);
        GroupByLevelNode groupByLevelNode = new GroupByLevelNode(new PlanNodeId("TestGroupByLevelNode"), Arrays.asList(seriesAggregationScanNode1, seriesAggregationScanNode2), Collections.singletonList(new CrossSeriesAggregationDescriptor(AggregationType.MAX_TIME.name().toLowerCase(), AggregationStep.FINAL, Arrays.asList(new TimeSeriesOperand(new PartialPath("root.sg.d1.s1")), new TimeSeriesOperand(new PartialPath("root.sg.d2.s1"))), (Expression)new TimeSeriesOperand(new PartialPath("root.sg.*.s1")))), groupByTimeParameter, Ordering.ASC);
        ByteBuffer byteBuffer = ByteBuffer.allocate(2048);
        groupByLevelNode.serialize(byteBuffer);
        byteBuffer.flip();
        Assert.assertEquals((Object)PlanNodeDeserializeHelper.deserialize(byteBuffer), (Object)groupByLevelNode);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(baos);
        groupByLevelNode.serialize(dataOutputStream);
        byte[] byteArray = baos.toByteArray();
        ByteBuffer buffer = ByteBuffer.wrap(byteArray);
        Assert.assertEquals((Object)PlanNodeDeserializeHelper.deserialize(buffer), (Object)groupByLevelNode);
    }
}

