/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.plan.node.process;

import java.nio.ByteBuffer;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.db.mpp.common.FragmentInstanceId;
import org.apache.iotdb.db.mpp.common.PlanFragmentId;
import org.apache.iotdb.db.mpp.plan.plan.node.PlanNodeDeserializeHelper;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.ExchangeNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.TimeJoinNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.sink.FragmentSinkNode;
import org.apache.iotdb.db.mpp.plan.statement.component.Ordering;
import org.junit.Assert;
import org.junit.Test;

public class ExchangeNodeSerdeTest {
    @Test
    public void testSerializeAndDeserialize() throws IllegalPathException {
        TimeJoinNode timeJoinNode = new TimeJoinNode(new PlanNodeId("TestTimeJoinNode"), Ordering.ASC);
        ExchangeNode exchangeNode = new ExchangeNode(new PlanNodeId("TestExchangeNode"));
        FragmentSinkNode fragmentSinkNode = new FragmentSinkNode(new PlanNodeId("TestFragmentSinkNode"));
        fragmentSinkNode.setDownStream(new TEndPoint("127.0.0.1", 6666), new FragmentInstanceId(new PlanFragmentId("q", 1), "ds"), new PlanNodeId("test"));
        fragmentSinkNode.addChild((PlanNode)timeJoinNode);
        exchangeNode.setRemoteSourceNode(fragmentSinkNode);
        exchangeNode.setUpstream(new TEndPoint("127.0.0.1", 6666), new FragmentInstanceId(new PlanFragmentId("q", 1), "ds"), new PlanNodeId("test"));
        ByteBuffer byteBuffer = ByteBuffer.allocate(10240);
        exchangeNode.serialize(byteBuffer);
        byteBuffer.flip();
        Assert.assertEquals((Object)PlanNodeDeserializeHelper.deserialize(byteBuffer), (Object)exchangeNode);
    }
}

