/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.plan.node.process;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.db.mpp.plan.plan.node.PlanNodeDeserializeHelper;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.DeviceViewNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.TimeJoinNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.OrderByParameter;
import org.apache.iotdb.db.mpp.plan.statement.component.Ordering;
import org.apache.iotdb.db.mpp.plan.statement.component.SortItem;
import org.apache.iotdb.db.mpp.plan.statement.component.SortKey;
import org.junit.Assert;
import org.junit.Test;

public class DeviceViewNodeSerdeTest {
    @Test
    public void testSerializeAndDeserialize() throws IllegalPathException {
        TimeJoinNode timeJoinNode1 = new TimeJoinNode(new PlanNodeId("TestTimeJoinNode"), Ordering.ASC);
        TimeJoinNode timeJoinNode2 = new TimeJoinNode(new PlanNodeId("TestTimeJoinNode"), Ordering.ASC);
        DeviceViewNode deviceViewNode = new DeviceViewNode(new PlanNodeId("TestDeviceMergeNode"), new OrderByParameter(Arrays.asList(new SortItem(SortKey.DEVICE, Ordering.ASC), new SortItem(SortKey.TIME, Ordering.DESC))), Arrays.asList("s1", "s2"), new HashMap());
        deviceViewNode.addChildDeviceNode("root.sg.d1", (PlanNode)timeJoinNode1);
        deviceViewNode.addChildDeviceNode("root.sg.d2", (PlanNode)timeJoinNode2);
        ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
        deviceViewNode.serialize(byteBuffer);
        byteBuffer.flip();
        Assert.assertEquals((Object)PlanNodeDeserializeHelper.deserialize(byteBuffer), (Object)deviceViewNode);
    }
}

