/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.plan.node.metadata.write;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.write.DeleteTimeSeriesNode;
import org.junit.Assert;
import org.junit.Test;

public class DeleteTimeSeriesNodeSerdeTest {
    @Test
    public void testSerializeAndDeserialize() throws IllegalPathException {
        PlanNodeId planNodeId = new PlanNodeId("DeleteTimeSeriesNode");
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendPathPattern(new PartialPath("root.sg.d1.s1"));
        patternTree.appendPathPattern(new PartialPath("root.sg.d2.*"));
        patternTree.constructTree();
        DeleteTimeSeriesNode deleteTimeSeriesNode = new DeleteTimeSeriesNode(planNodeId, patternTree);
        ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
        deleteTimeSeriesNode.serialize(byteBuffer);
        byteBuffer.flip();
        PlanNode deserializedNode = PlanNodeType.deserialize((ByteBuffer)byteBuffer);
        Assert.assertTrue((boolean)(deserializedNode instanceof DeleteTimeSeriesNode));
        Assert.assertEquals((Object)planNodeId, (Object)deserializedNode.getPlanNodeId());
        deleteTimeSeriesNode = (DeleteTimeSeriesNode)deserializedNode;
        PathPatternTree deserializedPatternTree = deleteTimeSeriesNode.getPatternTree();
        List pathList = patternTree.getAllPathPatterns();
        List deserializedPathList = deserializedPatternTree.getAllPathPatterns();
        Assert.assertEquals((long)pathList.size(), (long)deserializedPathList.size());
        for (int i = 0; i < pathList.size(); ++i) {
            Assert.assertEquals(pathList.get(i), deserializedPathList.get(i));
        }
    }
}

