/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.plan.distribution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.mpp.common.MPPQueryContext;
import org.apache.iotdb.db.mpp.common.QueryId;
import org.apache.iotdb.db.mpp.plan.analyze.Analysis;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.mpp.plan.plan.distribution.Util;
import org.apache.iotdb.db.mpp.plan.planner.distribution.DistributionPlanner;
import org.apache.iotdb.db.mpp.plan.planner.plan.DistributedQueryPlan;
import org.apache.iotdb.db.mpp.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.mpp.plan.planner.plan.LogicalQueryPlan;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.AggregationNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.DeviceMergeNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.DeviceViewNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.GroupByLevelNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.SlidingWindowAggregationNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.TimeJoinNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.SeriesAggregationScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.SeriesAggregationSourceNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.AggregationDescriptor;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.AggregationStep;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.CrossSeriesAggregationDescriptor;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.GroupByTimeParameter;
import org.apache.iotdb.db.mpp.plan.statement.component.Ordering;
import org.apache.iotdb.db.query.aggregation.AggregationType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.junit.Assert;
import org.junit.Test;

public class AggregationDistributionTest {
    @Test
    public void testAggregation1Series2Regions() throws IllegalPathException {
        QueryId queryId = new QueryId("test_1_series_2_regions");
        MPPQueryContext context = new MPPQueryContext("", queryId, null, new TEndPoint(), new TEndPoint());
        String sql = "select count(s1) from root.sg.d1";
        String d1s1Path = "root.sg.d1.s1";
        Analysis analysis = Util.analyze(sql, context);
        PlanNode rootNode = Util.genLogicalPlan(analysis, context);
        DistributionPlanner planner = new DistributionPlanner(analysis, new LogicalQueryPlan(context, rootNode));
        DistributedQueryPlan plan = planner.planFragments();
        Assert.assertEquals((long)2L, (long)plan.getInstances().size());
        HashMap<String, AggregationStep> expectedStep = new HashMap<String, AggregationStep>();
        expectedStep.put(d1s1Path, AggregationStep.PARTIAL);
        List fragmentInstances = plan.getInstances();
        fragmentInstances.forEach(f -> this.verifyAggregationStep(expectedStep, f.getFragment().getPlanNodeTree()));
        AggregationNode aggregationNode = (AggregationNode)((FragmentInstance)fragmentInstances.get(0)).getFragment().getPlanNodeTree().getChildren().get(0);
        Assert.assertEquals((Object)AggregationStep.FINAL, (Object)((AggregationDescriptor)aggregationNode.getAggregationDescriptorList().get(0)).getStep());
    }

    @Test
    public void testAggregation1Series2RegionsWithSlidingWindow() throws IllegalPathException {
        QueryId queryId = new QueryId("test_1_series_2_regions_sliding_window");
        MPPQueryContext context = new MPPQueryContext("", queryId, null, new TEndPoint(), new TEndPoint());
        String sql = "select count(s1) from root.sg.d1 group by ([0, 100), 5ms, 1ms)";
        String d1s1Path = "root.sg.d1.s1";
        Analysis analysis = Util.analyze(sql, context);
        PlanNode rootNode = Util.genLogicalPlan(analysis, context);
        DistributionPlanner planner = new DistributionPlanner(analysis, new LogicalQueryPlan(context, rootNode));
        DistributedQueryPlan plan = planner.planFragments();
        Assert.assertEquals((long)2L, (long)plan.getInstances().size());
        HashMap<String, AggregationStep> expectedStep = new HashMap<String, AggregationStep>();
        expectedStep.put(d1s1Path, AggregationStep.PARTIAL);
        List fragmentInstances = plan.getInstances();
        fragmentInstances.forEach(f -> this.verifyAggregationStep(expectedStep, f.getFragment().getPlanNodeTree()));
        AggregationNode aggregationNode = (AggregationNode)((PlanNode)((FragmentInstance)fragmentInstances.get(0)).getFragment().getPlanNodeTree().getChildren().get(0)).getChildren().get(0);
        Assert.assertEquals((Object)AggregationStep.INTERMEDIATE, (Object)((AggregationDescriptor)aggregationNode.getAggregationDescriptorList().get(0)).getStep());
    }

    @Test
    public void testTimeJoinAggregationSinglePerRegion() throws IllegalPathException {
        QueryId queryId = new QueryId("test_query_time_join_aggregation");
        MPPQueryContext context = new MPPQueryContext("", queryId, null, new TEndPoint(), new TEndPoint());
        String sql = "select count(s1) from root.sg.d1, root.sg.d22";
        String d1s1Path = "root.sg.d1.s1";
        String d2s1Path = "root.sg.d22.s1";
        Analysis analysis = Util.analyze(sql, context);
        PlanNode timeJoinNode = Util.genLogicalPlan(analysis, context);
        DistributionPlanner planner = new DistributionPlanner(analysis, new LogicalQueryPlan(context, timeJoinNode));
        DistributedQueryPlan plan = planner.planFragments();
        Assert.assertEquals((long)3L, (long)plan.getInstances().size());
        HashMap<String, AggregationStep> expectedStep = new HashMap<String, AggregationStep>();
        expectedStep.put(d1s1Path, AggregationStep.PARTIAL);
        expectedStep.put(d2s1Path, AggregationStep.PARTIAL);
        List fragmentInstances = plan.getInstances();
        fragmentInstances.forEach(f -> this.verifyAggregationStep(expectedStep, f.getFragment().getPlanNodeTree()));
    }

    private void verifyAggregationStep(Map<String, AggregationStep> expected, PlanNode root) {
        if (root == null) {
            return;
        }
        if (root instanceof SeriesAggregationSourceNode) {
            SeriesAggregationSourceNode handle = (SeriesAggregationSourceNode)root;
            List descriptorList = handle.getAggregationDescriptorList();
            descriptorList.forEach(d -> Assert.assertEquals(expected.get(handle.getPartitionPath().getFullPath()), (Object)d.getStep()));
        }
        root.getChildren().forEach(child -> this.verifyAggregationStep(expected, (PlanNode)child));
    }

    @Test
    public void testTimeJoinAggregationWithSlidingWindow() throws IllegalPathException {
        QueryId queryId = new QueryId("test_query_time_join_agg_with_sliding");
        MPPQueryContext context = new MPPQueryContext("", queryId, null, new TEndPoint(), new TEndPoint());
        String d1s1Path = "root.sg.d1.s1";
        String d3s1Path = "root.sg.d333.s1";
        String sql = "select count(s1) from root.sg.d1,root.sg.d333 group by ([0, 50), 5ms, 3ms)";
        Analysis analysis = Util.analyze(sql, context);
        PlanNode slidingWindowAggregationNode = Util.genLogicalPlan(analysis, context);
        DistributionPlanner planner = new DistributionPlanner(analysis, new LogicalQueryPlan(context, slidingWindowAggregationNode));
        DistributedQueryPlan plan = planner.planFragments();
        Assert.assertEquals((long)3L, (long)plan.getInstances().size());
        HashMap<String, AggregationStep> expectedStep = new HashMap<String, AggregationStep>();
        expectedStep.put(d1s1Path, AggregationStep.PARTIAL);
        expectedStep.put(d3s1Path, AggregationStep.PARTIAL);
        List fragmentInstances = plan.getInstances();
        fragmentInstances.forEach(f -> this.verifyAggregationStep(expectedStep, f.getFragment().getPlanNodeTree()));
        AggregationNode aggregationNode = (AggregationNode)((PlanNode)((FragmentInstance)fragmentInstances.get(0)).getFragment().getPlanNodeTree().getChildren().get(0)).getChildren().get(0);
        aggregationNode.getAggregationDescriptorList().forEach(d -> Assert.assertEquals((Object)AggregationStep.INTERMEDIATE, (Object)d.getStep()));
    }

    @Test
    public void testTimeJoinAggregationMultiPerRegion() throws IllegalPathException {
        QueryId queryId = new QueryId("test_query_time_join_aggregation");
        MPPQueryContext context = new MPPQueryContext("", queryId, null, new TEndPoint(), new TEndPoint());
        String d1s1Path = "root.sg.d1.s1";
        String d3s1Path = "root.sg.d333.s1";
        String sql = "select count(s1) from root.sg.d1, root.sg.d333";
        Analysis analysis = Util.analyze(sql, context);
        PlanNode timeJoinNode = Util.genLogicalPlan(analysis, context);
        DistributionPlanner planner = new DistributionPlanner(analysis, new LogicalQueryPlan(context, timeJoinNode));
        DistributedQueryPlan plan = planner.planFragments();
        Assert.assertEquals((long)3L, (long)plan.getInstances().size());
        HashMap<String, AggregationStep> expectedStep = new HashMap<String, AggregationStep>();
        expectedStep.put(d1s1Path, AggregationStep.PARTIAL);
        expectedStep.put(d3s1Path, AggregationStep.PARTIAL);
        List fragmentInstances = plan.getInstances();
        fragmentInstances.forEach(f -> this.verifyAggregationStep(expectedStep, f.getFragment().getPlanNodeTree()));
    }

    @Test
    public void testTimeJoinAggregationMultiPerRegion2() throws IllegalPathException {
        QueryId queryId = new QueryId("test_query_time_join_aggregation");
        MPPQueryContext context = new MPPQueryContext("", queryId, null, new TEndPoint(), new TEndPoint());
        String d3s1Path = "root.sg.d333.s1";
        String d4s1Path = "root.sg.d4444.s1";
        String sql = "select count(s1) from root.sg.d333, root.sg.d4444";
        Analysis analysis = Util.analyze(sql, context);
        PlanNode timeJoinNode = Util.genLogicalPlan(analysis, context);
        DistributionPlanner planner = new DistributionPlanner(analysis, new LogicalQueryPlan(context, timeJoinNode));
        DistributedQueryPlan plan = planner.planFragments();
        Assert.assertEquals((long)2L, (long)plan.getInstances().size());
        HashMap<String, AggregationStep> expectedStep = new HashMap<String, AggregationStep>();
        expectedStep.put(d3s1Path, AggregationStep.PARTIAL);
        expectedStep.put(d4s1Path, AggregationStep.PARTIAL);
        List fragmentInstances = plan.getInstances();
        fragmentInstances.forEach(f -> this.verifyAggregationStep(expectedStep, f.getFragment().getPlanNodeTree()));
    }

    @Test
    public void testGroupByLevelWithTwoChildren() throws IllegalPathException {
        QueryId queryId = new QueryId("test_group_by_level_two_children");
        String d1s1Path = "root.sg.d1.s1";
        String d2s1Path = "root.sg.d22.s1";
        String groupedPath = "root.sg.*.s1";
        GroupByLevelNode groupByLevelNode = new GroupByLevelNode(new PlanNodeId("TestGroupByLevelNode"), Arrays.asList(this.genAggregationSourceNode(queryId, d1s1Path, AggregationType.COUNT), this.genAggregationSourceNode(queryId, d2s1Path, AggregationType.COUNT)), Collections.singletonList(new CrossSeriesAggregationDescriptor(AggregationType.COUNT.name().toLowerCase(), AggregationStep.FINAL, Arrays.asList(new TimeSeriesOperand(new PartialPath(d1s1Path)), new TimeSeriesOperand(new PartialPath(d2s1Path))), (Expression)new TimeSeriesOperand(new PartialPath(groupedPath)))), null, Ordering.ASC);
        Analysis analysis = Util.constructAnalysis();
        MPPQueryContext context = new MPPQueryContext("", queryId, null, new TEndPoint(), new TEndPoint());
        DistributionPlanner planner = new DistributionPlanner(analysis, new LogicalQueryPlan(context, (PlanNode)groupByLevelNode));
        DistributedQueryPlan plan = planner.planFragments();
        Assert.assertEquals((long)3L, (long)plan.getInstances().size());
        HashMap<String, AggregationStep> expectedStep = new HashMap<String, AggregationStep>();
        expectedStep.put(d1s1Path, AggregationStep.PARTIAL);
        expectedStep.put(d2s1Path, AggregationStep.PARTIAL);
        List fragmentInstances = plan.getInstances();
        fragmentInstances.forEach(f -> this.verifyAggregationStep(expectedStep, f.getFragment().getPlanNodeTree()));
    }

    @Test
    public void testAggregationWithMultiGroupByLevelNode() throws IllegalPathException {
        QueryId queryId = new QueryId("test_group_by_level_two_children");
        String d3s1Path = "root.sg.d333.s1";
        String d4s1Path = "root.sg.d4444.s1";
        String groupedPath = "root.sg.*.s1";
        GroupByLevelNode groupByLevelNode = new GroupByLevelNode(new PlanNodeId("TestGroupByLevelNode"), Arrays.asList(this.genAggregationSourceNode(queryId, d3s1Path, AggregationType.COUNT), this.genAggregationSourceNode(queryId, d4s1Path, AggregationType.COUNT)), Collections.singletonList(new CrossSeriesAggregationDescriptor(AggregationType.COUNT.name().toLowerCase(), AggregationStep.FINAL, Arrays.asList(new TimeSeriesOperand(new PartialPath(d3s1Path)), new TimeSeriesOperand(new PartialPath(d4s1Path))), (Expression)new TimeSeriesOperand(new PartialPath(groupedPath)))), null, Ordering.ASC);
        Analysis analysis = Util.constructAnalysis();
        MPPQueryContext context = new MPPQueryContext("", queryId, null, new TEndPoint(), new TEndPoint());
        DistributionPlanner planner = new DistributionPlanner(analysis, new LogicalQueryPlan(context, (PlanNode)groupByLevelNode));
        DistributedQueryPlan plan = planner.planFragments();
        Assert.assertEquals((long)2L, (long)plan.getInstances().size());
        HashMap<String, AggregationStep> expectedStep = new HashMap<String, AggregationStep>();
        expectedStep.put(d3s1Path, AggregationStep.PARTIAL);
        expectedStep.put(d4s1Path, AggregationStep.PARTIAL);
        List fragmentInstances = plan.getInstances();
        fragmentInstances.forEach(f -> this.verifyAggregationStep(expectedStep, f.getFragment().getPlanNodeTree()));
        HashMap<String, List<String>> expectedDescriptorValue = new HashMap<String, List<String>>();
        expectedDescriptorValue.put(groupedPath, Arrays.asList(groupedPath, d3s1Path, d4s1Path));
        this.verifyGroupByLevelDescriptor(expectedDescriptorValue, (GroupByLevelNode)((FragmentInstance)fragmentInstances.get(0)).getFragment().getPlanNodeTree().getChildren().get(0));
        HashMap<String, List<String>> expectedDescriptorValue2 = new HashMap<String, List<String>>();
        expectedDescriptorValue2.put(groupedPath, Arrays.asList(d3s1Path, d4s1Path));
        this.verifyGroupByLevelDescriptor(expectedDescriptorValue2, (GroupByLevelNode)((FragmentInstance)fragmentInstances.get(1)).getFragment().getPlanNodeTree().getChildren().get(0));
    }

    @Test
    public void testGroupByLevelNodeWithSlidingWindow() throws IllegalPathException {
        QueryId queryId = new QueryId("test_group_by_level_with_sliding_window");
        String d3s1Path = "root.sg.d333.s1";
        String d4s1Path = "root.sg.d4444.s1";
        String groupedPath = "root.sg.*.s1";
        SlidingWindowAggregationNode slidingWindowAggregationNode = this.genSlidingWindowAggregationNode(queryId, Arrays.asList(new PartialPath(d3s1Path), new PartialPath(d4s1Path)), AggregationType.COUNT, AggregationStep.PARTIAL, null);
        TimeJoinNode timeJoinNode = new TimeJoinNode(queryId.genPlanNodeId(), Ordering.ASC);
        timeJoinNode.addChild((PlanNode)this.genAggregationSourceNode(queryId, d3s1Path, AggregationType.COUNT));
        timeJoinNode.addChild((PlanNode)this.genAggregationSourceNode(queryId, d4s1Path, AggregationType.COUNT));
        slidingWindowAggregationNode.addChild((PlanNode)timeJoinNode);
        GroupByLevelNode groupByLevelNode = new GroupByLevelNode(new PlanNodeId("TestGroupByLevelNode"), Collections.singletonList(slidingWindowAggregationNode), Collections.singletonList(new CrossSeriesAggregationDescriptor(AggregationType.COUNT.name().toLowerCase(), AggregationStep.FINAL, Arrays.asList(new TimeSeriesOperand(new PartialPath(d3s1Path)), new TimeSeriesOperand(new PartialPath(d4s1Path))), (Expression)new TimeSeriesOperand(new PartialPath(groupedPath)))), null, Ordering.ASC);
        Analysis analysis = Util.constructAnalysis();
        MPPQueryContext context = new MPPQueryContext("", queryId, null, new TEndPoint(), new TEndPoint());
        DistributionPlanner planner = new DistributionPlanner(analysis, new LogicalQueryPlan(context, (PlanNode)groupByLevelNode));
        DistributedQueryPlan plan = planner.planFragments();
        Assert.assertEquals((long)2L, (long)plan.getInstances().size());
        HashMap<String, AggregationStep> expectedStep = new HashMap<String, AggregationStep>();
        expectedStep.put(d3s1Path, AggregationStep.PARTIAL);
        expectedStep.put(d4s1Path, AggregationStep.PARTIAL);
        List fragmentInstances = plan.getInstances();
        fragmentInstances.forEach(f -> this.verifyAggregationStep(expectedStep, f.getFragment().getPlanNodeTree()));
        HashMap<String, List<String>> expectedDescriptorValue = new HashMap<String, List<String>>();
        expectedDescriptorValue.put(groupedPath, Arrays.asList(groupedPath, d3s1Path, d4s1Path));
        this.verifyGroupByLevelDescriptor(expectedDescriptorValue, (GroupByLevelNode)((FragmentInstance)fragmentInstances.get(0)).getFragment().getPlanNodeTree().getChildren().get(0));
        HashMap<String, List<String>> expectedDescriptorValue2 = new HashMap<String, List<String>>();
        expectedDescriptorValue2.put(groupedPath, Arrays.asList(d3s1Path, d4s1Path));
        this.verifyGroupByLevelDescriptor(expectedDescriptorValue2, (GroupByLevelNode)((FragmentInstance)fragmentInstances.get(1)).getFragment().getPlanNodeTree().getChildren().get(0));
        this.verifySlidingWindowDescriptor(Arrays.asList(d3s1Path, d4s1Path), (SlidingWindowAggregationNode)((PlanNode)((FragmentInstance)fragmentInstances.get(0)).getFragment().getPlanNodeTree().getChildren().get(0)).getChildren().get(0));
        this.verifySlidingWindowDescriptor(Arrays.asList(d3s1Path, d4s1Path), (SlidingWindowAggregationNode)((PlanNode)((FragmentInstance)fragmentInstances.get(1)).getFragment().getPlanNodeTree().getChildren().get(0)).getChildren().get(0));
    }

    @Test
    public void testGroupByLevelTwoSeries() throws IllegalPathException {
        QueryId queryId = new QueryId("test_group_by_level_two_series");
        String d1s1Path = "root.sg.d1.s1";
        String d1s2Path = "root.sg.d1.s2";
        String groupedPathS1 = "root.sg.*.s1";
        String groupedPathS2 = "root.sg.*.s2";
        GroupByLevelNode groupByLevelNode = new GroupByLevelNode(new PlanNodeId("TestGroupByLevelNode"), Arrays.asList(this.genAggregationSourceNode(queryId, d1s1Path, AggregationType.COUNT), this.genAggregationSourceNode(queryId, d1s2Path, AggregationType.COUNT)), Arrays.asList(new CrossSeriesAggregationDescriptor(AggregationType.COUNT.name().toLowerCase(), AggregationStep.FINAL, Collections.singletonList(new TimeSeriesOperand(new PartialPath(d1s1Path))), (Expression)new TimeSeriesOperand(new PartialPath(groupedPathS1))), new CrossSeriesAggregationDescriptor(AggregationType.COUNT.name().toLowerCase(), AggregationStep.FINAL, Collections.singletonList(new TimeSeriesOperand(new PartialPath(d1s2Path))), (Expression)new TimeSeriesOperand(new PartialPath(groupedPathS2)))), null, Ordering.ASC);
        Analysis analysis = Util.constructAnalysis();
        MPPQueryContext context = new MPPQueryContext("", queryId, null, new TEndPoint(), new TEndPoint());
        DistributionPlanner planner = new DistributionPlanner(analysis, new LogicalQueryPlan(context, (PlanNode)groupByLevelNode));
        DistributedQueryPlan plan = planner.planFragments();
        Assert.assertEquals((long)2L, (long)plan.getInstances().size());
        HashMap<String, AggregationStep> expectedStep = new HashMap<String, AggregationStep>();
        expectedStep.put(d1s1Path, AggregationStep.PARTIAL);
        expectedStep.put(d1s2Path, AggregationStep.PARTIAL);
        List fragmentInstances = plan.getInstances();
        fragmentInstances.forEach(f -> this.verifyAggregationStep(expectedStep, f.getFragment().getPlanNodeTree()));
        HashMap<String, List<String>> expectedDescriptorValue = new HashMap<String, List<String>>();
        expectedDescriptorValue.put(groupedPathS1, Arrays.asList(groupedPathS1, d1s1Path));
        expectedDescriptorValue.put(groupedPathS2, Arrays.asList(groupedPathS2, d1s2Path));
        this.verifyGroupByLevelDescriptor(expectedDescriptorValue, (GroupByLevelNode)((FragmentInstance)fragmentInstances.get(0)).getFragment().getPlanNodeTree().getChildren().get(0));
        HashMap<String, List<String>> expectedDescriptorValue2 = new HashMap<String, List<String>>();
        expectedDescriptorValue2.put(groupedPathS1, Collections.singletonList(d1s1Path));
        expectedDescriptorValue2.put(groupedPathS2, Collections.singletonList(d1s2Path));
        this.verifyGroupByLevelDescriptor(expectedDescriptorValue2, (GroupByLevelNode)((FragmentInstance)fragmentInstances.get(1)).getFragment().getPlanNodeTree().getChildren().get(0));
    }

    @Test
    public void testGroupByLevel2Series2Devices3Regions() throws IllegalPathException {
        QueryId queryId = new QueryId("test_group_by_level_two_series");
        String d1s1Path = "root.sg.d1.s1";
        String d1s2Path = "root.sg.d1.s2";
        String d2s1Path = "root.sg.d22.s1";
        String groupedPathS1 = "root.sg.*.s1";
        String groupedPathS2 = "root.sg.*.s2";
        GroupByLevelNode groupByLevelNode = new GroupByLevelNode(new PlanNodeId("TestGroupByLevelNode"), Arrays.asList(this.genAggregationSourceNode(queryId, d1s1Path, AggregationType.COUNT), this.genAggregationSourceNode(queryId, d1s2Path, AggregationType.COUNT), this.genAggregationSourceNode(queryId, d2s1Path, AggregationType.COUNT)), Arrays.asList(new CrossSeriesAggregationDescriptor(AggregationType.COUNT.name().toLowerCase(), AggregationStep.FINAL, Arrays.asList(new TimeSeriesOperand(new PartialPath(d1s1Path)), new TimeSeriesOperand(new PartialPath(d2s1Path))), (Expression)new TimeSeriesOperand(new PartialPath(groupedPathS1))), new CrossSeriesAggregationDescriptor(AggregationType.COUNT.name().toLowerCase(), AggregationStep.FINAL, Collections.singletonList(new TimeSeriesOperand(new PartialPath(d1s2Path))), (Expression)new TimeSeriesOperand(new PartialPath(groupedPathS2)))), null, Ordering.ASC);
        Analysis analysis = Util.constructAnalysis();
        MPPQueryContext context = new MPPQueryContext("", queryId, null, new TEndPoint(), new TEndPoint());
        DistributionPlanner planner = new DistributionPlanner(analysis, new LogicalQueryPlan(context, (PlanNode)groupByLevelNode));
        DistributedQueryPlan plan = planner.planFragments();
        Assert.assertEquals((long)3L, (long)plan.getInstances().size());
        HashMap<String, AggregationStep> expectedStep = new HashMap<String, AggregationStep>();
        expectedStep.put(d1s1Path, AggregationStep.PARTIAL);
        expectedStep.put(d1s2Path, AggregationStep.PARTIAL);
        expectedStep.put(d2s1Path, AggregationStep.PARTIAL);
        List fragmentInstances = plan.getInstances();
        fragmentInstances.forEach(f -> this.verifyAggregationStep(expectedStep, f.getFragment().getPlanNodeTree()));
        HashMap<String, List<String>> expectedDescriptorValue = new HashMap<String, List<String>>();
        expectedDescriptorValue.put(groupedPathS1, Arrays.asList(groupedPathS1, d1s1Path, d2s1Path));
        expectedDescriptorValue.put(groupedPathS2, Arrays.asList(groupedPathS2, d1s2Path));
        this.verifyGroupByLevelDescriptor(expectedDescriptorValue, (GroupByLevelNode)((FragmentInstance)fragmentInstances.get(0)).getFragment().getPlanNodeTree().getChildren().get(0));
        HashMap<String, List<String>> expectedDescriptorValue2 = new HashMap<String, List<String>>();
        expectedDescriptorValue2.put(groupedPathS1, Collections.singletonList(d1s1Path));
        expectedDescriptorValue2.put(groupedPathS2, Collections.singletonList(d1s2Path));
        this.verifyGroupByLevelDescriptor(expectedDescriptorValue2, (GroupByLevelNode)((FragmentInstance)fragmentInstances.get(2)).getFragment().getPlanNodeTree().getChildren().get(0));
    }

    @Test
    public void testGroupByLevelWithSliding2Series2Devices3Regions() throws IllegalPathException {
        QueryId queryId = new QueryId("test_group_by_level_two_series");
        String d1s1Path = "root.sg.d1.s1";
        String d1s2Path = "root.sg.d1.s2";
        String d2s1Path = "root.sg.d22.s1";
        String groupedPathS1 = "root.sg.*.s1";
        String groupedPathS2 = "root.sg.*.s2";
        TimeJoinNode timeJoinNode = new TimeJoinNode(queryId.genPlanNodeId(), Ordering.ASC);
        timeJoinNode.addChild((PlanNode)this.genAggregationSourceNode(queryId, d1s1Path, AggregationType.COUNT));
        timeJoinNode.addChild((PlanNode)this.genAggregationSourceNode(queryId, d1s2Path, AggregationType.COUNT));
        timeJoinNode.addChild((PlanNode)this.genAggregationSourceNode(queryId, d2s1Path, AggregationType.COUNT));
        SlidingWindowAggregationNode slidingWindowAggregationNode = this.genSlidingWindowAggregationNode(queryId, Arrays.asList(new PartialPath(d1s1Path), new PartialPath(d1s2Path), new PartialPath(d2s1Path)), AggregationType.COUNT, AggregationStep.PARTIAL, null);
        slidingWindowAggregationNode.addChild((PlanNode)timeJoinNode);
        GroupByLevelNode groupByLevelNode = new GroupByLevelNode(new PlanNodeId("TestGroupByLevelNode"), Collections.singletonList(slidingWindowAggregationNode), Arrays.asList(new CrossSeriesAggregationDescriptor(AggregationType.COUNT.name().toLowerCase(), AggregationStep.FINAL, Arrays.asList(new TimeSeriesOperand(new PartialPath(d1s1Path)), new TimeSeriesOperand(new PartialPath(d2s1Path))), (Expression)new TimeSeriesOperand(new PartialPath(groupedPathS1))), new CrossSeriesAggregationDescriptor(AggregationType.COUNT.name().toLowerCase(), AggregationStep.FINAL, Collections.singletonList(new TimeSeriesOperand(new PartialPath(d1s2Path))), (Expression)new TimeSeriesOperand(new PartialPath(groupedPathS2)))), null, Ordering.ASC);
        Analysis analysis = Util.constructAnalysis();
        MPPQueryContext context = new MPPQueryContext("", queryId, null, new TEndPoint(), new TEndPoint());
        DistributionPlanner planner = new DistributionPlanner(analysis, new LogicalQueryPlan(context, (PlanNode)groupByLevelNode));
        DistributedQueryPlan plan = planner.planFragments();
        Assert.assertEquals((long)3L, (long)plan.getInstances().size());
        HashMap<String, AggregationStep> expectedStep = new HashMap<String, AggregationStep>();
        expectedStep.put(d1s1Path, AggregationStep.PARTIAL);
        expectedStep.put(d1s2Path, AggregationStep.PARTIAL);
        expectedStep.put(d2s1Path, AggregationStep.PARTIAL);
        List fragmentInstances = plan.getInstances();
        fragmentInstances.forEach(f -> this.verifyAggregationStep(expectedStep, f.getFragment().getPlanNodeTree()));
        HashMap<String, List<String>> expectedDescriptorValue = new HashMap<String, List<String>>();
        expectedDescriptorValue.put(groupedPathS1, Arrays.asList(groupedPathS1, d1s1Path));
        expectedDescriptorValue.put(groupedPathS2, Arrays.asList(groupedPathS2, d1s2Path));
        this.verifyGroupByLevelDescriptor(expectedDescriptorValue, (GroupByLevelNode)((FragmentInstance)fragmentInstances.get(0)).getFragment().getPlanNodeTree().getChildren().get(0));
        HashMap<String, List<String>> expectedDescriptorValue2 = new HashMap<String, List<String>>();
        expectedDescriptorValue2.put(groupedPathS1, Collections.singletonList(d2s1Path));
        this.verifyGroupByLevelDescriptor(expectedDescriptorValue2, (GroupByLevelNode)((FragmentInstance)fragmentInstances.get(1)).getFragment().getPlanNodeTree().getChildren().get(0));
        HashMap<String, List<String>> expectedDescriptorValue3 = new HashMap<String, List<String>>();
        expectedDescriptorValue3.put(groupedPathS1, Collections.singletonList(d1s1Path));
        expectedDescriptorValue3.put(groupedPathS2, Collections.singletonList(d1s2Path));
        this.verifyGroupByLevelDescriptor(expectedDescriptorValue3, (GroupByLevelNode)((FragmentInstance)fragmentInstances.get(2)).getFragment().getPlanNodeTree().getChildren().get(0));
        this.verifySlidingWindowDescriptor(Arrays.asList(d1s1Path, d1s2Path), (SlidingWindowAggregationNode)((PlanNode)((FragmentInstance)fragmentInstances.get(0)).getFragment().getPlanNodeTree().getChildren().get(0)).getChildren().get(0));
        this.verifySlidingWindowDescriptor(Collections.singletonList(d2s1Path), (SlidingWindowAggregationNode)((PlanNode)((FragmentInstance)fragmentInstances.get(1)).getFragment().getPlanNodeTree().getChildren().get(0)).getChildren().get(0));
        this.verifySlidingWindowDescriptor(Arrays.asList(d1s1Path, d1s2Path), (SlidingWindowAggregationNode)((PlanNode)((FragmentInstance)fragmentInstances.get(2)).getFragment().getPlanNodeTree().getChildren().get(0)).getChildren().get(0));
    }

    @Test
    public void testAggregation1Series1Region() throws IllegalPathException {
        QueryId queryId = new QueryId("test_aggregation_1_series_1_region");
        String d2s1Path = "root.sg.d22.s1";
        SeriesAggregationSourceNode root = this.genAggregationSourceNode(queryId, d2s1Path, AggregationType.COUNT);
        Analysis analysis = Util.constructAnalysis();
        MPPQueryContext context = new MPPQueryContext("", queryId, null, new TEndPoint(), new TEndPoint());
        DistributionPlanner planner = new DistributionPlanner(analysis, new LogicalQueryPlan(context, (PlanNode)root));
        DistributedQueryPlan plan = planner.planFragments();
        Assert.assertEquals((long)1L, (long)plan.getInstances().size());
        Assert.assertEquals((Object)root, ((FragmentInstance)plan.getInstances().get(0)).getFragment().getPlanNodeTree().getChildren().get(0));
    }

    @Test
    public void testAlignByDevice1Device2Region() throws IllegalPathException {
        QueryId queryId = new QueryId("test_align_by_device_1_device_2_region");
        MPPQueryContext context = new MPPQueryContext("", queryId, null, new TEndPoint(), new TEndPoint());
        String sql = "select count(s1), count(s2) from root.sg.d1 align by device";
        Analysis analysis = Util.analyze(sql, context);
        PlanNode logicalPlanNode = Util.genLogicalPlan(analysis, context);
        DistributionPlanner planner = new DistributionPlanner(analysis, new LogicalQueryPlan(context, logicalPlanNode));
        DistributedQueryPlan plan = planner.planFragments();
        Assert.assertEquals((long)2L, (long)plan.getInstances().size());
        PlanNode f1Root = (PlanNode)((FragmentInstance)plan.getInstances().get(0)).getFragment().getPlanNodeTree().getChildren().get(0);
        PlanNode f2Root = (PlanNode)((FragmentInstance)plan.getInstances().get(1)).getFragment().getPlanNodeTree().getChildren().get(0);
        Assert.assertTrue((boolean)(f1Root instanceof DeviceViewNode));
        Assert.assertTrue((boolean)(f2Root instanceof TimeJoinNode));
        Assert.assertTrue((boolean)(f1Root.getChildren().get(0) instanceof AggregationNode));
        Assert.assertEquals((long)3L, (long)((PlanNode)f1Root.getChildren().get(0)).getChildren().size());
    }

    @Test
    public void testAlignByDevice2Device3Region() {
        QueryId queryId = new QueryId("test_align_by_device_2_device_3_region");
        MPPQueryContext context = new MPPQueryContext("", queryId, null, new TEndPoint(), new TEndPoint());
        String sql = "select count(s1), count(s2) from root.sg.d1,root.sg.d22 align by device";
        Analysis analysis = Util.analyze(sql, context);
        PlanNode logicalPlanNode = Util.genLogicalPlan(analysis, context);
        DistributionPlanner planner = new DistributionPlanner(analysis, new LogicalQueryPlan(context, logicalPlanNode));
        DistributedQueryPlan plan = planner.planFragments();
        Assert.assertEquals((long)3L, (long)plan.getInstances().size());
        PlanNode f1Root = (PlanNode)((FragmentInstance)plan.getInstances().get(0)).getFragment().getPlanNodeTree().getChildren().get(0);
        PlanNode f2Root = (PlanNode)((FragmentInstance)plan.getInstances().get(1)).getFragment().getPlanNodeTree().getChildren().get(0);
        PlanNode f3Root = (PlanNode)((FragmentInstance)plan.getInstances().get(2)).getFragment().getPlanNodeTree().getChildren().get(0);
        Assert.assertTrue((boolean)(f1Root instanceof DeviceMergeNode));
        Assert.assertTrue((boolean)(f2Root instanceof TimeJoinNode));
        Assert.assertTrue((boolean)(f3Root instanceof DeviceViewNode));
        Assert.assertTrue((boolean)(f3Root.getChildren().get(0) instanceof AggregationNode));
        Assert.assertTrue((boolean)(f1Root.getChildren().get(0) instanceof DeviceViewNode));
        Assert.assertTrue((boolean)(((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0) instanceof AggregationNode));
        Assert.assertEquals((long)3L, (long)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().size());
    }

    @Test
    public void testAlignByDevice2Device2Region() {
        QueryId queryId = new QueryId("test_align_by_device_2_device_2_region");
        MPPQueryContext context = new MPPQueryContext("", queryId, null, new TEndPoint(), new TEndPoint());
        String sql = "select count(s1), count(s2) from root.sg.d333,root.sg.d4444 align by device";
        Analysis analysis = Util.analyze(sql, context);
        PlanNode logicalPlanNode = Util.genLogicalPlan(analysis, context);
        DistributionPlanner planner = new DistributionPlanner(analysis, new LogicalQueryPlan(context, logicalPlanNode));
        DistributedQueryPlan plan = planner.planFragments();
        Assert.assertEquals((long)3L, (long)plan.getInstances().size());
        PlanNode f1Root = (PlanNode)((FragmentInstance)plan.getInstances().get(0)).getFragment().getPlanNodeTree().getChildren().get(0);
        PlanNode f2Root = (PlanNode)((FragmentInstance)plan.getInstances().get(1)).getFragment().getPlanNodeTree().getChildren().get(0);
        Assert.assertTrue((boolean)(f1Root instanceof DeviceViewNode));
        Assert.assertTrue((boolean)(f2Root instanceof TimeJoinNode));
        Assert.assertEquals((long)2L, (long)f1Root.getChildren().size());
    }

    private void verifyGroupByLevelDescriptor(Map<String, List<String>> expected, GroupByLevelNode node) {
        List descriptors = node.getGroupByLevelDescriptors();
        Assert.assertEquals((long)expected.size(), (long)descriptors.size());
        for (CrossSeriesAggregationDescriptor descriptor : descriptors) {
            String outputExpression = descriptor.getOutputExpression().getExpressionString();
            Assert.assertEquals((long)expected.get(outputExpression).size(), (long)descriptor.getInputExpressions().size());
            for (Expression inputExpression : descriptor.getInputExpressions()) {
                Assert.assertTrue((boolean)expected.get(outputExpression).contains(inputExpression.getExpressionString()));
            }
        }
    }

    private void verifySlidingWindowDescriptor(List<String> expected, SlidingWindowAggregationNode node) {
        List descriptorList = node.getAggregationDescriptorList();
        Assert.assertEquals((long)expected.size(), (long)descriptorList.size());
        HashMap verification = new HashMap();
        descriptorList.forEach(d -> verification.put(((Expression)d.getInputExpressions().get(0)).getExpressionString(), 1));
        Assert.assertEquals((long)expected.size(), (long)verification.size());
        expected.forEach(v -> Assert.assertEquals((long)1L, (long)((Integer)verification.get(v)).intValue()));
    }

    private SlidingWindowAggregationNode genSlidingWindowAggregationNode(QueryId queryId, List<PartialPath> paths, AggregationType type, AggregationStep step, GroupByTimeParameter groupByTimeParameter) {
        return new SlidingWindowAggregationNode(queryId.genPlanNodeId(), paths.stream().map(path -> new AggregationDescriptor(type.name().toLowerCase(), step, Collections.singletonList(new TimeSeriesOperand(path)))).collect(Collectors.toList()), groupByTimeParameter, Ordering.ASC);
    }

    private SeriesAggregationSourceNode genAggregationSourceNode(QueryId queryId, String path, AggregationType type) throws IllegalPathException {
        ArrayList<AggregationDescriptor> descriptors = new ArrayList<AggregationDescriptor>();
        descriptors.add(new AggregationDescriptor(type.name().toLowerCase(), AggregationStep.FINAL, Collections.singletonList(new TimeSeriesOperand(new PartialPath(path)))));
        return new SeriesAggregationScanNode(queryId.genPlanNodeId(), new MeasurementPath(path, TSDataType.INT32), descriptors);
    }

    @Test
    public void testParallelPlanWithAlignedSeries() throws IllegalPathException {
        QueryId queryId = new QueryId("test_query_aligned");
        MPPQueryContext context = new MPPQueryContext("", queryId, null, new TEndPoint(), new TEndPoint());
        String sql = "select d666666.s1, d666666.s2, d333.s1 from root.sg limit 10";
        Analysis analysis = Util.analyze(sql, context);
        PlanNode root = Util.genLogicalPlan(analysis, context);
        DistributionPlanner planner = new DistributionPlanner(analysis, new LogicalQueryPlan(context, root));
        DistributedQueryPlan plan = planner.planFragments();
        Assert.assertEquals((long)3L, (long)plan.getInstances().size());
    }
}

