/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.plan;

import java.time.ZoneId;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.IClientPoolFactory;
import org.apache.iotdb.commons.client.sync.SyncDataNodeInternalServiceClient;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.db.client.DataNodeClientPoolFactory;
import org.apache.iotdb.db.mpp.common.MPPQueryContext;
import org.apache.iotdb.db.mpp.common.QueryId;
import org.apache.iotdb.db.mpp.common.SessionInfo;
import org.apache.iotdb.db.mpp.plan.analyze.FakePartitionFetcherImpl;
import org.apache.iotdb.db.mpp.plan.analyze.FakeSchemaFetcherImpl;
import org.apache.iotdb.db.mpp.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.ISchemaFetcher;
import org.apache.iotdb.db.mpp.plan.execution.QueryExecution;
import org.apache.iotdb.db.mpp.plan.parser.StatementGenerator;
import org.apache.iotdb.db.mpp.plan.planner.plan.DistributedQueryPlan;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeUtil;
import org.apache.iotdb.db.mpp.plan.statement.Statement;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class QueryPlannerTest {
    private static IClientManager<TEndPoint, SyncDataNodeInternalServiceClient> internalServiceClientManager;

    @BeforeClass
    public static void setUp() {
        internalServiceClientManager = new IClientManager.Factory().createClientManager((IClientPoolFactory)new DataNodeClientPoolFactory.SyncDataNodeInternalServiceClientPoolFactory());
    }

    @AfterClass
    public static void destroy() {
        internalServiceClientManager.close();
    }

    @Ignore
    @Test
    public void testSqlToDistributedPlan() {
        String querySql = "SELECT d1.*, d333.s1 FROM root.sg LIMIT 10";
        Statement stmt = StatementGenerator.createStatement((String)querySql, (ZoneId)ZoneId.systemDefault());
        QueryExecution queryExecution = new QueryExecution(stmt, new MPPQueryContext(querySql, new QueryId("query1"), new SessionInfo(1L, "fakeUsername", "fakeZoneId"), new TEndPoint(), new TEndPoint()), IoTDBThreadPoolFactory.newSingleThreadExecutor((String)"test_query"), IoTDBThreadPoolFactory.newSingleThreadExecutor((String)"test_write_operation"), IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor((String)"test_query_scheduled"), (IPartitionFetcher)new FakePartitionFetcherImpl(), (ISchemaFetcher)new FakeSchemaFetcherImpl(), internalServiceClientManager);
        queryExecution.doLogicalPlan();
        System.out.printf("SQL: %s%n%n", querySql);
        System.out.println("===== Step 1: Logical Plan =====");
        System.out.println(PlanNodeUtil.nodeToString((PlanNode)queryExecution.getLogicalPlan().getRootNode()));
        queryExecution.doDistributedPlan();
        DistributedQueryPlan distributedQueryPlan = queryExecution.getDistributedPlan();
        System.out.println("===== Step 4: Split Fragment Instance =====");
        distributedQueryPlan.getInstances().forEach(System.out::println);
    }
}

