/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.parser;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.mpp.plan.parser.StatementGenerator;
import org.apache.iotdb.db.mpp.plan.statement.component.ResultColumn;
import org.apache.iotdb.db.mpp.plan.statement.crud.QueryStatement;
import org.junit.Assert;
import org.junit.Test;

public class StatementGeneratorTest {
    @Test
    public void testRawDataQuery() {
        List<String> selectExprList = Arrays.asList("s1", "s2");
        List<String> prefixPaths = Collections.singletonList("root.sg1.d1");
        this.checkQueryStatement("SELECT s1, s2 FROM root.sg1.d1 LIMIT 10 OFFSET 10", selectExprList, prefixPaths, 10, 10);
    }

    @Test
    public void testGroupByTagWithDuplicatedKeys() {
        try {
            this.checkQueryStatement("SELECT avg(*) FROM root.sg.** GROUP BY TAGS(k1, k2, k1)", Collections.emptyList(), Collections.emptyList(), 10, 10);
            Assert.fail();
        }
        catch (SemanticException e) {
            Assert.assertEquals((Object)"duplicated key in GROUP BY TAGS: k1", (Object)e.getMessage());
        }
    }

    private void checkQueryStatement(String sql, List<String> selectExprList, List<String> prefixPaths, int rowLimit, int rowOffset) {
        QueryStatement statement = (QueryStatement)StatementGenerator.createStatement((String)sql, (ZoneId)ZonedDateTime.now().getOffset());
        int cnt = 0;
        for (ResultColumn resultColumn : statement.getSelectComponent().getResultColumns()) {
            String selectExpr = resultColumn.getExpression().toString();
            Assert.assertEquals((Object)selectExprList.get(cnt++), (Object)selectExpr);
        }
        Assert.assertEquals((long)selectExprList.size(), (long)cnt);
        cnt = 0;
        for (PartialPath path : statement.getFromComponent().getPrefixPaths()) {
            Assert.assertEquals((Object)prefixPaths.get(cnt++), (Object)path.toString());
        }
        Assert.assertEquals((long)prefixPaths.size(), (long)cnt);
        Assert.assertEquals((long)rowLimit, (long)statement.getRowLimit());
        Assert.assertEquals((long)rowOffset, (long)statement.getRowOffset());
    }
}

