/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.analyze;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.mpp.plan.analyze.AnalyzeVisitor;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.filter.TimeFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.operator.AndFilter;
import org.apache.iotdb.tsfile.read.filter.operator.NotFilter;
import org.apache.iotdb.tsfile.read.filter.operator.OrFilter;
import org.apache.iotdb.tsfile.utils.Pair;
import org.junit.Assert;
import org.junit.Test;

public class QueryTimePartitionTest {
    @Test
    public void testAndTimeFilter() {
        TimeFilter.TimeGt left = TimeFilter.gt((long)10L);
        TimeFilter.TimeLt right = TimeFilter.lt((long)20L);
        AndFilter andFilter = new AndFilter((Filter)left, (Filter)right);
        List timeRangeList = andFilter.getTimeRanges();
        Assert.assertEquals((long)1L, (long)timeRangeList.size());
        Assert.assertEquals((long)11L, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)19L, (long)((TimeRange)timeRangeList.get(0)).getMax());
        andFilter = new AndFilter((Filter)left, (Filter)TimeFilter.ltEq((long)20L));
        timeRangeList = andFilter.getTimeRanges();
        Assert.assertEquals((long)1L, (long)timeRangeList.size());
        Assert.assertEquals((long)11L, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)20L, (long)((TimeRange)timeRangeList.get(0)).getMax());
        andFilter = new AndFilter((Filter)TimeFilter.gtEq((long)10L), (Filter)TimeFilter.ltEq((long)20L));
        timeRangeList = andFilter.getTimeRanges();
        Assert.assertEquals((long)1L, (long)timeRangeList.size());
        Assert.assertEquals((long)10L, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)20L, (long)((TimeRange)timeRangeList.get(0)).getMax());
        andFilter = new AndFilter((Filter)TimeFilter.ltEq((long)20L), (Filter)TimeFilter.gtEq((long)10L));
        timeRangeList = andFilter.getTimeRanges();
        Assert.assertEquals((long)1L, (long)timeRangeList.size());
        Assert.assertEquals((long)10L, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)20L, (long)((TimeRange)timeRangeList.get(0)).getMax());
        andFilter = new AndFilter((Filter)TimeFilter.gtEq((long)20L), (Filter)TimeFilter.ltEq((long)10L));
        timeRangeList = andFilter.getTimeRanges();
        Assert.assertEquals((long)0L, (long)timeRangeList.size());
        andFilter = new AndFilter((Filter)TimeFilter.gtEq((long)20L), (Filter)TimeFilter.lt((long)20L));
        timeRangeList = andFilter.getTimeRanges();
        Assert.assertEquals((long)0L, (long)timeRangeList.size());
    }

    @Test
    public void testOrTimeFilter() {
        OrFilter filter = new OrFilter((Filter)TimeFilter.lt((long)10L), (Filter)TimeFilter.gt((long)20L));
        List timeRangeList = filter.getTimeRanges();
        Assert.assertEquals((long)2L, (long)timeRangeList.size());
        Assert.assertEquals((long)Long.MIN_VALUE, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)9L, (long)((TimeRange)timeRangeList.get(0)).getMax());
        Assert.assertEquals((long)21L, (long)((TimeRange)timeRangeList.get(1)).getMin());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)((TimeRange)timeRangeList.get(1)).getMax());
        filter = new OrFilter((Filter)TimeFilter.lt((long)10L), (Filter)TimeFilter.gtEq((long)20L));
        timeRangeList = filter.getTimeRanges();
        Assert.assertEquals((long)2L, (long)timeRangeList.size());
        Assert.assertEquals((long)Long.MIN_VALUE, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)9L, (long)((TimeRange)timeRangeList.get(0)).getMax());
        Assert.assertEquals((long)20L, (long)((TimeRange)timeRangeList.get(1)).getMin());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)((TimeRange)timeRangeList.get(1)).getMax());
        filter = new OrFilter((Filter)TimeFilter.ltEq((long)10L), (Filter)TimeFilter.gtEq((long)20L));
        timeRangeList = filter.getTimeRanges();
        Assert.assertEquals((long)2L, (long)timeRangeList.size());
        Assert.assertEquals((long)Long.MIN_VALUE, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)10L, (long)((TimeRange)timeRangeList.get(0)).getMax());
        Assert.assertEquals((long)20L, (long)((TimeRange)timeRangeList.get(1)).getMin());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)((TimeRange)timeRangeList.get(1)).getMax());
        filter = new OrFilter((Filter)TimeFilter.gtEq((long)20L), (Filter)TimeFilter.ltEq((long)10L));
        timeRangeList = filter.getTimeRanges();
        Assert.assertEquals((long)2L, (long)timeRangeList.size());
        Assert.assertEquals((long)Long.MIN_VALUE, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)10L, (long)((TimeRange)timeRangeList.get(0)).getMax());
        Assert.assertEquals((long)20L, (long)((TimeRange)timeRangeList.get(1)).getMin());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)((TimeRange)timeRangeList.get(1)).getMax());
        filter = new OrFilter((Filter)TimeFilter.gtEq((long)20L), (Filter)TimeFilter.gtEq((long)10L));
        timeRangeList = filter.getTimeRanges();
        Assert.assertEquals((long)1L, (long)timeRangeList.size());
        Assert.assertEquals((long)10L, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)((TimeRange)timeRangeList.get(0)).getMax());
        filter = new OrFilter((Filter)TimeFilter.lt((long)20L), (Filter)TimeFilter.ltEq((long)10L));
        timeRangeList = filter.getTimeRanges();
        Assert.assertEquals((long)1L, (long)timeRangeList.size());
        Assert.assertEquals((long)Long.MIN_VALUE, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)19L, (long)((TimeRange)timeRangeList.get(0)).getMax());
    }

    @Test
    public void testAndOrTimeFilter() {
        OrFilter filter = new OrFilter((Filter)new AndFilter((Filter)TimeFilter.gtEq((long)10L), (Filter)TimeFilter.ltEq((long)20L)), (Filter)TimeFilter.gt((long)30L));
        List timeRangeList = filter.getTimeRanges();
        Assert.assertEquals((long)2L, (long)timeRangeList.size());
        Assert.assertEquals((long)10L, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)20L, (long)((TimeRange)timeRangeList.get(0)).getMax());
        Assert.assertEquals((long)31L, (long)((TimeRange)timeRangeList.get(1)).getMin());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)((TimeRange)timeRangeList.get(1)).getMax());
        AndFilter filter1 = new AndFilter((Filter)new OrFilter((Filter)TimeFilter.ltEq((long)10L), (Filter)TimeFilter.gt((long)20L)), (Filter)TimeFilter.gtEq((long)30L));
        timeRangeList = filter1.getTimeRanges();
        Assert.assertEquals((long)1L, (long)timeRangeList.size());
        Assert.assertEquals((long)30L, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)((TimeRange)timeRangeList.get(0)).getMax());
        filter1 = new AndFilter((Filter)new OrFilter((Filter)TimeFilter.ltEq((long)10L), (Filter)TimeFilter.gt((long)20L)), (Filter)TimeFilter.ltEq((long)30L));
        timeRangeList = filter1.getTimeRanges();
        Assert.assertEquals((long)2L, (long)timeRangeList.size());
        Assert.assertEquals((long)Long.MIN_VALUE, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)10L, (long)((TimeRange)timeRangeList.get(0)).getMax());
        Assert.assertEquals((long)21L, (long)((TimeRange)timeRangeList.get(1)).getMin());
        Assert.assertEquals((long)30L, (long)((TimeRange)timeRangeList.get(1)).getMax());
        filter = new OrFilter((Filter)new AndFilter((Filter)TimeFilter.gtEq((long)10L), (Filter)TimeFilter.ltEq((long)20L)), (Filter)new AndFilter((Filter)TimeFilter.lt((long)100L), (Filter)TimeFilter.gt((long)30L)));
        timeRangeList = filter.getTimeRanges();
        Assert.assertEquals((long)2L, (long)timeRangeList.size());
        Assert.assertEquals((long)10L, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)20L, (long)((TimeRange)timeRangeList.get(0)).getMax());
        Assert.assertEquals((long)31L, (long)((TimeRange)timeRangeList.get(1)).getMin());
        Assert.assertEquals((long)99L, (long)((TimeRange)timeRangeList.get(1)).getMax());
    }

    @Test
    public void testBetweenTimeFilter() {
        TimeFilter.TimeBetween filter = TimeFilter.between((long)10L, (long)20L, (boolean)false);
        List timeRangeList = filter.getTimeRanges();
        Assert.assertEquals((long)1L, (long)timeRangeList.size());
        Assert.assertEquals((long)10L, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)20L, (long)((TimeRange)timeRangeList.get(0)).getMax());
        filter = TimeFilter.between((long)10L, (long)20L, (boolean)true);
        timeRangeList = filter.getTimeRanges();
        Assert.assertEquals((long)2L, (long)timeRangeList.size());
        Assert.assertEquals((long)Long.MIN_VALUE, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)9L, (long)((TimeRange)timeRangeList.get(0)).getMax());
        Assert.assertEquals((long)21L, (long)((TimeRange)timeRangeList.get(1)).getMin());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)((TimeRange)timeRangeList.get(1)).getMax());
        filter = TimeFilter.between((long)10L, (long)Long.MAX_VALUE, (boolean)true);
        timeRangeList = filter.getTimeRanges();
        Assert.assertEquals((long)1L, (long)timeRangeList.size());
        Assert.assertEquals((long)Long.MIN_VALUE, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)9L, (long)((TimeRange)timeRangeList.get(0)).getMax());
        filter = TimeFilter.between((long)Long.MIN_VALUE, (long)20L, (boolean)true);
        timeRangeList = filter.getTimeRanges();
        Assert.assertEquals((long)1L, (long)timeRangeList.size());
        Assert.assertEquals((long)21L, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)((TimeRange)timeRangeList.get(0)).getMax());
    }

    @Test
    public void testNotTimeFilter() {
        NotFilter filter = new NotFilter((Filter)new AndFilter((Filter)TimeFilter.gt((long)10L), (Filter)TimeFilter.ltEq((long)20L)));
        List timeRangeList = filter.getTimeRanges();
        Assert.assertEquals((long)2L, (long)timeRangeList.size());
        Assert.assertEquals((long)Long.MIN_VALUE, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)10L, (long)((TimeRange)timeRangeList.get(0)).getMax());
        Assert.assertEquals((long)21L, (long)((TimeRange)timeRangeList.get(1)).getMin());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)((TimeRange)timeRangeList.get(1)).getMax());
        filter = new NotFilter((Filter)new OrFilter((Filter)TimeFilter.gt((long)20L), (Filter)TimeFilter.ltEq((long)10L)));
        timeRangeList = filter.getTimeRanges();
        Assert.assertEquals((long)1L, (long)timeRangeList.size());
        Assert.assertEquals((long)11L, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)20L, (long)((TimeRange)timeRangeList.get(0)).getMax());
    }

    @Test
    public void testTimeEqFilter() {
        TimeFilter.TimeEq filter = TimeFilter.eq((long)10L);
        List timeRangeList = filter.getTimeRanges();
        Assert.assertEquals((long)1L, (long)timeRangeList.size());
        Assert.assertEquals((long)10L, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)10L, (long)((TimeRange)timeRangeList.get(0)).getMax());
        NotFilter filter1 = new NotFilter((Filter)filter);
        timeRangeList = filter1.getTimeRanges();
        Assert.assertEquals((long)2L, (long)timeRangeList.size());
        Assert.assertEquals((long)Long.MIN_VALUE, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)9L, (long)((TimeRange)timeRangeList.get(0)).getMax());
        Assert.assertEquals((long)11L, (long)((TimeRange)timeRangeList.get(1)).getMin());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)((TimeRange)timeRangeList.get(1)).getMax());
    }

    @Test
    public void testTimeNotEqFilter() {
        TimeFilter.TimeNotEq filter = TimeFilter.notEq((long)10L);
        List timeRangeList = filter.getTimeRanges();
        Assert.assertEquals((long)2L, (long)timeRangeList.size());
        Assert.assertEquals((long)Long.MIN_VALUE, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)9L, (long)((TimeRange)timeRangeList.get(0)).getMax());
        Assert.assertEquals((long)11L, (long)((TimeRange)timeRangeList.get(1)).getMin());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)((TimeRange)timeRangeList.get(1)).getMax());
        NotFilter filter1 = new NotFilter((Filter)filter);
        timeRangeList = filter1.getTimeRanges();
        Assert.assertEquals((long)1L, (long)timeRangeList.size());
        Assert.assertEquals((long)10L, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)10L, (long)((TimeRange)timeRangeList.get(0)).getMax());
    }

    @Test
    public void testTimeGtFilter() {
        TimeFilter.TimeGt filter = TimeFilter.gt((long)10L);
        List timeRangeList = filter.getTimeRanges();
        Assert.assertEquals((long)1L, (long)timeRangeList.size());
        Assert.assertEquals((long)11L, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)((TimeRange)timeRangeList.get(0)).getMax());
        NotFilter filter1 = new NotFilter((Filter)filter);
        timeRangeList = filter1.getTimeRanges();
        Assert.assertEquals((long)1L, (long)timeRangeList.size());
        Assert.assertEquals((long)Long.MIN_VALUE, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)10L, (long)((TimeRange)timeRangeList.get(0)).getMax());
    }

    @Test
    public void testTimeGtEqFilter() {
        TimeFilter.TimeGtEq filter = TimeFilter.gtEq((long)10L);
        List timeRangeList = filter.getTimeRanges();
        Assert.assertEquals((long)1L, (long)timeRangeList.size());
        Assert.assertEquals((long)10L, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)((TimeRange)timeRangeList.get(0)).getMax());
        NotFilter filter1 = new NotFilter((Filter)filter);
        timeRangeList = filter1.getTimeRanges();
        Assert.assertEquals((long)1L, (long)timeRangeList.size());
        Assert.assertEquals((long)Long.MIN_VALUE, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)9L, (long)((TimeRange)timeRangeList.get(0)).getMax());
    }

    @Test
    public void testTimeLtFilter() {
        TimeFilter.TimeLt filter = TimeFilter.lt((long)10L);
        List timeRangeList = filter.getTimeRanges();
        Assert.assertEquals((long)1L, (long)timeRangeList.size());
        Assert.assertEquals((long)Long.MIN_VALUE, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)9L, (long)((TimeRange)timeRangeList.get(0)).getMax());
        NotFilter filter1 = new NotFilter((Filter)filter);
        timeRangeList = filter1.getTimeRanges();
        Assert.assertEquals((long)1L, (long)timeRangeList.size());
        Assert.assertEquals((long)10L, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)((TimeRange)timeRangeList.get(0)).getMax());
    }

    @Test
    public void testTimeLtEqFilter() {
        TimeFilter.TimeLtEq filter = TimeFilter.ltEq((long)10L);
        List timeRangeList = filter.getTimeRanges();
        Assert.assertEquals((long)1L, (long)timeRangeList.size());
        Assert.assertEquals((long)Long.MIN_VALUE, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)10L, (long)((TimeRange)timeRangeList.get(0)).getMax());
        NotFilter filter1 = new NotFilter((Filter)filter);
        timeRangeList = filter1.getTimeRanges();
        Assert.assertEquals((long)1L, (long)timeRangeList.size());
        Assert.assertEquals((long)11L, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)((TimeRange)timeRangeList.get(0)).getMax());
    }

    @Test
    public void testGetTimePartitionSlotList() {
        int i;
        Pair res = AnalyzeVisitor.getTimePartitionSlotList((Filter)new AndFilter((Filter)TimeFilter.gtEq((long)10L), (Filter)TimeFilter.ltEq((long)9L)));
        Assert.assertTrue((boolean)((List)res.left).isEmpty());
        Assert.assertFalse((boolean)((Boolean)((Pair)res.right).left));
        Assert.assertFalse((boolean)((Boolean)((Pair)res.right).right));
        res = AnalyzeVisitor.getTimePartitionSlotList((Filter)TimeFilter.gtEq((long)10L));
        Assert.assertEquals((long)1L, (long)((List)res.left).size());
        List<TTimePartitionSlot> expected = Collections.singletonList(new TTimePartitionSlot(0L));
        Assert.assertEquals((long)expected.size(), (long)((List)res.left).size());
        for (i = 0; i < expected.size(); ++i) {
            Assert.assertEquals((Object)expected.get(i), ((List)res.left).get(i));
        }
        Assert.assertFalse((boolean)((Boolean)((Pair)res.right).left));
        Assert.assertTrue((boolean)((Boolean)((Pair)res.right).right));
        res = AnalyzeVisitor.getTimePartitionSlotList((Filter)TimeFilter.lt((long)20L));
        Assert.assertEquals((long)1L, (long)((List)res.left).size());
        expected = Collections.singletonList(new TTimePartitionSlot(0L));
        Assert.assertEquals((long)expected.size(), (long)((List)res.left).size());
        for (i = 0; i < expected.size(); ++i) {
            Assert.assertEquals((Object)expected.get(i), ((List)res.left).get(i));
        }
        Assert.assertTrue((boolean)((Boolean)((Pair)res.right).left));
        Assert.assertFalse((boolean)((Boolean)((Pair)res.right).right));
        res = AnalyzeVisitor.getTimePartitionSlotList((Filter)new AndFilter((Filter)TimeFilter.gt((long)10L), (Filter)TimeFilter.ltEq((long)20L)));
        expected = Collections.singletonList(new TTimePartitionSlot(0L));
        Assert.assertEquals((long)expected.size(), (long)((List)res.left).size());
        for (i = 0; i < expected.size(); ++i) {
            Assert.assertEquals((Object)expected.get(i), ((List)res.left).get(i));
        }
        Assert.assertFalse((boolean)((Boolean)((Pair)res.right).left));
        Assert.assertFalse((boolean)((Boolean)((Pair)res.right).right));
        res = AnalyzeVisitor.getTimePartitionSlotList((Filter)new AndFilter((Filter)TimeFilter.gt((long)0L), (Filter)TimeFilter.ltEq((long)(IoTDBDescriptor.getInstance().getConfig().getTimePartitionInterval() * 3L + 1L))));
        expected = Arrays.asList(new TTimePartitionSlot(0L), new TTimePartitionSlot(IoTDBDescriptor.getInstance().getConfig().getTimePartitionInterval()), new TTimePartitionSlot(IoTDBDescriptor.getInstance().getConfig().getTimePartitionInterval() * 2L), new TTimePartitionSlot(IoTDBDescriptor.getInstance().getConfig().getTimePartitionInterval() * 3L));
        Assert.assertEquals((long)expected.size(), (long)((List)res.left).size());
        for (i = 0; i < expected.size(); ++i) {
            Assert.assertEquals((Object)expected.get(i), ((List)res.left).get(i));
        }
        Assert.assertFalse((boolean)((Boolean)((Pair)res.right).left));
        Assert.assertFalse((boolean)((Boolean)((Pair)res.right).right));
        res = AnalyzeVisitor.getTimePartitionSlotList((Filter)new AndFilter((Filter)TimeFilter.gtEq((long)(IoTDBDescriptor.getInstance().getConfig().getTimePartitionInterval() - 1L)), (Filter)TimeFilter.lt((long)(IoTDBDescriptor.getInstance().getConfig().getTimePartitionInterval() + 1L))));
        expected = Arrays.asList(new TTimePartitionSlot(0L), new TTimePartitionSlot(IoTDBDescriptor.getInstance().getConfig().getTimePartitionInterval()));
        Assert.assertEquals((long)expected.size(), (long)((List)res.left).size());
        for (i = 0; i < expected.size(); ++i) {
            Assert.assertEquals((Object)expected.get(i), ((List)res.left).get(i));
        }
        Assert.assertFalse((boolean)((Boolean)((Pair)res.right).left));
        Assert.assertFalse((boolean)((Boolean)((Pair)res.right).right));
        res = AnalyzeVisitor.getTimePartitionSlotList((Filter)TimeFilter.between((long)(IoTDBDescriptor.getInstance().getConfig().getTimePartitionInterval() - 1L), (long)IoTDBDescriptor.getInstance().getConfig().getTimePartitionInterval(), (boolean)false));
        expected = Arrays.asList(new TTimePartitionSlot(0L), new TTimePartitionSlot(IoTDBDescriptor.getInstance().getConfig().getTimePartitionInterval()));
        Assert.assertEquals((long)expected.size(), (long)((List)res.left).size());
        for (i = 0; i < expected.size(); ++i) {
            Assert.assertEquals((Object)expected.get(i), ((List)res.left).get(i));
        }
        Assert.assertFalse((boolean)((Boolean)((Pair)res.right).left));
        Assert.assertFalse((boolean)((Boolean)((Pair)res.right).right));
        res = AnalyzeVisitor.getTimePartitionSlotList((Filter)new AndFilter((Filter)TimeFilter.gtEq((long)IoTDBDescriptor.getInstance().getConfig().getTimePartitionInterval()), (Filter)TimeFilter.ltEq((long)(IoTDBDescriptor.getInstance().getConfig().getTimePartitionInterval() + 1L))));
        expected = Collections.singletonList(new TTimePartitionSlot(IoTDBDescriptor.getInstance().getConfig().getTimePartitionInterval()));
        Assert.assertEquals((long)expected.size(), (long)((List)res.left).size());
        for (i = 0; i < expected.size(); ++i) {
            Assert.assertEquals((Object)expected.get(i), ((List)res.left).get(i));
        }
        Assert.assertFalse((boolean)((Boolean)((Pair)res.right).left));
        Assert.assertFalse((boolean)((Boolean)((Pair)res.right).right));
        res = AnalyzeVisitor.getTimePartitionSlotList((Filter)TimeFilter.between((long)IoTDBDescriptor.getInstance().getConfig().getTimePartitionInterval(), (long)(IoTDBDescriptor.getInstance().getConfig().getTimePartitionInterval() + 1L), (boolean)false));
        expected = Collections.singletonList(new TTimePartitionSlot(IoTDBDescriptor.getInstance().getConfig().getTimePartitionInterval()));
        Assert.assertEquals((long)expected.size(), (long)((List)res.left).size());
        for (i = 0; i < expected.size(); ++i) {
            Assert.assertEquals((Object)expected.get(i), ((List)res.left).get(i));
        }
        Assert.assertFalse((boolean)((Boolean)((Pair)res.right).left));
        Assert.assertFalse((boolean)((Boolean)((Pair)res.right).right));
        OrFilter orFilter1 = new OrFilter((Filter)new AndFilter((Filter)TimeFilter.gtEq((long)10L), (Filter)TimeFilter.lt((long)IoTDBDescriptor.getInstance().getConfig().getTimePartitionInterval())), (Filter)new AndFilter((Filter)TimeFilter.gt((long)IoTDBDescriptor.getInstance().getConfig().getTimePartitionInterval()), (Filter)TimeFilter.lt((long)(IoTDBDescriptor.getInstance().getConfig().getTimePartitionInterval() * 2L - 100L))));
        OrFilter orFilter2 = new OrFilter((Filter)orFilter1, (Filter)new AndFilter((Filter)TimeFilter.gt((long)(IoTDBDescriptor.getInstance().getConfig().getTimePartitionInterval() * 2L - 50L)), (Filter)TimeFilter.ltEq((long)(IoTDBDescriptor.getInstance().getConfig().getTimePartitionInterval() * 2L - 40L))));
        OrFilter orFilter3 = new OrFilter((Filter)orFilter2, (Filter)new AndFilter((Filter)TimeFilter.gt((long)(IoTDBDescriptor.getInstance().getConfig().getTimePartitionInterval() * 2L - 20L)), (Filter)TimeFilter.ltEq((long)(IoTDBDescriptor.getInstance().getConfig().getTimePartitionInterval() * 3L + 10L))));
        OrFilter orFilter4 = new OrFilter((Filter)orFilter3, (Filter)new AndFilter((Filter)TimeFilter.gt((long)(IoTDBDescriptor.getInstance().getConfig().getTimePartitionInterval() * 5L + 1L)), (Filter)TimeFilter.lt((long)(IoTDBDescriptor.getInstance().getConfig().getTimePartitionInterval() * 5L + 10L))));
        res = AnalyzeVisitor.getTimePartitionSlotList((Filter)orFilter4);
        expected = Arrays.asList(new TTimePartitionSlot(0L), new TTimePartitionSlot(IoTDBDescriptor.getInstance().getConfig().getTimePartitionInterval()), new TTimePartitionSlot(IoTDBDescriptor.getInstance().getConfig().getTimePartitionInterval() * 2L), new TTimePartitionSlot(IoTDBDescriptor.getInstance().getConfig().getTimePartitionInterval() * 3L), new TTimePartitionSlot(IoTDBDescriptor.getInstance().getConfig().getTimePartitionInterval() * 5L));
        Assert.assertEquals((long)expected.size(), (long)((List)res.left).size());
        for (int i2 = 0; i2 < expected.size(); ++i2) {
            Assert.assertEquals((Object)expected.get(i2), ((List)res.left).get(i2));
        }
        Assert.assertFalse((boolean)((Boolean)((Pair)res.right).left));
        Assert.assertFalse((boolean)((Boolean)((Pair)res.right).right));
    }
}

