/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.analyze;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.partition.DataPartition;
import org.apache.iotdb.commons.partition.DataPartitionQueryParam;
import org.apache.iotdb.commons.partition.SchemaNodeManagementPartition;
import org.apache.iotdb.commons.partition.SchemaPartition;
import org.apache.iotdb.commons.partition.executor.SeriesPartitionExecutor;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.mpp.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.mpp.rpc.thrift.TRegionRouteReq;

public class FakePartitionFetcherImpl
implements IPartitionFetcher {
    private final String seriesSlotExecutorName = IoTDBDescriptor.getInstance().getConfig().getSeriesPartitionExecutorClass();
    private final int seriesPartitionSlotNum = IoTDBDescriptor.getInstance().getConfig().getSeriesPartitionSlotNum();
    private final SeriesPartitionExecutor partitionExecutor = SeriesPartitionExecutor.getSeriesPartitionExecutor((String)this.seriesSlotExecutorName, (int)this.seriesPartitionSlotNum);

    public SchemaPartition getSchemaPartition(PathPatternTree patternTree) {
        String device1 = "root.sg.d1";
        String device2 = "root.sg.d22";
        String device3 = "root.sg.d333";
        SchemaPartition schemaPartition = new SchemaPartition(IoTDBDescriptor.getInstance().getConfig().getSeriesPartitionExecutorClass(), IoTDBDescriptor.getInstance().getConfig().getSeriesPartitionSlotNum());
        HashMap schemaPartitionMap = new HashMap();
        HashMap<TSeriesPartitionSlot, TRegionReplicaSet> regionMap = new HashMap<TSeriesPartitionSlot, TRegionReplicaSet>();
        TRegionReplicaSet region1 = new TRegionReplicaSet(new TConsensusGroupId(TConsensusGroupType.SchemaRegion, 1), Arrays.asList(new TDataNodeLocation().setDataNodeId(11).setClientRpcEndPoint(new TEndPoint("192.0.1.1", 9000)), new TDataNodeLocation().setDataNodeId(12).setClientRpcEndPoint(new TEndPoint("192.0.1.2", 9000))));
        regionMap.put(new TSeriesPartitionSlot(device1.length()), region1);
        TRegionReplicaSet region2 = new TRegionReplicaSet(new TConsensusGroupId(TConsensusGroupType.SchemaRegion, 2), Arrays.asList(new TDataNodeLocation().setDataNodeId(31).setClientRpcEndPoint(new TEndPoint("192.0.3.1", 9000)), new TDataNodeLocation().setDataNodeId(32).setClientRpcEndPoint(new TEndPoint("192.0.3.2", 9000))));
        regionMap.put(new TSeriesPartitionSlot(device2.length()), region2);
        TRegionReplicaSet region3 = new TRegionReplicaSet(new TConsensusGroupId(TConsensusGroupType.SchemaRegion, 3), Arrays.asList(new TDataNodeLocation().setDataNodeId(11).setClientRpcEndPoint(new TEndPoint("192.0.1.1", 9000)), new TDataNodeLocation().setDataNodeId(12).setClientRpcEndPoint(new TEndPoint("192.0.1.2", 9000))));
        regionMap.put(new TSeriesPartitionSlot(device3.length()), region3);
        schemaPartitionMap.put("root.sg", regionMap);
        schemaPartition.setSchemaPartitionMap(schemaPartitionMap);
        return schemaPartition;
    }

    public SchemaPartition getOrCreateSchemaPartition(PathPatternTree patternTree) {
        return null;
    }

    public SchemaNodeManagementPartition getSchemaNodeManagementPartitionWithLevel(PathPatternTree patternTree, Integer level) {
        return null;
    }

    public DataPartition getDataPartition(Map<String, List<DataPartitionQueryParam>> sgNameToQueryParamsMap) {
        String device1 = "root.sg.d1";
        String device2 = "root.sg.d22";
        String device3 = "root.sg.d333";
        DataPartition dataPartition = new DataPartition(IoTDBDescriptor.getInstance().getConfig().getSeriesPartitionExecutorClass(), IoTDBDescriptor.getInstance().getConfig().getSeriesPartitionSlotNum());
        HashMap dataPartitionMap = new HashMap();
        HashMap sgPartitionMap = new HashMap();
        ArrayList<TRegionReplicaSet> d1DataRegions = new ArrayList<TRegionReplicaSet>();
        d1DataRegions.add(new TRegionReplicaSet(new TConsensusGroupId(TConsensusGroupType.DataRegion, 1), Arrays.asList(new TDataNodeLocation().setDataNodeId(11).setClientRpcEndPoint(new TEndPoint("192.0.1.1", 9000)), new TDataNodeLocation().setDataNodeId(12).setClientRpcEndPoint(new TEndPoint("192.0.1.2", 9000)))));
        d1DataRegions.add(new TRegionReplicaSet(new TConsensusGroupId(TConsensusGroupType.DataRegion, 2), Arrays.asList(new TDataNodeLocation().setDataNodeId(21).setClientRpcEndPoint(new TEndPoint("192.0.2.1", 9000)), new TDataNodeLocation().setDataNodeId(22).setClientRpcEndPoint(new TEndPoint("192.0.2.2", 9000)))));
        HashMap<TTimePartitionSlot, ArrayList<TRegionReplicaSet>> d1DataRegionMap = new HashMap<TTimePartitionSlot, ArrayList<TRegionReplicaSet>>();
        d1DataRegionMap.put(new TTimePartitionSlot(), d1DataRegions);
        ArrayList<TRegionReplicaSet> d2DataRegions = new ArrayList<TRegionReplicaSet>();
        d2DataRegions.add(new TRegionReplicaSet(new TConsensusGroupId(TConsensusGroupType.DataRegion, 3), Arrays.asList(new TDataNodeLocation().setDataNodeId(31).setClientRpcEndPoint(new TEndPoint("192.0.3.1", 9000)), new TDataNodeLocation().setDataNodeId(32).setClientRpcEndPoint(new TEndPoint("192.0.3.2", 9000)))));
        HashMap<TTimePartitionSlot, ArrayList<TRegionReplicaSet>> d2DataRegionMap = new HashMap<TTimePartitionSlot, ArrayList<TRegionReplicaSet>>();
        d2DataRegionMap.put(new TTimePartitionSlot(), d2DataRegions);
        ArrayList<TRegionReplicaSet> d3DataRegions = new ArrayList<TRegionReplicaSet>();
        d3DataRegions.add(new TRegionReplicaSet(new TConsensusGroupId(TConsensusGroupType.DataRegion, 1), Arrays.asList(new TDataNodeLocation().setDataNodeId(11).setClientRpcEndPoint(new TEndPoint("192.0.1.1", 9000)), new TDataNodeLocation().setDataNodeId(12).setClientRpcEndPoint(new TEndPoint("192.0.1.2", 9000)))));
        d3DataRegions.add(new TRegionReplicaSet(new TConsensusGroupId(TConsensusGroupType.DataRegion, 4), Arrays.asList(new TDataNodeLocation().setDataNodeId(41).setClientRpcEndPoint(new TEndPoint("192.0.4.1", 9000)), new TDataNodeLocation().setDataNodeId(42).setClientRpcEndPoint(new TEndPoint("192.0.4.2", 9000)))));
        HashMap<TTimePartitionSlot, ArrayList<TRegionReplicaSet>> d3DataRegionMap = new HashMap<TTimePartitionSlot, ArrayList<TRegionReplicaSet>>();
        d3DataRegionMap.put(new TTimePartitionSlot(), d3DataRegions);
        sgPartitionMap.put(new TSeriesPartitionSlot(device1.length()), d1DataRegionMap);
        sgPartitionMap.put(new TSeriesPartitionSlot(device2.length()), d2DataRegionMap);
        sgPartitionMap.put(new TSeriesPartitionSlot(device3.length()), d3DataRegionMap);
        dataPartitionMap.put("root.sg", sgPartitionMap);
        dataPartition.setDataPartitionMap(dataPartitionMap);
        return dataPartition;
    }

    public DataPartition getDataPartitionWithUnclosedTimeRange(Map<String, List<DataPartitionQueryParam>> sgNameToQueryParamsMap) {
        return this.getDataPartition(sgNameToQueryParamsMap);
    }

    public DataPartition getOrCreateDataPartition(Map<String, List<DataPartitionQueryParam>> sgNameToQueryParamsMap) {
        return null;
    }

    public DataPartition getOrCreateDataPartition(List<DataPartitionQueryParam> dataPartitionQueryParams) {
        DataPartition dataPartition = new DataPartition(IoTDBDescriptor.getInstance().getConfig().getSeriesPartitionExecutorClass(), IoTDBDescriptor.getInstance().getConfig().getSeriesPartitionSlotNum());
        HashMap dataPartitionMap = new HashMap();
        HashMap<TSeriesPartitionSlot, Map> sgPartitionMap = new HashMap<TSeriesPartitionSlot, Map>();
        dataPartitionMap.put("root.sg", sgPartitionMap);
        dataPartition.setDataPartitionMap(dataPartitionMap);
        ArrayList<TRegionReplicaSet> d1DataRegions = new ArrayList<TRegionReplicaSet>();
        d1DataRegions.add(new TRegionReplicaSet(new TConsensusGroupId(TConsensusGroupType.DataRegion, 1), Arrays.asList(new TDataNodeLocation().setDataNodeId(11).setClientRpcEndPoint(new TEndPoint("192.0.1.1", 9000)), new TDataNodeLocation().setDataNodeId(12).setClientRpcEndPoint(new TEndPoint("192.0.1.2", 9000)))));
        d1DataRegions.add(new TRegionReplicaSet(new TConsensusGroupId(TConsensusGroupType.DataRegion, 2), Arrays.asList(new TDataNodeLocation().setDataNodeId(21).setClientRpcEndPoint(new TEndPoint("192.0.2.1", 9000)), new TDataNodeLocation().setDataNodeId(22).setClientRpcEndPoint(new TEndPoint("192.0.2.2", 9000)))));
        ArrayList<TRegionReplicaSet> d2DataRegions = new ArrayList<TRegionReplicaSet>();
        d2DataRegions.add(new TRegionReplicaSet(new TConsensusGroupId(TConsensusGroupType.DataRegion, 3), Arrays.asList(new TDataNodeLocation().setDataNodeId(31).setClientRpcEndPoint(new TEndPoint("192.0.3.1", 9000)), new TDataNodeLocation().setDataNodeId(32).setClientRpcEndPoint(new TEndPoint("192.0.3.2", 9000)))));
        HashMap<TTimePartitionSlot, ArrayList<TRegionReplicaSet>> d2DataRegionMap = new HashMap<TTimePartitionSlot, ArrayList<TRegionReplicaSet>>();
        d2DataRegionMap.put(new TTimePartitionSlot(), d2DataRegions);
        for (DataPartitionQueryParam dataPartitionQueryParam : dataPartitionQueryParams) {
            TSeriesPartitionSlot seriesPartitionSlot = this.partitionExecutor.getSeriesPartitionSlot(dataPartitionQueryParam.getDevicePath());
            Map timePartitionSlotListMap = sgPartitionMap.computeIfAbsent(seriesPartitionSlot, k -> new HashMap());
            for (TTimePartitionSlot timePartitionSlot : dataPartitionQueryParam.getTimePartitionSlotList()) {
                if (timePartitionSlot.startTime == 0L) {
                    timePartitionSlotListMap.put(timePartitionSlot, d1DataRegions);
                    continue;
                }
                timePartitionSlotListMap.put(timePartitionSlot, d2DataRegions);
            }
        }
        return dataPartition;
    }

    public boolean updateRegionCache(TRegionRouteReq req) {
        return true;
    }

    public void invalidAllCache() {
    }
}

