/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.analyze;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.mpp.common.MPPQueryContext;
import org.apache.iotdb.db.mpp.common.QueryId;
import org.apache.iotdb.db.mpp.common.header.ColumnHeader;
import org.apache.iotdb.db.mpp.common.header.DatasetHeader;
import org.apache.iotdb.db.mpp.plan.analyze.Analysis;
import org.apache.iotdb.db.mpp.plan.analyze.Analyzer;
import org.apache.iotdb.db.mpp.plan.analyze.FakePartitionFetcherImpl;
import org.apache.iotdb.db.mpp.plan.analyze.FakeSchemaFetcherImpl;
import org.apache.iotdb.db.mpp.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.ISchemaFetcher;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.binary.AdditionExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.GreaterThanExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.LessThanExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.LogicAndExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.LogicOrExpression;
import org.apache.iotdb.db.mpp.plan.expression.leaf.ConstantOperand;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimestampOperand;
import org.apache.iotdb.db.mpp.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.mpp.plan.parser.StatementGenerator;
import org.apache.iotdb.db.mpp.plan.statement.Statement;
import org.apache.iotdb.db.mpp.plan.statement.crud.QueryStatement;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.filter.GroupByFilter;
import org.apache.iotdb.tsfile.read.filter.TimeFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.operator.AndFilter;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.ratis.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.ratis.thirdparty.com.google.common.collect.Sets;
import org.junit.Assert;
import org.junit.Test;

public class AnalyzeTest {
    @Test
    public void testRawDataQuery() {
        String sql = "select s1, status, s1 + 1 as t from root.sg.d1 where time > 100 and s2 > 10;";
        try {
            Analysis actualAnalysis = this.analyzeSQL(sql);
            Analysis expectedAnalysis = new Analysis();
            expectedAnalysis.setGlobalTimeFilter((Filter)TimeFilter.gt((long)100L));
            expectedAnalysis.setSelectExpressions((Set)Sets.newHashSet((Object[])new Expression[]{new TimeSeriesOperand(new PartialPath("root.sg.d1.s1")), new TimeSeriesOperand(new PartialPath("root.sg.d1.s2")), new AdditionExpression((Expression)new TimeSeriesOperand(new PartialPath("root.sg.d1.s1")), (Expression)new ConstantOperand(TSDataType.INT64, "1"))}));
            expectedAnalysis.setWhereExpression((Expression)new GreaterThanExpression((Expression)new TimeSeriesOperand(new PartialPath("root.sg.d1.s2")), (Expression)new ConstantOperand(TSDataType.INT64, "10")));
            expectedAnalysis.setSourceTransformExpressions((Set)Sets.newHashSet((Object[])new Expression[]{new TimeSeriesOperand(new PartialPath("root.sg.d1.s1")), new TimeSeriesOperand(new PartialPath("root.sg.d1.s2")), new AdditionExpression((Expression)new TimeSeriesOperand(new PartialPath("root.sg.d1.s1")), (Expression)new ConstantOperand(TSDataType.INT64, "1"))}));
            expectedAnalysis.setSourceExpressions((Set)Sets.newHashSet((Object[])new Expression[]{new TimeSeriesOperand(new PartialPath("root.sg.d1.s1")), new TimeSeriesOperand(new PartialPath("root.sg.d1.s2"))}));
            expectedAnalysis.setRespDatasetHeader(new DatasetHeader(Arrays.asList(new ColumnHeader("root.sg.d1.s1", TSDataType.INT32), new ColumnHeader("root.sg.d1.s2", TSDataType.DOUBLE, "root.sg.d1.status"), new ColumnHeader("root.sg.d1.s1 + 1", TSDataType.DOUBLE, "t")), false));
            this.alignByTimeAnalysisEqualTest(actualAnalysis, expectedAnalysis);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testAggregationQuery() {
        String sql = "select count(s1 + 1) + 1 as t from root.sg.d1 where time > 100 and s2 > 10 group by ([0, 1000), 10ms) having sum(s2 + 1) + count(s1) > 100;";
        try {
            Analysis actualAnalysis = this.analyzeSQL(sql);
            Analysis expectedAnalysis = new Analysis();
            expectedAnalysis.setGlobalTimeFilter((Filter)new AndFilter((Filter)TimeFilter.gt((long)100L), (Filter)new GroupByFilter(10L, 10L, 0L, 1000L)));
            expectedAnalysis.setSelectExpressions((Set)Sets.newHashSet((Object[])new Expression[]{new AdditionExpression((Expression)new FunctionExpression("count", new LinkedHashMap(), Collections.singletonList(new AdditionExpression((Expression)new TimeSeriesOperand(new PartialPath("root.sg.d1.s1")), (Expression)new ConstantOperand(TSDataType.INT64, "1")))), (Expression)new ConstantOperand(TSDataType.INT64, "1"))}));
            expectedAnalysis.setHavingExpression((Expression)new GreaterThanExpression((Expression)new AdditionExpression((Expression)new FunctionExpression("sum", new LinkedHashMap(), Collections.singletonList(new AdditionExpression((Expression)new TimeSeriesOperand(new PartialPath("root.sg.d1.s2")), (Expression)new ConstantOperand(TSDataType.INT64, "1")))), (Expression)new FunctionExpression("count", new LinkedHashMap(), Collections.singletonList(new TimeSeriesOperand(new PartialPath("root.sg.d1.s1"))))), (Expression)new ConstantOperand(TSDataType.INT64, "100")));
            expectedAnalysis.setAggregationExpressions((Set)Sets.newHashSet((Object[])new Expression[]{new FunctionExpression("count", new LinkedHashMap(), Collections.singletonList(new AdditionExpression((Expression)new TimeSeriesOperand(new PartialPath("root.sg.d1.s1")), (Expression)new ConstantOperand(TSDataType.INT64, "1")))), new FunctionExpression("sum", new LinkedHashMap(), Collections.singletonList(new AdditionExpression((Expression)new TimeSeriesOperand(new PartialPath("root.sg.d1.s2")), (Expression)new ConstantOperand(TSDataType.INT64, "1")))), new FunctionExpression("count", new LinkedHashMap(), Collections.singletonList(new TimeSeriesOperand(new PartialPath("root.sg.d1.s1"))))}));
            expectedAnalysis.setWhereExpression((Expression)new GreaterThanExpression((Expression)new TimeSeriesOperand(new PartialPath("root.sg.d1.s2")), (Expression)new ConstantOperand(TSDataType.INT64, "10")));
            expectedAnalysis.setSourceTransformExpressions((Set)Sets.newHashSet((Object[])new Expression[]{new TimeSeriesOperand(new PartialPath("root.sg.d1.s1")), new AdditionExpression((Expression)new TimeSeriesOperand(new PartialPath("root.sg.d1.s2")), (Expression)new ConstantOperand(TSDataType.INT64, "1")), new AdditionExpression((Expression)new TimeSeriesOperand(new PartialPath("root.sg.d1.s1")), (Expression)new ConstantOperand(TSDataType.INT64, "1"))}));
            expectedAnalysis.setSourceExpressions((Set)Sets.newHashSet((Object[])new Expression[]{new TimeSeriesOperand(new PartialPath("root.sg.d1.s1")), new TimeSeriesOperand(new PartialPath("root.sg.d1.s2"))}));
            expectedAnalysis.setRespDatasetHeader(new DatasetHeader(Collections.singletonList(new ColumnHeader("count(root.sg.d1.s1 + 1) + 1", TSDataType.DOUBLE, "t")), false));
            this.alignByTimeAnalysisEqualTest(actualAnalysis, expectedAnalysis);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testRawDataQueryAlignByDevice() {
        String sql = "select s1, status, s2 + 1 from root.sg.* where time > 100 and s2 > 10 align by device;";
        try {
            Analysis actualAnalysis = this.analyzeSQL(sql);
            Analysis expectedAnalysis = new Analysis();
            expectedAnalysis.setGlobalTimeFilter((Filter)TimeFilter.gt((long)100L));
            expectedAnalysis.setSelectExpressions((Set)Sets.newHashSet((Object[])new Expression[]{new TimeSeriesOperand((PartialPath)new MeasurementPath(new PartialPath("Device", false), TSDataType.TEXT)), new TimeSeriesOperand(new PartialPath("s1")), new TimeSeriesOperand(new PartialPath("s2")), new AdditionExpression((Expression)new TimeSeriesOperand(new PartialPath("s2")), (Expression)new ConstantOperand(TSDataType.INT64, "1"))}));
            expectedAnalysis.setDeviceToSelectExpressions((Map)ImmutableMap.of((Object)"root.sg.d1", (Object)Sets.newHashSet((Object[])new Expression[]{new TimeSeriesOperand(new PartialPath("root.sg.d1.s1")), new TimeSeriesOperand(new PartialPath("root.sg.d1.s2")), new AdditionExpression((Expression)new TimeSeriesOperand(new PartialPath("root.sg.d1.s2")), (Expression)new ConstantOperand(TSDataType.INT64, "1"))}), (Object)"root.sg.d2", (Object)Sets.newHashSet((Object[])new Expression[]{new TimeSeriesOperand(new PartialPath("root.sg.d2.s1")), new TimeSeriesOperand(new PartialPath("root.sg.d2.s2")), new AdditionExpression((Expression)new TimeSeriesOperand(new PartialPath("root.sg.d2.s2")), (Expression)new ConstantOperand(TSDataType.INT64, "1"))})));
            expectedAnalysis.setDeviceToWhereExpression((Map)ImmutableMap.of((Object)"root.sg.d1", (Object)new GreaterThanExpression((Expression)new TimeSeriesOperand(new PartialPath("root.sg.d1.s2")), (Expression)new ConstantOperand(TSDataType.INT64, "10")), (Object)"root.sg.d2", (Object)new GreaterThanExpression((Expression)new TimeSeriesOperand(new PartialPath("root.sg.d2.s2")), (Expression)new ConstantOperand(TSDataType.INT64, "10"))));
            expectedAnalysis.setDeviceToAggregationExpressions((Map)ImmutableMap.of());
            expectedAnalysis.setDeviceToSourceTransformExpressions((Map)ImmutableMap.of((Object)"root.sg.d1", (Object)Sets.newHashSet((Object[])new Expression[]{new TimeSeriesOperand(new PartialPath("root.sg.d1.s1")), new TimeSeriesOperand(new PartialPath("root.sg.d1.s2")), new AdditionExpression((Expression)new TimeSeriesOperand(new PartialPath("root.sg.d1.s2")), (Expression)new ConstantOperand(TSDataType.INT64, "1"))}), (Object)"root.sg.d2", (Object)Sets.newHashSet((Object[])new Expression[]{new TimeSeriesOperand(new PartialPath("root.sg.d2.s1")), new TimeSeriesOperand(new PartialPath("root.sg.d2.s2")), new AdditionExpression((Expression)new TimeSeriesOperand(new PartialPath("root.sg.d2.s2")), (Expression)new ConstantOperand(TSDataType.INT64, "1"))})));
            expectedAnalysis.setDeviceToSourceExpressions((Map)ImmutableMap.of((Object)"root.sg.d1", (Object)Sets.newHashSet((Object[])new Expression[]{new TimeSeriesOperand(new PartialPath("root.sg.d1.s1")), new TimeSeriesOperand(new PartialPath("root.sg.d1.s2"))}), (Object)"root.sg.d2", (Object)Sets.newHashSet((Object[])new Expression[]{new TimeSeriesOperand(new PartialPath("root.sg.d2.s1")), new TimeSeriesOperand(new PartialPath("root.sg.d2.s2"))})));
            expectedAnalysis.setDeviceViewInputIndexesMap((Map)ImmutableMap.of((Object)"root.sg.d1", Arrays.asList(1, 2, 3), (Object)"root.sg.d2", Arrays.asList(1, 2, 3)));
            expectedAnalysis.setDeviceViewOutputExpressions((Set)Sets.newHashSet((Object[])new Expression[]{new TimeSeriesOperand((PartialPath)new MeasurementPath(new PartialPath("Device", false), TSDataType.TEXT)), new TimeSeriesOperand(new PartialPath("s1")), new TimeSeriesOperand(new PartialPath("s2")), new AdditionExpression((Expression)new TimeSeriesOperand(new PartialPath("s2")), (Expression)new ConstantOperand(TSDataType.INT64, "1"))}));
            expectedAnalysis.setRespDatasetHeader(new DatasetHeader(Arrays.asList(new ColumnHeader("Device", TSDataType.TEXT), new ColumnHeader("s1", TSDataType.INT32), new ColumnHeader("s2", TSDataType.DOUBLE, "status"), new ColumnHeader("s2 + 1", TSDataType.DOUBLE)), false));
            this.alignByDeviceAnalysisEqualTest(actualAnalysis, expectedAnalysis);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testAggregationQueryAlignByDevice() {
        String sql = "select count(s1 + 1) + 1 from root.sg.* where time > 100 and s2 > 10 group by ([0, 1000), 10ms) having sum(s2 + 1) + count(s1) > 100 align by device;";
        try {
            Analysis actualAnalysis = this.analyzeSQL(sql);
            Analysis expectedAnalysis = new Analysis();
            expectedAnalysis.setGlobalTimeFilter((Filter)new AndFilter((Filter)TimeFilter.gt((long)100L), (Filter)new GroupByFilter(10L, 10L, 0L, 1000L)));
            expectedAnalysis.setSelectExpressions((Set)Sets.newHashSet((Object[])new Expression[]{new TimeSeriesOperand((PartialPath)new MeasurementPath(new PartialPath("Device", false), TSDataType.TEXT)), new AdditionExpression((Expression)new FunctionExpression("count", new LinkedHashMap(), Collections.singletonList(new AdditionExpression((Expression)new TimeSeriesOperand(new PartialPath("s1")), (Expression)new ConstantOperand(TSDataType.INT64, "1")))), (Expression)new ConstantOperand(TSDataType.INT64, "1"))}));
            expectedAnalysis.setHavingExpression((Expression)new GreaterThanExpression((Expression)new AdditionExpression((Expression)new FunctionExpression("sum", new LinkedHashMap(), Collections.singletonList(new AdditionExpression((Expression)new TimeSeriesOperand(new PartialPath("s2")), (Expression)new ConstantOperand(TSDataType.INT64, "1")))), (Expression)new FunctionExpression("count", new LinkedHashMap(), Collections.singletonList(new TimeSeriesOperand(new PartialPath("s1"))))), (Expression)new ConstantOperand(TSDataType.INT64, "100")));
            expectedAnalysis.setDeviceToSelectExpressions((Map)ImmutableMap.of((Object)"root.sg.d1", (Object)Sets.newHashSet((Object[])new Expression[]{new AdditionExpression((Expression)new FunctionExpression("count", new LinkedHashMap(), Collections.singletonList(new AdditionExpression((Expression)new TimeSeriesOperand(new PartialPath("root.sg.d1.s1")), (Expression)new ConstantOperand(TSDataType.INT64, "1")))), (Expression)new ConstantOperand(TSDataType.INT64, "1"))}), (Object)"root.sg.d2", (Object)Sets.newHashSet((Object[])new Expression[]{new AdditionExpression((Expression)new FunctionExpression("count", new LinkedHashMap(), Collections.singletonList(new AdditionExpression((Expression)new TimeSeriesOperand(new PartialPath("root.sg.d2.s1")), (Expression)new ConstantOperand(TSDataType.INT64, "1")))), (Expression)new ConstantOperand(TSDataType.INT64, "1"))})));
            expectedAnalysis.setDeviceToWhereExpression((Map)ImmutableMap.of((Object)"root.sg.d1", (Object)new GreaterThanExpression((Expression)new TimeSeriesOperand(new PartialPath("root.sg.d1.s2")), (Expression)new ConstantOperand(TSDataType.INT64, "10")), (Object)"root.sg.d2", (Object)new GreaterThanExpression((Expression)new TimeSeriesOperand(new PartialPath("root.sg.d2.s2")), (Expression)new ConstantOperand(TSDataType.INT64, "10"))));
            expectedAnalysis.setDeviceToAggregationExpressions((Map)ImmutableMap.of((Object)"root.sg.d1", (Object)Sets.newHashSet((Object[])new Expression[]{new FunctionExpression("count", new LinkedHashMap(), Collections.singletonList(new AdditionExpression((Expression)new TimeSeriesOperand(new PartialPath("root.sg.d1.s1")), (Expression)new ConstantOperand(TSDataType.INT64, "1")))), new FunctionExpression("sum", new LinkedHashMap(), Collections.singletonList(new AdditionExpression((Expression)new TimeSeriesOperand(new PartialPath("root.sg.d1.s2")), (Expression)new ConstantOperand(TSDataType.INT64, "1")))), new FunctionExpression("count", new LinkedHashMap(), Collections.singletonList(new TimeSeriesOperand(new PartialPath("root.sg.d1.s1"))))}), (Object)"root.sg.d2", (Object)Sets.newHashSet((Object[])new Expression[]{new FunctionExpression("count", new LinkedHashMap(), Collections.singletonList(new AdditionExpression((Expression)new TimeSeriesOperand(new PartialPath("root.sg.d2.s1")), (Expression)new ConstantOperand(TSDataType.INT64, "1")))), new FunctionExpression("sum", new LinkedHashMap(), Collections.singletonList(new AdditionExpression((Expression)new TimeSeriesOperand(new PartialPath("root.sg.d2.s2")), (Expression)new ConstantOperand(TSDataType.INT64, "1")))), new FunctionExpression("count", new LinkedHashMap(), Collections.singletonList(new TimeSeriesOperand(new PartialPath("root.sg.d2.s1"))))})));
            expectedAnalysis.setDeviceToSourceTransformExpressions((Map)ImmutableMap.of((Object)"root.sg.d1", (Object)Sets.newHashSet((Object[])new Expression[]{new TimeSeriesOperand(new PartialPath("root.sg.d1.s1")), new AdditionExpression((Expression)new TimeSeriesOperand(new PartialPath("root.sg.d1.s1")), (Expression)new ConstantOperand(TSDataType.INT64, "1")), new AdditionExpression((Expression)new TimeSeriesOperand(new PartialPath("root.sg.d1.s2")), (Expression)new ConstantOperand(TSDataType.INT64, "1"))}), (Object)"root.sg.d2", (Object)Sets.newHashSet((Object[])new Expression[]{new TimeSeriesOperand(new PartialPath("root.sg.d2.s1")), new AdditionExpression((Expression)new TimeSeriesOperand(new PartialPath("root.sg.d2.s1")), (Expression)new ConstantOperand(TSDataType.INT64, "1")), new AdditionExpression((Expression)new TimeSeriesOperand(new PartialPath("root.sg.d2.s2")), (Expression)new ConstantOperand(TSDataType.INT64, "1"))})));
            expectedAnalysis.setDeviceToSourceExpressions((Map)ImmutableMap.of((Object)"root.sg.d1", (Object)Sets.newHashSet((Object[])new Expression[]{new TimeSeriesOperand(new PartialPath("root.sg.d1.s1")), new TimeSeriesOperand(new PartialPath("root.sg.d1.s2"))}), (Object)"root.sg.d2", (Object)Sets.newHashSet((Object[])new Expression[]{new TimeSeriesOperand(new PartialPath("root.sg.d2.s1")), new TimeSeriesOperand(new PartialPath("root.sg.d2.s2"))})));
            expectedAnalysis.setDeviceViewOutputExpressions((Set)Sets.newHashSet((Object[])new Expression[]{new TimeSeriesOperand((PartialPath)new MeasurementPath(new PartialPath("Device", false), TSDataType.TEXT)), new FunctionExpression("sum", new LinkedHashMap(), Collections.singletonList(new AdditionExpression((Expression)new TimeSeriesOperand(new PartialPath("s2")), (Expression)new ConstantOperand(TSDataType.INT64, "1")))), new FunctionExpression("count", new LinkedHashMap(), Collections.singletonList(new TimeSeriesOperand(new PartialPath("s1")))), new FunctionExpression("count", new LinkedHashMap(), Collections.singletonList(new AdditionExpression((Expression)new TimeSeriesOperand(new PartialPath("s1")), (Expression)new ConstantOperand(TSDataType.INT64, "1"))))}));
            expectedAnalysis.setDeviceViewInputIndexesMap((Map)ImmutableMap.of((Object)"root.sg.d1", Arrays.asList(2, 3, 1), (Object)"root.sg.d2", Arrays.asList(2, 3, 1)));
            expectedAnalysis.setRespDatasetHeader(new DatasetHeader(Arrays.asList(new ColumnHeader("Device", TSDataType.TEXT), new ColumnHeader("count(s1 + 1) + 1", TSDataType.DOUBLE)), false));
            this.alignByDeviceAnalysisEqualTest(actualAnalysis, expectedAnalysis);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testTimeFilterRewrite() throws IllegalPathException {
        String[] sqls = new String[]{"select s1 from root.sg.d1 where time>1 and time<3", "select s1 from root.sg.d1 where time>1 and time<3 or time>100", "select s1 from root.sg.d1 where time>1 or time<3", "select s1 from root.sg.d1 where time>1 and time<3 and s1>1", "select s1 from root.sg.d1 where time>1 and time<3 or s1>1", "select s1 from root.sg.d1 where time>1 or time<3 or time >5", "select s1 from root.sg.d1 where time>1 and time<3 and s1>1 and time>4", "select s1 from root.sg.d1 where time>1 and time<3 or time >4 and time>5", "select s1 from root.sg.d1 where time>1 or time<3 and s1>1", "select s1 from root.sg.d1 where time>1 or time<3 or s1>1", "select s1 from root.sg.d1 where time>1 or s1>1 and time<3", "select s1 from root.sg.d1 where time>1 or s1>1 or time<3"};
        Expression[] predicates = new Expression[]{null, null, null, new GreaterThanExpression((Expression)new TimeSeriesOperand(new PartialPath("s1")), (Expression)new ConstantOperand(TSDataType.INT32, "1")), new LogicOrExpression((Expression)new LogicAndExpression((Expression)new GreaterThanExpression((Expression)new TimestampOperand(), (Expression)new ConstantOperand(TSDataType.INT64, "1")), (Expression)new LessThanExpression((Expression)new TimestampOperand(), (Expression)new ConstantOperand(TSDataType.INT64, "3"))), (Expression)new GreaterThanExpression((Expression)new TimeSeriesOperand(new PartialPath("s1")), (Expression)new ConstantOperand(TSDataType.INT32, "1"))), null, new GreaterThanExpression((Expression)new TimeSeriesOperand(new PartialPath("s1")), (Expression)new ConstantOperand(TSDataType.INT32, "1")), null, new LogicOrExpression((Expression)new GreaterThanExpression((Expression)new TimestampOperand(), (Expression)new ConstantOperand(TSDataType.INT64, "1")), (Expression)new LogicAndExpression((Expression)new LessThanExpression((Expression)new TimestampOperand(), (Expression)new ConstantOperand(TSDataType.INT64, "3")), (Expression)new GreaterThanExpression((Expression)new TimeSeriesOperand(new PartialPath("s1")), (Expression)new ConstantOperand(TSDataType.INT32, "1")))), new LogicOrExpression((Expression)new GreaterThanExpression((Expression)new TimestampOperand(), (Expression)new ConstantOperand(TSDataType.INT64, "1")), (Expression)new LogicOrExpression((Expression)new LessThanExpression((Expression)new TimestampOperand(), (Expression)new ConstantOperand(TSDataType.INT64, "3")), (Expression)new GreaterThanExpression((Expression)new TimeSeriesOperand(new PartialPath("s1")), (Expression)new ConstantOperand(TSDataType.INT32, "1")))), new LogicOrExpression((Expression)new GreaterThanExpression((Expression)new TimestampOperand(), (Expression)new ConstantOperand(TSDataType.INT64, "1")), (Expression)new LogicAndExpression((Expression)new GreaterThanExpression((Expression)new TimeSeriesOperand(new PartialPath("s1")), (Expression)new ConstantOperand(TSDataType.INT32, "1")), (Expression)new LessThanExpression((Expression)new TimestampOperand(), (Expression)new ConstantOperand(TSDataType.INT64, "3")))), new LogicOrExpression((Expression)new GreaterThanExpression((Expression)new TimestampOperand(), (Expression)new ConstantOperand(TSDataType.INT64, "1")), (Expression)new LogicOrExpression((Expression)new GreaterThanExpression((Expression)new TimeSeriesOperand(new PartialPath("s1")), (Expression)new ConstantOperand(TSDataType.INT32, "1")), (Expression)new LessThanExpression((Expression)new TimestampOperand(), (Expression)new ConstantOperand(TSDataType.INT64, "3"))))};
        for (int i = 0; i < sqls.length; ++i) {
            Analysis analysis = this.analyzeSQL(sqls[i]);
            QueryStatement queryStatement = (QueryStatement)analysis.getStatement();
            if (predicates[i] == null) {
                Assert.assertNull((Object)queryStatement.getWhereCondition());
                continue;
            }
            Assert.assertEquals((Object)predicates[i], (Object)queryStatement.getWhereCondition().getPredicate());
        }
    }

    @Test
    public void testDataPartitionAnalyze() {
        Analysis analysis = this.analyzeSQL("insert into root.sg.d1(timestamp,s) values(1,10),(86401,11)");
        Assert.assertEquals((long)((Map)((Map)analysis.getDataPartitionInfo().getDataPartitionMap().get("root.sg")).get(new TSeriesPartitionSlot(8923))).size(), (long)1L);
    }

    @Test
    public void testSelectIntoPath() throws IllegalPathException {
        List<String> sqls = Arrays.asList("SELECT s1, s2 INTO root.sg_copy.d1(t1, t2), root.sg_copy.d2(t1, t2) FROM root.sg.d1, root.sg.d2;", "SELECT s1, s2 INTO root.sg_copy.d1(t1, t2, t3, t4) FROM root.sg.d1, root.sg.d2;", "SELECT s1, s2 INTO root.sg_copy.d1(t1), root.sg_copy.d2(t1, t2), root.sg_copy.d3(t1) FROM root.sg.d1, root.sg.d2;", "select count(s1 + s2), last_value(s2) into root.agg.count(s1_add_s2), root.agg.last_value(s2) from root.sg.d1 group by ([0, 100), 10ms);", "select s1 + s2 into root.expr.add(d1s1_d1s2, d1s1_d2s2, d2s1_d1s2, d2s1_d2s2) from root.sg.d1, root.sg.d2;", "select s1, s1 into root.sg_copy.d1(s1, s2)  from root.sg.d1", "select s1, s1 into root.sg_copy.d1(s1), root.sg_copy.d2(s1)  from root.sg.d1", "select s1, s2 into ::(t1, t1, t2, t2) from root.sg.*;", "select s1, s2 into root.sg_copy.::(::) from root.sg.*;", "select s1, s2 into root.sg_copy.d1_copy(${2}_${3}), root.sg_copy.d1_copy(${2}_${3}), root.sg_copy.d2_copy(${2}_${3}), root.sg_copy.d2_copy(${2}_${3}) from root.sg.d1, root.sg.d2;", "select d1.s1, d1.s2, d2.s1, d2.s2 into ::(s1_1, s2_2), root.sg.d2_2(s3_3), root.backup_${1}.::(s4) from root.sg", "select s1, s2 into root.sg_bk.new_d1(::) from root.sg.d1;");
        List<List> results = Arrays.asList(Arrays.asList(new Pair((Object)"root.sg.d1.s1", (Object)new PartialPath("root.sg_copy.d1.t1")), new Pair((Object)"root.sg.d2.s1", (Object)new PartialPath("root.sg_copy.d1.t2")), new Pair((Object)"root.sg.d1.s2", (Object)new PartialPath("root.sg_copy.d2.t1")), new Pair((Object)"root.sg.d2.s2", (Object)new PartialPath("root.sg_copy.d2.t2"))), Arrays.asList(new Pair((Object)"root.sg.d1.s1", (Object)new PartialPath("root.sg_copy.d1.t1")), new Pair((Object)"root.sg.d2.s1", (Object)new PartialPath("root.sg_copy.d1.t2")), new Pair((Object)"root.sg.d1.s2", (Object)new PartialPath("root.sg_copy.d1.t3")), new Pair((Object)"root.sg.d2.s2", (Object)new PartialPath("root.sg_copy.d1.t4"))), Arrays.asList(new Pair((Object)"root.sg.d1.s1", (Object)new PartialPath("root.sg_copy.d1.t1")), new Pair((Object)"root.sg.d2.s1", (Object)new PartialPath("root.sg_copy.d2.t1")), new Pair((Object)"root.sg.d1.s2", (Object)new PartialPath("root.sg_copy.d2.t2")), new Pair((Object)"root.sg.d2.s2", (Object)new PartialPath("root.sg_copy.d3.t1"))), Arrays.asList(new Pair((Object)"count(root.sg.d1.s1 + root.sg.d1.s2)", (Object)new PartialPath("root.agg.count.s1_add_s2")), new Pair((Object)"last_value(root.sg.d1.s2)", (Object)new PartialPath("root.agg.last_value.s2"))), Arrays.asList(new Pair((Object)"root.sg.d1.s1 + root.sg.d1.s2", (Object)new PartialPath("root.expr.add.d1s1_d1s2")), new Pair((Object)"root.sg.d1.s1 + root.sg.d2.s2", (Object)new PartialPath("root.expr.add.d1s1_d2s2")), new Pair((Object)"root.sg.d2.s1 + root.sg.d1.s2", (Object)new PartialPath("root.expr.add.d2s1_d1s2")), new Pair((Object)"root.sg.d2.s1 + root.sg.d2.s2", (Object)new PartialPath("root.expr.add.d2s1_d2s2"))), Arrays.asList(new Pair((Object)"root.sg.d1.s1", (Object)new PartialPath("root.sg_copy.d1.s1")), new Pair((Object)"root.sg.d1.s1", (Object)new PartialPath("root.sg_copy.d1.s2"))), Arrays.asList(new Pair((Object)"root.sg.d1.s1", (Object)new PartialPath("root.sg_copy.d1.s1")), new Pair((Object)"root.sg.d1.s1", (Object)new PartialPath("root.sg_copy.d2.s1"))), Arrays.asList(new Pair((Object)"root.sg.d1.s1", (Object)new PartialPath("root.sg.d1.t1")), new Pair((Object)"root.sg.d2.s1", (Object)new PartialPath("root.sg.d2.t1")), new Pair((Object)"root.sg.d1.s2", (Object)new PartialPath("root.sg.d1.t2")), new Pair((Object)"root.sg.d2.s2", (Object)new PartialPath("root.sg.d2.t2"))), Arrays.asList(new Pair((Object)"root.sg.d1.s1", (Object)new PartialPath("root.sg_copy.d1.s1")), new Pair((Object)"root.sg.d2.s1", (Object)new PartialPath("root.sg_copy.d2.s1")), new Pair((Object)"root.sg.d1.s2", (Object)new PartialPath("root.sg_copy.d1.s2")), new Pair((Object)"root.sg.d2.s2", (Object)new PartialPath("root.sg_copy.d2.s2"))), Arrays.asList(new Pair((Object)"root.sg.d1.s1", (Object)new PartialPath("root.sg_copy.d1_copy.d1_s1")), new Pair((Object)"root.sg.d2.s1", (Object)new PartialPath("root.sg_copy.d1_copy.d2_s1")), new Pair((Object)"root.sg.d1.s2", (Object)new PartialPath("root.sg_copy.d2_copy.d1_s2")), new Pair((Object)"root.sg.d2.s2", (Object)new PartialPath("root.sg_copy.d2_copy.d2_s2"))), Arrays.asList(new Pair((Object)"root.sg.d1.s1", (Object)new PartialPath("root.sg.d1.s1_1")), new Pair((Object)"root.sg.d1.s2", (Object)new PartialPath("root.sg.d1.s2_2")), new Pair((Object)"root.sg.d2.s1", (Object)new PartialPath("root.sg.d2_2.s3_3")), new Pair((Object)"root.sg.d2.s2", (Object)new PartialPath("root.backup_sg.d2.s4"))), Arrays.asList(new Pair((Object)"root.sg.d1.s1", (Object)new PartialPath("root.sg_bk.new_d1.s1")), new Pair((Object)"root.sg.d1.s2", (Object)new PartialPath("root.sg_bk.new_d1.s2"))));
        for (int i = 0; i < sqls.size(); ++i) {
            Analysis analysis = this.analyzeSQL(sqls.get(i));
            assert (analysis != null);
            Assert.assertEquals((Object)results.get(i), (Object)analysis.getIntoPathDescriptor().getSourceTargetPathPairList());
        }
    }

    @Test
    public void testSelectIntoPathAlignByDevice() throws IllegalPathException {
        List<String> sqls = Arrays.asList("select s1, s2 into root.sg_copy.::(t1, t2) from root.sg.d1, root.sg.d2 align by device;", "select s1 + s2 into root.expr.add(d1s1_d1s2), root.expr.add(d2s1_d2s2) from root.sg.d1, root.sg.d2 align by device;", "select count(s1), last_value(s2) into root.agg.::(count_s1, last_value_s2) from root.sg.d1, root.sg.d2 group by ([0, 100), 10ms) align by device;", "select s1, s2 into root.sg1.new_d1(::), root.sg2.new_d2(::) from root.sg.d1, root.sg.d2 align by device;", "select s1, s2 into root.sg1.new_${2}(::) from root.sg.d1, root.sg.d2 align by device;");
        ArrayList results = new ArrayList();
        HashMap<String, List<Pair>> resultMap1 = new HashMap<String, List<Pair>>();
        resultMap1.put("root.sg.d1", Arrays.asList(new Pair((Object)"s1", (Object)new PartialPath("root.sg_copy.d1.t1")), new Pair((Object)"s2", (Object)new PartialPath("root.sg_copy.d1.t2"))));
        resultMap1.put("root.sg.d2", Arrays.asList(new Pair((Object)"s1", (Object)new PartialPath("root.sg_copy.d2.t1")), new Pair((Object)"s2", (Object)new PartialPath("root.sg_copy.d2.t2"))));
        results.add(resultMap1);
        HashMap<String, List<Pair>> resultMap2 = new HashMap<String, List<Pair>>();
        resultMap2.put("root.sg.d1", Collections.singletonList(new Pair((Object)"s1 + s2", (Object)new PartialPath("root.expr.add.d1s1_d1s2"))));
        resultMap2.put("root.sg.d2", Collections.singletonList(new Pair((Object)"s1 + s2", (Object)new PartialPath("root.expr.add.d2s1_d2s2"))));
        results.add(resultMap2);
        HashMap<String, List<Pair>> resultMap3 = new HashMap<String, List<Pair>>();
        resultMap3.put("root.sg.d1", Arrays.asList(new Pair((Object)"count(s1)", (Object)new PartialPath("root.agg.d1.count_s1")), new Pair((Object)"last_value(s2)", (Object)new PartialPath("root.agg.d1.last_value_s2"))));
        resultMap3.put("root.sg.d2", Arrays.asList(new Pair((Object)"count(s1)", (Object)new PartialPath("root.agg.d2.count_s1")), new Pair((Object)"last_value(s2)", (Object)new PartialPath("root.agg.d2.last_value_s2"))));
        results.add(resultMap3);
        HashMap<String, List<Pair>> resultMap4 = new HashMap<String, List<Pair>>();
        resultMap4.put("root.sg.d1", Arrays.asList(new Pair((Object)"s1", (Object)new PartialPath("root.sg1.new_d1.s1")), new Pair((Object)"s2", (Object)new PartialPath("root.sg1.new_d1.s2"))));
        resultMap4.put("root.sg.d2", Arrays.asList(new Pair((Object)"s1", (Object)new PartialPath("root.sg2.new_d2.s1")), new Pair((Object)"s2", (Object)new PartialPath("root.sg2.new_d2.s2"))));
        results.add(resultMap4);
        HashMap<String, List<Pair>> resultMap5 = new HashMap<String, List<Pair>>();
        resultMap5.put("root.sg.d1", Arrays.asList(new Pair((Object)"s1", (Object)new PartialPath("root.sg1.new_d1.s1")), new Pair((Object)"s2", (Object)new PartialPath("root.sg1.new_d1.s2"))));
        resultMap5.put("root.sg.d2", Arrays.asList(new Pair((Object)"s1", (Object)new PartialPath("root.sg1.new_d2.s1")), new Pair((Object)"s2", (Object)new PartialPath("root.sg1.new_d2.s2"))));
        results.add(resultMap5);
        for (int i = 0; i < sqls.size(); ++i) {
            Analysis analysis = this.analyzeSQL(sqls.get(i));
            assert (analysis != null);
            Assert.assertEquals(results.get(i), (Object)analysis.getDeviceViewIntoPathDescriptor().getDeviceToSourceTargetPathPairListMap());
        }
    }

    private Analysis analyzeSQL(String sql) {
        try {
            Statement statement = StatementGenerator.createStatement((String)sql, (ZoneId)ZonedDateTime.now().getOffset());
            MPPQueryContext context = new MPPQueryContext(new QueryId("test_query"));
            Analyzer analyzer = new Analyzer(context, (IPartitionFetcher)new FakePartitionFetcherImpl(), (ISchemaFetcher)new FakeSchemaFetcherImpl());
            return analyzer.analyze(statement);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)(sql + ", " + e.getMessage()));
            Assert.fail();
            return null;
        }
    }

    private void alignByTimeAnalysisEqualTest(Analysis actualAnalysis, Analysis expectedAnalysis) {
        this.commonAnalysisEqualTest(expectedAnalysis, actualAnalysis);
        Assert.assertEquals((Object)expectedAnalysis.getSourceExpressions(), (Object)actualAnalysis.getSourceExpressions());
        Assert.assertEquals((Object)expectedAnalysis.getSourceTransformExpressions(), (Object)actualAnalysis.getSourceTransformExpressions());
        Assert.assertEquals((Object)expectedAnalysis.getWhereExpression(), (Object)actualAnalysis.getWhereExpression());
        Assert.assertEquals((Object)expectedAnalysis.getAggregationExpressions(), (Object)actualAnalysis.getAggregationExpressions());
        Assert.assertEquals((Object)expectedAnalysis.getCrossGroupByExpressions(), (Object)actualAnalysis.getCrossGroupByExpressions());
    }

    private void alignByDeviceAnalysisEqualTest(Analysis actualAnalysis, Analysis expectedAnalysis) {
        this.commonAnalysisEqualTest(expectedAnalysis, actualAnalysis);
        Assert.assertEquals((Object)expectedAnalysis.getDeviceToSourceExpressions(), (Object)actualAnalysis.getDeviceToSourceExpressions());
        Assert.assertEquals((Object)expectedAnalysis.getDeviceToSourceTransformExpressions(), (Object)actualAnalysis.getDeviceToSourceTransformExpressions());
        Assert.assertEquals((Object)expectedAnalysis.getDeviceToWhereExpression(), (Object)actualAnalysis.getDeviceToWhereExpression());
        Assert.assertEquals((Object)expectedAnalysis.getDeviceToAggregationExpressions(), (Object)actualAnalysis.getDeviceToAggregationExpressions());
        Assert.assertEquals((Object)expectedAnalysis.getDeviceToSelectExpressions(), (Object)actualAnalysis.getDeviceToSelectExpressions());
        Assert.assertEquals((Object)expectedAnalysis.getDeviceViewOutputExpressions(), (Object)actualAnalysis.getDeviceViewOutputExpressions());
        Assert.assertEquals((Object)expectedAnalysis.getDeviceViewInputIndexesMap(), (Object)actualAnalysis.getDeviceViewInputIndexesMap());
    }

    private void commonAnalysisEqualTest(Analysis actualAnalysis, Analysis expectedAnalysis) {
        Assert.assertEquals((Object)expectedAnalysis.getSelectExpressions(), (Object)actualAnalysis.getSelectExpressions());
        Assert.assertEquals((Object)expectedAnalysis.getHavingExpression(), (Object)actualAnalysis.getHavingExpression());
        Assert.assertEquals((Object)expectedAnalysis.getRespDatasetHeader(), (Object)actualAnalysis.getRespDatasetHeader());
        Assert.assertEquals((Object)expectedAnalysis.getGlobalTimeFilter(), (Object)actualAnalysis.getGlobalTimeFilter());
    }
}

