/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.analyze;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.mpp.common.MPPQueryContext;
import org.apache.iotdb.db.mpp.common.QueryId;
import org.apache.iotdb.db.mpp.plan.analyze.Analyzer;
import org.apache.iotdb.db.mpp.plan.analyze.FakePartitionFetcherImpl;
import org.apache.iotdb.db.mpp.plan.analyze.FakeSchemaFetcherImpl;
import org.apache.iotdb.db.mpp.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.ISchemaFetcher;
import org.apache.iotdb.db.mpp.plan.parser.StatementGenerator;
import org.apache.iotdb.db.mpp.plan.statement.component.IntoComponent;
import org.junit.Assert;
import org.junit.Test;

public class AnalyzeFailTest {
    @Test
    public void illegalAggregationTest1() {
        String message = "Raw data and aggregation result hybrid calculation is not supported.";
        this.assertAnalyzeSemanticException("SELECT sum(s1) + s1 FROM root.sg.d1", message);
    }

    @Test
    public void illegalAggregationTest2() {
        String message = "Aggregation results cannot be as input of the aggregation function.";
        this.assertAnalyzeSemanticException("SELECT sum(sum(s1)) FROM root.sg.d1", message);
    }

    @Test
    public void illegalAggregationTest3() {
        String message = "Raw data and aggregation hybrid query is not supported.";
        this.assertAnalyzeSemanticException("SELECT sum(s1), s1 FROM root.sg.d1", message);
    }

    @Test
    public void samePropertyKeyTest() {
        this.assertAnalyzeSemanticException("CREATE TIMESERIES root.sg1.d1.s1 INT32 TAGS('a'='1') ATTRIBUTES('a'='1')", "Tag and attribute shouldn't have the same property key");
    }

    @Test
    public void sameMeasurementsInAlignedTest() {
        this.assertAnalyzeSemanticException("CREATE ALIGNED TIMESERIES root.ln.wf01.GPS(latitude FLOAT, latitude FLOAT)", "Measurement under an aligned device is not allowed to have the same measurement name");
    }

    @Test
    public void selectIntoTest() {
        this.assertAnalyzeSemanticException("select s1, s2 into root.sg_bk.new_d(t1, t2) from root.sg.* align by device;", IntoComponent.DEVICE_NUM_MISMATCH_ERROR_MSG);
        this.assertAnalyzeSemanticException("select s1, s2 into root.sg_bk.new_d(t1, t2) from root.sg.*;", IntoComponent.PATH_NUM_MISMATCH_ERROR_MSG);
        this.assertAnalyzeSemanticException("select s1, s2 into root.sg_bk.new_d(t1, t2), root.sg_bk.new_d(t3, t1) from root.sg.* align by device;", IntoComponent.DUPLICATE_TARGET_PATH_ERROR_MSG);
        this.assertAnalyzeSemanticException("select s1, s2 into root.sg_bk.new_d(t1, t2, t1, t4) from root.sg.*;", IntoComponent.DUPLICATE_TARGET_PATH_ERROR_MSG);
        this.assertAnalyzeSemanticException("select s1, s2 into root.sg_bk.new_${1}(t1, t2) from root.sg.* align by device;", IntoComponent.DUPLICATE_TARGET_PATH_ERROR_MSG);
        this.assertAnalyzeSemanticException("select s1, s2 into root.sg_bk.new_${1}(t1, t2), root.sg_bk.new_${1}(t1, t2) from root.sg.*;", IntoComponent.DUPLICATE_TARGET_PATH_ERROR_MSG);
        this.assertAnalyzeSemanticException("select s1, s2 into root.sg_bk.new_d(::) from root.sg.*;", IntoComponent.DUPLICATE_TARGET_PATH_ERROR_MSG);
        this.assertAnalyzeSemanticException("select s1, s2 into root.sg_bk.new_d(t1, t2), aligned root.sg_bk.new_d(t3, t4) from root.sg.* align by device;", IntoComponent.DEVICE_ALIGNMENT_INCONSISTENT_ERROR_MSG);
        this.assertAnalyzeSemanticException("select s1, s2 into root.sg_bk.new_d(t1, t2), aligned root.sg_bk.new_d(t3, t4) from root.sg.*;", IntoComponent.DEVICE_ALIGNMENT_INCONSISTENT_ERROR_MSG);
        this.assertAnalyzeSemanticException("select count(s1), last_value(s2) into root.sg_bk.new_${2}(::) from root.sg.* align by device;", IntoComponent.FORBID_PLACEHOLDER_ERROR_MSG);
        this.assertAnalyzeSemanticException("select count(s1), last_value(s2) into root.sg_bk.new_d1(::), root.sg_bk.new_d2(::) from root.sg.* align by device;", IntoComponent.FORBID_PLACEHOLDER_ERROR_MSG);
        this.assertAnalyzeSemanticException("select count(s1), last_value(s2) into root.sg_bk.new_d1(::), root.sg_bk.new_d2(::) from root.sg.*;", IntoComponent.FORBID_PLACEHOLDER_ERROR_MSG);
        this.assertAnalyzeSemanticException("select count(s1), last_value(s2) into root.sg_bk.new_${2}(t1, t2, t3, t4) from root.sg.*;", IntoComponent.FORBID_PLACEHOLDER_ERROR_MSG);
        this.assertAnalyzeSemanticException("select count(s1), last_value(s2) into root.sg_bk.new_${2}(::) from root.sg.*;", IntoComponent.FORBID_PLACEHOLDER_ERROR_MSG);
        this.assertAnalyzeSemanticException("select s1 + 1, s1 + s2 into root.sg_bk.new_${2}(::) from root.sg.* align by device;", IntoComponent.FORBID_PLACEHOLDER_ERROR_MSG);
        this.assertAnalyzeSemanticException("select s1 + 1, s1 + s2 into root.sg_bk.new_d1(::), root.sg_bk.new_d2(::) from root.sg.* align by device;", IntoComponent.FORBID_PLACEHOLDER_ERROR_MSG);
        this.assertAnalyzeSemanticException("select s1 + 1, s1 + s2 into root.sg_bk.new_d1(::), root.sg_bk.new_d2(::) from root.sg.*;", IntoComponent.FORBID_PLACEHOLDER_ERROR_MSG);
        this.assertAnalyzeSemanticException("select s1 + 1, s1 + s2 into root.sg_bk.new_${2}(t1, t2, t3, t4) from root.sg.*;", IntoComponent.FORBID_PLACEHOLDER_ERROR_MSG);
        this.assertAnalyzeSemanticException("select s1 + 1, s1 + s2 into root.sg_bk.new_${2}(::) from root.sg.*;", IntoComponent.FORBID_PLACEHOLDER_ERROR_MSG);
        this.assertAnalyzeSemanticException("select * into root.sg_bk.new_d1(::), root.sg_bk.new_d2(::) from root.sg.**;", IntoComponent.PLACEHOLDER_MISMATCH_ERROR_MSG);
        this.assertAnalyzeSemanticException("select s1, s2 into root.sg_bk.new_d1(${3}, s2) from root.sg.d1;", IntoComponent.PLACEHOLDER_MISMATCH_ERROR_MSG);
        this.assertAnalyzeSemanticException("select * into root.sg_bk.new_${2}(::, s1) from root.sg.**;", IntoComponent.PLACEHOLDER_MISMATCH_ERROR_MSG);
        this.assertAnalyzeSemanticException("select d1.s1, d1.s2, d2.s3, d3.s4 into ::(s1_1, s2_2, backup_${4}) from root.sg", IntoComponent.PLACEHOLDER_MISMATCH_ERROR_MSG);
        this.assertAnalyzeSemanticException("select s1, s2 into ::(s1_1, s2_2), root.backup_sg.::(s1, s2) from root.sg.* align by device;", IntoComponent.PLACEHOLDER_MISMATCH_ERROR_MSG);
    }

    private void assertAnalyzeSemanticException(String sql, String message) {
        try {
            Analyzer analyzer = new Analyzer(new MPPQueryContext(new QueryId("test_query")), (IPartitionFetcher)new FakePartitionFetcherImpl(), (ISchemaFetcher)new FakeSchemaFetcherImpl());
            analyzer.analyze(StatementGenerator.createStatement((String)sql, (ZoneId)ZonedDateTime.now().getOffset()));
            Assert.fail();
        }
        catch (SemanticException e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains(message));
        }
    }
}

