/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.schedule;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.mpp.common.FragmentInstanceId;
import org.apache.iotdb.db.mpp.common.PlanFragmentId;
import org.apache.iotdb.db.mpp.common.QueryId;
import org.apache.iotdb.db.mpp.execution.driver.IDriver;
import org.apache.iotdb.db.mpp.execution.exchange.IMPPDataExchangeManager;
import org.apache.iotdb.db.mpp.execution.schedule.DriverScheduler;
import org.apache.iotdb.db.mpp.execution.schedule.queue.ID;
import org.apache.iotdb.db.mpp.execution.schedule.task.DriverTask;
import org.apache.iotdb.db.mpp.execution.schedule.task.DriverTaskID;
import org.apache.iotdb.db.mpp.execution.schedule.task.DriverTaskStatus;
import org.apache.iotdb.mpp.rpc.thrift.TFragmentInstanceId;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class DriverSchedulerTest {
    private final DriverScheduler manager = DriverScheduler.getInstance();
    private static final long QUERY_TIMEOUT_MS = IoTDBDescriptor.getInstance().getConfig().getQueryTimeoutThreshold();

    @After
    public void tearDown() {
        this.manager.getQueryMap().clear();
        this.manager.getBlockedTasks().clear();
        this.manager.getReadyQueue().clear();
        this.manager.getTimeoutQueue().clear();
    }

    @Test
    public void testManagingDriver() {
        IMPPDataExchangeManager mockMPPDataExchangeManager = (IMPPDataExchangeManager)Mockito.mock(IMPPDataExchangeManager.class);
        this.manager.setBlockManager(mockMPPDataExchangeManager);
        QueryId queryId = new QueryId("test");
        PlanFragmentId fragmentId = new PlanFragmentId(queryId, 0);
        FragmentInstanceId instanceId1 = new FragmentInstanceId(fragmentId, "inst-0");
        IDriver mockDriver1 = (IDriver)Mockito.mock(IDriver.class);
        Mockito.when((Object)mockDriver1.getInfo()).thenReturn((Object)instanceId1);
        FragmentInstanceId instanceId2 = new FragmentInstanceId(fragmentId, "inst-1");
        IDriver mockDriver2 = (IDriver)Mockito.mock(IDriver.class);
        Mockito.when((Object)mockDriver2.getInfo()).thenReturn((Object)instanceId2);
        List<IDriver> instances = Arrays.asList(mockDriver1, mockDriver2);
        this.manager.submitDrivers(queryId, instances, QUERY_TIMEOUT_MS);
        Assert.assertTrue((boolean)this.manager.getBlockedTasks().isEmpty());
        Assert.assertEquals((long)1L, (long)this.manager.getQueryMap().size());
        Assert.assertTrue((boolean)this.manager.getQueryMap().containsKey(queryId));
        Assert.assertEquals((long)2L, (long)((Set)this.manager.getQueryMap().get(queryId)).size());
        Assert.assertEquals((long)2L, (long)this.manager.getTimeoutQueue().size());
        Assert.assertEquals((long)2L, (long)this.manager.getReadyQueue().size());
        DriverTask task1 = (DriverTask)this.manager.getTimeoutQueue().get((ID)new DriverTaskID(instanceId1));
        Assert.assertNotNull((Object)task1);
        DriverTask task2 = (DriverTask)this.manager.getTimeoutQueue().get((ID)new DriverTaskID(instanceId2));
        Assert.assertNotNull((Object)task2);
        Assert.assertTrue((boolean)((Set)this.manager.getQueryMap().get(queryId)).contains(task1));
        Assert.assertTrue((boolean)((Set)this.manager.getQueryMap().get(queryId)).contains(task2));
        Assert.assertEquals((Object)DriverTaskStatus.READY, (Object)task1.getStatus());
        Assert.assertEquals((Object)DriverTaskStatus.READY, (Object)task2.getStatus());
        IDriver mockDriver3 = (IDriver)Mockito.mock(IDriver.class);
        FragmentInstanceId instanceId3 = new FragmentInstanceId(fragmentId, "inst-2");
        Mockito.when((Object)mockDriver3.getInfo()).thenReturn((Object)instanceId3);
        this.manager.submitDrivers(queryId, Collections.singletonList(mockDriver3), QUERY_TIMEOUT_MS);
        Assert.assertTrue((boolean)this.manager.getBlockedTasks().isEmpty());
        Assert.assertEquals((long)1L, (long)this.manager.getQueryMap().size());
        Assert.assertTrue((boolean)this.manager.getQueryMap().containsKey(queryId));
        Assert.assertEquals((long)3L, (long)((Set)this.manager.getQueryMap().get(queryId)).size());
        Assert.assertEquals((long)3L, (long)this.manager.getTimeoutQueue().size());
        Assert.assertEquals((long)3L, (long)this.manager.getReadyQueue().size());
        DriverTask task3 = (DriverTask)this.manager.getTimeoutQueue().get((ID)new DriverTaskID(instanceId3));
        Assert.assertNotNull((Object)task3);
        Assert.assertTrue((boolean)((Set)this.manager.getQueryMap().get(queryId)).contains(task3));
        Assert.assertEquals((Object)DriverTaskStatus.READY, (Object)task3.getStatus());
        QueryId queryId2 = new QueryId("test2");
        PlanFragmentId fragmentId2 = new PlanFragmentId(queryId2, 0);
        FragmentInstanceId instanceId4 = new FragmentInstanceId(fragmentId2, "inst-0");
        IDriver mockDriver4 = (IDriver)Mockito.mock(IDriver.class);
        Mockito.when((Object)mockDriver4.getInfo()).thenReturn((Object)instanceId4);
        this.manager.submitDrivers(queryId2, Collections.singletonList(mockDriver4), QUERY_TIMEOUT_MS);
        Assert.assertTrue((boolean)this.manager.getBlockedTasks().isEmpty());
        Assert.assertEquals((long)2L, (long)this.manager.getQueryMap().size());
        Assert.assertTrue((boolean)this.manager.getQueryMap().containsKey(queryId2));
        Assert.assertEquals((long)1L, (long)((Set)this.manager.getQueryMap().get(queryId2)).size());
        Assert.assertEquals((long)4L, (long)this.manager.getTimeoutQueue().size());
        Assert.assertEquals((long)4L, (long)this.manager.getReadyQueue().size());
        DriverTask task4 = (DriverTask)this.manager.getTimeoutQueue().get((ID)new DriverTaskID(instanceId4));
        Assert.assertNotNull((Object)task4);
        Assert.assertTrue((boolean)((Set)this.manager.getQueryMap().get(queryId2)).contains(task4));
        Assert.assertEquals((Object)DriverTaskStatus.READY, (Object)task4.getStatus());
        Mockito.reset((Object[])new IDriver[]{mockDriver1});
        Mockito.when((Object)mockDriver1.getInfo()).thenReturn((Object)instanceId1);
        this.manager.abortFragmentInstance(instanceId1);
        ((IMPPDataExchangeManager)Mockito.verify((Object)mockMPPDataExchangeManager, (VerificationMode)Mockito.times((int)1))).forceDeregisterFragmentInstance((TFragmentInstanceId)Mockito.any());
        Assert.assertTrue((boolean)this.manager.getBlockedTasks().isEmpty());
        Assert.assertEquals((long)2L, (long)this.manager.getQueryMap().size());
        Assert.assertTrue((boolean)this.manager.getQueryMap().containsKey(queryId));
        Assert.assertEquals((long)3L, (long)this.manager.getTimeoutQueue().size());
        Assert.assertEquals((long)3L, (long)this.manager.getReadyQueue().size());
        Assert.assertEquals((Object)DriverTaskStatus.ABORTED, (Object)task1.getStatus());
        Assert.assertEquals((Object)DriverTaskStatus.READY, (Object)task2.getStatus());
        Assert.assertEquals((Object)DriverTaskStatus.READY, (Object)task3.getStatus());
        Assert.assertEquals((Object)DriverTaskStatus.READY, (Object)task4.getStatus());
        ((IDriver)Mockito.verify((Object)mockDriver1, (VerificationMode)Mockito.times((int)1))).failed((Throwable)Mockito.any());
        Assert.assertEquals((Object)" called", (Object)task1.getAbortCause());
        Mockito.reset((Object[])new IMPPDataExchangeManager[]{mockMPPDataExchangeManager});
        Mockito.reset((Object[])new IDriver[]{mockDriver1});
        Mockito.when((Object)mockDriver1.getInfo()).thenReturn((Object)instanceId1);
        Mockito.reset((Object[])new IDriver[]{mockDriver2});
        Mockito.when((Object)mockDriver2.getInfo()).thenReturn((Object)instanceId2);
        Mockito.reset((Object[])new IDriver[]{mockDriver3});
        Mockito.when((Object)mockDriver3.getInfo()).thenReturn((Object)instanceId3);
        this.manager.abortQuery(queryId);
        ((IMPPDataExchangeManager)Mockito.verify((Object)mockMPPDataExchangeManager, (VerificationMode)Mockito.times((int)2))).forceDeregisterFragmentInstance((TFragmentInstanceId)Mockito.any());
        Assert.assertTrue((boolean)this.manager.getBlockedTasks().isEmpty());
        Assert.assertEquals((long)1L, (long)this.manager.getQueryMap().size());
        Assert.assertFalse((boolean)this.manager.getQueryMap().containsKey(queryId));
        Assert.assertEquals((long)1L, (long)this.manager.getTimeoutQueue().size());
        Assert.assertEquals((long)1L, (long)this.manager.getReadyQueue().size());
        Assert.assertEquals((Object)DriverTaskStatus.ABORTED, (Object)task1.getStatus());
        Assert.assertEquals((Object)DriverTaskStatus.ABORTED, (Object)task2.getStatus());
        Assert.assertEquals((Object)DriverTaskStatus.ABORTED, (Object)task3.getStatus());
        Assert.assertEquals((Object)DriverTaskStatus.READY, (Object)task4.getStatus());
        ((IDriver)Mockito.verify((Object)mockDriver1, (VerificationMode)Mockito.never())).failed((Throwable)Mockito.any());
        ((IDriver)Mockito.verify((Object)mockDriver2, (VerificationMode)Mockito.times((int)1))).failed((Throwable)Mockito.any());
        ((IDriver)Mockito.verify((Object)mockDriver3, (VerificationMode)Mockito.times((int)1))).failed((Throwable)Mockito.any());
        ((IDriver)Mockito.verify((Object)mockDriver4, (VerificationMode)Mockito.never())).failed((Throwable)Mockito.any());
        Assert.assertEquals((Object)"query cascading aborted", (Object)task2.getAbortCause());
        Assert.assertEquals((Object)"query cascading aborted", (Object)task3.getAbortCause());
        Assert.assertNull((Object)task4.getAbortCause());
    }
}

