/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.schedule;

import io.airlift.units.Duration;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.db.mpp.common.FragmentInstanceId;
import org.apache.iotdb.db.mpp.common.PlanFragmentId;
import org.apache.iotdb.db.mpp.common.QueryId;
import org.apache.iotdb.db.mpp.execution.driver.IDriver;
import org.apache.iotdb.db.mpp.execution.exchange.IMPPDataExchangeManager;
import org.apache.iotdb.db.mpp.execution.schedule.DriverScheduler;
import org.apache.iotdb.db.mpp.execution.schedule.ExecutionContext;
import org.apache.iotdb.db.mpp.execution.schedule.ITaskScheduler;
import org.apache.iotdb.db.mpp.execution.schedule.queue.ID;
import org.apache.iotdb.db.mpp.execution.schedule.queue.IDIndexedAccessible;
import org.apache.iotdb.db.mpp.execution.schedule.task.DriverTask;
import org.apache.iotdb.db.mpp.execution.schedule.task.DriverTaskStatus;
import org.apache.iotdb.db.utils.stats.CpuTimer;
import org.apache.iotdb.mpp.rpc.thrift.IDataNodeRPCService;
import org.apache.iotdb.mpp.rpc.thrift.TFragmentInstanceId;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class DefaultDriverSchedulerTest {
    private final DriverScheduler manager = DriverScheduler.getInstance();

    @After
    public void tearDown() throws IOException {
        this.clear();
    }

    @Test
    public void testBlockedToReady() {
        DriverTaskStatus[] invalidStates;
        IMPPDataExchangeManager mockMPPDataExchangeManager = (IMPPDataExchangeManager)Mockito.mock(IMPPDataExchangeManager.class);
        this.manager.setBlockManager(mockMPPDataExchangeManager);
        ITaskScheduler defaultScheduler = this.manager.getScheduler();
        IDriver mockDriver = (IDriver)Mockito.mock(IDriver.class);
        QueryId queryId = new QueryId("test");
        FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "inst-0");
        Mockito.when((Object)mockDriver.getInfo()).thenReturn((Object)instanceId);
        for (DriverTaskStatus status : invalidStates = new DriverTaskStatus[]{DriverTaskStatus.FINISHED, DriverTaskStatus.ABORTED, DriverTaskStatus.READY, DriverTaskStatus.RUNNING}) {
            DriverTask testTask = new DriverTask(mockDriver, 100L, status);
            this.manager.getBlockedTasks().add(testTask);
            HashSet<DriverTask> taskSet = new HashSet<DriverTask>();
            taskSet.add(testTask);
            this.manager.getQueryMap().put(queryId, taskSet);
            this.manager.getTimeoutQueue().push((IDIndexedAccessible)testTask);
            defaultScheduler.blockedToReady(testTask);
            Assert.assertEquals((Object)status, (Object)testTask.getStatus());
            Assert.assertTrue((boolean)this.manager.getBlockedTasks().contains(testTask));
            Assert.assertNull((Object)this.manager.getReadyQueue().get((ID)testTask.getId()));
            Assert.assertNotNull((Object)this.manager.getTimeoutQueue().get((ID)testTask.getId()));
            Assert.assertTrue((boolean)this.manager.getQueryMap().containsKey(queryId));
            Assert.assertTrue((boolean)((Set)this.manager.getQueryMap().get(queryId)).contains(testTask));
            this.clear();
        }
        DriverTask testTask = new DriverTask(mockDriver, 100L, DriverTaskStatus.BLOCKED);
        this.manager.getBlockedTasks().add(testTask);
        HashSet<DriverTask> taskSet = new HashSet<DriverTask>();
        taskSet.add(testTask);
        this.manager.getQueryMap().put(queryId, taskSet);
        this.manager.getTimeoutQueue().push((IDIndexedAccessible)testTask);
        defaultScheduler.blockedToReady(testTask);
        Assert.assertEquals((Object)DriverTaskStatus.READY, (Object)testTask.getStatus());
        Assert.assertFalse((boolean)this.manager.getBlockedTasks().contains(testTask));
        Assert.assertNotNull((Object)this.manager.getReadyQueue().get((ID)testTask.getId()));
        Assert.assertNotNull((Object)this.manager.getTimeoutQueue().get((ID)testTask.getId()));
        Assert.assertTrue((boolean)this.manager.getQueryMap().containsKey(queryId));
        Assert.assertTrue((boolean)((Set)this.manager.getQueryMap().get(queryId)).contains(testTask));
        ((IDriver)Mockito.verify((Object)mockDriver, (VerificationMode)Mockito.never())).failed((Throwable)Mockito.any());
        this.clear();
    }

    @Test
    public void testReadyToRunning() {
        DriverTaskStatus[] invalidStates;
        IMPPDataExchangeManager mockMPPDataExchangeManager = (IMPPDataExchangeManager)Mockito.mock(IMPPDataExchangeManager.class);
        this.manager.setBlockManager(mockMPPDataExchangeManager);
        ITaskScheduler defaultScheduler = this.manager.getScheduler();
        IDriver mockDriver = (IDriver)Mockito.mock(IDriver.class);
        QueryId queryId = new QueryId("test");
        FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "inst-0");
        Mockito.when((Object)mockDriver.getInfo()).thenReturn((Object)instanceId);
        for (DriverTaskStatus status : invalidStates = new DriverTaskStatus[]{DriverTaskStatus.FINISHED, DriverTaskStatus.ABORTED, DriverTaskStatus.BLOCKED, DriverTaskStatus.RUNNING}) {
            DriverTask testTask = new DriverTask(mockDriver, 100L, status);
            HashSet<DriverTask> taskSet = new HashSet<DriverTask>();
            taskSet.add(testTask);
            this.manager.getQueryMap().put(queryId, taskSet);
            this.manager.getTimeoutQueue().push((IDIndexedAccessible)testTask);
            defaultScheduler.readyToRunning(testTask);
            Assert.assertEquals((Object)status, (Object)testTask.getStatus());
            Assert.assertFalse((boolean)this.manager.getBlockedTasks().contains(testTask));
            Assert.assertNotNull((Object)this.manager.getTimeoutQueue().get((ID)testTask.getId()));
            Assert.assertTrue((boolean)this.manager.getQueryMap().containsKey(queryId));
            Assert.assertTrue((boolean)((Set)this.manager.getQueryMap().get(queryId)).contains(testTask));
            this.clear();
        }
        DriverTask testTask = new DriverTask(mockDriver, 100L, DriverTaskStatus.READY);
        HashSet<DriverTask> taskSet = new HashSet<DriverTask>();
        taskSet.add(testTask);
        this.manager.getQueryMap().put(queryId, taskSet);
        this.manager.getTimeoutQueue().push((IDIndexedAccessible)testTask);
        defaultScheduler.readyToRunning(testTask);
        Assert.assertEquals((Object)DriverTaskStatus.RUNNING, (Object)testTask.getStatus());
        Assert.assertFalse((boolean)this.manager.getBlockedTasks().contains(testTask));
        Assert.assertNotNull((Object)this.manager.getTimeoutQueue().get((ID)testTask.getId()));
        Assert.assertTrue((boolean)this.manager.getQueryMap().containsKey(queryId));
        Assert.assertTrue((boolean)((Set)this.manager.getQueryMap().get(queryId)).contains(testTask));
        ((IDriver)Mockito.verify((Object)mockDriver, (VerificationMode)Mockito.never())).failed((Throwable)Mockito.any());
        this.clear();
    }

    @Test
    public void testRunningToReady() {
        DriverTaskStatus[] invalidStates;
        IMPPDataExchangeManager mockMPPDataExchangeManager = (IMPPDataExchangeManager)Mockito.mock(IMPPDataExchangeManager.class);
        this.manager.setBlockManager(mockMPPDataExchangeManager);
        ITaskScheduler defaultScheduler = this.manager.getScheduler();
        IDriver mockDriver = (IDriver)Mockito.mock(IDriver.class);
        QueryId queryId = new QueryId("test");
        FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "inst-0");
        Mockito.when((Object)mockDriver.getInfo()).thenReturn((Object)instanceId);
        for (DriverTaskStatus status : invalidStates = new DriverTaskStatus[]{DriverTaskStatus.FINISHED, DriverTaskStatus.ABORTED, DriverTaskStatus.BLOCKED, DriverTaskStatus.READY}) {
            DriverTask testTask = new DriverTask(mockDriver, 100L, status);
            HashSet<DriverTask> taskSet = new HashSet<DriverTask>();
            taskSet.add(testTask);
            this.manager.getQueryMap().put(queryId, taskSet);
            this.manager.getTimeoutQueue().push((IDIndexedAccessible)testTask);
            defaultScheduler.runningToReady(testTask, new ExecutionContext());
            Assert.assertEquals((Object)status, (Object)testTask.getStatus());
            Assert.assertFalse((boolean)this.manager.getBlockedTasks().contains(testTask));
            Assert.assertNull((Object)this.manager.getReadyQueue().get((ID)testTask.getId()));
            Assert.assertNotNull((Object)this.manager.getTimeoutQueue().get((ID)testTask.getId()));
            Assert.assertTrue((boolean)this.manager.getQueryMap().containsKey(queryId));
            Assert.assertTrue((boolean)((Set)this.manager.getQueryMap().get(queryId)).contains(testTask));
            this.clear();
        }
        DriverTask testTask = new DriverTask(mockDriver, 100L, DriverTaskStatus.RUNNING);
        HashSet<DriverTask> taskSet = new HashSet<DriverTask>();
        taskSet.add(testTask);
        this.manager.getQueryMap().put(queryId, taskSet);
        this.manager.getTimeoutQueue().push((IDIndexedAccessible)testTask);
        ExecutionContext context = new ExecutionContext();
        context.setTimeSlice(new Duration(1.0, TimeUnit.SECONDS));
        context.setCpuDuration(new CpuTimer.CpuDuration());
        defaultScheduler.runningToReady(testTask, context);
        Assert.assertEquals((double)0.0, (double)testTask.getSchedulePriority(), (double)1.0E-5);
        Assert.assertEquals((Object)DriverTaskStatus.READY, (Object)testTask.getStatus());
        Assert.assertFalse((boolean)this.manager.getBlockedTasks().contains(testTask));
        Assert.assertNotNull((Object)this.manager.getReadyQueue().get((ID)testTask.getId()));
        Assert.assertNotNull((Object)this.manager.getTimeoutQueue().get((ID)testTask.getId()));
        Assert.assertTrue((boolean)this.manager.getQueryMap().containsKey(queryId));
        Assert.assertTrue((boolean)((Set)this.manager.getQueryMap().get(queryId)).contains(testTask));
        ((IDriver)Mockito.verify((Object)mockDriver, (VerificationMode)Mockito.never())).failed((Throwable)Mockito.any());
        this.clear();
    }

    @Test
    public void testRunningToBlocked() {
        DriverTaskStatus[] invalidStates;
        IMPPDataExchangeManager mockMPPDataExchangeManager = (IMPPDataExchangeManager)Mockito.mock(IMPPDataExchangeManager.class);
        this.manager.setBlockManager(mockMPPDataExchangeManager);
        ITaskScheduler defaultScheduler = this.manager.getScheduler();
        IDriver mockDriver = (IDriver)Mockito.mock(IDriver.class);
        QueryId queryId = new QueryId("test");
        FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "inst-0");
        Mockito.when((Object)mockDriver.getInfo()).thenReturn((Object)instanceId);
        for (DriverTaskStatus status : invalidStates = new DriverTaskStatus[]{DriverTaskStatus.FINISHED, DriverTaskStatus.ABORTED, DriverTaskStatus.BLOCKED, DriverTaskStatus.READY}) {
            DriverTask testTask = new DriverTask(mockDriver, 100L, status);
            HashSet<DriverTask> taskSet = new HashSet<DriverTask>();
            taskSet.add(testTask);
            this.manager.getQueryMap().put(queryId, taskSet);
            this.manager.getTimeoutQueue().push((IDIndexedAccessible)testTask);
            defaultScheduler.runningToBlocked(testTask, new ExecutionContext());
            Assert.assertEquals((Object)status, (Object)testTask.getStatus());
            Assert.assertFalse((boolean)this.manager.getBlockedTasks().contains(testTask));
            Assert.assertNull((Object)this.manager.getReadyQueue().get((ID)testTask.getId()));
            Assert.assertNotNull((Object)this.manager.getTimeoutQueue().get((ID)testTask.getId()));
            Assert.assertTrue((boolean)this.manager.getQueryMap().containsKey(queryId));
            Assert.assertTrue((boolean)((Set)this.manager.getQueryMap().get(queryId)).contains(testTask));
            this.clear();
        }
        DriverTask testTask = new DriverTask(mockDriver, 100L, DriverTaskStatus.RUNNING);
        HashSet<DriverTask> taskSet = new HashSet<DriverTask>();
        taskSet.add(testTask);
        this.manager.getQueryMap().put(queryId, taskSet);
        this.manager.getTimeoutQueue().push((IDIndexedAccessible)testTask);
        ExecutionContext context = new ExecutionContext();
        context.setTimeSlice(new Duration(1.0, TimeUnit.SECONDS));
        context.setCpuDuration(new CpuTimer.CpuDuration());
        defaultScheduler.runningToBlocked(testTask, context);
        Assert.assertEquals((double)0.0, (double)testTask.getSchedulePriority(), (double)1.0E-5);
        Assert.assertEquals((Object)DriverTaskStatus.BLOCKED, (Object)testTask.getStatus());
        Assert.assertTrue((boolean)this.manager.getBlockedTasks().contains(testTask));
        Assert.assertNull((Object)this.manager.getReadyQueue().get((ID)testTask.getId()));
        Assert.assertNotNull((Object)this.manager.getTimeoutQueue().get((ID)testTask.getId()));
        Assert.assertTrue((boolean)this.manager.getQueryMap().containsKey(queryId));
        Assert.assertTrue((boolean)((Set)this.manager.getQueryMap().get(queryId)).contains(testTask));
        ((IDriver)Mockito.verify((Object)mockDriver, (VerificationMode)Mockito.never())).failed((Throwable)Mockito.any());
        this.clear();
    }

    @Test
    public void testRunningToFinished() {
        DriverTaskStatus[] invalidStates;
        IMPPDataExchangeManager mockMPPDataExchangeManager = (IMPPDataExchangeManager)Mockito.mock(IMPPDataExchangeManager.class);
        this.manager.setBlockManager(mockMPPDataExchangeManager);
        ITaskScheduler defaultScheduler = this.manager.getScheduler();
        IDriver mockDriver = (IDriver)Mockito.mock(IDriver.class);
        QueryId queryId = new QueryId("test");
        FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "inst-0");
        Mockito.when((Object)mockDriver.getInfo()).thenReturn((Object)instanceId);
        for (DriverTaskStatus status : invalidStates = new DriverTaskStatus[]{DriverTaskStatus.FINISHED, DriverTaskStatus.ABORTED, DriverTaskStatus.BLOCKED, DriverTaskStatus.READY}) {
            DriverTask testTask = new DriverTask(mockDriver, 100L, status);
            HashSet<DriverTask> taskSet = new HashSet<DriverTask>();
            taskSet.add(testTask);
            this.manager.getQueryMap().put(queryId, taskSet);
            this.manager.getTimeoutQueue().push((IDIndexedAccessible)testTask);
            defaultScheduler.runningToFinished(testTask, new ExecutionContext());
            Assert.assertEquals((Object)status, (Object)testTask.getStatus());
            Assert.assertFalse((boolean)this.manager.getBlockedTasks().contains(testTask));
            Assert.assertNull((Object)this.manager.getReadyQueue().get((ID)testTask.getId()));
            Assert.assertNotNull((Object)this.manager.getTimeoutQueue().get((ID)testTask.getId()));
            Assert.assertTrue((boolean)this.manager.getQueryMap().containsKey(queryId));
            Assert.assertTrue((boolean)((Set)this.manager.getQueryMap().get(queryId)).contains(testTask));
            this.clear();
        }
        DriverTask testTask = new DriverTask(mockDriver, 100L, DriverTaskStatus.RUNNING);
        HashSet<DriverTask> taskSet = new HashSet<DriverTask>();
        taskSet.add(testTask);
        this.manager.getQueryMap().put(queryId, taskSet);
        this.manager.getTimeoutQueue().push((IDIndexedAccessible)testTask);
        ExecutionContext context = new ExecutionContext();
        context.setTimeSlice(new Duration(1.0, TimeUnit.SECONDS));
        context.setCpuDuration(new CpuTimer.CpuDuration());
        defaultScheduler.runningToFinished(testTask, context);
        Assert.assertEquals((double)0.0, (double)testTask.getSchedulePriority(), (double)1.0E-5);
        Assert.assertEquals((Object)DriverTaskStatus.FINISHED, (Object)testTask.getStatus());
        Assert.assertFalse((boolean)this.manager.getBlockedTasks().contains(testTask));
        Assert.assertNull((Object)this.manager.getReadyQueue().get((ID)testTask.getId()));
        Assert.assertNull((Object)this.manager.getTimeoutQueue().get((ID)testTask.getId()));
        Assert.assertFalse((boolean)this.manager.getQueryMap().containsKey(queryId));
        ((IDriver)Mockito.verify((Object)mockDriver, (VerificationMode)Mockito.never())).failed((Throwable)Mockito.any());
        this.clear();
    }

    @Test
    public void testToAbort() {
        DriverTaskStatus[] validStates;
        DriverTaskStatus[] invalidStates;
        IMPPDataExchangeManager mockMPPDataExchangeManager = (IMPPDataExchangeManager)Mockito.mock(IMPPDataExchangeManager.class);
        this.manager.setBlockManager(mockMPPDataExchangeManager);
        IDataNodeRPCService.Client mockMppServiceClient = (IDataNodeRPCService.Client)Mockito.mock(IDataNodeRPCService.Client.class);
        ITaskScheduler defaultScheduler = this.manager.getScheduler();
        QueryId queryId = new QueryId("test");
        FragmentInstanceId instanceId1 = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "inst-0");
        IDriver mockDriver1 = (IDriver)Mockito.mock(IDriver.class);
        Mockito.when((Object)mockDriver1.getInfo()).thenReturn((Object)instanceId1);
        IDriver mockDriver2 = (IDriver)Mockito.mock(IDriver.class);
        FragmentInstanceId instanceId2 = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "inst-1");
        Mockito.when((Object)mockDriver2.getInfo()).thenReturn((Object)instanceId2);
        for (DriverTaskStatus status : invalidStates = new DriverTaskStatus[]{DriverTaskStatus.FINISHED, DriverTaskStatus.ABORTED}) {
            DriverTask testTask1 = new DriverTask(mockDriver1, 100L, status);
            DriverTask testTask2 = new DriverTask(mockDriver2, 100L, DriverTaskStatus.BLOCKED);
            HashSet<DriverTask> taskSet = new HashSet<DriverTask>();
            taskSet.add(testTask1);
            taskSet.add(testTask2);
            this.manager.getQueryMap().put(queryId, taskSet);
            this.manager.getTimeoutQueue().push((IDIndexedAccessible)testTask1);
            this.manager.getTimeoutQueue().push((IDIndexedAccessible)testTask2);
            this.manager.getBlockedTasks().add(testTask2);
            defaultScheduler.toAborted(testTask1);
            Assert.assertEquals((Object)status, (Object)testTask1.getStatus());
            Assert.assertEquals((Object)DriverTaskStatus.BLOCKED, (Object)testTask2.getStatus());
            Assert.assertFalse((boolean)this.manager.getBlockedTasks().contains(testTask1));
            Assert.assertTrue((boolean)this.manager.getBlockedTasks().contains(testTask2));
            Assert.assertNull((Object)this.manager.getReadyQueue().get((ID)testTask1.getId()));
            Assert.assertNull((Object)this.manager.getReadyQueue().get((ID)testTask2.getId()));
            Assert.assertNotNull((Object)this.manager.getTimeoutQueue().get((ID)testTask1.getId()));
            Assert.assertNotNull((Object)this.manager.getTimeoutQueue().get((ID)testTask2.getId()));
            Assert.assertTrue((boolean)this.manager.getQueryMap().containsKey(queryId));
            Assert.assertTrue((boolean)((Set)this.manager.getQueryMap().get(queryId)).contains(testTask1));
            Assert.assertTrue((boolean)((Set)this.manager.getQueryMap().get(queryId)).contains(testTask2));
            ((IDriver)Mockito.verify((Object)mockDriver1, (VerificationMode)Mockito.never())).failed((Throwable)Mockito.any());
            ((IDriver)Mockito.verify((Object)mockDriver2, (VerificationMode)Mockito.never())).failed((Throwable)Mockito.any());
            this.clear();
        }
        for (DriverTaskStatus status : validStates = new DriverTaskStatus[]{DriverTaskStatus.RUNNING, DriverTaskStatus.READY, DriverTaskStatus.BLOCKED}) {
            Mockito.reset((Object[])new IDriver[]{mockDriver1});
            Mockito.when((Object)mockDriver1.getInfo()).thenReturn((Object)instanceId1);
            Mockito.reset((Object[])new IDriver[]{mockDriver2});
            Mockito.when((Object)mockDriver2.getInfo()).thenReturn((Object)instanceId2);
            DriverTask testTask1 = new DriverTask(mockDriver1, 100L, status);
            DriverTask testTask2 = new DriverTask(mockDriver2, 100L, DriverTaskStatus.BLOCKED);
            HashSet<DriverTask> taskSet = new HashSet<DriverTask>();
            taskSet.add(testTask1);
            taskSet.add(testTask2);
            this.manager.getQueryMap().put(queryId, taskSet);
            this.manager.getTimeoutQueue().push((IDIndexedAccessible)testTask1);
            defaultScheduler.toAborted(testTask1);
            Mockito.reset((Object[])new IDataNodeRPCService.Client[]{mockMppServiceClient});
            ((IMPPDataExchangeManager)Mockito.verify((Object)mockMPPDataExchangeManager, (VerificationMode)Mockito.times((int)2))).forceDeregisterFragmentInstance((TFragmentInstanceId)Mockito.any());
            Mockito.reset((Object[])new IMPPDataExchangeManager[]{mockMPPDataExchangeManager});
            Assert.assertEquals((Object)DriverTaskStatus.ABORTED, (Object)testTask1.getStatus());
            Assert.assertEquals((Object)DriverTaskStatus.ABORTED, (Object)testTask2.getStatus());
            Assert.assertFalse((boolean)this.manager.getBlockedTasks().contains(testTask1));
            Assert.assertFalse((boolean)this.manager.getBlockedTasks().contains(testTask2));
            Assert.assertNull((Object)this.manager.getReadyQueue().get((ID)testTask1.getId()));
            Assert.assertNull((Object)this.manager.getReadyQueue().get((ID)testTask2.getId()));
            Assert.assertNull((Object)this.manager.getTimeoutQueue().get((ID)testTask1.getId()));
            Assert.assertNull((Object)this.manager.getTimeoutQueue().get((ID)testTask2.getId()));
            Assert.assertFalse((boolean)this.manager.getQueryMap().containsKey(queryId));
            ((IDriver)Mockito.verify((Object)mockDriver1, (VerificationMode)Mockito.never())).failed((Throwable)Mockito.any());
            ((IDriver)Mockito.verify((Object)mockDriver2, (VerificationMode)Mockito.times((int)1))).failed((Throwable)Mockito.any());
            this.clear();
        }
    }

    private void clear() {
        this.manager.getQueryMap().clear();
        this.manager.getBlockedTasks().clear();
        this.manager.getReadyQueue().clear();
        this.manager.getTimeoutQueue().clear();
    }
}

