/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.schema;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.consensus.SchemaRegionId;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.ICreateAlignedTimeSeriesPlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.ICreateTimeSeriesPlan;
import org.apache.iotdb.db.metadata.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.metadata.schemaregion.SchemaEngine;
import org.apache.iotdb.db.mpp.common.schematree.ClusterSchemaTree;
import org.apache.iotdb.db.mpp.common.schematree.DeviceSchemaInfo;
import org.apache.iotdb.db.mpp.execution.operator.schema.SchemaFetchScanOperator;
import org.apache.iotdb.db.qp.physical.sys.CreateAlignedTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTimeSeriesPlan;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SchemaFetchScanOperatorTest {
    @Before
    public void setUp() {
        EnvironmentUtils.envSetUp();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void testSchemaFetchResult() throws Exception {
        ISchemaRegion schemaRegion = this.prepareSchemaRegion();
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendPathPattern(new PartialPath("root.**.status"));
        patternTree.appendPathPattern(new PartialPath("root.**.s1"));
        patternTree.constructTree();
        SchemaFetchScanOperator schemaFetchScanOperator = new SchemaFetchScanOperator(null, null, patternTree, Collections.emptyMap(), schemaRegion, false);
        Assert.assertTrue((boolean)schemaFetchScanOperator.hasNext());
        TsBlock tsBlock = schemaFetchScanOperator.next();
        Assert.assertFalse((boolean)schemaFetchScanOperator.hasNext());
        Binary binary = tsBlock.getColumn(0).getBinary(0);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(binary.getValues());
        Assert.assertEquals((long)1L, (long)ReadWriteIOUtils.readByte((InputStream)inputStream));
        ClusterSchemaTree schemaTree = ClusterSchemaTree.deserialize((InputStream)inputStream);
        DeviceSchemaInfo deviceSchemaInfo = schemaTree.searchDeviceSchemaInfo(new PartialPath("root.sg.d2.a"), Arrays.asList("s1", "status"));
        Assert.assertTrue((boolean)deviceSchemaInfo.isAligned());
        List measurementSchemaList = deviceSchemaInfo.getMeasurementSchemaList();
        Assert.assertEquals((long)2L, (long)measurementSchemaList.size());
        Assert.assertEquals(Arrays.asList("s1", "s2"), measurementSchemaList.stream().map(MeasurementSchema::getMeasurementId).sorted().collect(Collectors.toList()));
        Pair pair = schemaTree.searchMeasurementPaths(new PartialPath("root.sg.**.status"), 0, 0, false);
        Assert.assertEquals((long)3L, (long)((List)pair.left).size());
        Assert.assertEquals(Arrays.asList("root.sg.d1.s2", "root.sg.d2.a.s2", "root.sg.d2.s2"), ((List)pair.left).stream().map(PartialPath::getFullPath).collect(Collectors.toList()));
    }

    private ISchemaRegion prepareSchemaRegion() throws Exception {
        SchemaEngine schemaEngine = SchemaEngine.getInstance();
        SchemaRegionId schemaRegionId = new SchemaRegionId(0);
        schemaEngine.createSchemaRegion(new PartialPath("root.sg"), schemaRegionId);
        ISchemaRegion schemaRegion = schemaEngine.getSchemaRegion(schemaRegionId);
        CreateTimeSeriesPlan createTimeSeriesPlan = new CreateTimeSeriesPlan(new PartialPath("root.sg.d1.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, null, null, null, null);
        schemaRegion.createTimeseries((ICreateTimeSeriesPlan)createTimeSeriesPlan, -1L);
        createTimeSeriesPlan.setPath(new PartialPath("root.sg.d2.s1"));
        schemaRegion.createTimeseries((ICreateTimeSeriesPlan)createTimeSeriesPlan, -1L);
        createTimeSeriesPlan.setAlias("status");
        createTimeSeriesPlan.setPath(new PartialPath("root.sg.d1.s2"));
        schemaRegion.createTimeseries((ICreateTimeSeriesPlan)createTimeSeriesPlan, -1L);
        createTimeSeriesPlan.setPath(new PartialPath("root.sg.d2.s2"));
        schemaRegion.createTimeseries((ICreateTimeSeriesPlan)createTimeSeriesPlan, -1L);
        CreateAlignedTimeSeriesPlan createAlignedTimeSeriesPlan = new CreateAlignedTimeSeriesPlan(new PartialPath("root.sg.d2.a"), Arrays.asList("s1", "s2"), Arrays.asList(TSDataType.INT32, TSDataType.INT32), Arrays.asList(TSEncoding.PLAIN, TSEncoding.PLAIN), Arrays.asList(CompressionType.UNCOMPRESSED, CompressionType.UNCOMPRESSED), Arrays.asList(null, "status"), Collections.emptyList(), Collections.emptyList());
        schemaRegion.createAlignedTimeSeries((ICreateAlignedTimeSeriesPlan)createAlignedTimeSeriesPlan);
        return schemaRegion;
    }
}

